@echo off
REM ***********************************************************************
REM *** RndBckgr.cmd: Background Randomizer.  Randomize the background  ***
REM *** ver.1         of the desktop.  This runs at low-priority and so ***
REM ***               its timing for new backgrounds is not accurate.   ***
REM ***********************************************************************
start "Background Randomizer" /N /B /WIN /MIN CEnvi %0.cmd
GOTO CENVI_EXIT

#define  REPEAT_MINUTE_INTERVAL      3  // minutes between changes

// Define desktop settings that deviate from the default so that when
// the new desktop image is given it does not change your other
// desktop settings
OtherDesktopSettings = "ICONVIEW=NONFLOWED,MINI;"

// Define full filespecs. for where all the random images may be found
ImagesSpecs = { `C:\OS2\BITMAP\*.BMP` ,
                `C:\OS2\BITMAP\*.BGA` ,
                `E:\Personal\Images\*.bmp` ,
                `D:\WIN\*.BMP` };


// Build an array of ALL files that match the above file specs
FileCount = BuildFileList(FileList);
if ( FileCount < 2 ) {
   printf("\aNot enough files chosen for randomizing.\n");
   printf("Press any key to exit...\n");
   exit(1);
}
 
// Hide this program
system("WinSet \"Background Randomizer\" HIDE");

// Make this task run only in the background
// REDUCE PRIORITY OF THIS PROCESS TO IDLETIME
#define ORD_DOS32SETPRIORITY     236
#define PRTYC_IDLETIME     1  // set to idletime priority
DynamicLink("doscalls",ORD_DOS32SETPRIORITY,BIT32,CDECL,
            0/*all threads*/,PRTYC_IDLETIME/*idletime*/,
            0,0/*current process*/)

// initialize the random number gererator
srand();

// Loop forever, picking new screens
for ( NewChoice = -1; ; suspend(REPEAT_MINUTE_INTERVAL * 60 * 1000) ) {

   // choose the next random screen to display
   PreviousChoice = NewChoice;
   do {
      NewChoice = rand() % FileCount;
   } while( PreviousChoice == NewChoice ); // don't want same choice repeated
 
   // get the desktop object
   if ( NULL != (DesktopObject = WinQueryObject("<WP_DESKTOP>")) ) {

      // build setup string, and give to dekstop object
      printf("Display \"%s\"\n",FileList[NewChoice]);
      sprintf(SetupString,"BACKGROUND=%s;%s;",FileList[NewChoice],
              OtherDesktopSettings);
      WinSetObjectData(DesktopObject,SetupString);

   }

}


BuildFileList(FileList) {
   count = 0;
   for ( Spec = GetArraySpan(ImagesSpecs); 0 <= Spec; Spec-- ) {
      if ( (SubList = Directory(ImagesSpecs[Spec])) ) {
         // add all of the files in SubList onto FileList
         for ( Sub = GetArraySpan(SubList); 0 <= Sub; Sub-- ) {
            FileList[count++] = SubList[Sub].name;
            printf("File choice %d = \"%s\"\n",count,FileList[count-1]);
         }
      }
   }
   return(count);
}

WinQueryObject(ObjectID) // called by above code
{
   #define ORD_WINQUERYOBJECT    252
   return DynamicLink("PMWP",ORD_WINQUERYOBJECT,BIT32,CDECL,ObjectID);
}

WinSetObjectData(WPObjectHandle,SetupString) // called by above code
{
   #define ORD_WINSETOBJECTDATA  250
   return DynamicLink("PMWP",ORD_WINSETOBJECTDATA,BIT32,CDECL,
                        WPObjectHandle,SetupString)
}

:CENVI_EXIT
