EXTPROC CEnvi
/************************************************************
 *** BoxFont.cmd - Set and/or show the default values for ***
 *** ver.1         OS/2 and DOS boxes                     ***
 ************************************************************/

#include <Profile.lib>

main(argc,argv)
{
   // Get current size
   BLObSize(current,2);
   PrfQueryProfileData(HINI_USERPROFILE,"Shield","~Font Size...",current,2);
   printf("Current Font Size = %d x %d\n",BLObGet(current,1,UWORD8),BLObGet(current,0,UWORD8));

   if ( argc != 1  &&  argc != 3 )
      Instructions();
   else if ( argc == 3 ) {
      height = atoi(argv[1]), width = atoi(argv[2]);
      if ( height < 1  ||  width < 1 )
            Instructions();
      else {
         current[1] = height, current[0] = width;
         PrfWriteProfileData(HINI_USERPROFILE,"Shield","~Font Size...",current,2);
      }
   }
}

Instructions()
{
   printf("\n")
   printf("BoxFont - Show and Set the default font size for DOS and OS/2 windows\n")
   printf("\n")
   printf("USAGE: BoxFont [Height Width]\n")
   printf("\n")
   printf("WHERE: Height & Width - Font height and width\n")
   printf("\n")
   printf("EXAMPLES: BoxFont 8 8      - Set to 8 x 8 font\n")
   printf("          BoxFont 15 7     - Set to 15 x 7 font\n")
   printf("\n")
}

