/*
***************************************************************** 
                    DISCLAIMER  
  
Novell, Inc. makes no representations or warranties with respect to
any NetWare software, and specifically disclaims any express or
implied warranties of merchantability, title, or fitness for a
particular purpose.  

Distribution of any NetWare software is forbidden without the
express written consent of Novell, Inc.  Further, Novell reserves
the right to discontinue distribution of any NetWare software.

Novell is not responsible for lost profits or revenue, loss of use
of the software, loss of data, costs of re-creating lost data, the
cost of any substitute equipment or program, or claims by any party
other than you.  Novell strongly recommends a backup be made before
any software is installed.   Technical support for this software
may be provided at the discretion of Novell.
*****************************************************************
*/
#include "main.z"


/* *** Internal Prototypes **************************/
N_INTERN_FUNC( nid )
Init( void );

N_INTERN_FUNC( void )
Term( void );

N_INTERN_FUNC( void )	
InitNAWF( void );

N_INTERN_FUNC( void )
TermNAWF( void );

N_GLOBAL_FUNC( nbool8 )
OnAppAfterCREATE ( pUMsgStruct pMsg );

N_GLOBAL_FUNC( nbool8 )
OnAppAfterACTION( pUMsgStruct pMsg );

/******************************************************/
/*                    VECTORS                         */
/******************************************************/

UInstVectorBegin( AppVector, N_NULL )
UInstVectorMsg( UMSG_CREATE, UMSG_MODE_AFTER, OnAppAfterCREATE)
UInstVectorMsg( UMSG_ACTION, UMSG_MODE_AFTER, OnAppAfterACTION)
UInstVectorEnd( AppVector )

/***** Globals *************************************/
N_GLOBAL_VAR UModAccess		Access;     /* Global access record */
N_GLOBAL_VAR nid				  idResFile;  /* nid for the resource file */
N_GLOBAL_VAR nid				  idApp;      /* nid of the application instance */

/****************************************************************************
Function: UModMain
	Application entry point.  NAWF main calls UModMain
****************************************************************************/
N_GLOBAL_LIBRARY (nint32) 
UModMain(nid idModule, nid idPrevInst, nflag32 flOptions)
{
	UMsgStruct		msg;

	idApp = Init();
   if (idApp = N_NULL)
   {
      Term();
      return (1);
   }

	/* Message Get - Dispatch model */
	while (UMsgGet( &Access, &msg, N_NULL, UMSG_CAT_ALL ))
	{
		if (UMsgMap( &Access, N_NULL, &msg, N_NULL ))
		{
			/* dispatch message that was not handled by UMsgMap */
			UMsgDispatch( &Access, &msg, 0 );
		}
	}

  Term();
  return (0);
}

/****************************************************************************
Function: Init
	Initialize application components and globals.
****************************************************************************/
N_INTERN_FUNC( nid )	
Init( void )
{
	nint16			FontWidth, i;
	nid				idResPack, appID;

	
	/* Initialize NAWF components */
	InitNAWF();

	/* Open resource file */
	idResFile = UResOpenModule( &Access, UModGetModule( &Access ), URES_OPEN_READ ); 

	/* Initialize Application instance */
   idResPack =UResCreatePack (&Access, idResFile, URES_TYPE_INSTANCE,
                                 APP_ID, URES_PACK_NO_KEEP);
   DEBUG_ASSERT (((UErrGetVal (&Access)==N_SUCCESS) &&
                  (UResValidatePack (&Access, idResPack)==N_TRUE)),
                          "Can't create App resource packet"); 

   /* Load application instance */
   appID = UInstLoad (&Access, N_NULL, idResPack, N_NULL, N_NULL);

  return (appID);
}

/****************************************************************************
Function: Term
	Terminate application components and globals.
****************************************************************************/
N_INTERN_FUNC( void )	
Term( void )
{
  	/* Close resource file */
  	UResClose( &Access, idResFile, N_NULL );
  
  	/* Terminate NAWF components */
    TermNAWF();
}

/****************************************************************************
Function: InitNAWF
	Initialize NAWF components.
****************************************************************************/
N_INTERN_FUNC( void )	
InitNAWF( void )
{	
  	/* Essential foundation components */
  	if (! UModInit	( &Access, UMOD_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  	if (! UMemInit	( &Access, UMEM_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  	if (! UErrInit	( &Access, UERR_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  
  	/* More foundation components */
  	if (! UDInit	( &Access, UD_VERSION,		0L )) UModExit( UErrGetVal( &Access ) );	
  	if (! UFileInit	( &Access, UFILE_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  	if (! UResInit	( &Access, URES_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  	if (! UFontInit	( &Access, UFONT_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  	if (! UGrafInit	( &Access, UGRAF_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  	if (! UMsgInit	( &Access, UMSG_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  	if (! UInstInit	( &Access, UINST_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  	if (! UPrefInit	( &Access, UPREF_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  	if (! UPrInit	( &Access, UPR_VERSION,		0L )) UModExit( UErrGetVal( &Access ) );
  	if (! USysInit	( &Access, USYS_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  
  	/* interface components */
  	if (! UItemInit	( &Access, UITEM_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  	if (! UKeyInit	( &Access, UKEY_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  	if (! UClipInit	( &Access, UCLIP_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
	
  	if (! UAppInit	( &Access, UAPP_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  	if (! UWndInit	( &Access, UWND_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  	if (! UBtnInit	( &Access, UBTN_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  	if (! UDspInit	( &Access, UDSP_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  	if (! UMenuInit	( &Access, UMENU_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  	if (! UEtxtInit	( &Access, UETXT_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  	if (! UListInit	( &Access, ULIST_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  
  	if (! UVoidInit	( &Access, UVOID_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  	if (! UBoxInit	( &Access, UBOX_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  	if (! USldrInit	( &Access, USLDR_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  	
  	if (! UDlgInit	( &Access, UDLG_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  	
  	/* Standard packages */
  	if (! UStdFSelInit	( &Access, USTD_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  	if (! UStdCSelInit	( &Access, USTD_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  	if (! UPntrInit ( &Access, UPNTR_VERSION,	0L )) UModExit( UErrGetVal( &Access ) );
  
}

/****************************************************************************
Function: TermNAWF
	Terminate NAWF components.
****************************************************************************/
N_INTERN_FUNC( void )	
TermNAWF( void )
{
    UPntrTerm (&Access);
  	UStdCSelTerm( &Access );
  	UStdFSelTerm( &Access );

  	UDlgTerm	( &Access );

  	USldrTerm	( &Access );
  	UBoxTerm	( &Access );
  	UVoidTerm	( &Access );
  
  	UListTerm	( &Access );
  	UEtxtTerm	( &Access );
  	UMenuTerm	( &Access );
  	UDspTerm	( &Access );
  	UBtnTerm	( &Access );
  	UWndTerm	( &Access );
  	UAppTerm	( &Access );
	
  	UClipTerm	( &Access );
  	UKeyTerm	( &Access );
  	UItemTerm	( &Access );
  	
  	USysTerm	( &Access );
  	UPrTerm		( &Access );
  	UPrefTerm	( &Access );
  	UInstTerm	( &Access );
  	UMsgTerm	( &Access );
  	UGrafTerm	( &Access );
  	UFontTerm	( &Access );
  	UResTerm	( &Access );
  	UFileTerm	( &Access );
  	UDTerm		( &Access );
  
  	UErrTerm	( &Access );
  	UMemTerm	( &Access );
    UModTerm	( &Access );
}

/*****************************************************************************
   OnAppAfterCREATE filter procedure is called after the UMSG_CREATE message
   is post-filtered.
*****************************************************************************/
N_GLOBAL_FUNC( nbool8 )
OnAppAfterCREATE ( pUMsgStruct pMsg )
{
   return N_TRUE;
}
/*****************************************************************************
   OnAppAfterACTION filter procedure is called after the UMSG_ACTION message
   is post-filtered.
*****************************************************************************/
N_GLOBAL_FUNC( nbool8 )
OnAppAfterACTION( pUMsgStruct pMsg )
{
	nid idInst;
   /* Store the nid of the the Application instance */
	idInst = UMsgGetInst( pMsg ); 
	switch( (nint16)UMsgGetParam1( pMsg ) )	/* Action code of item selected */
	{
		case APP_MENU_CLOSE:			/* Quit/Exit selected */
		{
			/* Destroy the window, but defer to messages already in queue */
			UInstDestroy( &Access, idInst, UINST_DEFERRED );
			break;
		}
   }
    return N_TRUE;
}
/*****************************************************************************/

