/* TCP timeout routines */
#include <stdio.h>
#include "global.h"
#include "mbuf.h"
#include "timer.h"
#include "netuser.h"
#include "internet.h"
#include "tcp.h"

int Tcp_retry = 5;

/* Timer timeout */
void
tcp_timeout(void *p)
{
	struct tcb *tcb = (struct tcb *)p;

	if(tcb == NULLTCB)
		return;

	/* Make sure the timer has stopped (we might have been kicked) */
	stop_timer(&tcb->timer);

	switch(tcb->state){
	case TCP_TIME_WAIT:				/* 2MSL timer has expired */
		close_self(tcb,NORMAL);
		break;
	default:
		/* Retransmission timer has expired */
		tcb->flags.retran = 1;	/* Indicate > 1  transmission */
		tcb->backoff++;
		if(Tcp_retry > 0) {
            if((tcb->backoff > Tcp_retry && tcb->state != TCP_ESTABLISHED)
              || (tcb->backoff > Tcp_retry * 5
			  && (tcb->state == TCP_ESTABLISHED || tcb->state == TCP_FINWAIT1))) {
				close_self(tcb,TIMEOUT);
				break;
			}
		}
		tcb->snd.ptr = tcb->snd.una;

		/* Reduce slowstart threshold to half current window */
		tcb->ssthresh = max(tcb->cwind / 2,tcb->mss);

		/* Shrink congestion window to 1 packet */
		tcb->cwind = tcb->mss;
		tcp_output(tcb);
		break;
	}
}

