#ifndef _POP_H
#define _POP_H

/*
			filename --  POP.H
			author   --  Mike Stockett, WA7DYX
			additional hacking by Allen Gwinn, N5CKP
*/

#define BUF_LEN		257

#include <fcntl.h>

/* ---------------- common server data structures ---------------- */

/* POP server control block */

struct popserv {
	int	socket;					/* socket number for this connection */
	char state;					/* server state */
#define LSTN		0
#define AUTH		1
#define MBOX		2
#define ITEM		3
#define	NEXT		4
#define DONE		5
	char buf[BUF_LEN];			/* input line buffer */
	char username[MAXPATH];		/* user/folder name */
	char *path;					/* different path to mailfile */
	FILE *wf;					/* work folder file pointer */
	int	folder_len;				/* number of msgs in current folder */
	int msg_num;				/* current msg number */
	int32 msg_len;				/* length of current msg */
	int	msg_status_size; 		/* size of the message status array */
	int32 curpos;				/* current msg's position in file */
	int32 folder_file_size;		/* length of the current folder file, in bytes */
	int32 nextpos;				/* next msg's position in file */
	unsigned int folder_modified;	/*  mail folder contents modified flag */
	unsigned int *msg_status;	/* message status array pointer */
	int def;					/* flag for default msg/path */
};
#define NULLSCB	(struct popserv *)0

void popserv __ARGS((int s,void *unused,void *p));


/* ---------------- common client data structures ---------------- */

/* POP client control block */
struct popcli {
	int	socket;			/* socket for this connection */
	char state;			/* client state */
#define	   CALL		0
#define	   NMBR		3
#define	   SIZE		5
#define	   XFER		8
#define	   EXIT		10
	char *buf;			/* tcp input buffer pointer */
	int32 msg_len;		/* length of current msg */
	FILE *fd;			/* tempfile pointer */
/*	FILE *mf;			/* mailbox file pointer */
/*	int count;			/* input buffer length */
/*	int	folder_len;		/* number of msgs in current folder */
/*	int	msg_num;		/* current message number */
};

#endif /* _POP_H */
