/*
 *
 * NNTP Server/Client Subroutines - See RFC977
 * Jeffrey R. Comstock. - NR0D - Bloomington, Minnesota USA
 * Copyright 1990 Jeffrey R. Comstock, All Rights Reserved.
 * Permission granted for non-commercial copying and use, provided
 * this notice is retained.
 *
 * DB3FL 9107xx: heavily rewritten and bug fixing in file-handling
 * DB3FL 920121: splitted into several files
 *
 */

#include <stdio.h>
#include <string.h>
#include <time.h>
#include <dos.h>
#include <conio.h>
#include <io.h>
#include <dir.h>
#include <ctype.h>
#include <sys/stat.h>

#include "global.h"
#include "nntp.h"
#include "ftp.h"
#include "files.h"
#include "socket.h"

#define	DOSLEN	8		/* max. length of dir/file-names */

int Filecheck = 0;
int16 Nntpquiet = 0;


/* main directory-creating routine
 * returncode: -1 error; 0 success
 */
static int near
make_dir(char *path)
{
	if(path == NULLCHAR)
		return -1;

	if(access(path,0)) {
		if(mkdir(path)) {
			tprintf("Can't create %s: %s\n",path,sys_errlist[errno]);
			return -1;
		}
	}
	return 0;
}

/* main file-checking routine
 * returncode: -1 if error; 0 success */
static int near
check_file(char *path)
{
	if(access(path,0)) {
/*
		return Fclose(Fopen(path,WRITE_TEXT,0,0));
*/
		return close(creat(path,S_IWRITE));
	}
	return 0;
}

/* checks the file-system used for NNTP
 * returncode: -1 if error; 0 success - and "Filecheck" is set to 1 */
int
check_system(void)
{
	FILE *f;
	char line[LineLen], *cp, *cp1;
	int error = 0;

	if (Post.host == NULLCHAR) {
		cp = strxdup(Hostname);
		if((cp1 = strchr(cp,'.')) != NULLCHAR)
			*cp1 = '\0';
		Post.host = strxdup(cp);
		xfree(cp);
	}
	if(Filecheck) {
		return 0;
	}
	error  = make_dir(Forward);
	error |= check_file(Pointer);
	error |= check_file(History);
	error |= check_file(Active);
	error |= check_file(Poll);

	if(error) {
		goto quit;
	}
	sprintf(line,"%s/fwd.seq",News);
	if(access(line,0)) {
		if((f = Fopen(line,"w+",0,1)) == NULLFILE) {
			goto quit;
		}
		fputs("1\n",f);
		Fclose(f);
	}
	sprintf(line,"%s/sequence.seq",Mailqdir);
	if(access(line,0)) {
		if((f = Fopen(line,"w+",0,1)) == NULLFILE) {
			goto quit;
		}
		fputs("1\n",f);
		Fclose(f);
	}
	Filecheck = 1;
	return 0;

quit:
	Filecheck = 0;
	tputs("Error in NNTP file system\n");
	return -1;
}

/* creating path to a new newsgroup
 * handling of "." and "\" in pathnames especially MSDos */
/* returncode: -1 error; 0 success */
#ifdef NNTPENH
int
#else
static int near
#endif
make_path(char *group,int w)
{
	FILE *f;
	char *cp, *cp1, pathname[LineLen];
	int got_it = 0;

	if (group == NULLCHAR
	  || (f = Fopen(Pointer,APPEND_TEXT,0,1)) == NULLFILE)
		return -1;

	cp = strxdup(group);

	for(;;) {
		if((cp1 = strchr(cp,'.')) != NULLCHAR) {
			*cp1 = '\0';
		} else {
			got_it = 1;
		}
		sprintf(pathname,"%s/%s",News,cp);

		if(make_dir(pathname)) {
			xfree(cp);
			Fclose(f);
			return -1;
		}
		if(got_it) {
			if(w) {
				fprintf(f,"%s %s\n",group,pathname);
			}
			xfree(cp);
			Fclose(f);
			return 0;
		}
		*cp1 = '/';
	}
}

static int near
update_list(struct nntpserv *a)
{
	FILE *f, *t;
	char *p, *p1, l2[LineLen];

	if((f = Fopen(Active,READ_TEXT,a->s,0)) == NULLFILE)
		return -1;

	if ((t = Tmpfile(0,1)) == NULLFILE) {
		Fclose(f);
		return -1;
	}
	p1 = a->ap->group;
	a->ap->number = 0;

	while(fgets(a->buf,LineLen,f) != NULL) {
		a->ap->tmpu = strcspn(a->buf," ");
		strncpy(l2,a->buf,a->ap->tmpu);
		l2[a->ap->tmpu] = '\0';

		if(strncmp(p1,l2,DOSLEN) == 0) {
			p = strchr(a->buf,' ') + 1;
			a->ap->number = (unsigned)atoi(p);
			(a->ap->number)++;
			p = strchr(p,' ');
			fprintf(t,"%s %5.5u%s",p1,a->ap->number,p);
		} else {
			fputs(a->buf,t);
		}
	}
    Fclose(f);
	rewind(t);

	if((f = Fopen(Active,WRITE_TEXT,a->s,0)) == NULLFILE) {
		Fclose(t);
		return -1;
    }
	while(fgets(a->buf,LineLen,t) != NULL) {
		fputs(a->buf,f);
	}
	Fclose(t);

#ifdef NNTPENH
	/* highest article in active file = 0 and update allowed ? */
	if((a->ap->number == 0) && fullauto) {
#else
	/* highest article in active file = 0 ? */
	if(a->ap->number == 0) {
#endif
		make_path(a->ap->group,1);
		a->ap->number = 1;
		fprintf(f,"%s 00001 00001 y\n",a->ap->group);
	}
	Fclose(f);
	return (a->ap->number);
}

/* checks for a minimum header
 * returncode: 0 complete; 1 not complete */
int
garbled(FILE *f)
{
/*
 * The minimum requirement for an incoming article is that it must have
 * a newsgroups: line, a message-id: line, a date: line, a from: line,
 * a subject: line and a blank line to delimit header from body.
 *
 */
	char line[LineLen];
	int ok = 0;

    rewind(f);

	while(fgets(line,LineLen,f) != NULL) {
		if (strnicmp(line,Hdrs[NEWSGROUPS],12) == 0)
			ok |= 1;
		if (strnicmp(line,Hdrs[MSGID],12) == 0)
			ok |= 2;
		if (strnicmp(line,Hdrs[DATE],6) == 0)
			ok |= 4;
		if (strnicmp(line,Hdrs[FROM],6) == 0)
			ok |= 8;
		if (strnicmp(line,Hdrs[SUBJECT],9) == 0)
			ok |= 16;
        if (check_blank(line))
			break;
    }
    rewind(f);
    return (ok == 31) ? 0 : 1;
}

/* checkes if path to given article exists
 * returncode: -1 error; 1 success; 0 no path */
int
get_path2(struct article *art)
{
	FILE *f;
	char line[LineLen], *p = art->group;

	if(art->group == NULLCHAR
	  || (f = Fopen(Pointer,READ_TEXT,0,1)) == NULLFILE) {
		return -1;
	}
	while(fgets(line,LineLen,f) != NULL) {
		if(strcspn(line," ") != strlen(p)) {
			continue;
		}
		if(strnicmp(p,line,strlen(p)) == 0) {
			p = (strchr(line,' ')) + 1;
			rip(p);
			if(art->path != NULLCHAR) {
				xfree(art->path);
			}
			art->path = strxdup(p);
			Fclose(f);
			return 1;
		}
    }
    Fclose(f);
	return 0;
}

/* returncode: -1 error; 0 success */
static void near
dup_f(FILE *in,FILE *out,struct nntpserv *mp)
/* Path: bug in col 1 of article body bug fixed by G4JEC 901019....*/
{
	char *p;
	int blank_line_flag = 1;

	while(fgets(mp->buf,LineLen,in) != NULL) {
		if(blank_line_flag) {
			if(strnicmp(mp->buf,Hdrs[PATH],5) == 0) {
				 p = strchr(mp->buf,' ') + 1;
				 fprintf(out,"%s%s!%s",Hdrs[PATH],Post.host,p);
				 blank_line_flag = 0;					/* DG1ZX */
				 continue;
			}
		}
		/* oh oh - nntpserv is modifying articles....*/
		if(strlen(mp->buf) == 1 && mp->buf[0] == '.') {
			continue;
		}
		fputs(mp->buf,out);
	}
}
/* copy article to \spool\news\junk and update history and fwd.seq file
 * returncode: < 1 if error; 1 success */
static int near
dofwd(struct nntpserv *mp,FILE *f,FILE *history)
{
    FILE *fwd;

	sprintf(mp->buf,"%s/fwd.seq",News);
	if ((fwd = Fopen(mp->buf,"r+",mp->s,0)) == NULLFILE) {
		return -1;
	}
    fgets(mp->buf,LineLen,fwd);
	mp->hold_i = atoi(mp->buf) + 1;
    fprintf(history," JUNK/%u",mp->hold_i);
    rewind(fwd);
    fprintf(fwd,"%u",mp->hold_i);
	Fclose(fwd);

    sprintf(mp->buf,"%s/%u",Forward,mp->hold_i);
	if ((fwd = Fopen(mp->buf,WRITE_TEXT,mp->s,0)) == NULLFILE) {
		return -2;
	}
	rewind(f);
    dup_f(f,fwd,mp);
    Fclose(fwd);
	return 1;
}

/* file-receiving routine
 * returncode: -1 if error or 'recvline' faults; 0 success; 1 if blank line */
int
recv_file(FILE *fp,int s)
{
	char line[LineLen];
	int check = 0;

	while(recvline(s,line,LineLen) != -1) {
		rip(line);

		if(strcmp(line,".") == 0) {
			return 0;
		}
		if(!check) {            		/* only enabled on first line! */
			check = 1;
			if (*line == '\0') {     	/* check for blank line */
				return 1;
			}
		}
		fprintf(fp,"%s\n",line);
	}
	return -1;
}

/* checks incoming article-id against existing articles
 * returncode: -1 if error; 1 if article exists; 0 no article found */
int
check_article(char *id)
{
	char line[LineLen], *p = strchr(id,'<');
	FILE *f;

	if(id == NULLCHAR
	  || p == NULLCHAR
	  || (f = Fopen(History,READ_TEXT,0,1)) == NULLFILE) {
		return -1;
	}
	while(fgets(line,LineLen,f) != NULL) {
		if(strncmp(line,p,strlen(p)) == 0) {
			Fclose(f);
			return 1;
		}
		pwait(NULL);
	}
	Fclose(f);
	return 0;
}

int
xfer_article2(FILE *f,struct nntpserv *mp)
{
	char line[LineLen], l[LineLen], *p, *p1, *group = NULLCHAR, *from = NULLCHAR, his[MAXPATH];
    FILE *fptr, *history;
	int alpha, x;
#ifdef CONTROL
	int control = 0;
#endif
	struct tm *stm;

	if(f == NULLFILE
	  || (history = Fopen(History,APPEND_TEXT,mp->s,0)) == NULLFILE) {
		xfree(mp->id);
		return -1;
	}
	mp->ap = mxallocw(sizeof(struct article));

	while(fgets(line,LineLen,f) != NULL) {
		rip(line);
		if(*line == '\0') {
			break;
		}
		if (strnicmp(line,Hdrs[FROM],6) == 0) {
			p = strchr(line,' ') + 1;
			from = strxdup(p);
			continue;
		}
		if (strnicmp(line,Hdrs[NEWSGROUPS],12) == 0) {
			char *cp = l;

			p = strchr(line,' ') + 1;
			alpha = 0;

			while(*p != '\0') {
				if(isalnum(*p) && alpha < DOSLEN) {
					*cp++ = *p;
					alpha++;
				}
				if(*p == '.'|| *p == ',') {
					*cp++ = *p;
					alpha = 0;
				}
				p++;
			}
			*cp = '\0';

			group = strxdup(l);
			continue;
		}
	}
	stm = gmtime(&currtime);

	sprintf(his,"%s %2.2d%2.2d%2.2d %2.2d%2.2d%2.2d",
		mp->id,
		stm->tm_year,stm->tm_mon+1,stm->tm_mday,
		stm->tm_hour,stm->tm_min,stm->tm_sec);

	mp->hold_i = 0;
	p = group;
	x = 1;
    while (x) {
		if ((p1 = strchr(p,',')) != NULLCHAR) {
			p1 = line;
			while (*p != ',') {
				*(p1++) = *(p++);
			}
			*p1 = '\0';
			p++;
			mp->ap->group = strxdup(line);
		} else {
			mp->ap->group = strxdup(p);
			x = 0;
		}
		update_list(mp);
		if (mp->ap->number > 0) {
			get_path2(mp->ap);
			mp->hold_i = 1;
			sprintf(line,"%s/%u",mp->ap->path,mp->ap->number);
			rewind(f);
			if((fptr = Fopen(line,WRITE_TEXT,mp->s,0)) == NULLFILE) {
				Fclose(history);
				xfree(mp->ap->group);
				goto quit;
			}
			dup_f(f,fptr,mp);
			Fclose(fptr);
			fprintf(history,"%s %s/%u\n",his,mp->ap->group,mp->ap->number);
#ifdef CONTROL
			if (strcmp(mp->ap->group,"control") == 0) {
				control = 1;
			}
#endif
			if(mp->ap->path != NULLCHAR) {
				xfree(mp->ap->path);
			}
		}
		xfree(mp->ap->group);
    }
	if(mp->hold_i == 0) {
		if((x = dofwd(mp,f,history)) < 1) {
			mp->hold_i = 0;
		}
#ifdef NNTPENH
		/* newsgroup did not exist in active file, so forward it to junk */
		xfree(group);
		group = strxdup("JUNK");
#endif
	}
	Fclose(history);

	switch(Nntpquiet) {
	case 0:
		putch(7);
	case 1:
		/* timestamp by dc3sn */
		tprintf("NNTP: new news for %s from %s at %s\n",
			group,from,timestr(currtime));
		break;
	case 3:
		log(-1,IPPORT_NNTP,"NNTP new news from %s",from);
		break;
	}
#ifdef CONTROL
	if (control == 1)
		docontrol(f,mp);
#endif
quit:
	xfree(mp->id);
	xfree(mp->ap);
	if(from != NULLCHAR)
		xfree(from);
	if(group != NULLCHAR)
		xfree(group);
	return 0;
}

/* checks for not valid chars in a line
 * returncode: 0 if valid; 1 if invalid */
int
check_blank(char *bp)
{
	char *cp = bp;

	if(*cp > ' ') {
		return 0;
	} else while(*cp) {
		if(*cp++ > ' ') {
			return 0;
		}
	}
	return 1;
}

/* converts timestring to unix-compatible structure
 * returncode: 0 (!!) if error; > 0 success */
static int32
make_nntime(struct date *d,struct time *t,char *str)
{
	char *cp, tmp[3];

    if(str == NULLCHAR) {
		return 0;
    }                    
	tmp[2] = '\0';
	cp = str;
    strncpy(tmp,cp,2);

    if((d->da_year = atoi(tmp) + 1900) < 1980) {
		d->da_year = 1980;
    }
    if(d->da_year > 2099) {
        return 0;
    }
    cp += 2;
    strncpy(tmp,cp,2);
    d->da_mon = atoi(tmp);
    
    if(d->da_mon < 1 || d->da_mon > 12) {
        return 0;
    }
    cp += 2;
    strncpy(tmp,cp,2);
	d->da_day = atoi(tmp);
    
    if(d->da_day < 1 || d->da_day > 32) {
        return 0;
    }
    cp += 3;
    strncpy(tmp,cp,2);
    
    if((t->ti_hour = atoi(tmp)) > 24) {
        return 0;
    }
    cp += 2;
    strncpy(tmp,cp,2);
    
    if((t->ti_min = atoi(tmp)) > 60) {
        return 0;
    }
    cp += 2;
    strncpy(tmp,cp,2);
    
    if((t->ti_sec = atoi(tmp)) > 60) {
        return 0;
    }
	t->ti_hund = 0;
    return (dostounix(d,t));
}

/* checks if two spaces exists in given string
 * returncode: -1 if error; 1 success */
static int near
check_one(char *str)
{
	char *cp;

    if(str == NULLCHAR || (cp = strchr(str,' ')) == NULLCHAR) {
		return -1;
    }
    if(strchr(++cp,' ') == NULLCHAR) {
		return -1;
    }
	return 1;
}

static int
restreql(char *w,char *s)
{
	while (*s && *w) {
		switch (*w) {
			case '*':
                for (w++; *s; s++) {
                    if (restreql(w, s)) {
						return 1;
                    }
                }
				break;
			default:
                if (*w != *s) {
					return 0;
                }
				w++, s++;
				break;
		}
	}
    if (*s) {
		return 0;
    }
    while (*w) {
        if (*w++ != '*') {
			return 0;
        }
    }
    return 1;
}

static int near
ngmatcha(int (*func)(char *,char *),int dflt,struct g_list *ngspec,struct g_list *matchlist)
{
	char *cp;
	int match = dflt;
	struct g_list *n, *m = matchlist;

	for(;;) {
		if ((cp = strchr(m->str,'/')) != NULLCHAR)
			*cp = '\0';
		n = ngspec;
		for (;;) {
			if (n->str[0] == '!') {      /* Handle negation */
				if((*func)(n->str + 1,m->str)) {
					match = 0;
				}
			} else {
				if((*func)(n->str, m->str)) {
					match = 1;
				}
			}
			if(n->next == NULLG)
				break;
			else
				n = n->next;
		}
		if (m->next == NULLG)
			break;
	    else
			m = m->next;
	}
	return (match);
}

/*
        checks if article is newer than date/time specified in string
        and if the groups in the given string matches with the
        newsgroups in historyfile.
        If new news exist, MID from all articles are copied in temporary file
        returncode: -1 if error; 0 if no new news; 1 new news available
*/

int
newnews(struct nntpserv *mp,FILE *f)
{
	char *cp = mp->buf, *cp1, line[LineLen], groups[LineLen];
	struct g_list *ng, *hist, *ngp, *histp, *ptr;
	FILE *f1;
	int match, j, all = 1, i = 1, error = -1;

	if(check_one(mp->buf) == -1) {
		return -1;
	}
	/* cut off newsgroups from time/date */
	while (*(cp++) > 32) {
		i++;
	}
	if (strlen(cp) < 13) {
		return -1;
	}
	strncpy(groups,mp->buf,i-1);
	groups[i-1] = '\0';

	if(strcmp(groups,"*") != 0) {
		all = 0;
	}
	/* convert date/time string in unixtime format */
	mp->datest = (struct date *)mxallocw(sizeof(struct date));
	mp->timest = (struct time *)mxallocw(sizeof(struct time));

	if((mp->unixtime = make_nntime(mp->datest,mp->timest,cp)) < 1)
		goto quit;

	/* build list of all newsgroups in the given string */
	if(!all) {
		ng = ngp = (struct g_list *)mxallocw(sizeof(struct g_list));
		cp = groups;

		for (;;) {
			if(strchr(cp,',') == NULLCHAR ) {
				ng->str = strxdup(cp);
				ng->next = NULLG;
				break;
			}

			j = strcspn(cp,",");
			ng->str = (char *)mxallocw(j+1);
			strncpy(ng->str,cp,j);
			ng->str[j] = '\0';
			ng->next = (struct g_list *)mxallocw(sizeof(struct g_list));
			ng = ng->next;

			if((cp1 = strchr(cp,',')) != NULLCHAR) {
				cp = cp1 + 1;
			} else {
				break;
			}
		}
	}

	/* now compare date/time and newsgroups with all entries in history file */
	if ((f1 = Fopen(History,READ_TEXT,0,1)) == NULLFILE) {
		goto quit1;
	}
	error = 0;

	for (;;) {
		if(fgets(line,LineLen,f1) == NULL)
			break;
		rip(line);

		if((mp->ftime = make_nntime(mp->datest,mp->timest,strchr(line,' ') + 1)) == 0)
			/* something wrong with this line so stop searching */
			break;

		/* article is older than date/time in given string.
		   ==> read next line from history */
		if((mp->ftime - mp->unixtime) < 0)
			continue;

		/* if article is newer, then check if newsgroups in given string
		   and entry in history matches */
		if (!all) {
			for(i = 3, cp = line; i; --i) {
				cp = strchr(cp,' ') + 1;
			}
			histp = (struct g_list *)mxallocw(sizeof(struct g_list));
			hist = histp;

			/* build list of all newsgroups from the article */
			for (;;) {
				if (strchr(cp,' ') == NULLCHAR) {
					hist->str = strxdup(cp);
					hist->next = NULLG;
					break;
				}
				j = strcspn(cp," ");
				hist->str = (char *)mxallocw(j+1);
				strncpy(hist->str,cp,j);
				hist->str[j] = '\0';
				hist->next = (struct g_list *)mxallocw(sizeof(struct g_list));
				hist = hist->next;

				if((cp1 = strchr(cp,' ')) != NULLCHAR) {
					cp = cp1 + 1;
				} else {
					break;
				}
			}

			/* now check if both list matches */
			match = ngmatcha(restreql,0,ngp,histp);

			/* free list of all newsgroups specified in the article */
			ptr = histp;

			for (;;) {
				ptr = histp->next;
				xfree(histp->str);
				xfree(histp);
				histp = ptr;
				if (histp == NULLG)
					break;
			}
			/* if no matches exists then read new line from history */
			if(!match) {
				continue;
			}
		}

		/* we found a new news, so copy message id to file
		   and read next line from history */
		error = 1;
		cp = line;
		while ( *cp > 32 ) {
			fputc(*(cp++),f);
		}
		fputc('\n',f);
	}

    Fclose(f1);

quit1:
	/* free list of all newsgroups specified in the given string */
	if(!all) {
		ptr = ngp;

		for (;;) {
			ptr = ngp->next;
			xfree(ngp->str);
			xfree(ngp);
			ngp = ptr;
			if (ngp == NULLG) {
				break;
			}
		}
	}
quit:
	rewind(f);
	xfree(mp->datest);
	xfree(mp->timest);
	return error;
}

/* get id-number of message
 * returncode: -1 if error; 0 if no message; 1 success */
int
get_id(struct nntpserv *mp)
{
    FILE *f;
	char tmp[LineLen];

	if ((f = open_message(mp)) == NULLFILE)
		return 0;

	while(fgets(tmp,LineLen,f) != NULL) {
		if(check_blank(tmp)) {
			break;
		}
		if(strnicmp(tmp,Hdrs[MSGID],12) == 0) {
			Fclose(f);
			strcpy(mp->buf,strchr(tmp,' '));
			rip(mp->buf);
			return 1;
		}
    }
    Fclose(f);
	strcpy(mp->buf,"\0");
    return 0;
}

int
art_ret(struct nntpserv *mp,int flag)
{
	if(get_id(mp) < 1) {
		return -1;
	}
	if(flag) {
		usprintf(mp->s,retrieve,mp->pointer,mp->buf,artmsg);
	}
	return 0;
}

/* main message-opening routine
 * returncode: NULLFILE if error; filepointer success */
FILE *
open_message(struct nntpserv *mp)
{
	FILE *f;
	char line[LineLen];

	sprintf(line,"%s/%u",mp->path,mp->pointer);

	if((f = Fopen(line,READ_TEXT,0,0)) == NULLFILE) {
		usputs(mp->s,noart);
	}
	return f;
}

/* returncode: -1 error; 1 success; 0 no entry */
int
get_path(struct nntpserv *mp)
{
	FILE *f;
	char line[LineLen], *cp1 = mp->buf;
	int i;

	if(mp->buf == NULLCHAR
	  || (f = Fopen(Pointer,READ_TEXT,mp->s,0)) == NULLFILE) {
		return -1;
	}
	if(*cp1 == ' ') {
		cp1++;
	}
	i = strlen(cp1);

	while(fgets(line,LineLen,f) != NULL) {
		if(strcspn(line," ") != i) {
			continue;
		}
		if(strnicmp(cp1,line,i) == 0) {
			char *cp = (strchr(line,' ')) + 1;
			rip(cp);
			if(mp->path != NULLCHAR) {
				xfree(mp->path);
			}
			mp->path = strxdup(cp);
			Fclose(f);
			return 1;
		}
    }
    Fclose(f);
	return 0;
}

/* Sends article <message-id> to the client or check if path to
 * host we are polling now exists.
 * Return value: -1 on error, 1 article sent, 0 no article
 * check = 1 : check only pathfield in article
 * check = 0 : send article
 */
int
doarticle(struct nntpserv *mp,int flag,char *hname)
{
	FILE *f;
	int32 ok = 0;
/*
	char *holds, *p = strchr(mp->buf,' '), *p2, line[LineLen];
*/
	char *holds, *p = mp->buf, *p2, line[LineLen];

	if(p == NULLCHAR || (f = Fopen(History,READ_TEXT,0,0)) == NULLFILE) {
		usputs(mp->s,badsyntax);
		return -1;
	}
	while(fgets(line,LineLen,f) != NULL) {
		if(strstr(line,p) != NULLCHAR) {
			Fclose(f);
			p = (strchr(line,' ')) + 14;    /* point to the first newsgroup */
			p2 = strchr(p,'/');             /* point to article number */
			mp->hold_i = mp->pointer;       /* save current pointer */
			holds = strxdup(mp->path);      /* save path of current article */
			mp->pointer = atoi((p2 + 1));   /* get the article number */

			if (mp->path != NULLCHAR) {
				xfree(mp->path);
				mp->path = '\0';
			}
			*p2 = '\0';
			rip(p);
			strcpy(mp->buf,p);

			if(strncmp(p + 1,"JUNK",6) == 0) {
				strcpy(mp->buf,Forward);
				mp->path = strxdup(mp->buf);
			} else {
				get_path(mp);
			}
			if(hname == NULLCHAR ) {
				/* send article */
				if((f = open_message(mp)) == NULLFILE) {
					xfree(mp->path);                /* file not found */
					mp->path = strxdup(holds);
					mp->pointer = mp->hold_i;
					xfree(holds);
					return -1;
				}
				if(art_ret(mp,flag) != -1) {
					ok = sendfile(f, mp->s, ASCII_TYPE,0);
					ok = (ok == -1) ? -1 : 1;
					usputs(mp->s,NEol);
				}
			} else {
				int getpath = 0;

				/* check only pathfield in article */
				sprintf(line,"%s/%u",mp->path,mp->pointer);

				if((f = Fopen(line,READ_TEXT,0,0)) == NULLFILE) {
					xfree(mp->path);                /* file not found */
					mp->path = strxdup(holds);
					mp->pointer = mp->hold_i;
					xfree(holds);
					return -1;
				}
				while(!getpath && (fgets(line,LINELEN,f) != NULL)) {
					if (strnicmp(line,Hdrs[PATH],6) != 0) {
						continue;
					}
					ok = 1;             /* default: send article */
					getpath = 1;    	/* reset condition for while-loop */

					/* skip first entry, because its our own hostname */
					p2 = strstr(line,"!") + 1;

					for (;;) {
						/* cut off first entry and compare it with the hostname */
						if ((p = strstr(p2,"!")) == NULL) {
							break;
						}
						*p = '\0';
						if(strcmpi(hname,p2) == 0) {
							ok = 0;         /* oops, I've got you. */
							break;          /* don't forward article */
						}
						p2 = ++p;
					}
				}
			}
			Fclose(f);
			xfree(mp->path);
			mp->path = strxdup(holds);
			mp->pointer = mp->hold_i;
			xfree(holds);
			return ((int)ok);
		}
	}
	Fclose(f);
	usputs(mp->s,noart);
	return 0;
}

