#ifndef _MAILBOX_H
#define _MAILBOX_H

#ifndef _TIMER_H
#include "timer.h"
#endif

struct mbx {
	struct mbx *next;
	int state;				/* mailbox state */
#define MBX_LOGIN	0		/* trying to log in */
#define MBX_CMD		1
#define MBX_BBS		2		/* connected to the bbs */
#define MBX_CONVERS 3		/* conversd implementation - DB3FL */
	char name[20];
	char nodename[20];
	char *line;
	int type;				/* Type of session when invoking "chat" */
	int family;				/* Type of uplink session */
	int user;				/* User linkage area */
	char escape;			/* Escape character */
	int16 perms;			/* Privileges
#define AX25_CMD		8	/* AX.25 gateway operation allowed */
#define TELNET_CMD		16	/* Telnet gateway operation allowed */
#define NETROM_CMD		32	/* NET/ROM gateway operation allowed */
#define SYSOP_CMD		64	/* Remote sysop access allowed */
#define EXCLUDED_CMD	128	/* This user is banned from the BBS */
	char *path;				/* Directory path */
	char *startmsg;			/* Message to be sent at connect through any */
							/* of the gateways */
	int err_cnt;			/* a try to stop endless "Huh?" or "Error ?" */
	char stype;
} ;
#define 	NULLMBX		(struct mbx *)0

/* Structure used for automatic flushing of gateway sockets */
struct gwalarm {
	int s1;
	int s2;
	struct timer t;
};

extern struct mbx *Mbox;
extern int ThirdParty;
extern char Banner[];

/* In mailbox.c: */
void mbx_incom __ARGS((int s,void *t,void *p));
int domboxdisplay __ARGS((int argc,char *argv[],void *p));
int mbxrecvline __ARGS((struct mbx *m));

#endif	/* _MAILBOX_H */

