#ifndef	_DOMAIN_H
#define	_DOMAIN_H

#ifndef _TIME_H
#include <time.h>
#endif

#ifndef	_GLOBAL_H
#include "global.h"
#endif

#ifndef	_MBUF_H
#include "mbuf.h"
#endif

#ifndef _PROC_H
#include "proc.h"
#endif

#define	MAXCNAME	10	/* Maximum amount of cname recursion */

#define	NRLIST	17

#define	TYPE_A		1	/* Host address */
#define	TYPE_NS		2	/* Name server */
#define	TYPE_MD		3	/* Mail destination (obsolete) */
#define	TYPE_MF		4	/* Mail forwarder (obsolete) */
#define	TYPE_CNAME	5	/* Canonical name */
#define	TYPE_SOA	6	/* Start of Authority */
#define	TYPE_MB		7	/* Mailbox name (experimental) */
#define	TYPE_MG		8	/* Mail group member (experimental) */
#define	TYPE_MR		9	/* Mail rename name (experimental) */
#define	TYPE_NULL	10	/* Null (experimental) */
#define	TYPE_WKS	11	/* Well-known sockets */
#define	TYPE_PTR	12	/* Pointer record */
#define	TYPE_HINFO	13	/* Host information */
#define	TYPE_MINFO	14	/* Mailbox info */
#define	TYPE_MX		15	/* Mail exchanger */
#define	TYPE_TXT	16	/* Text strings */
#define	TYPE_AXFR	252	/* Transfer zone of authority */
#define	TYPE_MAILB	253	/* Transfer mailbox records */
#define	TYPE_MAILA	254	/* Transfer mail agent records */
#define	TYPE_ANY	255	/* wildcard match */

#define	CLASS_IN	1	/* The ARPA Internet */
#define	CLASS_CH	3	/* The CHAOS net at MIT*/
#define	CLASS_ANY	255	/* wildcard match */

struct dserver {
	struct dserver *next;
	int32 address;			/* IP address of server */
	int32 timeout;			/* Current timeout, ticks */
	int32 srtt;				/* Smoothed round trip time, ticks */
	int32 mdev;				/* Mean deviation, ticks */
	int32 queries;			/* Query packets send to this server */
	int32 responses;		/* Response packets received from this server */
	int32 missers;			/* Timeout hits */
};
#define	NULLDOM	(struct dserver *)0

#define	AGAIN		8	/* Average RTT gain = 1/8 */
#define	LAGAIN		3	/* Log2(AGAIN) */
#define	DGAIN		4	/* Mean deviation gain = 1/4 */
#define	LDGAIN		2	/* log2(DGAIN) */

#define	DOM_RESPONSE	0x8000
#define	DOM_AUTHORITY	0x0400
#define	DOM_TRUNC		0x0200
#define	DOM_DORECURSE	0x0100
#define	DOM_CANRECURSE	0x0080

/* Header for all domain messages */
struct dhdr {
	int16 id;				/* Identification */
	char qr;				/* Query/Response */
#define	RESPONSE		1
	char opcode;
#define	QUERY			0
#define	IQUERY			1
#define	DSTATUS			2
#define	ZONEINIT		14
#define	ZONEREF			15
	char aa;				/* Authoratative answer */
	char tc;				/* Truncation */
	char rd;				/* Recursion desired */
	char ra;				/* Recursion available */
	char rcode;				/* Response code */
#define	NO_ERROR		0
#define	FORMAT_ERROR	1
#define	SERVER_FAIL		2
#define	NAME_ERROR		3
#define	NOT_IMPL		4
#define	REFUSED			5
	int16 qdcount;			/* Question count */
	int16 ancount;			/* Answer count */
	int16 nscount;			/* Authority (name server) count */
	int16 arcount;			/* Additional record count */
	struct quest **qlist;	/* List of questions */
	struct rr **ans;		/* List of answers */
	struct rr **ns;			/* List of name servers */
	struct rr **add;		/* List of additional records */
};
struct quest {
	char *qname;			/* Domain name being sought */
	int16 qtype;			/* Type (A, MX, etc) */
	int16 qclass;			/* Class (IN, etc) */
};
#define	NULLDHDR (struct dhdr *)0

/* header for resouce records (rr's) */
struct mx {
	int16 pref;
	char *exch;
};

struct hinfo {
	char *cpu;
	char *os;
};

struct minfo {
	char *rmailbx;
	char *emailbx;
};

struct wks {
	int32 addr;
	unsigned char protocol;
	unsigned char bitmap[64];
};

struct soa {
	char *mname;
	char *rname;
	int32 serial;
	int32 refresh;
	int32 retry;
	int32 expire;
	int32 minimum;
};

struct rr {
	struct rr *next;		/* linked list pointer */
	struct rr *soarec;		/* pointer to owning SOA*/
	char *name;				/* Domain name, ascii form */
	char *origin;
	int16 type;				/* A, MX, etc */
	int16 class;			/* IN, etc */
	int32 ttl;				/* Time-to-live */
	int16 rdlength;			/* Length of data field */
	union {
		int32 addr;			/* Used for type == A */
		struct soa *soa;	/* Used for type == SOA */
		struct mx mx;		/* Used for type == MX */
		struct hinfo hinfo;	/* Used for type == HINFO */
		struct minfo minfo;	/* Used for type == MINFO */
		struct wks *wks;	/* Used for type == WKS */
		char *name;			/* for domain names */
		char *data;			/* for anything else */
	} rdata;
};
#define	NULLRR	(struct rr *)0

struct rr_memory{
	char Dname[127];		/* Remember previous records name */
	int32 Dttl;				/* Remember previous records ttl */
	int Dclass;				/* Remember previous records class */
	char *dorigin;			/* Remember previous $origin name */
	struct rr *rrp;			/* For next memory rr record in dfind */
};

struct dlist{
	char *name;
	struct dlist *next;
};
#define	NULLDLIST (struct dlist *)0

typedef enum {
	Found,
	Missing
} Ctype;

typedef enum {
	Address,
	Name
} Rtype;

typedef enum {
	Unknown,
	Bad,
	Suspect,
	Good,
	Activep,
	Waiting
} Apstate;

typedef struct {
   Ctype type;
   Apstate state;
   Apstate proc_run;
   time_t ti;
   char name[40];
   int32 address;
   struct timer timer;
} Cache;

extern Cache *cache;

#define NDTYPES 17

extern char *Dsuffix, *Dorigin;
extern int SDom, DBloaded, Db_initialize, Dstypes[], Dhaveaa, Cwrite, DTranslate, DVerbose;
extern int16 Dcache_size, Dtimeout, Dretries;
extern struct dserver *Dlist;
extern struct dlist *Lorigin;
extern struct rr *Rrlist[], *Rrlistl[];

int32 resolve __ARGS((char *name));
struct rr *resolve_rr __ARGS((char *dname,int16 dtype));
char *resolve_a __ARGS((int32 ip_address, int shorten));
char *resolve_mailb __ARGS((char *name));

/* in domserv.c */
void proc_query __ARGS((int s,void *d,void *b));

/* in domcli.c */
int docachereset __ARGS((int argc,char **argv,void *p));
int docachegarb __ARGS((int argc,char **argv,void *p));
int docachelist __ARGS((int argc,char **argv,void *p));
/* in domsubr.c */
int isaddr __ARGS((char *s));
struct dhdr *bld_dhdr __ARGS((int16 qr,int16 op,int16 flags,int16 rcode, char *name,int class,int type));
int ntohdomain __ARGS((struct dhdr *dhdr,struct mbuf **bbp));
void free_dhdr __ARGS((struct dhdr *dp));
int res_mkbuf __ARGS((struct dhdr *dp,char *buffer,int16 len));
struct rr *get_rr __ARGS((FILE *fp,struct rr_memory *memory));
int add_rr __ARGS((FILE *fp,struct rr *rrp1));
struct rr *copy_rr __ARGS((struct rr *rr));
struct rr * make_rr __ARGS((int source,char *dname,int16 dclass,int16 dtype,int32 ttl,int16 rdl,void *data));
int cmp_rr __ARGS((struct rr *rr1,struct rr *rr2));
void free_rr __ARGS((struct rr *rrp));
void put_rr __ARGS((FILE *fp,struct rr *rrp,int addorg));   /* DB3FL */
char *type2str __ARGS((int type));
struct rr *dfind __ARGS((FILE *dbase,char *name,int type,struct rr_memory *memory));
void proc_answer __ARGS((struct dhdr *dhdr,struct dserver *dp, FILE *dfp));
int sendquery __ARGS((int32 address,char *buf,int len,struct mbuf **bp,int32 timeout));

#endif	/* _DOMAIN_H */
