#ifndef	_AX25_H
#define	_AX25_H

#ifndef	_GLOBAL_H
#include "global.h"
#endif

#ifndef	_MBUF_H
#include "mbuf.h"
#endif

#ifndef _TIMER_H
#include "timer.h"
#endif

#ifndef	_IFACE_H
#include "iface.h"
#endif

#ifndef _SOCKET_H
#include "socket.h"
#endif

/* AX.25 datagram (address) sub-layer definitions */

#define AXROUTESIZE 	499
#define AXROUTEHOLDTIME	(30 * DAYS)

extern int32 Axholdtime;

#define	MAXDIGIS	7		/* Maximum number of digipeaters */
#define	ALEN		6		/* Number of chars in callsign field */
#define	AXALEN		7		/* Total AX.25 address length, including SSID */
#define	AXBUF		10		/* Buffer size for maximum-length ascii call */

/* Bits within SSID field of AX.25 address */
#define	SSID		0x1e	/* Sub station ID */
#define DAMA		0x20    /* DAMA bke 920531   DAMA-Master ID */
#define	REPEATED	0x80	/* Has-been-repeated bit in repeater field */
#define	E			0x01	/* Address extension bit */
#define	C			0x80	/* Command/response designation */

/* Upper sub-layer (LAPB) definitions */
/* Control field templates */
#define	I		0x00		/* Information frames */
#define	S		0x01		/* Supervisory frames */
#define	RR		0x01		/* Receiver ready */
#define	RNR		0x05		/* Receiver not ready */
#define	REJ		0x09		/* Reject */
#define	U		0x03		/* Unnumbered frames */
#define	SABM	0x2f		/* Set Asynchronous Balanced Mode */
#define	DISC	0x43		/* Disconnect */
#define	DM		0x0f		/* Disconnected mode */
#define	UA		0x63		/* Unnumbered acknowledge */
#define	FRMR	0x87		/* Frame reject */
#define	UI		0x03		/* Unnumbered information */
#define	PF		0x10		/* Poll/final bit */

#define	MMASK	7			/* Mask for modulo-8 sequence numbers */

/* FRMR reason bits */
#define	W		1			/* Invalid control field */
#define	X		2			/* Unallowed I-field */
#define	Y		4			/* Too-long I-field */
#define	Z		8			/* Invalid sequence number */

/* AX25 protocol constants */
#define DST_C   1           /* Set C bit in dest addr */
#define SRC_C   2           /* Set C bit in source addr */
#define VERS1   0           /* AX25L2V1 compatible frame */
#define CMD     (DST_C)     /* Command frame */
#define POLL    (DST_C|PF)  /* Poll frame */
#define RESP    (SRC_C)     /* Response frame */
#define FINAL   (SRC_C|PF)	/* Final frame */

/* Round trip timing parameters */
#define AGAIN   8               /* Average RTT gain = 1/8 */
#define DGAIN   4               /* Mean deviation gain = 1/4 */

extern struct iface *axroute_default_ifp;

extern char Mycall[AXALEN], Ax25multi[][AXALEN], *Ax25states[],
			*Ax25reasons[], Nomycall[];

extern int T3disc;

extern int16 Digipeat,T1init,T2init,T3init,T4init,T5init,Retries,
			 Maxframe,Paclen,Pthresh,Axwindow;

/* Internal representation of an AX.25 address */
struct ax25_addr {
	char call[ALEN];
	char ssid;
};
#define NULLAXADDR (struct ax25_addr *)0

struct axroute_tab {
	struct ax25_addr call;
	struct axroute_tab *digi;
	struct iface *ifp;
	int perm;
	int32 time;
	struct axroute_tab *next;
};

extern struct axroute_tab *Axroute_tab;

struct ax_saverecord {
	struct ax25_addr call;
	struct ax25_addr digi;
	short dev;
	int32 time;
};

/* Internal representation of an AX.25 header */
struct ax25 {
	struct ax25_addr dest;				/* Destination address */
	struct ax25_addr source;			/* Source address */
	struct ax25_addr digis[MAXDIGIS];	/* Digi string */
	int ndigis;							/* Number of digipeaters */
	int cmdrsp;							/* Command/response */
};

/* Per-connection link control block
 * These are created and destroyed dynamically,
 * and are indexed through a hash table.
 * One exists for each logical AX.25 Level 2 connection
 */
struct ax25_cb {
	struct ax25_cb *next;		/* linked list pointers */

	char path[70];
	int pathlen;

	struct iface *iface;		/* Interface */

	struct mbuf *txq;			/* Transmit queue */
	struct mbuf *rxasm;			/* Receive reassembly buffer */
	struct mbuf *rxq;			/* Receive queue */
	int16 rcvcnt;
	int32 sndqtime;

	struct axreseq {			/* Resequencing queue */
		struct mbuf *bp;
		int sum;
	} reseq[8];

	char rejsent;				/* REJ frame has been sent */
	char rnrsent;           	/* RNR frame has been sent */
	char polling;				/* Poll frame has been sent */
	char clone;					/* Server-type cb, will be cloned */
	int32 remotebusy;			/* Remote sent RNR */

	char reason;				/* Reason for connection closing */
#define	LB_NORMAL			0	/* Normal close */
#define	LB_DM				1	/* Received DM from other end */
#define	LB_TIMEOUT			2	/* Excessive retries */
#define LB_UNUSED			3	/* Link is redundant - unused */
	int mode;
#define STREAM				0
#define DGRAM				1
	char vs;					/* Our send state variable */
	char vr;					/* Our receive state variable */
	char unack;					/* Number of unacked frames */
	int closed;					/* disc when sendqueue empty */
	int cwind;					/* Congestion window */
	unsigned retries;			/* Retry counter */
	int state;					/* Link state */
#define	DISCONNECTED		1
#define LISTEN				2
#define	CONNECTING			3
#define	DISCONNECTING		4
#define	CONNECTED			5
#define TIMEWAIT            6
	struct timer t1;			/* Retransmission timer */
	struct timer t2;            /* Acknowledgement delay timer */
	struct timer t3;			/* Keep-alive poll timer */
	struct timer t4;			/* Link redundancy timer */
	struct timer t5;			/* Packet assembly timer */
	int32 srt;					/* Smoothed round-trip time, ms */
	int32 mdev;					/* Mean rtt deviation, ms */
	int32 sndtime[8];			/* time of 1st transmission */

	void (*r_upcall) __ARGS((struct ax25_cb *,int));	 /* Receiver upcall */
	void (*t_upcall) __ARGS((struct ax25_cb *,int));	 /* Transmit upcall */
	void (*s_upcall) __ARGS((struct ax25_cb *,int,int)); /* State change upcall */

	int user;					/* User pointer */
	int segremain;				/* Segmenter state */
	struct mbuf *segasm;		/* Segmenter reassembly buffer */
	struct ax25_cb *peer;   	/* Pointer to peer's control block */
	int dama;                   /* DAMA bke 920609   DAMA-Flag */
};
#define	NULLAX25	((struct ax25_cb *)0)

extern struct ax25_cb Ax25default,*Ax25_cb;

/* C-bit stuff */
#define	LAPB_UNKNOWN	0
#define	LAPB_COMMAND	1
#define	LAPB_RESPONSE	2

/* AX.25 Level 3 Protocol IDs (PIDs) */
#define PID_X25			0x01	/* CCITT X.25 PLP */
#define	PID_SEGMENT		0x08	/* Segmentation fragment */
#define PID_TEXNET		0xc3	/* TEXNET datagram protocol */
#define	PID_LQ			0xc4	/* Link quality protocol */
#define	PID_IP			0xcc	/* ARPA Internet Protocol */
#define	PID_ARP			0xcd	/* ARPA Address Resolution Protocol */
#define PID_FLEXNET		0xce	/* Flexnet routing info */
#define	PID_NETROM		0xcf	/* NET/ROM */
#define	PID_NO_L3		0xf0	/* No level 3 protocol */

#define	SEG_FIRST		0x80	/* First segment of a sequence */
#define	SEG_REM			0x7f	/* Mask for # segments remaining */

#define	AX_EOL			"\r"	/* AX.25 end-of-line convention */

/* Link quality database record format
 * Currently used only by AX.25 interfaces
 */
struct lq {
	char addr[AXALEN];		/* Hardware address of station heard */
	int32 time;				/* Time station was last heard */
	int32 currxcnt;			/* Current # of packets heard from this station */
	unsigned char pid;
	unsigned char lock;
};
#define	NULLLQ	(struct lq *)0

/* Max number of fake AX.25 interfaces for RFC-1226 encapsulation */
#define NAX25   10

/* Codes for the open_ax25 call */
#define	AX_PASSIVE	0
#define	AX_ACTIVE	1
#define	AX_SERVER	2	/* Passive, clone on opening */

void ax_recv __ARGS((struct iface *,struct mbuf *));
void axip_input __ARGS((struct iface *iface,struct ip *ip,struct mbuf *bp,int rxbroadcast));
int axip_raw __ARGS((struct iface *iface,struct mbuf *bp));
int ax_send __ARGS((struct mbuf *bp,struct iface *iface,int32 gateway,int prec,
	int del,int tput,int rel));
int ax_output __ARGS((struct iface *iface,char *dest,char *source,int16 pid,
	struct mbuf *data));
struct axroute_tab *axroute_tabptr __ARGS((struct ax25_addr *call,int create));
void axroute_add __ARGS((struct ax25_cb *cp,int perm));
int is_bud __ARGS((char *call,int store));
int axflush __ARGS((struct iface *ifp));
int maxheard __ARGS((struct iface *ifp,int num));
/* int ax25val __ARGS((struct ax25_cb *axp));	*/
int disc_ax25 __ARGS((struct ax25_cb *axp));
int kick_ax25 __ARGS((struct ax25_cb *axp));
struct ax25_cb *open_ax25 __ARGS((struct iface *,char *,char *,int,
	void (*) __ARGS((struct ax25_cb *,int)),
	void (*) __ARGS((struct ax25_cb *,int)),
	void (*) __ARGS((struct ax25_cb *,int,int)),int user));
struct mbuf *recv_ax25 __ARGS((struct ax25_cb *axp,int16 cnt));
int reset_ax25 __ARGS((struct ax25_cb *axp));
int send_ax25 __ARGS((struct ax25_cb *axp,struct mbuf *bp,int pid));
int addreq __ARGS((char *a,char *b));
void addrcp __ARGS((char *to,char *from));
struct ax25_cb *find_ax25 __ARGS((char *,char *));
void del_ax25 __ARGS((struct ax25_cb *axp));
char *pax25 __ARGS((char *e,char *addr));
int setcall __ARGS((char *out,char *call));
int  sendctl __ARGS((struct ax25_cb *axp,int cmdrsp,int cmd));
int t1_timeout __ARGS((struct ax25_cb *cp));	/* ax25val */
void t2_timeout __ARGS((struct ax25_cb *cp));
void t3_timeout __ARGS((struct ax25_cb *cp));
void t4_timeout __ARGS((struct ax25_cb *cp));
void t5_timeout __ARGS((struct ax25_cb *cp));
struct mbuf *segmenter __ARGS((struct mbuf *bp,int16 ssize));
void init_maxheard __ARGS((struct iface *ifp));
void build_path __ARGS((struct ax25_cb *axp,struct iface *ifp,char *newpath,int flags));

/* definition for flags */
#define REVERSE		0x01
#define NEWSRT		0x02

int st_ax25 __ARGS((struct ax25_cb *cp));		/* ax25val */
int callreq __ARGS((char *a));

/* In socket.c: */
void s_arcall __ARGS((struct ax25_cb *axp,int cnt));
void s_ascall __ARGS((struct ax25_cb *axp,int old,int new));
void s_atcall __ARGS((struct ax25_cb *axp,int cnt));

#endif	/* _AX25_H */
