#ifndef _ASY_H
#define _ASY_H

#ifndef _GLOBAL_H
#include "global.h"
#endif

#ifndef _MBUF_H
#include "mbuf.h"
#endif

#ifndef _IFACE_H
#include "iface.h"
#endif

#define	ASY_MAX	6		/* Five asynch ports allowed on the PC */

#define	SLIP_MODE		0
#define	AX25_MODE		1
#define	NRS_MODE		2
#define	UNKNOWN_MODE	3
#define PPP_MODE		4

/* In 8250.c: */
int asy_init __ARGS((int dev,struct iface *iface,char *arg1,char *arg2,
	unsigned bufsize,int trigchar,long speed,int cts,int rlsd));
int32 asy_ioctl __ARGS((struct iface *ifp,int cmd,int set,int32 val));
int asy_send __ARGS((int dev,struct mbuf *bp));
int asy_speed __ARGS((int dev,long speed));
int asy_stop __ARGS((struct iface *iface,int tmp));
int get_asy __ARGS((int dev));

int redial __ARGS((struct asy *asyp,int flag));

/* In asyvec.asm: */
INTERRUPT asy0vec __ARGS((void));
INTERRUPT asy1vec __ARGS((void));
INTERRUPT asy2vec __ARGS((void));
INTERRUPT asy3vec __ARGS((void));
INTERRUPT asy4vec __ARGS((void));
INTERRUPT asy5vec __ARGS((void));

#endif	/* ASY_MAX */


