/* Script For Viewing GPFax-Document from VoiXEL	*/

options results
parse arg file pad			/* Gets the AmigaDOS argument for the PW */

signal on halt
signal on syntax
signal on break_c

options failat 50

say "ARexx-script for viewing GPFax-Document from VoiXEL"
say ""

if file = '' then do
   say "No FAX-file supplied!"
   say "Exiting.."
   exit
end


ADDRESS COMMAND "VoiXEL:VoiXELWaitForPort -q REXX_GPFAX"

if rc>0 then
	do
		say "Starting GPFax."
		ADDRESS COMMAND "run >nil: <nil: GPFax:GPFax -z -W -NP -Q"
		ADDRESS COMMAND "VoiXEL:VoiXELWaitForPort REXX_GPFAX"
		if rc>0 then
			do
				say "Couldn't start GPFax."
				exit
			end
		say "Sending ""viewfax " file """ to GPFax."
		ADDRESS rexx_gpfax viewfax file
		say "Quit GPFax."
		ADDRESS rexx_gpfax quitfax
    end
else
	do
		say "Sending ""viewfax " file """ to GPFax."
		ADDRESS rexx_gpfax viewfax file
	end

exit



error:
	call Debug("Error" rc "at line" sigl)
	return rc

break_c:
halt:
	call Debug("CTRL_C at line" sigl)
	exit 20

syntax:
	call Debug("Syntax error" rc "at line" sigl)
	return rc


Debug: procedure
	parse arg info

	firstLine = sourceline(1)
	parse var firstLine '/*' title '*/'
	say title ':' info
	return
