/* FaxScript For GPFax And VoiXEL							*/
/* Start/Listen GPFax, Recieve Fax, Exit/Unlisten GPFax		*/

ADDRESS VOIXELPORT
options results

signal on break_c
signal on halt
signal on syntax

options failat 50

say "FaxScript For GPFax And VoiXEL"

ADDRESS COMMAND "VoiXEL:VoiXELWaitForPort -q REXX_GPFAX"

if rc>0 then
	do
		ADDRESS COMMAND "run >nil: <nil: GPFax:GPFax -z -W -NP -Q"
		ADDRESS COMMAND "VoiXEL:VoiXELWaitForPort REXX_GPFAX"
		if rc>0 then
		do
			call setVars(rc)
			exit
		end
		ADDRESS rexx_gpfax recfax
		call setVars(rc)
		ADDRESS rexx_gpfax quitfax
    end
else
	do
		ADDRESS rexx_gpfax openserial
		ADDRESS rexx_gpfax recfax
		call setVars(rc)
		ADDRESS rexx_gpfax closeserial
	end
exit


setVars: procedure
	parse arg error

	if error=0 then
		do
		address rexx_gpfax 'reportlog' 3
		address voixelport 'setVAR RETURNCODE ' || result
		address rexx_gpfax 'reportlog' 4
		address voixelport 'setVAR CALLERNUMBER ' || result
		address rexx_gpfax 'reportlog' 6
		address voixelport 'setVAR LENGTH ' || result
		address rexx_gpfax 'reportlog' 1
		address voixelport 'setVAR FILENAME ' || result
		end
	else
		do
		address voixelport 'setVAR RETURNCODE ' || 'FAIL'
		address voixelport 'setVAR CALLERNUMBER ' || 'FAIL'
		address voixelport 'setVAR LENGTH ' || 0
		address voixelport 'setVAR FILENAME'
	end
	return rc


error:
	call Debug("Error" rc "at line" sigl)
	return rc

break_c:
halt:
	call Debug("CTRL_C at line" sigl)
	exit 20

syntax:
	call Debug("Syntax error" rc "at line" sigl)
	return rc


Debug: procedure
	parse arg info

	firstLine = sourceline(1)
	parse var firstLine '/*' title '*/'
	say title ':' info
	return
