/**/
v="$VER: FreqNote Rexx Set filenote to description Williamson 56.00"
outdir=GetClip("OUTDIR")||"/"
parse arg indir site_address
indir=addslash(indir)
parse var site_address d "#" z ":" n "/" f "." p

req=z'.'n'.'f'.'p'.REQTEMP'
if ~open('rf',outdir||req,'r') then exit
inlist=upper(showdir(INDIR,'F'))
if inlist="" then exit
q=1
do while ~eof('rf')
    request=translate(readln('rf'),' ','09'x)
    if request="" then iterate
    if index(request,"!") then parse var request request.q  "!" password ';' reqdesc.q
    else parse var request request.q ';' reqdesc.q
    q=q+1
end
requests=q-1
i=0
do forever
    i=i+1
    parse var inlist infile.i inlist
    if infile.i == "" then break
end
recd=i-1
if recd=0 then exit

do i=1 to recd
    do j=1 to requests
        if upper(request.j)=upper(infile.i) then do
            if show('p',"ROOFLOG") then Address "ROOFLOG"  'logline' left(time(),5) 'FreqNote: 'request.j':'strip(compress(reqdesc.j,'"'),'B')
            address COMMAND 'FileNote' indir||request.j '"'strip(compress(reqdesc.j,'"'),'B')'"'
        end
    end
end
exit

addslash:
curr=arg(1)
select
    when right(curr, 1) = ":" then nop
    when right(curr, 1) = "/" then nop
    otherwise curr = curr"/"
end
return(curr)
