/**/
v='$VER: Carrier Rexx Watch Carrier for Doors Williamson 55.03'
options results
script='Carrier'
log=show('p','ROOFLOG')
logport=lower(GetClip('SHELTER'))||'wpl'
parse arg port session
session=strip(session)

    do i=1 to 120
        Address COMMAND 'SetEnv DOOR'||port '`status com='session'`'
        task=GetVar('DOOR'||port,'G')
        if task="" | task='TASK' then call delay(50)
            else leave
    end
    if task="" | task='TASK' then do
        call PutLog('DOOR 'session' did not start',10,10)
        exit
    end
    call PutLog('Watching carrier on 'port' for Task:'task session,10,10)

    Address VALUE port
    do forever
        call delay(50)
        'String $(door)'
        if upper(RESULT)="FALSE" then do
            call PutLog('Door 'session 'Task:'task 'not active',10,10)
            exit 
        end
        'CheckCarrier'
        if RC~=0 then iterate 
/*        if RESULT~=0 then iterate */
        else do
            call PutLog('Carrier lost RC:'RC 'during DOOR 'session),10,10)
            call PutLog('Sending BREAK to DOOR task:'task,10,10)
            address COMMAND "BREAK" task "C"
            exit
        end
    end
    call PutLog('Exiting',10,10)
exit

PutLog:  procedure expose log logport port script
    if log then do
        if arg(3) < GetClip('STATUSLEVEL') then say arg(1)
        if arg(2) > GetClip('LOGLEVEL') then return 0
        address 'ROOFLOG' 'LOGLINE' left(time(),5) script': 'arg(1)
    end;else do
        address LOGPROC 'PutLog "'logport time() right(port,1) script':'arg(1)'"'
    end
return 0

lower:
return(bitor(arg(1),'20'x))
