
/* received on 1/22/93 through E-Mail - typed from page 396 of old RKM  */
/* modified by James McOrmond to provide simple type function for Jammail */

#include <stdio.h> 
#include <exec/types.h>
#include <exec/nodes.h>
#include <exec/lists.h>
#include <exec/ports.h>
#include <exec/libraries.h>
#include <exec/devices.h>
#include <exec/io.h>
#include <devices/serial.h>

#include <proto/exec.h>
#include <string.h>
 
struct IOExtSer *IORser;
struct MsgPort *port;
char buffer[200];
extern struct MsgPort *CreatePort();
extern struct IORequest *CreateExtIO();
 
int type(char *filename, char *device, int unit, unsigned long baud, unsigned char sf)
{

    int WriteSer(struct IOExtSer *io, char *data);

    FILE *file;
    char line[255];

    int ret = 1;
    int error;

    port=CreatePort(device,unit);
    if(port==NULL)
    {
	printf("Can't CreatePort!\n");
	exit(100);
    }
  
    IORser=(struct IOExtSer *)CreateExtIO(port,sizeof(struct IOExtSer));
    if(IORser==NULL)
    {
	printf("Can't CreateExtIO\n");
	goto cleanup1;
    }
 
    IORser->io_ReadLen=0x08;
    IORser->io_BrkTime=750000;
    IORser->io_Baud=baud;
    IORser->io_WriteLen=0x08;
    IORser->io_StopBits=0x01;
    IORser->io_RBufLen=2048;
    IORser->io_SerFlags=sf;
    IORser->io_TermArray.TermArray0=0x51040303;
    IORser->io_TermArray.TermArray1=0x03030303;

    IORser->IOSer.io_Command=SDCMD_SETPARAMS;

    if((error=OpenDevice(device,unit,IORser,sf))!=0)
    {
        printf("Can't open device! : %ld\n",error);
        goto cleanup1;
    }

    if (file = fopen(filename, "r"))
    {
        ret = 0;
        printf("Type: %s\n", filename);
        while (fgets(line, 255, file))
        {
            strcat(line, "\r");
            WriteSer(IORser,line);
        }
        fclose(file);
    }
    else
        printf("Can't Find: %s\n", filename);

    cleanup2:
    CloseDevice(IORser);

    cleanup1:
    DeletePort(port);
    return ret;
}

 
int WriteSer(struct IOExtSer *io, char *data)
{
    int error;

    io->IOSer.io_Data=(APTR)data;
    io->IOSer.io_Length=-1;
    io->IOSer.io_Command=CMD_WRITE;

    if((error=DoIO(io))!=0)
    {
        printf("write error:%ld\n",error);
    }
    return error;
}
