
/* Variation on traplist.library.  New "official" nodelist.libray */

/* Based almost entirely on traplist.library, (C) 1990 Martin Laubach */

/* Inspired by structures written by Juergenn Hermann */

/* Slight adjustments made by Todd Kover 1:109/447 */


#ifndef NL_NL_H
#define NL_NL_H 1

#define NODELIST_NAME   "nodelist.library"
#define NODELIST_VER    2L

/*-------------------------------------------------------------------------*/
#define NL_USE_DOMAINS  0x00000001   /* Use domains in addr structure      */
                                   /* Passed to NLOpen()                   */

/*-------------------------------------------------------------------------*/
#define NL_VERBATIM 0x8000      /* Don't translate phone numbers in search */
               /* A FindNL() with that flag will give you the phone number */
               /* as it is listed in the nodelist                                                                       */

#define NL_PARSE_INVALID_CHAR   -1              /* Returned by NLParseAddr */
#define NL_PARSE_INVALID_NUMBER -2

/*-------------------------------------------------------------------------*/
/* defined/reserved Tag IDs */

#define ID_PASS 0x50415353              /* password entry   */
#define ID_TCNF 0x55434E46              /* TD config entry  */
#define ID_ACCT 0x41434354              /* accounting entry */

/*-------------------------------------------------------------------------*/
/* Use these macros in NLEnumNode() */

#define IS_ZONE(ad,re)   (ad->Zone == ad->Net && ad->Net == re && !ad->Node && !ad->Point)
#define IS_NET(ad,re)    (!ad->Node && !ad->Point)
#define IS_NODE(ad,re)   (ad->Node && !ad->Point)
#define IS_POINT(ad,re)  (ad->Point)
#define IS_REGION(ad,re) (!ad->Node && !ad->Point && re == ad->Net)

/*-------------------------------------------------------------------------*/
typedef struct
        {
        WORD Zone;
        WORD Net;
        WORD Node;
        WORD Point;
        char *Domain;
        } Addr;

/* This structure is returned by NLFind() and NLIndexFind() */

typedef struct
        {
        Addr Node;                                         /* node address */
        WORD Region;                                 /* region (0 if none) */
        WORD Hub;                 /* node # of this node's HUB (0 if none) */
        char *System;                                         /* node name */
        char *Sysop;                                         /* sysop name */
        char *Phone;                                       /* phone number */
        char *City;                                      /* city and state */
        char *Passwd;                                          /* password */
        char *Flags;                                     /* nodelist flags */
        LONG Cost;                                                 /* cost */
        UWORD BaudRate;                                       /* baud rate */
        LONG ID;                      /* unique ID (offset into nodeindex) */
        char *Line;                  /* Line as it appears in the NODELIST */
        } NodeDesc;

/*-------------------------------------------------------------------------*/
#ifndef NL_PRIVATE

typedef void *Extra;
typedef void *NodeList;

void LibArexx(void);

NodeList NLOpen(char *, ULONG);
void NLClose(NodeList);
NodeDesc *NLFind(NodeList, Addr *, ULONG);
int NLAddrComp(Addr *, Addr *);
void NLFreeNode(NodeDesc *);
NodeDesc *NLIndexFind(NodeList, Addr *, ULONG);

Extra ExtraOpen(char *);
void *ExtraFromNL(NodeList);
void ExtraClose(Extra);
void *ExtraFind(Extra, Addr *addr, ULONG, ULONG *);
void *ExtraFindLock(Extra, Addr *addr, ULONG, ULONG *);
BOOL ExtraPut(Extra, Addr *, ULONG, int, void *);
BOOL ExtraChange(Extra, Addr *, ULONG, int, void *);
BOOL ExtraDel(Extra, void *);
BOOL ExtraFlush(Extra);
void ExtraLock(Extra);
void ExtraUnlock(Extra);
LONG ExtraEnumNode(Extra, BOOL (*)(Addr *, void *), void *);
void ExtraChanged(Extra);
LONG ExtraEnumTag(Extra, Addr *, BOOL (*)(void *, ULONG, ULONG, void *), void *);

LONG NLEnumNode(NodeList, LONG, Addr *, BOOL (*)(Addr *, ULONG, void *), void *);

LONG NLParseAddr(Addr *, char *, Addr *);

BOOL NLSubmitNewIndex(NodeList, char *, char *);

void ExtraLockTag(Extra, void *);
void ExtraUnlockTag(Extra, void *);
/* #pragma libcall NodelistBase LibArexx 1E 9802 */
#pragma libcall NodelistBase NLOpen 24 0802
#pragma libcall NodelistBase NLClose 2A 801
#pragma libcall NodelistBase NLFind 30 09803
#pragma libcall NodelistBase NLFreeNode 36 801
#pragma libcall NodelistBase NLAddrComp 3C 9802
#pragma libcall NodelistBase NLIndexFind 42 09803
#pragma libcall NodelistBase ExtraFromNL 48 801
#pragma libcall NodelistBase ExtraOpen 4E 801
#pragma libcall NodelistBase ExtraClose 54 801
#pragma libcall NodelistBase ExtraFind 5A A09804
#pragma libcall NodelistBase ExtraPut 60 A109805
#pragma libcall NodelistBase ExtraDel 66 9802
/*#pragma libcall NodelistBase ObsoleteOldIndexFind 6C 09803 */
#pragma libcall NodelistBase ExtraFlush 72 801
#pragma libcall NodelistBase ExtraLock 78 801
#pragma libcall NodelistBase ExtraUnlock 7E 801
#pragma libcall NodelistBase ExtraEnumNode 84 A9803
#pragma libcall NodelistBase ExtraChanged 8A 801
#pragma libcall NodelistBase ExtraEnumTag 90 BA9804
#pragma libcall NodelistBase NLEnumNode 96 BA90805
#pragma libcall NodelistBase NLParseAddr 9C A9803
#pragma libcall NodelistBase NLSubmitNewIndex A2 9802
/* ExtraLockTag(xtra, address)(A0,A1)*/
/* ExtraUnlockTag(xtra, address)(A0,A1)*/
/* ExtraChange(xtra, addr, tag, size, data)(A0,A1,D0,D1,A2)*/
/* ExtraFindLock(xtra, addr, tag, size)(A0,A1,D0,A2)*/
#endif

#endif
/*-------------------------------------------------------------------------*/
/* ID: 134.55@5229  Last Changed: 30 Apr 1991 02:48:00 by mjl */
