
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <time.h>

#include <exec/types.h>
#include <exec/memory.h>
#include <exec/execbase.h>
#include <exec/ports.h>
#include <exec/nodes.h>
#include <exec/lists.h>
#include <exec/devices.h>
#include <exec/io.h>
#include <exec/libraries.h>

#include "libraries/dosextens.h"
#include "libraries/dos.h"

#include <intuition/intuition.h>

#include <dos/dos.h>
#include <dos/dosextens.h>

#include <proto/exec.h>
#include <proto/dos.h>

#include <utility/hooks.h>

#include "xferq/xferq.h"
#include "xferq/xferq_pragmas.h"

struct Library *XferqBase;

ULONG __asm SHWCB(register __a0 struct Hook *hook,
	register __a2 struct NetAddress *na, register __a1 struct TagItem *tags)
{
   void writevar(char *name, char *info);
   void readvar(char *name, char *info);

   char info[10], variable[40];

   char temp[255];

   int number, minpri, maxpri, zone, net, node, point, togo, bad, busy;
   char sys[40], var[50];

   char *astring, *domain=NULL;
   long pri;

   readvar("minpri", temp);
   if (!temp[0]) strcpy(temp, "50");
   minpri = atoi(temp);

   readvar("maxpri", temp);
   if (!temp[0]) strcpy(temp, "100");
   maxpri = atoi(temp);

   astring = XfqPutAddressTags(na, XQ_Mandatory, XQADDR_ANYTHING,
		XQ_Optional, XQADDR_ANYTHING,TAG_DONE);

   XfqExamObjectTags(na, XQ_Domain, &domain, XQ_Zone, &zone,
      XQ_Net, &net, XQ_Node, &node, XQ_Point, &point, TAG_DONE);

   if ((zone) || (net))
      sprintf(sys, "%d.%d.%d.%d.%s", zone, net, node, point, domain);
   else
      sprintf(sys, "%s", astring);

   sprintf(var, "JamTool/Togo.%s", sys);
   readvar(var, temp);
   if (!temp[0]) strcpy(temp, "0");
   togo=atoi(temp);

   pri=XfqMaxSitePri(na);

   if(astring)
   {
      if ((pri >= minpri) && (pri <= maxpri) && (!togo))
      {
         readvar("JamTool/ToDial", info);
         number = atoi(info)+1;
         sprintf(info, "%d", number);
         writevar("JamTool/ToDial", info);
         sprintf(variable, "JamTool/ToDial-%d", number);
         writevar(variable, astring);
         sprintf(variable, "Env:JamTool/ToDial-%d", number+1);
         remove(variable);
      }
      XfqDropObject(astring);
   }

   if (togo)
   {
      sprintf(temp, "%d", togo-1);
      writevar(var, temp);
   }
   else
   {
      sprintf(var, "JamTool/Bad.%s", sys);
      readvar(var, temp);
      if (!temp[0]) strcpy(temp, "0");
      bad=atoi(temp);

      sprintf(var, "JamTool/Busy.%s", sys);
      readvar(var, temp);
      if (!temp[0]) strcpy(temp, "0");
      busy=atoi(temp);

      togo=(((bad*3)+busy) / 6);

      sprintf(var, "JamTool/Togo.%s", sys);
      sprintf(temp, "%d", togo);
      if (togo)
      {
         writevar(var, temp);
      }
      else
      {
         sprintf(var, "Env:JamTool/Togo.%s", sys);
         remove(var);
      }
   }
   if(domain) XfqDropObject(domain);
   return TRUE;
}


int flolist(char uucp)
{
   void writevar(char *name, char *info);
   void readvar(char *name, char *info);

   int scandir(char *address);
   char i;

   typedef ULONG (*HOOK_FUNC)();

   struct Session *sites;
   struct Hook hook;

   FILE *lsys;

   long error;
   char *emsg;

   char address[30], tmp[255];

   UnLock(CreateDir("Env:JamTool"));
   system("delete >nil: env:jamtool/todial#?");


   sites = XfqGetSiteList();
   if (error = XfqGetError())
   {
       emsg = XfqErrorMsg(error);
       printf("Failed due to %s\n", emsg);
       XfqDropObject(emsg);
   }
   else
   {
       hook.h_Entry = (HOOK_FUNC)SHWCB;

       XfqWalkSessionCallBackTags(sites, XQ_CallBack, &hook, TAG_DONE);
   }

   if (sites)
   {
       XfqDropObject(sites);
   }

   if (uucp)
   {
      if ((lsys = fopen("uulib:l.sys", "r")) !=NULL)
      {
         while (fgets(tmp, 250, lsys) != NULL)
         {
            if ((tmp[0]=='#') || (tmp[0]==';') || (strlen(tmp) < 5)) continue;
 
            sscanf(tmp, "%s %s", address, tmp);

            for (i=0;i<=strlen(tmp);i++)
               tmp[i]=toupper(tmp[i]);

            if (!strcmp(tmp, "ANY"))
               scandir(address);
         }
         fclose(lsys);          
      }
   }
   return 0;
}


int scandir(char *address)
{
   void writevar(char *name, char *info);
   void readvar(char *name, char *info);

   char temp[30], info[30], directory[30];

   int i;

   struct FileLock       *my_lock;
   struct FileInfoBlock  *my_info;

   my_info = (struct FileInfoBlock *) AllocMem (sizeof(struct FileInfoBlock),
          MEMF_PUBLIC|MEMF_CLEAR);
 
   if (my_info == NULL) 
   {
      printf ("\nCannot allocate memory for FileInfoBlock!\n");
      return(-1);
   }

   strcpy(directory, "uuspool:");

   my_lock = (struct FileLock *)Lock(directory, ACCESS_READ);

   if (my_lock==NULL)
   {
      printf ("Cannot get a read lock on %s", directory);
      FreeMem (my_info,sizeof(struct FileInfoBlock));
      return(-1);
   }

   strcpy(temp, "C.");

   for (i=0;i<=strlen(address);i++)
      temp[i+2]=toupper(address[i]);

   Examine ((BPTR)my_lock, my_info);

   while (ExNext((BPTR)my_lock, my_info))
   {
      if (my_info->fib_DirEntryType >= 0) continue;

      for (i=0;i<=strlen(my_info->fib_FileName);i++)
         my_info->fib_FileName[i]=toupper(my_info->fib_FileName[i]);


      if (!(strncmp(my_info->fib_FileName, temp, strlen(address))))
      {
         readvar("JamTool/ToDial", info);
         i = atoi(info)+1;
         sprintf(info, "%d", i);
         writevar("JamTool/ToDial", info);
         sprintf(info, "JamTool/ToDial-%d", i);
         writevar(info, address);
         break;
      }
   }
   
   UnLock((BPTR) my_lock);
   FreeMem (my_info,sizeof(struct FileInfoBlock));
   return 0;
}
