REM this program takes a map file and then can output another map file
REM to a different ppdV and ppdH and different origin.
REM then the beginning stuff and all labels at the end must be cut
REM and pasted back into the new file

OPTION BASE 0
CLS : PRINT "This program will convert any APRS map from one ORIGIN and SCALE"
      PRINT "to another.  The output of this program will be in MAPTEMP.map"
      PRINT
Prompt: INPUT "Enter File name of source map"; F$
        OPEN F$ FOR INPUT AS #3
        INPUT "Enter desired SCALE in pixels-per-deg"; PPDD
        INPUT "Enter New Latitude of origin"; NLat
        INPUT "Enter New Longitude of origin"; NLon
LoadAux: 'Load into another dim of array until full (AyPtr starts at 0)
     INPUT "Enter file name for output if other than MAPTEMP.MAP"; F$
     IF F$ = "" THEN F$ = "MAPTEMP.MAP"
     OPEN F$ FOR OUTPUT AS #4
     INPUT #3, LATa: LINE INPUT #3, a$: IF NLat = 0 THEN NLat = LATa
     PRINT #4, NLat; ","; a$
     INPUT #3, LONa: LINE INPUT #3, a$: IF NLon = 0 THEN NLon = LONa
     PRINT #4, NLon; ","; a$
     INPUT #3, ppdV: LINE INPUT #3, a$'Pix-per-deg-Vert
     PRINT #4, PPDD; ","; a$
     INPUT #3, LatCen: LINE INPUT #3, a$
     PRINT #4, LatCen; ","; a$
     INPUT #3, LonCen: LINE INPUT #3, a$
     PRINT #4, LonCen; ","; a$
     INPUT #3, MapRng: LINE INPUT #3, a$
     PRINT #4, MapRng; ","; a$
     INPUT #3, MinRnga: LINE INPUT #3, a$
     PRINT #4, MinRnga; ","; a$
     LINE INPUT #3, a$: REM ignore line of instructions
     PRINT #4, a$
     i = 0
     REM now make offset and scale calculations
     Sfac = PPDD / ppdV
     LOfset = LONa - NLon
     LAfset = LATa - NLat
ON ERROR GOTO Errorfix

     PRINT : PRINT "Now processing map points.  Should an end of file error occur"
     PRINT "use F6, then CLOSE, to close the file.  Then use your editor to see"
     PRINT "what you have so far and fix any errors..."

     DO WHILE NOT EOF(3)
        i = i + 1: INPUT #3, x%, y%
        IF x% <> 0 THEN
           x% = Sfac * (x% - ppdV * LOfset)
           y% = Sfac * (y% - ppdV * LAfset)
           IF x% = 0 THEN x% = 1: PRINT "ZERO value of X!  Converted to 1,"; y%
           END IF
        REM print #4, MID$(STR$(x%), 2); ","; MID$(STR$(y%), 2)
        WRITE #4, x%, y%
        IF x% = 0 AND NOT EOF(3) THEN ' Get line color & store with x=0
           INPUT #3, z%: LINE INPUT #3, a$ ' Echo line name
           PRINT #4, z%; ","; a$
           IF y% = -1 THEN EXIT DO' All labels listed at end of file
           END IF
        LOOP: PRINT
        PRINT "All map points converted.  Now doing labels..."
        DO WHILE NOT EOF(3)
        LINE INPUT #3, a$: PRINT #4, a$
        LOOP: CLOSE #3: CLOSE #4
       
        PRINT : PRINT "CONVERSION SUCCESSFUL. USE EDITOR TO ADD ANY NEW FEATURES"
        PRINT "TO YOUR NEW MAP IN FILE NAMED MAPTEMP.map."
        INPUT "Hit return to continue.."; a$: STOP

Errorfix: IF ERR = 62 THEN CLOSE : RESUME NEXT

END

