#include "pop.h"

struct Screen         *Scr = NULL;
APTR                   VisualInfo = NULL;
struct Window         *Project0Wnd = NULL;
struct Gadget         *Project0GList = NULL;
struct Menu           *Project0Menus = NULL;
struct IntuiMessage    Project0Msg;
struct Gadget         *Project0Gadgets[9];
UWORD                  Project0Left = 119;
UWORD                  Project0Top = 147;
UWORD                  Project0Width = 418;
UWORD                  Project0Height = 69;
UBYTE                 *Project0Wdt = (UBYTE *)"AmiPOP Client";
struct TextAttr       *Font, Attr;
UWORD                  FontX, FontY;
UWORD                  OffX, OffY;

ULONG __saveds __asm hidepass( register __a0 struct Hook*, register __a2 struct SGWork* ,register __a1 ULONG* );

struct Hook hookentry =
{
	{0},
	hidepass,
	0,
	0,
};

struct NewMenu Project0NewMenu[] = {
	NM_TITLE, (STRPTR)"Project", NULL, 0, NULL, NULL,
	NM_ITEM, (STRPTR)"Hide", (STRPTR)"H", 0, 0L, (APTR)Project0MENU_HIDE,
	NM_ITEM, (STRPTR)NM_BARLABEL, NULL, 0, 0L, NULL,
	NM_ITEM, (STRPTR)"About...", NULL, 0, 0L, (APTR)Project0MENU_ABOUT,
	NM_ITEM, (STRPTR)"Quit", (STRPTR)"Q", 0, 0L, (APTR)Project0MENU_QUIT,
	NM_END, NULL, NULL, 0, 0L, NULL };

static UWORD ComputeX( UWORD value )
{
	return(( UWORD )((( FontX * value ) + 4 ) / 8 ));
}

static UWORD ComputeY( UWORD value )
{
	return(( UWORD )((( FontY * value ) + 4 ) / 8 ));
}

static void ComputeFont( UWORD width, UWORD height )
{
	Font = &Attr;
	Font->ta_Name = (STRPTR)Scr->RastPort.Font->tf_Message.mn_Node.ln_Name;
	Font->ta_YSize = FontY = Scr->RastPort.Font->tf_YSize;
	FontX = Scr->RastPort.Font->tf_XSize;

	OffX = Scr->WBorLeft;
	OffY = Scr->RastPort.TxHeight + Scr->WBorTop + 1;

	if ( width && height ) {
		if (( ComputeX( width ) + OffX + Scr->WBorRight ) > Scr->Width )
			goto UseTopaz;
		if (( ComputeY( height ) + OffY + Scr->WBorBottom ) > Scr->Height )
			goto UseTopaz;
	}
	return;

UseTopaz:
	Font->ta_Name = (STRPTR)"topaz.font";
	FontX = FontY = Font->ta_YSize = 8;
}

int SetupScreen( void )
{
	if ( ! ( Scr = LockPubScreen( PubScreenName )))
	{
		if ( ! (Scr = LockPubScreen( NULL )))
		{
			return( 1L );
		}
	}

	ComputeFont( 0, 0 );

	if ( ! ( VisualInfo = GetVisualInfo( Scr, TAG_DONE )))
		return( 2L );

	return( 0L );
}

void CloseDownScreen( void )
{
	if ( VisualInfo ) {
		FreeVisualInfo( VisualInfo );
		VisualInfo = NULL;
	}

	if ( Scr        ) {
		UnlockPubScreen( NULL, Scr );
		Scr = NULL;
	}
}

void Project0Render( void )
{
	ComputeFont( Project0Width, Project0Height );

	DrawBevelBox( Project0Wnd->RPort, OffX + ComputeX( 0 ),
					OffY + ComputeY( 50 ),
					ComputeX( 417 ),
					ComputeY( 18 ),
					GT_VisualInfo, VisualInfo, TAG_DONE );
}

int HandleProject0IDCMP( void )
{
	struct IntuiMessage	*m;
	struct MenuItem		*n;
	int			(*func)( void );
	BOOL			running = TRUE;

	while( (Project0Wnd) && (m = GT_GetIMsg( Project0Wnd->UserPort ) ) ) {

		CopyMem(( char * )m, ( char * )&Project0Msg, (long)sizeof( struct IntuiMessage ));

		GT_ReplyIMsg( m );

		switch ( Project0Msg.Class ) {

			case	IDCMP_REFRESHWINDOW:
				GT_BeginRefresh( Project0Wnd );
				Project0Render();
				GT_EndRefresh( Project0Wnd, TRUE );
				break;

			case	IDCMP_CLOSEWINDOW:
				running = Project0CloseWindow();
				break;

			case	IDCMP_VANILLAKEY:
				Project0VanillaKey();
				break;

			case	IDCMP_CHANGEWINDOW:
				Project0ChangeWindow();
				break;

			case	IDCMP_GADGETUP:
				func = ( int (*) (void ) )(( struct Gadget * )Project0Msg.IAddress )->UserData;
				func();
				break;

			case	IDCMP_MENUPICK:
				while ( (Project0Msg.Code != MENUNULL) && (Project0Wnd) )
				{
					n = ItemAddress( Project0Menus, Project0Msg.Code );
					func = (int (*) (void) )(GTMENUITEM_USERDATA(n));
					running= func();
					Project0Msg.Code = n->NextSelect;
				}
				break;
		}
	}
	return( running );
}

int OpenProject0Window( void )
{
	struct NewGadget	ng;
	struct Gadget	*g;
	UWORD		wleft = Project0Left, wtop = Project0Top, ww, wh;

	WORD zipsize[]={0,0,200,90};

	hookentry.h_SubEntry = (ULONG (*)() )password; /* Attempt to get hook working again */
	memset(passfake,PASSCHAR,strlen(password)); /* Show initial string gadget condition */
	passfake[strlen(password)]='\0';

	ComputeFont( Project0Width, Project0Height );

	ww = ComputeX( Project0Width );
	wh = ComputeY( Project0Height );

	if (( wleft + ww + OffX + Scr->WBorRight ) > Scr->Width ) wleft = Scr->Width - ww;
	if (( wtop + wh + OffY + Scr->WBorBottom ) > Scr->Height ) wtop = Scr->Height - wh;

	zipsize[2]=(WORD)(ww + Scr->WBorRight);
	zipsize[3]=(WORD)(Scr->WBorTop + (Scr->Font->ta_YSize +1));

	if ( ! ( g = CreateContext( &Project0GList )))
		return( 1L );

/* */

	ng.ng_VisualInfo = VisualInfo;
	ng.ng_TextAttr   = Font;
	ng.ng_LeftEdge	= OffX + ComputeX( 85 );
	ng.ng_TopEdge	= OffY + ComputeY( 17 );
	ng.ng_Width		= ComputeX( 114 );
	ng.ng_Height	= ComputeY( 12 );
	ng.ng_GadgetID	= GD_MYGAD_USER;
	ng.ng_GadgetText= "_Username";
	ng.ng_Flags		= PLACETEXT_LEFT;
	ng.ng_UserData	= (APTR)MYGAD_USERClicked;

	Project0Gadgets[GD_MYGAD_USER]=g=	CreateGadget(STRING_KIND,g,&ng,
										GTST_String,	username,
										GTST_MaxChars,	SMALLSTRING-1,
										GT_Underscore,	'_',
										TAG_DONE);
/* */

	ng.ng_LeftEdge	= OffX + ComputeX( 85 );
	ng.ng_TopEdge	= OffY + ComputeY( 32 );
	ng.ng_Width		= ComputeX( 114 );
	ng.ng_Height	= ComputeY( 12 );
	ng.ng_GadgetID	= GD_MYGAD_PASSWORD;
	ng.ng_GadgetText= "Pass_word";
	ng.ng_Flags		= PLACETEXT_LEFT;
	ng.ng_UserData	= (APTR)MYGAD_PASSWORDClicked;

	Project0Gadgets[GD_MYGAD_PASSWORD]=g=	CreateGadget(STRING_KIND,g,&ng,
										GTST_String,	passfake,
										GTST_EditHook,	&hookentry,
										GTST_MaxChars,	SMALLSTRING-1,
										GT_Underscore,	'_',
										TAG_DONE);

/* */

	ng.ng_LeftEdge	= OffX + ComputeX( 414 ) - 25;
	ng.ng_TopEdge	= OffY + ComputeY( 32 );
	ng.ng_Width		= ComputeX( 26 );
	ng.ng_Height	= ComputeY( 11 );
	ng.ng_GadgetID	= GD_MYGAD_DELETE;
	ng.ng_GadgetText= "_Delete Messages?";
	ng.ng_Flags		= PLACETEXT_LEFT;
	ng.ng_UserData	= (APTR)MYGAD_DELETEClicked;

	Project0Gadgets[GD_MYGAD_DELETE]=g=	CreateGadget(CHECKBOX_KIND,g,&ng,
										GTCB_Checked,	delmail,
										GT_Underscore,	'_',
										TAG_END);

/* */

    ng.ng_LeftEdge	= OffX + ComputeX( 300 );
	ng.ng_TopEdge	= OffY + ComputeY( 2 );
	ng.ng_Width		= ComputeX( 114 );
	ng.ng_Height	= ComputeY( 12 );
	ng.ng_GadgetID	= GD_MYGAD_MAILDIR;
	ng.ng_GadgetText= "Mail _Box";
	ng.ng_Flags		= PLACETEXT_LEFT;
	ng.ng_UserData	= (APTR)MYGAD_MAILDIRClicked;

	Project0Gadgets[GD_MYGAD_MAILDIR]=g=	CreateGadget(STRING_KIND,g,&ng,
										GTST_String,	maildir,
										GTST_MaxChars,	BIGSTRING-1,
										GT_Underscore,	'_',
										TAG_DONE);

/* */

    ng.ng_LeftEdge	= OffX + ComputeX( 329 );
	ng.ng_TopEdge	= OffY + ComputeY( 53 );
	ng.ng_Width		= ComputeX( 83 );
	ng.ng_Height	= ComputeY( 11 );
	ng.ng_GadgetID	= GD_MYGAD_BUTTON;
	ng.ng_GadgetText= "Check _Now";
	ng.ng_Flags		= PLACETEXT_IN;
	ng.ng_UserData	= (APTR)MYGAD_BUTTONClicked;

	Project0Gadgets[GD_MYGAD_BUTTON]=g=	CreateGadget(BUTTON_KIND,g,&ng,
										GT_Underscore,	'_',
										TAG_DONE);

/* */

    ng.ng_LeftEdge	= OffX + ComputeX( 85 );
	ng.ng_TopEdge	= OffY + ComputeY( 2 );
	ng.ng_Width		= ComputeX( 114 );
	ng.ng_Height	= ComputeY( 12 );
	ng.ng_GadgetID	= GD_MYGAD_HOST;
	ng.ng_GadgetText= "_POP Host";
	ng.ng_Flags		= PLACETEXT_LEFT;
	ng.ng_UserData	= (APTR)MYGAD_HOSTClicked;

	Project0Gadgets[GD_MYGAD_HOST]=g=	CreateGadget(STRING_KIND,g,&ng,
										GTST_String,	pophost,
										GTST_MaxChars,	BIGSTRING-1,
										GT_Underscore,	'_',
										TAG_DONE);

/* */

	ng.ng_LeftEdge	= OffX + ComputeX( 202 );
	ng.ng_TopEdge	= OffY + ComputeY( 53 );
	ng.ng_Width		= ComputeX( 39 );
	ng.ng_Height	= ComputeY( 12 );
	ng.ng_GadgetID	= GD_MYGAD_TIME;
	ng.ng_GadgetText= "How _Often";
	ng.ng_Flags		= PLACETEXT_RIGHT;
	ng.ng_UserData	= (APTR)MYGAD_TIMEClicked;

	Project0Gadgets[GD_MYGAD_TIME]=g=	CreateGadget(INTEGER_KIND,g,&ng,
										GTIN_Number,	timecheck,
										GTIN_MaxChars,	3,
										GT_Underscore,	'_',
										GA_Disabled,	!checkper,
										TAG_DONE);

/* */

	ng.ng_LeftEdge	= OffX + ComputeX( 11 );
	ng.ng_TopEdge	= OffY + ComputeY( 54 );
	ng.ng_Width		= ComputeX( 26 );
	ng.ng_Height	= ComputeY( 11 );
	ng.ng_GadgetID	= GD_MYGAD_CRONCHECK;
	ng.ng_GadgetText= "_Check Periodically";
	ng.ng_Flags		= PLACETEXT_RIGHT;
	ng.ng_UserData	= (APTR)MYGAD_CRONCHECKClicked;

	Project0Gadgets[GD_MYGAD_CRONCHECK]=g=	CreateGadget(CHECKBOX_KIND,g,&ng,
										GTCB_Checked,	checkper,
										GT_Underscore,	'_',
										TAG_DONE);

/* */

	ng.ng_LeftEdge	=  OffX + ComputeX( 414 ) - 25;
	ng.ng_TopEdge	= OffY + ComputeY( 17 );
	ng.ng_Width		= ComputeX( 26 );
	ng.ng_Height	= ComputeY( 11 );
	ng.ng_GadgetID	= GD_MYGAD_APPEND;
	ng.ng_GadgetText= "_Append to MailBox?";
	ng.ng_Flags		= PLACETEXT_LEFT;
	ng.ng_UserData	= (APTR)MYGAD_APPENDClicked;

	Project0Gadgets[GD_MYGAD_APPEND]=g=	CreateGadget(CHECKBOX_KIND,g,&ng,
										GT_Underscore,	'_',
										GTCB_Checked,	appfile,
										TAG_DONE);

	if ( ! ( Project0Menus = CreateMenus( Project0NewMenu, GTMN_FrontPen, 0L, GTMN_NewLookMenus, TRUE, TAG_DONE )))
		return( 3L );

	LayoutMenus( Project0Menus, VisualInfo, TAG_DONE );

	if ( ! ( Project0Wnd = OpenWindowTags( NULL,
				WA_Left,	wleft,
				WA_Top,		wtop,
				WA_Width,	ww + OffX + Scr->WBorRight,
				WA_Height,	wh + OffY + Scr->WBorBottom,
				WA_IDCMP,	STRINGIDCMP|CHECKBOXIDCMP|BUTTONIDCMP|INTEGERIDCMP|IDCMP_MENUPICK|IDCMP_CLOSEWINDOW|IDCMP_VANILLAKEY|IDCMP_CHANGEWINDOW|IDCMP_REFRESHWINDOW,
				WA_Flags,	WFLG_DRAGBAR|WFLG_DEPTHGADGET|WFLG_CLOSEGADGET|WFLG_SMART_REFRESH,
				WA_Gadgets,	Project0GList,
				WA_Title,	Project0Wdt,
				WA_PubScreen,	Scr,
				WA_AutoAdjust,	TRUE,
				WA_NewLookMenus,TRUE,
				WA_Activate,	TRUE,
				WA_Zoom,	zipsize,
				TAG_DONE )))
	return( 4L );

	SetMenuStrip( Project0Wnd, Project0Menus );
	GT_RefreshWindow( Project0Wnd, NULL );

	Project0Render();

	return( 0L );
}

void CloseProject0Window( void )
{
	if ( Project0Menus      ) {
		ClearMenuStrip( Project0Wnd );
		FreeMenus( Project0Menus );
		Project0Menus = NULL;	}

	if ( Project0Wnd        ) {
		CloseWindow( Project0Wnd );
		Project0Wnd = NULL;
	}

	if ( Project0GList      ) {
		FreeGadgets( Project0GList );
		Project0GList = NULL;
	}
}

/* Hook goodies */

ULONG __saveds __asm hidepass(register __a0 struct Hook *hook, register __a2 struct SGWork *sgw, register __a1 ULONG *msg)
{
	UBYTE *pass_ptr;

	pass_ptr = (STRPTR)hook->h_SubEntry;

	sgw->BufferPos = sgw->NumChars;

	if(*msg == SGH_KEY)
	{
		switch (sgw->EditOp)
		{
			case EO_INSERTCHAR:
				pass_ptr[sgw->BufferPos - 1] = sgw->WorkBuffer[sgw->BufferPos - 1];
				pass_ptr[sgw->BufferPos] = '\0';
    			sgw->WorkBuffer[sgw->BufferPos - 1] = (UBYTE)PASSCHAR;
				break;

			case EO_DELBACKWARD:
				pass_ptr[sgw->BufferPos] = '\0';
				break;

			default:
				sgw->Actions &= ~SGA_USE;
				break;
		}

		return (~0L);
	}
	if(*msg == SGH_CLICK)
	{
		sgw->BufferPos = sgw->NumChars;
		return (~0L);
	}

	return (0L);
}

