/*
 * File......: GT_RMemo.prg
 * Author....: Niall Scott
 * BBS.......: The Dark Knight Returns
 * Net/Node..: 050/069
 * User Name.: Niall Scott
 * Date......: 29/6/93
 * Revision..: 1.0
 * Log file..: $Logfile$
 *
 * This is an original work by Niall R Scott and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * Rev 1.0  29/6/93
 * Initial Revision
 */

/*  $DOC$
 *  $FUNCNAME$
 *      GT_MEMOREAD
 *  $CATEGORY$
 *      Get Reader
 *  $ONELINER$
 *      GET a Memo Field
 *  $SYNTAX$
 * 		@ <row>, <col> GET <memo> MEMO COORD <coords> ;
 *       BOXCOLOR <bcolor> TITLE <title>
 *  $ARGUMENTS$
 *      Standard Get parameters +
 *		coords 	- array of 4 elements Top,left,bottom,right of MemoEdit Box
 *		bcolor  - color of MemoEdit Box (optional)
 *		title   - title of Memoedit Box (optional)
 *  $RETURNS$
 *      Updated Get:buffer
 *  $DESCRIPTION$
 *      To allow a standard GET/Read on a Memo field.
 *		displays MEMO/memo at the <row>, <col> position depending
 *		if the memo field has anything in it.
 *		Control_Page_Down to enter the Memo reader
 *		Allows all standard features of get system eg WHEN,VALID
 *		if get COLOR is used this will be used for the MEMO/memo
 *
 *		REQUIRES GT_Cent() if the TITLE option is used
 *  $EXAMPLES$
 *PROCEDURE TestMemo()
 *	LOCAL GetList := {}
 *	LOCAL mNotes
 *
 *  	CLS
 *  	mNotes := "This is the default memo string at entry to the GET."
 *
 *  	@ 4,0 SAY "Notes:"
 *  	@ 4,10 GET mNotes MEMO COORD {5, 10, 15, 50} ;
 *								BOXCOLOR "W+/B,GR+/B" TITLE 'Test'
 *  	READ
 *
 *  	? mNotes
 * 	RETURN
 *  $SEEALSO$
 *
 *  $INCLUDE$
 *		GT_Memo.ch
 *  $END$
 */

#include "gt_lib.ch"
#include "gt_memo.ch"

//  Layout of cargo instance variable
#define  ID       1                 // cargo col 1 - option id
#define  DATA     2                 // cargo col 2 - memo data
#define  COORDS   3                 // cargo col 3 - coordinates array
#define  COLOR    4                 // cargo col 4 - optional box color
#define  HEADER	  5                 // cargo col 5 - optional Box Title

//  Layout of COORDS element in cargo instance variable
#define  T        1                 // coords col 1 - top
#define  L        2                 // coords col 2 - left
#define  B        3                 // coords col 3 - bottom
#define  R        4                 // coords col 4 - right

//  For compatibility  with Clipper 5.01 taken from
//  Common.ch included with Clipper 5.2
#translate ISBLOCK( <v1> )       => ( valtype( <v1> ) == "B" )
#translate ISCHARACTER( <v1> )   => ( valtype( <v1> ) == "C" )

#define MEMO_OPEN	K_CTRL_PGDN
#define MEMO_CLOSE  K_CTRL_W



PROCEDURE GT_MemoRead(g)
   Local cOldColor
   cOldColor := SetColor()
   IF (GetPreValidate(g))
      SETKEY(K_CTRL_PGUP, {|| KeyWrite()})
      g:setFocus()

      WHILE(g:exitstate == GE_NOEXIT)

         WHILE(g:exitstate == GE_NOEXIT)
            MyApplyKey(g, INKEY(0))
         ENDDO

         IF (!GetPostValidate(g))
            g:exitstate := GE_NOEXIT
         ENDIF

      ENDDO

      g:killFocus()
      SETKEY(MEMO_CLOSE, NIL)
   ENDIF
   SetColor( cOldColor )
RETURN

FUNCTION KeyWrite

   KEYBOARD CHR(K_CTRL_END)

RETURN NIL

PROCEDURE MyApplyKey(get, key)
LOCAL cKey
LOCAL bKeyBlock

   // check for SET KEY first
   IF ((bKeyBlock := SETKEY(key)) <> NIL)
      GetDoSetKey(bKeyBlock, get)
      RETURN									// NOTE
   ENDIF

   DO CASE
   CASE (key == K_UP);              get:exitState := GE_UP
   CASE (key == K_SH_TAB);          get:exitState := GE_UP
   CASE (key == K_DOWN);            get:exitState := GE_DOWN
   CASE (key == K_TAB);             get:exitState := GE_DOWN
   CASE (key == K_ENTER);           get:exitState := GE_ENTER

   CASE (key == K_ESC);             IF (SET(_SET_ESCAPE)) ;;
                                      get:exitState := GE_ESCAPE ;;
                                    ENDIF

   CASE (key == K_PGUP);            get:exitState := GE_WRITE
   CASE (key == K_PGDN);            get:exitState := GE_WRITE
   CASE (key == K_CTRL_HOME);       get:exitState := GE_TOP
   CASE (key == MEMO_OPEN);         GetMemo(get)
   ENDCASE

RETURN



FUNCTION GetMemo( oGet)
LOCAL cTempScrn, aCoords
LOCAL cOldColor := SETCOLOR()
LOCAL lOldScore := SET(_SET_SCOREBOARD, .F.)
LOCAL nRow := ROW(), nCol := COL()
LOCAL cTitle

   //Default aCoords to Full Screen
   aCoords := IF(VALTYPE( oGet:cargo[COORDS]) == "A", ;
     oGet:cargo[COORDS], {0, 0, MAXROW(), MAXCOL()})

   cTempScrn := SAVESCREEN(aCoords[T], aCoords[L], aCoords[B], aCoords[R])

   IF  oGet:cargo[COLOR] <> NIL
      SETCOLOR( oGet:cargo[COLOR])
   ENDIF

   // Draw Single Line Box
   @ aCoords[T], aCoords[L] TO aCoords[B], aCoords[R]

   //Draw Title centred on top line if passed
   IF ( oGet:cargo[HEADER] <> NIL ) .AND. ( ISCHARACTER( oGet:cargo[HEADER] ))
			cTitle := ' '+ oGet:cargo[HEADER]+ ' '
			@ aCoords[T], aCoords[L] + GT_CENT(cTitle,aCoords[R]-aCoords[L]) SAY cTitle

   ENDIF

	//The Meat of the function
    oGet:varPut( oGet:cargo[DATA] := MEMOEDIT( oGet:cargo[DATA], aCoords[T] + 1, ;
    aCoords[L] + 1, aCoords[B] - 1, aCoords[R] - 1))

    oGet:updateBuffer()

   RESTSCREEN(aCoords[T], aCoords[L], aCoords[B], aCoords[R], cTempScrn)

   SETCOLOR(cOldColor)
   SET(_SET_SCOREBOARD, lOldScore)
   SETPOS(nRow, nCol)

RETURN NIL


FUNCTION xGetNew(nRow, nCol, bBlock, cName, bValid, bWhen)
LOCAL oGet := GetNew(nRow, nCol, bBlock, cName)

   oGet:postBlock := bValid
   oGet:preBlock := bWhen

RETURN(oGet)
