/*
 * GT CLIPPER STANDARD HEADER
 *
 * File......: gt_compn.c
 * Author....: Brian Dukes
 * BBS.......: THE CELLAR bbs
 * Net/Node..: 013/203
 * User Name.: Brian Dukes
 * Date......: 28/5/93
 * Revision..: 1.0
 *
 * This is an original work by Brian Dukes and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */

/*
 *  $DOC$
 *  $FUNCNAME$
 *      GT_COMPN()
 *  $CATEGORY$
 *      General
 *  $ONELINER$
 *      Compress a Clipper Numeric value into a string
 *  $SYNTAX$
 *      <str> := GT_CompN(<numeric>,<size>)
 *  $ARGUMENTS$
 *      <numeric> - Clipper value to compress
 *      <size>    - Number of Bytes to compress to (1/2/4/8)
 *  $RETURNS$
 *      <str>     - Character String Returned
 *  $DESCRIPTION$
 *      This function is surprisingly quite handy.  Its principle use is to
 *      create data storage types similar to C, char,int, long, double.
 *      The use then surpasses that with the fact that these new variables
 *      in clipper are just 1/2/4/8 character strings which can be written
 *      away to databases or even used in an index.
 *
 *      what this all means is that a field that only needs to store values
 *      from 0-255, only need be one character wide in the database
 *      structure.
 *
 *  $EXAMPLES$
 *      #include "gt_compn.h"
 *
 *      function main()
 *
 *         * Setup some Test Values into some local variables
 *
 *         local w   := 10
 *         local x   := 1000
 *         local y   := 1234567
 *         local z   := 1234567.890123
 *
 *         * Reserve Enough Space in Each Storage Variable
 *
 *         local s_w := space( GT_BYTE )
 *         local s_x := space( GT_INT )
 *         local s_y := space( GT_LONG )
 *         local s_z := space( GT_DOUBLE )
 *
 *         * Store The Compressed Numbers in Their Storage Variables
 *
 *         s_w := GT_CompN( w, GT_BYTE)
 *         s_x := GT_CompN( x, GT_INT )
 *         s_y := GT_CompN( y, GT_LONG)
 *         s_z := GT_CompN( z, GT_DOUBLE)
 *
 *  $SEEALSO$
 *      GT_UNCOMPN()
 *  $END$
 */

/**** Compiled in MS/C v6.0  as  CL /AL /Gs /Zl -c gt_compn.c        ****/

#include <extend.h>
#include "gt_compn.h"

CLIPPER GT_CompN()
{
   unsigned int siz = _parni( 2 ) ;    /* Get the SIZE of the Variable */
   int    i_var     = 0 ;
   long   l_var     = 0 ;
   double d_var     = 0.00 ;
   char       out_buf[10] ;
   char far * out   = out_buf ;

   switch (siz)
      {
         case GT_BYTE :
            i_var = _parni( 1 ) ;  /* Get the Number initially as an INT */
            out[0] = (unsigned char) i_var ;
            out[ GT_BYTE+1 ] = NULL ;
            break;

         case GT_INT :
            i_var = _parni( 1 ) ;  /* Get the Number as an INT */
            _gt_far_copy(out,&i_var,GT_INT) ;
            out[ GT_INT+1 ] = NULL ;
            break;

         case GT_LONG :
            l_var = _parnl( 1 ) ;  /* Get the Number as an LONG */
            _gt_far_copy(out,&l_var,GT_LONG) ;
            out[ GT_LONG+1 ] = NULL ;
            break;

         case GT_DOUBLE :
            d_var = _parnd( 1 ) ;  /* Get the Number as an DOUBLE */
            _gt_far_copy(out,&d_var,GT_DOUBLE) ;
            out[ GT_DOUBLE+1 ] = NULL ;
            break;
      }

   _retclen(out, siz) ;
   return ;
}


/***************************************************************************
 _gt_far_copy() - Copy Near Memory to Far Memory
 ***************************************************************************/

int _gt_far_copy( char far * out , char * in , int len)
{
   int i = 0 ;
   char far * fp = out ;
   char * p = in ;

   while (i < len)
      {
         *fp++ = *p++ ;
         ++i ;
      }

   return (len) ;
}
