/*

 Ŀ
                                                                        
  File Name...: OPENSCRN.PRG                                            
  Author......: Vernon E. Six, Jr.                                      
  Date created: 04-04-94              Date updated: 04-04-94           
  Time created: 09:30:29pm            Time updated: 09:30:29pm         
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/

#include "BAS_VERN.CH"
#include "setcurs.ch"

/* HYPERTEXT START
!short: basOpenScrn()   Draw a very nice opening screen for your applications
basOpenScrn()   Draw a very nice opening screen for your applications

^BDescription: ^B

   basOpenScrn() allows your functions to draw a very nice opening screen
   for your application.


^BSyntax:^B

   basOpenScrn( cBigText, [cTitle1], [cTitle2], [cFooter1], [cFooter2] )


^BPass:^B

   ^BcBigText^B is a character expression that should contai the text you
   want displayed in "big" letters on your opening screen.  You can fit
   roughly eight characters in this field.

   ^BcTitle1^B is an optional character expression to use as the first line
   of the title for your opening screen.

   ^BcTitle2^B is an optional character expression to use as the second line
   of the title for your opening screen.

   ^BcFooter1^B is an optional character expression to use as the first
   line of the footer for your opening screen.  "CopyRight (c) 1994 by
   FrontLine Software" is assumed if you don't pass ^BcFooter1^B.

   ^BcFooter2^B is an optional character expression to use as the second
   line of the footer for your opening screen.  "All Rights Reserved World
   Wide" is assumed if you don't pass ^BcFooter2^B.


^BReturns:^B

   Always nil


^BSource:^B

   OPENSCRN.PRG



HYPERTEXT END */
function basOpenScrn( pcBigText, pcTitle1, pcTitle2, pcFooter1, pcFooter2 )

   local nLength  := len( basBigText( pcBigText, 1 ) )
   local nRow     := int( maxrow() / 2 ) - 4
   local nCol     := int( ( 80 - nLength ) / 2 )
   local nCntr    := 0
   local nKey     := 0

   local cTColor1 := if( basMono(), "N/W", "B/W"  )
   local cTColor2 := if( basMono(), "N/W", "B/W"  )

   local cLColor1 := if( basMono(), "N/W", "R+/W" )
   local cBigColr := if( basMono(), "N/W", "B/W"  )
   local cLColor2 := if( basMono(), "N/W", "R+/W" )

   local cFColor1 := if( basMono(), "N/W", "B/W"  )
   local cFColor2 := if( basMono(), "N/W", "B/W"  )

   assume pcTitle1 is "" if missing
   assume pcTitle2 is "" if missing

   assume pcFooter1 is "Copyright (c) 1994 by FrontLine Software" if missing
   assume pcFooter2 is "All Rights Reserved World Wide"

   DispBegin()

   setcursor(SC_NONE)

   DispBox(00,00,maxrow(),maxcol(),space(9),cTColor1)

   @ nRow-6,0 say padc(pcTitle1,80) color cTColor1
   @ nRow-5,0 say padc(pcTitle2,80) color cTColor2

   @ nRow,nCol say replicate(chr(223),nLength) color cLColor1

   for nCntr := 1 to 6

      @ nRow+nCntr,nCol say basBigText( pcBigText, nCntr) color cBigColr

   next nCntr

   @ nRow+7,nCol say replicate(chr(223),nLength) color cLColor2

   @ nRow+12,0 say padc(pcFooter1,80) color cFColor1
   @ nRow+13,0 say padc(pcFooter2,80) color cFColor2

   DispEnd()

   nKey = inkey(3)

   if nKey = 0

      @ maxrow(),00 say padc( "( Press Any Key To Continue )", 80 ) color cTColor1

      inkey(0)

   endif

   clear screen

   setcursor(SC_NORMAL)

   return nil

