/*

 Ŀ
                                                                        
  File Name...: NG_PULL.PRG                                             
  Author......: Vernon E. Six, Jr.                                      
  Date created: 07-04-94              Date updated: 07-04-94           
  Time created: 01:15:06pm            Time updated: 01:15:06pm         
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/

#include "fileio.ch"

function Ng_Pull( pcInFile, pcOutFile )

   local nHandle     := 0
   local cLine       := ""
   local axEntries   := {}
   local lReading    := .f.
   local nLen1       := 0
   local nLen2       := 0
   local nI          := 0
   local nJ          := 0

   cls
   ? "NG_PULL v2.0 - HyperText Processor"
   ? "CopyRight (c) 1994 by FrontLine Software"
   ? "All Rights Reserved World Wide"
   ?
   ?

   begin sequence

      if .not. pcount() == 2
         ? "Syntax:  NG_PULL {InFile.Ext} {OutFile.Ext}"
         ?
         ? "Note: If {OutFile.Ext} exists, it will be appended to"
         break
      endif

      ? upper(pcInFile)

      if .not. file( pcInFile )
         ? "File not found... " + pcInFile
         break
      endif

      nHandle := ft_fUse(pcInFile)

      if nHandle < 1
         ? "Unable to open file... " + pcInFile
         break
      endif

      while .not. ft_fEof()

         cLine := ft_fReadLn()

         if alltrim(cLine) == "/* HYPERTEXT START"
            aAdd(axEntries,{})
            lReading := .t.
            ft_fSkip()
            loop
         endif

         if alltrim(cLine) == "HYPERTEXT END */"
            lReading := .f.
            ft_fSkip()
            loop
         endif

         if lReading
            aAdd( axEntries[len(axEntries)], cLine )
         endif

         ft_fSkip()

      enddo

      ft_fUse()

      axEntries := aSort( axEntries,,,{|x,y|x[1] <= y[1]} )

      if file(pcOutFile)
         nHandle := fOpen(pcOutFile,FO_READWRITE)
      else
         nHandle := fCreate(pcOutFile)
      endif

      if nHandle < 1
         ? "Unable to create file... " + pcOutFile
         break
      endif

      fseek(nHandle,0,FS_END)

      nLen1 := len(axEntries)

      for nI := 1 to nLen1

         nLen2 := len(axEntries[nI])
         for nJ := 1 to nLen2

            fWrite(nHandle,axEntries[nI,nJ] + chr(13) + chr(10) )

         next nJ

      next nI

      fClose(nHandle)

   end sequence

   return nil












