/*

 Ŀ
                                                                        
  File Name...: HOST.PRG                                                
  Author......: Vern Six                                                
  Date created: 09-30-94                Date updated: 09-30-94         
  Time created: 11:19:13am              Time updated: 11:19:13am       
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/



// host mode command line utility
function Host(pcCmd,pcFileName,pcUser,pcKillSent)

   cls
   ? "Host v1.1 - Command Line Version"
   ? "CopyRight (c) 1994 by FrontLine Software"
   ? "All Rights Reserved World Wide"
   ?
   ?

   begin sequence

      do case

         case pcount() == 0

            sSyntax()

         case upper(pcCmd) == "WAIT"

            hstHost()

         case upper(pcCmd) == "SEND"

            if pcount() < 4
               sSyntax()
               break
            endif

            hstAddFile( pcUser, pcFileName, (pcKillSent $ "YyTt") )


         case upper(pcCmd) == "FILESENT"

            if pcount() != 3
               sSyntax()
               break
            endif

            hstFileSent(pcUSer,pcFileName)


         case upper(pcCmd) == "REMFILE"

            if pcount() != 3
               sSyntax()
               break
            endif

            hstRemFile(pcUSer,pcFileName)


         otherwise

            sSyntax()


      endcase

   end sequence

   return nil


static function sSyntax()

   ? "Proper Syntax:"
   ?
   ? "HOST WAIT                                - Wait for a call"
   ?
   ? "HOST SEND {filename} {user} {killsent}   - Send a file to a user"
   ? "  Example:  HOST SEND C:\AUTOEXEC.BAT VERNSIX Y"
   ?
   ? "HOST FILESENT {filename} {user}          - Mark file as sent"
   ? "  Example:  HOST FILESENT C:\AUTOEXEC.BAT VERNSIX"
   ?
   ? "HOST REMFILE {filename} {user}           - Remove file from queue"
   ? "  Example:  HOST REMFILE C:\AUTOEXEC.BAT VERNSIX"
   ?
   ?

   return nil

