/*

 Ŀ
                                                                        
  File Name...: DESSTUFF.PRG                                            
  Author......: Vernon E. Six, Jr.                                      
  Date created: 09-03-94              Date updated: 09-03-94           
  Time created: 06:11:08pm            Time updated: 06:11:08pm         
                                                                        
  Notes.......: This code is really nothing more than what came with    
                the DESCRYPT.LIB.  I just changed it to return a value  
                instead of printing stuff to the screen.                
                                                                        
 
  

*/

// Blocksize must be a multiple of 8
#define __BLKSIZE 8192


/* HYPERTEXT START
!short: desDecrypt()    Decrypt a file that was encrypted w/desEcrypt()
desDecrypt()    Decrypt a file that was encrypted w/desEncrypt()

^BDescription: ^B

   desDecrypt() is a simple adaptation of Ira's DECR.PRG except this
   function doesn't display errors to the screen, rather it returns an
   error code.


^BSyntax:^B

   nError := desDecrypt( cInFile, cOutFile, cKey )


^BPass:^B

   ^BcInFile^B is a character expression that should contain the full
   filename of the file to decrypt.  If you don't specify a path, the
   current path is assumed.

   ^BcOutFile^B is a character expression that should contain the full
   filename of the file to place the decrypted file in.  If you don't
   specify a path, the current path is assumed.

   ^BcKey^B is a character expression that should contain the key that
   was used when ^BcInFile^B was encrypted by desEncrypt().  This value
   must be exactly eight characters in length and is case sensitive.


^BReturns:^B

   ^BnError^B is a numeric expression that will contain the following
   values...

       Ŀ
        Value  Description                                        
       Ĵ
                                                                  
           0   No error.  Success!                                
                                                                  
          -1   Incorrect number of parameters                     
                                                                  
          -2   Unable to open cInFile                             
                                                                  
          -3   Wrong cKey for this file                           
                                                                  
          -4   Unable to create cOutFile                          
                                                                  
       


^BNotes:^B

   Requires DESCRYPT.LIB from...

       Extrasensory Software
       4450 Murietta Ave., #8
       Sherman Oaks, CA  91423

       (818) 981-8367 Voice
       (818) 986-5411 Fax


^BSource:^B

   DESSTUFF.PRG

HYPERTEXT END */
function desDecrypt( pcInFile, pcOutFile, pcKey )

   local cBlk        := ""       // Current block
   local nInHandle   := 0        // File handle for input file
   local nOutHandle  := 0        // File handle for output file
   local nPieceLen   := 0        // Length of current block
   local cUnCipher   := ""       // Decrypted current block
   local cCBCcode    := pcKey    // Cypher Block Chaining key
   local nOutFileLen := 0        // Length of unencrypted file
   local nError      := 0

   begin sequence

      if .not. pcount() == 3
         nError := -1                  // incorrect parms
         break
      endif

      nInHandle := fopen( pcInFile )

      if nInHandle < 0
         nError := -2                  // unable to open InFile
         break
      endif

      cBlk := space( 12 )
      fread( nInHandle, @cBlk, 12 )

      if .not. Password( pcKey ) == left( cBlk, 8 )
         nError := -3                  // wrong key
         break
      endif

      nOutFileLen := bin2l( SUBSTR( cBlk, 9 ) )

      nOutHandle := fcreate( pcOutFile )

      if nOutHandle < 0
         nError := -4                  // unable to create OutFile
         break
      endif

      nPieceLen   := __BLKSIZE
      cBlk        := space( __BLKSIZE )


      // In this loop, the input file is decrypted __BLKSIZE at a time
      // and written to the output file.
      while nPieceLen == __BLKSIZE

         nPieceLen := fread( nInHandle, @cBlk, __BLKSIZE )

         cUnCipher := DecryptStr( left(cBlk,nPieceLen), pcKey, cCBCcode )

         fwrite( nOutHandle, cUnCipher )

         cCBCcode  := right( cBlk, 8 )

      enddo

      fclose( nInHandle )

      // Here the file pointer is moved to the correct position and
      // the output file is truncated by fwrite()ing nothing.
      fseek ( nOutHandle, nOutFileLen, 0 )
      fwrite( nOutHandle, "" )
      fclose( nOutHandle     )

   end sequence

   return nError




/* HYPERTEXT START
!short: desEncrypt()    Encrypt a file
desEncrypt()    Encrypt a file

^BDescription: ^B

   desEncrypt() is a simple adaptation of Ira's ENCR.PRG except this
   function doesn't display errors to the screen, rather it returns an
   error code.


^BSyntax:^B

   nError := desEncrypt( cInFile, cOutFile, cKey )


^BPass:^B

   ^BcInFile^B is a character expression that should contain the full
   filename of the file to encrypt.  If you don't specify a path, the
   current path is assumed.

   ^BcOutFile^B is a character expression that should contain the full
   filename of the file to place the encrypted file in.  If you don't
   specify a path, the current path is assumed.

   ^BcKey^B is a character expression that should contain a security
   key for encrypting this file.  This value must be exactly eight
   characters in length and is case sensitive.


^BReturns:^B

   ^BnError^B is a numeric expression that will contain the following
   values...

       Ŀ
        Value  Description                                        
       Ĵ
                                                                  
           0   No error.  Success!                                
                                                                  
          -1   Incorrect number of parameters                     
                                                                  
          -2   Unable to open cInFile                             
                                                                  
          -3   Unable to create cOutFile                          
                                                                  
       


^BNotes:^B

   Requires DESCRYPT.LIB from...

       Extrasensory Software
       4450 Murietta Ave., #8
       Sherman Oaks, CA  91423

       (818) 981-8367 Voice
       (818) 986-5411 Fax


^BSource:^B

   DESSTUFF.PRG

HYPERTEXT END */
function desEncrypt( pcInFile, pcOutFile, pcKey )

   local cBlk        := ""       // Current block
   local nInHandle   := 0        // File handle for input file
   local nOutHandle  := 0        // File handle for output file
   local nPieceLen   := 0        // Length of current block
   local cCypher     := ""       // Encrypted current block
   local cCBCcode    := pcKey    // Cypher Block Chaining key
   local nInFileLen  := 0        // Length of unencrypted file
   local nError      := 0

   begin sequence

      if .not. pcount() == 3
         nError := -1                  // incorrect parms
         break
      endif


      nInHandle := fopen( pcInFile )

      if nInHandle < 0
         nError := -2                  // unable to open InFile
         break
      endif

      InFileLen := fseek( nInHandle, 0, 2 )
      fseek( nInHandle, 0, 0 )


      nOutHandle := fcreate( pcOutFile )

      if nOutHandle < 0
         nError := -3                  // unable to create OutFile
         break
      endif


      fwrite( nOutHandle, password(pcKey) + l2bin(InFileLen) )

      nPieceLen   := __BLKSIZE
      cBlk        := space( __BLKSIZE )


      // In this loop, the input file is encrypted __BLKSIZE at a time
      // and written to the output file.
      while nPieceLen == __BLKSIZE

         nPieceLen   := fread( nInHandle, @cBlk, __BLKSIZE )

         cCypher     := EncryptStr( left(cBlk,nPieceLen), pcKey, cCBCcode )

         fwrite( nOutHandle, cCypher )

         cCBCcode    := right(cCypher,8)

      enddo

      fclose( nOutHandle )
      fclose( nInHandle )

   end sequence

   return nError


