@echo off
rem BLD_NG.BAT - Build BAS_VERN.NG
rem Last Updated: Thu  10-06-1994  17:40:26
rem Requires: Expert Help from SofSolutions

rem    make sure the utilities are here
if not exist ng_pull.exe goto no_utils
if not exist datsort.exe goto no_utils

rem    pull all the hypertext from the *.PRGs
if exist func.doc del func.doc
for %%s in (*.PRG) do call ng_pull %%s func.doc

rem    sort the documentation by function name
datsort func.doc func.dat

rem    bring them all together
copy /b header.dat + func.dat  text.dat

rem    compile
ehc text.dat       -NG -NP

rem    link
ehml bas_ng.ehl

rem    rename it
if exist bas_vern.ng del bas_vern.ng
ren bas_ng.ng bas_vern.ng

rem    clean up
del func.dat
del func.doc
del text.dat
del text.eho
del datsort.exe
del ng_pull.exe

goto end

:no_utils
echo You are missing the required utilities (NG_PULL.EXE & DATSORT.EXE).
echo You can build them by typing the following commands...
echo.
echo     cd ng_pull
echo     bld
echo.
echo.

:end

