/*

 Ŀ
                                                                        
  File Name...: AT.PRG                                                  
  Author......: Vernon E. Six, Jr.                                      
  Date created: 04-04-94              Date updated: 09-20-94           
  Time created: 09:31:20pm            Time updated: 05:35:39pm         
  CopyRight...: (c) 1994 by FrontLine Software                          
                                                                        
 
  

*/

#include "BAS_VERN.CH"

/* HYPERTEXT START
!short: basAt()         Return the position of the Nth occurance of a string
basAt()         Return the position of the Nth occurance of a string

^BDescription: ^B

   basAt() is an improved version of Clipper's own AT() function.  The main
   difference is that you can specify which occurance of the search string
   you want to find.


^BSyntax:^B

   nPos := basAt( cSearch, cTarget, nOccurance )


^BPass:^B

   ^BcSearch^B is a character expression that should contain phrase you want
   to search for in ^BcTarget^B.

   ^BcTarget^B is a character expression that should contain the string you
   want to search through for ^BcSearch^B.

   ^BnOccurance^B is a numeric expression that should contain the desired
   occurance of ^BcSearch^B you want to locate.


^BReturns:^B

   ^BnPos^B is a numeric expression that will contain the position within
   ^BcTarget^B that ^BcSearch^B can be located.


^BSource:^B

   AT.PRG

HYPERTEXT END */
function basAt( pcSearch, pcTarget, pnOccurance )

   // Returns the position of the Nth occurance of pcSearch within pcTarget

   local nPosition := 0
   local nCntr     := 0
   local nFound    := 0
   local nLength   := 0

   assume pnOccurance is 1 if missing

   nLength := len(pcTarget)

   for nCntr := 1 to nLength

      if substr( pcTarget, nCntr, len(pcSearch) ) == pcSearch

         nFound++

         if nFound == pnOccurance
            nPosition := nCntr
            exit
         endif

      endif

   next nCntr

   return nPosition




// 
//
// the following are here just because NG_PULL.EXE can't pull from a *.CH
// file
//
// 


/* HYPERTEXT START
!short: ASSUME          Assume a variable is a value if not passed
ASSUME          Assume a variable is a value if not passed

^BDescription: ^B

   ASSUME allows you to easily default a variable to a specified value if the
   variable was not passed to your function.


^BSyntax:^B

   ASSUME <MemVar> IS <Value> [IF MISSING]


^BPass:^B

   ^B<MemVar>^B is any valid Clipper variable

   ^B<Value>^B is any valid Clipper value


^BReturns:^B

   N/A

^BSource:^B

   BAS_VERN.CH

HYPERTEXT END */


/* HYPERTEXT START
!short: nTrim()         Convert a numeric value to a trimmed string
nTrim()         Convert a numeric value to a trimmed string

^BDescription: ^B

   nTrim() allows you to convert a numeric value to a "trimmed" string.


^BSyntax:^B

   cTrimmed := nTrim( nValue )


^BPass:^B

   ^BnValue^B is a numeric expression that should contain the number you
   want to convert to a trimmed string.


^BReturns:^B

   ^BcTrimmed^B is a character expression that will contain the trimmed
   string version of ^BnValue^B.


^BSource:^B

   BAS_VERN.CH

HYPERTEXT END */



/* HYPERTEXT START
!short: _TIME_NOW       Manifest constant for current time in date/time format
_TIME_NOW       Manifest constant for current time in date/time format

^BDescription: ^B

   _TIME_NOW is just a shorthand method of writing basDateTime() without
   any parameters.


^BSyntax:^B

   _TIME_NOW


^BPass:^B

   N/A


^BReturns:^B

   N/A


^BSource:^B

   BAS_VERN.CH

HYPERTEXT END */




/* HYPERTEXT START
!short: basShrink()     Shrink an array by one element
basShrink()     Shrink an array by one element

^BDescription: ^B

   basShrink() makes shrinking an array a one step process instead of first
   calling ADEL() and then ASIZE().


^BSyntax:^B

   basShrink( array )


^BPass:^B

   ^Barray^B is an array that you want to delete the last element from


^BReturns:^B

   N/A


^BSource:^B

   BAS_VERN.CH

HYPERTEXT END */




/* HYPERTEXT START
!short: basEnhanced()   Return the "enhanced" portion of a SETCOLOR() string
basEnhanced()   Return the "enhanced" portion of a SETCOLOR() string

^BDescription: ^B

   basEnhanced() allows you to quickly obtain the "enhanced" portion of a
   SETCOLOR() string.


^BSyntax:^B

   cString := basEnhanced( cColor )


^BPass:^B

   ^BcColor^B is a character expression that should contain the SETCOLOR()
   string you want to parse.


^BReturns:^B

   ^BcString^B is a character expression that will contain the color
   portion you want.


^BSource:^B

   BAS_VERN.CH

HYPERTEXT END */



/* HYPERTEXT START
!short: basUnselected() Return the "unselected" portion of a SETCOLOR() string
basUnselected() Return the "unselected" portion of a SETCOLOR() string

^BDescription: ^B

   basUnselected() allows you to quickly obtain the "unselected" portion of a
   SETCOLOR() string.


^BSyntax:^B

   cString := basUnselected( cColor )


^BPass:^B

   ^BcColor^B is a character expression that should contain the SETCOLOR()
   string you want to parse.


^BReturns:^B

   ^BcString^B is a character expression that will contain the color
   portion you want.


^BSource:^B

   BAS_VERN.CH

HYPERTEXT END */




/* HYPERTEXT START
!short: basNormal()     Return the "normal" portion of a SETCOLOR() string
basNormal()     Return the "normal" portion of a SETCOLOR() string

^BDescription: ^B

   basNormal() allows you to quickly obtain the "normal" portion of a
   SETCOLOR() string.


^BSyntax:^B

   cString := basNormal( cColor )


^BPass:^B

   ^BcColor^B is a character expression that should contain the SETCOLOR()
   string you want to parse.


^BReturns:^B

   ^BcString^B is a character expression that will contain the color
   portion you want.


^BSource:^B

   BAS_VERN.CH

HYPERTEXT END */








