/*****************************************************************************
  DLGCBAR.H

  Purpose: 
  	Interface for CTheApp.  This class encapsulates the initialization,
  	running, and termination of the DLGCBAR application.  There must be
  	exactly one object of class CTheApp in the application.  The object
  	must be declared at the global level.

  Functions:
  	CTheApp::CTheApp()          -- constructor
  	CTheApp::~CTheApp()         -- destructor
  	CTheApp::FirstInstance()    -- locate first instance of app
  	CTheApp::InitInstance()     -- initialize app-instance
  	CTheApp::OnHelpAbout()		-- display About box

  Development Team: 
  	Mary Kirtland

  Written by Microsoft Product Support Services, Premier ISV Support
  Copyright (c) 1994 Microsoft Corporation. All rights reserved.
\****************************************************************************/

#ifndef __DLGCBAR_H__
	#define __DLGCBAR_H__
	
class CTheApp : public CWinApp
{   
public:
	CTheApp();

// Attributes
public:

// Operations
public:

// Overrides
public:
	virtual BOOL InitInstance();

// Implementation
public:
	virtual ~CTheApp();  
	  
protected:	  
	BOOL FirstInstance();

	// Generated message map functions
	//{{AFX_MSG(CTheApp)
	afx_msg void OnHelpAbout();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#endif //__DLGCBAR_H__

	
