{$A+,B-,D+,E-,F-,G-,I-,L+,N-,O-,P-,Q+,R+,S+,T+,V-,X+,Y+}
{$M 16384,0,0}
uses DOS, TpCRT, TpString;

const CopyR ='WVW_tune, ver. 1.00   (C) V.S. Rabets, 1994';

type FontCode = (font866, fontWin);
     tFont = record FName: PathStr;   {  䠩  ⮬        }
                    FLen:  word;      {  䠩  ⮬      }
                    Code:  FontCode;  { ஢             }
                    FOfs:  word;      { 饭 [ࠣ]  }
             end;                     {               WinView.com  }
const Font: array [1..6] of tFont = (
            (FName:'866_08.FNT'; FLen:2048; Code:font866; FOfs:$07A2-$100),
            (FName:'866_14.FNT'; FLen:3584; Code:font866; FOfs:$11A2-$100),
            (FName:'866_16.FNT'; FLen:4096; Code:font866; FOfs:$2722-$100),
            (FName:'WIN_08.FNT'; FLen:2048; Code:fontWin; FOfs:$0FA2-$100),
            (FName:'WIN_14.FNT'; FLen:3584; Code:fontWin; FOfs:$1FA2-$100),
            (FName:'WIN_16.FNT'; FLen:4096; Code:fontWin; FOfs:$3722-$100) );

type tSwitch = record SName: char;         {    ப WVW }
                      SNum:  byte;         { 浪           }
                      SVal:  byte;         { ﭨ                 }
                      SDescr: string[44];  { ᠭ                  }
               end;
const sCount = 8;                        { ᫮ ࠨ 祩 WVW   }
      ofsSw_Name = $3E30 - $100;         { 饭 ⠡  祩     }
      ofsSw_Val  = $3E3D - $100;         { 饭 ⠡ 祭 祩 }
      wSwitch: array [1..sCount] of tSwitch = (
   (SName:'^'; SNum:3; SVal: 0; SDescr:' ᯮ짮 ࠢ_Ctrl'),
   (SName:'S'; SNum:4; SVal: 0; SDescr:'࠭ ᪠- '),
   (SName:'B'; SNum:5; SVal: 0; SDescr:'ࠦ ᨬ 00  FF ஡'),
   (SName:'C'; SNum:6; SVal: 0; SDescr:' ন ⠡ UpCase'),
   (SName:'I'; SNum:7; SVal: 0; SDescr:' ஢ ० ࠬ'),
   (SName:'L'; SNum:8; SVal: 0; SDescr:'⠭  '),
   (SName:'K'; SNum:9; SVal: 0; SDescr:'⠭ ࠨ '),
   (SName:'X'; SNum:10;SVal: 0; SDescr:' ᫥ 襭 ணࠬ'));

type tBord = record BOfs: word;            { 饭 ࠬ  WVW.com }
                    BVal,                  { 饥 祭 ࠬ   }
                    BDef: byte;            { ⠭⭮ 祭     }
                    BDescr: string[29];    { ᠭ                 }
             end;
const BordCount = 10;                      { ᫮ ࠨ ࠬ }
      wBord: array [1..BordCount] of tBord = (
  (BOfs:$41D-$100; BVal:0; BDef:$00; BDescr:'᪠ 866 '),
  (BOfs:$41E-$100; BVal:0; BDef:$38; BDescr:'᪠ 866 '),
  (BOfs:$425-$100; BVal:0; BDef:$04; BDescr:'᪠ Win '),
  (BOfs:$426-$100; BVal:0; BDef:$24; BDescr:'᪠ Win '),
  (BOfs:$63B-$100; BVal:0; BDef:$08; BDescr:'᪠ 866 '),
  (BOfs:$63C-$100; BVal:0; BDef:$01; BDescr:'᪠ 866 '),
  (BOfs:$626-$100; BVal:0; BDef:$10; BDescr:'ࠨ᪠ 866 '),
  (BOfs:$627-$100; BVal:0; BDef:$02; BDescr:'ࠨ᪠ 866 '),
  (BOfs:$427-$100; BVal:0; BDef:$05; BDescr:'᪮-ࠨ᪠ Win '),
  (BOfs:$428-$100; BVal:0; BDef:$2D; BDescr:'᪮-ࠨ᪠ Win '));

type tName = array [1..11] of char;
     pName = ^tName;
const wLen = 20443;                {  䠩 WVW.com                    }
      ofsName = $0766 - $100;      { 饭  WinVieW  䠩 WVW.com }
      wName = 'WinVieW1.00';       {  WinVieW                     }

var wBuf: array [0..wLen-1] of byte;   {   뢠 WVW.com }
    fBuf: array [0..4096-1] of byte;   {   뢠 ⮢ }

procedure Help;
begin
  ClrScr;
  writeln (CopyR);
  writeln (   'ன騪 ࠩ WinVieW ᨨ 1.00');
  writeln (#10'    WVW.com ࠩ WinVieW    ⥪饬 ⠫.');
  writeln (#10'      㪠   ப 䠩 ⮢.');
  writeln (   '       ⮢  ଠ EVAfont  뢠');
  writeln (   '        866_08  866_14  866_16  Win_08  Win_14    Win_16,');
  writeln (   '       ७ .fnt  ( Win_*.fnt ᯮ ⮫쪮 ᨬ 80h-BFh).');
  writeln (#10'    /S -   ࠨ ࠬ஢  ⠭⭮ ﭨ.');
  writeln (#10'    뢠  ᪠ १⭮  ࠩ');
  writeln (   '       WVW.com 室    ᬥ饭 3FBCh.');
  writeln ;
  writeln ('        02-05-94                   .. '                 );
  writeln ('                         e-mail:   rabets@icph20.sherna.msk.su');
  writeln ('                          :   142 432'                    );
  writeln ('                                   ᪮᪠ .'            );
  writeln ('                                   ᪨ -'              );
  writeln ('                                   . ୮'            );
  writeln ('                                    -, 18, . 241'  );
  halt;
end;

procedure Err (Mes: string);            { 饭  訡  室 }
begin
   TextAttr:=$4F;
   ClrScr;
   writeln (#10'  ',Mes,#7);
   halt;
end;

procedure DefaultParams;     { ⠭ ࠬ஢  祭  㬮砭 }
var b: byte;
begin
  for b:=1 to sCount do wSwitch[b].SVal:=0;
  for b:=1 to BordCount do with wBord[b] do BVal:=BDef;
  writeln ('⠭ ⠭ 祭 ࠬ஢ WinVieW');
end;

procedure TuneBord (N: byte);                           { ன ࠬ }
type tColor = record CName: char;        {  梥 }
                     CVal:  byte;        { 祭       }
                     CDescr: string[13]; { ᠭ       }
              end;
const BColor: array [1..6] of tColor = (
              (CName:'r'; CVal:32; CDescr:'񬭮-'),
              (CName:'g'; CVal:16; CDescr:'񬭮-'),
              (CName:'b'; CVal: 8; CDescr:'񬭮-ᨭ'  ),
              (CName:'R'; CVal: 4; CDescr:''      ),
              (CName:'G'; CVal: 2; CDescr:''      ),
              (CName:'B'; CVal: 1; CDescr:''        ) );
var R: registers;
    SaveBord: byte;
    BCh: char;
    b: byte;
begin
  with wBord[N] do repeat
    Window (9,9, 71,25); TextAttr:=$34; ClrScr;
    FastWrite ('  ENTER - ⠭ ࠬ, ESC -   ',25,20,$70);
    writeln (' ࠨ ࠬ: ', BDescr); TextAttr:=$31;
    writeln (#10'   ⨢  ࠬ  㪢');
    writeln (   ' R,G,B  㦭 ॣ:'#10);
    for b:=1 to 6 do with BColor[b] do begin
        write   ('        '); if (BVal and CVal)>0 then write (#8'');
        writeln (' ',CName, '   ',CDescr);
    end;
    R.AX:=$1001; R.BH:=BVal; Intr($10,R);  { ⠭ ࠬ }
    BCh:=ReadKey; if BCh=#0 then ReadKey; if BCh=#27{Esc} then BVal:=BDef;
    for b:=1 to 6 do with BColor[b] do if BCh=CName then BVal:=BVal xor CVal;
    R.AX:=$1001; R.BH:=BVal; Intr($10,R);  { ⠭ ࠬ }
  until (BCh=#27{Esc}) or (BCh=#13{Enter});
  TextAttr:=$1B; ClrScr; Window (1,1, 80,25);
end;

{ ---------------------------------------------------------------- MAIN --- }
label ParValid;
var SaveMode: word;
    Par: ComStr;
    fW,fF: file;
    CharSize: byte;
    w,b: byte;
    Ch: char;
    SaveWVW: boolean;
begin
  SaveMode:=LastMode; TextMode(Co80); TextAttr:=$1E; ClrScr;
  writeln (CopyR); TextAttr:=$1B;
  assign(fW,'WVW.com');
  reset (fW,1); if IOresult>0 then
            Err(' ⥪饬 ⠫   䠩 WVW.com ࠩ WinVieW');
  if FileSize(fW)<>wLen then Err ('ୠ  䠩 WVW.com');
  BlockRead (fW, wBuf, wLen);
       if IOresult>0 then Err('訡 ⥭ 䠩 WVW.com ࠩ WinVieW');
  if tName( Ptr(Seg(wBuf),Ofs(wBuf)+ofsName)^ )<>wName
     then Err (' 䠩 WVW.com,   ࠩ -  1.00');

  for b:=1 to sCount do with wSwitch[b] do begin
     if SName<>char(wBuf[ofsSw_Name+SNum]) then Err (' 䠩 WVW.com');
     SVal:=wBuf[ofsSw_Val+SNum];
     { ஥  ࠢ $80, ⠫ - 0 }
     if (SVal and $7F)>0 then Err (' 䠩 WVW.com');
  end;
  for b:=1 to BordCount do with wBord[b] do BVal:=wBuf[BOfs];

  for w:=1 to ParamCount do begin              {   ப }
    Par:=StUpcase(ParamStr(w));
    if Par='/?' then Help;
    if Par='/S' then begin DefaultParams; continue end;
    for b:=1 to 6 do if JustFilename(Par)=Font[b].FName then goto ParValid;
        Err (' ࠬ  ப: '+Par);
    ParValid:
    with Font[b] do begin
      assign(fF,Par);
      reset (fF,1); if IOresult>0 then Err ('  䠩  ' + Par);
      if FileSize(fF)<>FLen then Err ('ୠ  䠩  ' + Par);
      BlockRead (fF, fBuf, FLen);
                if IOresult>0 then Err ('訡 ⥭ 䠩  '+ Par);
      CharSize:=Flen div 256;
      if Code=font866 then move (fBuf, wBuf[FOfs], Flen)
         else move (fBuf[CharSize*$80], wBuf[FOfs], CharSize*($BF-$80+1));
      close (fF); if IOresult>0 then Err('訡  䠩  '+Par);
      writeln ('  ', FName);
    end;
  end;

  HiddenCursor;
  repeat
    SaveWVW:=false;
    FastWrite (
    '  F2 -  ࠬ஢  WVW.com, ESC - 室    ',25,9,$70);
    gotoXY (1,9);
    writeln (' ᮮ⢥ 㪢   ﭨ :');
    for b:=1 to sCount do with wSwitch[b] do begin
        write ('     '); if SVal=$80 then write (#8'');
        writeln (' ', SName, '   ', SDescr);
    end;
    writeln (#10'  0-9  ⠭ ᮮ⢥饩 ࠬ:');
    writeln ('                           ');
    writeln ('        866-       0            4             6');
    writeln ('        866-       1            5             7');
    writeln ('        Win-       2            8             8');
    writeln ('        Win-       3            9             9');
    Ch:=UpCase(ReadKey); if Ch=#0 then SaveWVW:=ReadKey=#60{F2};
    for b:=1 to sCount do with wSwitch[b] do
        if Ch=SName then SVal:=SVal xor $80;
    if Ch in ['0'..'9'] then TuneBord (succ(byte(Ch)-byte('0')));
  until (Ch=#27) or SaveWVW;
  if SaveWVW then begin
     for b:=1 to sCount do with wSwitch[b] do wBuf[ofsSw_Val+SNum]:=SVal;
     for b:=1 to BordCount do with wBord[b] do wBuf[BOfs]:=BVal;
     Seek(fW,0); BlockWrite (fW, wBuf, wLen); close (fW);
       if IOresult>0 then Err('訡  䠩 WVW.com ࠩ WinVieW');
  end;
  TextMode(SaveMode);
end.
