;       Mem736 - expander memory
;         (⥫ )
; ।⠢ 736    DOS

cseg    segment
        assume  cs:cseg,ds:cseg,es:cseg,ss:cseg

;     ६
        
nprm    equ     byte ptr ds:[0080h]  ;- ⮢  ࠬ ணࠬ
old10   equ     dword ptr cs:[00c0h] ;  뢠 10
old2f   equ     dword ptr cs:[00c4h] ;  뢠 2F
prz1    equ     word ptr ds:[00c8h]  ;ਧ 736k(FFFF)/640k(0000)
prz2    equ     word ptr cs:[00cah]  ;ਧ  (FFFF)/(0000)
; ਧ prz1 뢠  ꥬ ⨢  㯥 DOS  -
;  ,  ਧ prz2 - ⨢  ⨢஢ १⭠ -
; ࠬ   .
old08   equ     dword ptr cs:[00d0h] ;  뢠 08
old20   equ     dword ptr cs:[00d4h] ;  뢠 20
old21   equ     dword ptr cs:[00d8h] ;  뢠 21

        org     100h
start:  jmp     begin

;     ६

;    


;   楤 new2f - ࠡ稪 뢠 2F
;  楤 ⠢  楯 ࠡ稪 뢠 2F. ᫨
; ॣ AH  饭  뢠 2F  ࠢ EFh,  ࠢ -
; । ᫥饬 ࠡ稪. ᫨ AH = EFh,   ॣ
; AL. ᫨ AL = 55h,  ந ⨢ १⭮ ணࠬ,
; .. ⪫砥 ࠡ稪 뢠 10h (prz2=0000h), ᮥ
;  DOS   640 (.. 㪮稢 ᫥  MCB), -
;  樠 (⠭ ० 03h १ ⠭
; int 10h). ᫨ AL = AAh,  ந ⨢ १⭮ ணࠬ-
; , ..   ਢ  ﭨ 㯭  -
; ᠬ A0000-BFFFF,    A0000  B7FFF 砥  DOS
; (.. 㢥稢 ᫥  MCB), ⠭ ਧ ⨢-
;  ணࠬ (prz2)  ਧ ࠧ  736 (prz1).  AH = EFh
;  ॣ AX ᥣ 頥 祭 AA55h,  ᯮ 
;   १⭮  ணࠬ.

new2f     proc      near
          cmp       ah,0efh   ;᫨ 㭪.EF,  室  ࠡ⪥ ( lb01),
          je        lb01      ;,  室  ஬ .
          jmp       dword ptr cs:old2f
lb01:     push      ds        ;࠭ ॣ஢  ⥪.
          push      es
          push      dx
          cld
          mov       dx,cs     ;ds=cs
          mov       ds,dx
          xor       dx,dx     ;es=0
          mov       es,dx
;    㭪樨:
;  55 -  ࠡ稪 뢠 10
;  AA -   . .10
          cmp       al,55h    ;᫨ 㭪.55,   ..10,
          jne       lb02      ;᫨ ,   ஢ <㭪=AA>
          call      m640      ;640 - ணࠬ १ MCB
                              ; ࠭ A0000
          mov       prz1,0000h  ;ᤥ ਧ 640
          mov       prz2,0000h  ;ᤥ ਧ 
          mov       ax,0003h  ;⠭ ⥪⮢ ० 03h
          int       10h       ;(8025 ᨬ, 梥)
out2f:    mov       bx,prz2
                              ;⠭ ॣ஢  
          pop       dx        ; ࠡ稪 뢠 2F
          pop       es
          pop       ds
          mov       ax,0aa55h ;ਧ  १⭮ ணࠬ mem736
          iret                ;  뢠 2F
lb02:     cmp       al,0aah   ;᫨ 㭪. AA,   ..10,
          jne       out2f     ;᫨ ,   室
          call      egamem    ;egamem - - 祭  ࠡ祥
                              ;ﭨ  A0000 - B8000
          call      clrs      ;clrs - ணࠬ ⪨ ࠭
          call      m736      ;736 - ணࠬ ७ MCB
                              ; ࠭ B8000
          mov       prz1,0ffffh ;ᤥ ਧ ON
          mov       prz2,0ffffh ;ᤥ ਧ 
          jmp       out2f     ; 室  뢠
new2f     endp

;   楤 new2f

;   new10 - ࠡ稪 뢠 10
;  ᭮ 楤 १⭮ .   ⢫ -
; 祭 ꥬ ⨢   室  ᪨  ⥪-
;  ०  ᯥ稢 ⠭ ࠡ   ⥪⮢
; ०  ᯮ짮    ७  DOS.
;  楤 ᫥ ⪨ ४  ᪨ ० 
; ( 㭪 00h, ० > 03h )  ⪫砥 ⥫  ( ᫨
;  室 ) । ⠭ ०.  ⪠ ४
;  ⥪⮢ ० ( 㭪 00h, ० <= 03h ) 頥 㫥
;   , ᫨ 室, 㢥稢 㯭  
;  736.  楤  ࠡ稪 㭪権 02h ( 樮-
; ஢  )  05h ( ⠭ ⨢ ࠭ ) ⠭⭮ -
; ࠬ ࠡ⪨ 뢠 10h.     ⥪⮢ ०,
;  ⨢ mem736, ᯮ ⠭⭮ (  ० 㯭 
; ᠬ A0000h-BFFFFh ),   ࠢ쭮 ࠡ 㭪権 02h  05h -
; 室  ᮮ⢥騥 ࠢ (    ࠢ -
; ⠢ ᫮ C000h ). 㭪 0Eh ( 뢮 ᨬ  ० ⥫⠩ )
; 믮 ⠭ ࠡ稪,  樮஢  ᫥
; 믮 뢮 ᨬ ந  楤ன. 㭪 0Eh
; ( ⠭ ⮢ ) 墠祭  ⠭ 㯭 
;   DOS ᫥  襭, ⠪  ⠭ ࠡ稪
; 樠 ࠭,  ⠭ ⠭ ⥪⮢ ०.

new10     proc      near
          push      ds
          push      es
          push      dx
          mov       dx,cs
          mov       ds,dx     ;ds=cs
          xor       dx,dx
          mov       es,dx     ;es=0
          pop       dx
          cmp       prz2,0ffffh ;᫨ 736 ,  த,
          jne       out10a      ;  室.
          cmp       ah,0      ;᫨ 㭪 00,  ࠡ⪠,
          jne       lb11      ;᫨ ,  室  த ( lb11).

;ࠡ⪠ 㭪樨 00
          cmp       al,03h    ;᫨ ० ⥪⮢ (<=03), ,
          ja        lb12      ;᫨ ᪨,  室.
;ࠡ⪠ ० <=03
          or        al,80h    ;⠭  1 襣  ०,
                              ; ⮬ ந室 ⠭ ० 
                              ;樠樨 ࠭.
          pushf
          call      dword ptr cs:old10      ;室  ⭮
                                            ;-  ⮬
          and       byte ptr es:[0487h],7fh ;  7 䫠 EGA,
                                            ; 訩  ⥪饣
                                            ;०.
          call      egamem    ;  ࠡ  A0000-B8000
          call      clrs      ; ࠭
          cmp       prz1,0ffffh
          je        out10     ;᫨   736,   室
          call      m736      ;㢥   MCB
          mov       prz1,0ffffh ;ਧ  ON
;室  뢠
out10:    pop       es
          pop       ds
          iret
;ࠡ⪠ ० >03
lb12:     call      m640      ;㬥   MCB
          mov       prz1,0000h             ;ਧ  OFF
          pushf
          call      dword ptr cs:old10     ;室  ⭮
                                           ;-  ⮬
          jmp       out10
; ࠡ⪨ 㭪樨 00

;஢ઠ ਧ 736 (prz1).
lb11:     cmp       prz1,0ffffh
          je        lb13  ;᫨ ਧ 736,  室
                          ; ⭮ ࠡ稪  
out10a:   pop       es
          pop       ds
          jmp       dword ptr cs:old10

lb13:     cmp       ah,02h    ;᫨ 㭪.02 (- ),
          jne       lb14      ;ࠡ⪠,   த

;ࠡ⪠ 㭪樨 02 (樮஢ )
          push      ax
          push      bx
          push      cx
          push      dx
          mov       bl,bh     ; BL  ࠭
          xor       bh,bh
          shl       bx,1      ; BX  ࠭ * 2
          add       bx,0450h  ;   न 
                              ; ६ BIOS.
          mov       word ptr es:[bx],dx ; 0040:005X - 
          sub       bx,0450h
lb15:     shr       bx,1      ; BX  ࠭
; 楤 樮஢ 
          mov       ax,word ptr es:[044ah] ; AX ⢮ ᨬ ⮫-
                                           ;殢  ⥪饬 ०.
          mul       dh          ; AX ந  ப
                                ; ⢠ ⮫殢  ப
          xor       dh,dh       ; DX ⠫  ⮫
          add       ax,dx       ;   ᨬ 
                                ;砫 ࠭
          mov       cx,ax       ;cx=ax
          mov       ax,bx       ; AX  ࠭
          mov       bx,0800h    ;0800h ࠧ ࠭  
          mul       bx          ; AX ᬥ饭 -  砫 
          add       ax,cx       ; AX ᬥ饭    砫
                                ;
          add       ax,0c000h   ; ᬥ饭   A0000h
          mov       cx,ax       ;᫥ ᬥ饭 樨   CX
          mov       dx,03d4h    ;  ॣ 0Eh  0Fh  EGA 3D5h
          mov       al,0eh      ;᫥  .
          out       dx,al
          inc       dx
          mov       al,ch
          out       dx,al
          dec       dx
          mov       al,0fh
          out       dx,al
          inc       dx
          mov       al,cl
          out       dx,al
          pop       dx
          pop       cx
          pop       bx
          pop       ax
          jmp       out10
; ࠡ⪨ 㭪樨 02

lb14:     cmp       ah,05     ;᫨ 㭪 05,  ࠡ-,
          jne       lb16      ; த

;ࠡ⪠ 㭪樨 05 (⠭ ⨢ ࠭)
          push      ax
          push      cx
          ; 0040:0062  ࠭
          mov       byte ptr es:[0462h],al  ; -  ६ BIOS
          xor       ah,ah     ;㫥 .  AX
          mov       cx,word ptr es:[044ch]  ;ࠧ ࠭  
          shr       cx,1                    ;cx=cx/2
          mul       cx
          ;⥯  AX ᬥ饭 ࠭  砫 
          mov       word ptr es:[044eh],ax     ;  0040:004
          shr       ax,1                       ;ax=ax/2
          add       ax,0c000h                  ; AX ᬥ饭 ࠭ ⭮-
                                               ;⥫쭮  A0000h.
          mov       cx,ax                      ;=
          call      epoint      ;⠭ 窨 室 ⠭
                                ;࠭.
          pop       cx
          pop       ax
          jmp       out10
; ࠡ⪨ 㭪樨 05

lb16:     cmp       ah,0eh    ;᫨ 㭪 0,  ࠡ⪠,
          jne       lb17      ; த

;ࠡ⪠ 㭪樨 0 (뢮 ᨬ  ० ⥫⠩)
          pushf
          call      dword ptr cs:old10  ;맮 ⭮ ..10
                                        ; ⮬ 
          push      ax
          push      bx
          push      cx
          push      dx
          ; BL  ⨢ ࠭
          ;㫥 襣  
          ;ᤢ    ࠧ
          ; DX - 
          mov       bl,byte ptr es:[0462h]
          xor       bh,bh
          shl       bx,1
          add       bx,0450h
          mov       dx,word ptr es:[bx]
          sub       bx,0450h
          jmp       lb15      ; 樮஢ 
; ࠡ⪨ 㭪樨 0

lb17:     cmp       ah,11h    ;᫨ 㭪 11,  ࠡ⪠ (lb18)
          je        lb18      ;  室 (out10a)
          jmp       out10a

;ࠡ⪠ 㭪樨 11 (⠭ ⮢)
lb18:     pop       es
          pop       ds
          pushf
          call      dword ptr cs:old10  ;맮 ⭮ ࠡ稪
                                        ;.10  ⮬
          call      egamem    ;⨢஢  0000-8000
          iret
; ࠡ⪨ 㭪樨 11

new10     endp

;   楤 new10


;  楤 new08 - ࠡ稪 뢠 08
;  楤  - ⮣   ணࠬ ᠬ -
;   ᯫ  ᪨ ०   
; ⮬ 뢠 10h. ⢥  ணࠬ mem736   ⪫-
;  ⥫   DOS  ⠪ ४祭. ⮬ -
;  室 ﭭ ᫥ 㯭  
; 640  ⪫ ⥫   㦥  -
; .  楤 墠뢠 뢠 08h ( ⨪ ⠩ ),
; ஥ 뢠 ⠩஬ ⭮ ਬ୮ 18.2 ࠧ  ᥪ㭤.
; । ।祩 ࠢ ⠭⭮ ࠡ稪 뢠 08h,
;  楤 ந ஢ 㯭   
; A0000h,   㦥  㯭 ⪫砥 ⥫
;   DOS.

new08   proc    near
        push    ax
        push    es
        xor     ax,ax
        mov     es,ax                     ;es=0
        cmp     word ptr es:[0413h],02e0h ;஢ઠ  736, ᫨  ⠪,
        pop     es                        ; 室  ஢ -
        pop     ax                        ;   ࠭楩 A0000h,
        jz      lb21                      ;᫨ ,   ⠭⭮ -
        jmp     dword ptr cs:old08        ;ࠡ稪 뢠 08h.
lb21:   push    ds
        push    ax
        mov     ax,0a000h
        mov     ds,ax
        mov     ax,word ptr ds:[1000h]     ; ஢ઠ   ࠭楩
        not     word ptr ds:[1000h]        ;0000h  ᯮᮡ ࠡ.
        not     ax
        cmp     ax,word ptr ds:[1000h]     ;᫨   ࠡ⠥,
        jne     lb22                       ; 室,
        not     word ptr ds:[1000h]        ; ⠭ 祩
        pop     ax                      ;000:1000h,  ।
        pop     ds                      ;ࠢ ஬ ࠡ稪
                                        ;뢠 08.
        jmp     dword ptr cs:old08
lb22:   pop     ax
        pop     ds                      ;室  ⭮ ࠡ..08
        pushf
        call    dword ptr cs:old08      ; ⮬ .
        push    es
        push    ds
        push    ax
        mov     ax,cs           ;ds=cs
        mov     ds,ax
        xor     ax,ax           ;es=0
        mov     es,ax
        call    m640            ;१   640
        mov     prz1,0000h      ;ਧ 640
        pop     ax              ;⠭ ॣ஢ 
        pop     ds              ;  뢠
        pop     es
        iret
new08   endp

;   楤 new08


;  楤 new12 - ࠡ稪 뢠 12
;  楤  ᮡ ⠭ ࠡ稪 뢠 12h
; 室騩  ROM BIOS.  頥  ॣ AX ᫮   
; 0000:0413h ( ⢮ 㯭    ).  楤
;  - ⮣,   BIOS ਭ ᫮ 襥
; 0280h ( 640k )  訡  㣫   0280h.

new12   proc    near
        push    es      ; ࠡ稪 㦠  AX ᫮ 
        xor     ax,ax   ; 0000:0413h ( - 㯭 
        mov     es,ax   ;  ).
        mov     ax,word ptr es:[0413h]
        pop     es
        iret
new12   endp

;   楤 new12


;  楤 new20 - ࠡ稪 뢠 20
;  楤 ᫥ 뢠 20h ( 襭 ணࠬ ),
;  ᫨  ⮬ vtv736 ⨢   뤥 DOS ⠢ 
; 640 (  뢠 ᫨ ணࠬ 室  ᯨ᮪ ᮢ⨬ -
; ࠬ  ᫨  ᯮ 䨪 ),  ந ⠭-
;  ꥬ  736 ⥬ ⠭ ⥪⮢ ० 03h १ 
; 맮 뢠 10h. (  ⮬ ࠡ⠥ 楤 new10. )

new20   proc    near            ;᫨ mem736 ⨢஢,  ३
        cmp     prz2,0000h      ; ⠭⭮ ࠡ稪.
        jz      out20
        push    ax              ;࠭ ᯮ㥬 ॣ஢
        push    es
        xor     ax,ax
        mov     es,ax           ;es=0
        cmp     word ptr es:[0413h],02e0h       ;᫨  736, 
                                                ; ⠭- ࠡ稪,
        pop     es                              ;᫨ , 
        jz      lb90            ;⠭
        mov     ax,0003h        ;० 03,  뢠
        int     10h             ; ࠡ稪.
lb90:   pop     ax
out20:  jmp     dword ptr cs:old20
new20   endp

;   楤 new20


;  楤 new21 - ࠡ稪 뢠 21
;  楤 ᫥ 㭪樨 00h, 4Ch  4Bh 뢠 21h ( -
;  㭪権 DOS ).   㭪樨 00h  4Ch ( 믮
; ணࠬ ) 筠 ॠ樨 楤 new20.    稨 -
;   640  ⨢ mem736    640  ⠭-
;  ⥪⮢ ० 03h . 㭪 4Bh 墠祭 
; ⪫祭 ⥫쭮   ᪥ ணࠬ ᮢ⨬ 
; 736. 㭪 4Bh ᯮ DOS  ᪥ ணࠬ  믮,
;  ⮬   ॣ஢ DS:DX । 㪠⥫  ப  
; ணࠬ.  楤 ஢    ᮢ   
;   ᨢ nprg,   㦥 ᮢ ⪫砥 ⥫-
;    ⠭ ⠭⭮ ﭨ 
;  ࠭稢 ⮫쪮 १ ᫥  MCB. ᨢ 
; nprg  ६ nname ᮤঠ ⢮   ᨢ ନ-
;  १⭮  ணࠬ 736  ࢮ ᪥ ணࠬ
;  ᭮ ᯨ᪠   䠩 mem736.lpr. ᨢ   ᫥-
;  :    ਭ   砥 ⠬
; 00h  01h.  00h    砥   १  
; 640   ⠭ ⠭⭮ ० , 
;  01h 砥   ⠭ ⠭ ० 
; .

new21   proc    near
        cmp     prz2,0000h      ;᫨ mem736 ⨢஢,  ३
        jnz     nnext           ; ⠭⭮ ࠡ稪 (out21).
        jmp     out21
nnext:  cmp     ah,4bh  ;᫨ 㭪 4B (EXEC),   ࠡ  EXE00,
        jz      exe00   ;  த  lb40
        jmp     lb40
;  ࠡ稪 㭪樨 4b. ⢫ ஫   ᪠
;  ணࠬ. ᫨    ᯨ᪥ nprg,  .  ⪫砥.
exe00:  pushf
        push    ds      ;࠭  ᯮ㥬 ॣ஢.
        push    es
        push    ax              ;㭪 EXEC । 㪠⥫ 
        push    bx              ;ப   ᪠ ணࠬ
        push    cx              ; ॣ DS:DX
        push    dx
        push    si
        push    di
        push    bp
        cld
        mov     si,dx
        dec     dx
exe01:  lodsb
        cmp     al,00h  ; 㫥   ப  
        jne     exe01   ;᪠ ணࠬ.
        dec     si      ;SI 㪠뢠  㫥 
        std
exe02:  lodsb
        cmp     al,5ch  ; 砫  ணࠬ.  稭
        je      exe03   ;᫥ ᨬ "\" (5), ":" (3), 
        cmp     al,3ah  ; ᠬ 砫 ப.
        je      exe03
        cmp     si,dx
        jne     exe02
        jmp     short exe04
exe03:  inc     si
exe04:  inc     si      ;SI 㪠뢠  砫  ணࠬ.
        mov     dx,si   ;ᬥ饭  ண.  DX.
        mov     bp,offset nprg  ;ᬥ饭 ᨢ   BP
        mov     cx,cs:nname     ;稪   ᨢ nprg
        cmp     cx,0            ;᫨  nprg  0,  室.
        jz      outexe
        mov     ax,cs
        mov     es,ax           ;ES:=CS
        xor     di,di           ;DI:=00
exe05:  mov     al,byte ptr ds:[si]     ; ᨬ   ண.
        mov     bl,byte ptr es:[di+bp]  ; ᨬ  ᨢ .
        cmp     bl,02h          ;᫨ ᨬ.  ᨢ < 02, 
        jae     exe06           ;砥 ᮢ ,  ந
                                ;஢ઠ ᨬ   ᪠
                                ;ணࠬ  ᮮ⢥⢨
        cmp     al,2eh          ;ᨬ "."  "nul".
        je      exeoff          ;᫨ ᮮ⢥  몫. . .,
        cmp     al,00h          ;  EXE08.
        je      exeoff
        jmp     exe08
exeoff: cmp     bl,00h          ; ᫥    ணࠬ
        jne     exesp           ; ᨢ nprg, ᫨ 0,  १ 
        mov     ax,cs           ; 640,    ஬ ।-
        mov     ds,ax           ; . (..  -
        xor     ax,ax           ;⠥ 㯭  ᠬ A0000h).
        mov     es,ax           ;᫨ 01h,  ந  - 
        call    m640            ; ० 03h .
        mov     prz1,0000h
        jmp     outexe
exesp:  mov     ax,0ef55h
        int     2fh
        mov     prz2,0ffffh
outexe: pop     bp
        pop     di      ;⠭ ॣ஢  室 
        pop     si      ;⭮ ࠡ稪.
        pop     dx
        pop     cx
        pop     bx
        pop     ax
        pop     es
        pop     ds
        popf
        jmp     dword ptr cs:old21
exe06:  cmp     al,41h          ;᫨ ᨬ  孥 ॣ
        jb      exe07           ;( >41h  <5Bh ),  ॢ 
        cmp     al,5bh          ;  ॣ.
        jae     exe07
        or      al,20h
exe07:  cmp     al,bl           ;᫨ ᨬ  ࠢ,  室,
        jne     exe08           ;  ᫥騬 ᨬ.
        inc     si
        inc     di
        jmp     exe05
exe08:  add     bp,000dh        ;⥫  ᫥騩 
        mov     di,0000h        ;ᨢ .
        mov     si,dx           ;⥫  砫  ண.
        loop    exe05
        jmp     outexe
;   ࠡ稪 㭪樨 EXEC (4B).
lb40:   push    ax      ;࠭ ॣ஢ AX  ES  ⥪
        push    es      
        xor     ax,ax
        mov     es,ax                           ;es=0
        cmp     word ptr es:[0413h],02e0h       ;᫨  736,  -
        pop     es                              ;⠭ ॣ  ३-
        pop     ax                      ;  ⠭⭮ ࠡ稪 -
        jz      out21           ;뢠 21h, ᫨ , 
        cmp     ah,00h          ;⠭ ⠭
        jz      lb41            ;० 03   㭪権
        cmp     ah,4ch          ;00  4 ( 믮
        jnz     out21           ;ணࠬ),  뢠 
lb41:   push    ax              ;ࠡ稪.
        mov     ax,0003h
        int     10h
        pop     ax
out21:  jmp     dword ptr cs:old21
new21   endp

;   楤 new21


;  ணࠬ egamem - 砥  ࠡ  EGA  VGA 
;  楤 ।祭  ᯥ祭 㯭  -
;      A0000h-BFFFFh.  ⮣  ॣ 06h
; ( ࠢ騥 㭪樨 䨪 )   3CFh 뢮 
; 02h,  砥: 0=0 - ⥪⮢ ०, 1=1 - 楯 
; ᪮⥩  ᫥ , 2/3=00 - ⮡ࠦ  
;  稭   A0000h. ।⥫쭮   3CEh 뢮
;  ॣ  3CF - 06h.

egamem    proc      near
          push      ax          ;࠭ ॣ஢
          push      dx
          mov       dx,03ceh
          mov       al,06h
          out       dx,al       ;  3CEh  06h
          inc       dx
          mov       al,02h
          out       dx,al       ;  3CFh  02h
          pop       dx          ;⠭ ॣ஢
          pop       ax
          push      cx
          mov       cx,0c000h   ; CX  窠 室  
          call      epoint      ;맮 楤 ⠭ 窨 室
          pop       cx
          ret                   ;  楤
egamem    endp

;   ணࠬ egamem


;  ணࠬ epoint - ⠭ 窨 室 
;  楤 ⠭  室 ⥪饩 ࠭ 
; 砫 . 窠 室  맮 楤 । 
; ॣ CX.    ᫥ 믮 楤 egamem
; 稭   A0000h,   㫥 ࠭ ॡ ᬥ-
;  (B8000h-A0000h)/2=C000h.  믮 楤 egamem 
;  祭 ।  ⢥ 窨 室.  믮 -
; 楤 new10, 㭪樨 05h ( ⠭ ⨢ ࠭ ), 
; ᬥ饭   ᫥  楤.    -
;    ॣ஢ 0Ch (訩)  0Dh (訩)  3D5h, 
; 樨  ॣ஢ ᯮ  3D4h.

epoint    proc      near
          push      ax          ;࠭ ॣ஢  ⥪
          push      dx
          mov       al,0ch
          mov       dx,03d4h
          out       dx,al       ;뢮   3D4h  ॣ 0Ch
                                ; 3D5h
          mov       al,ch
          inc       dx
          out       dx,al       ;뢮   3D5h ᮤন ॣ CH
          mov       al,0dh
          dec       dx
          out       dx,al       ;뢮   3D4h  ॣ 0Ch
                                ; 3D5h
          mov       al,cl
          inc       dx
          out       dx,al       ;뢮   3D5h ᮤন ॣ CL
          pop       dx          ;⠭ ॣ஢ 
          pop       ax          ;  楤
          ret
epoint    endp

;   ணࠬ epoint


;  ணࠬ clrs - ⪠ ࠭
;  楤 頥 ࠭   ⠭⭮ 㭪樨 06h -
; 뢠 10h  BIOS .

clrs      proc      near
          push      ax
          push      bx
          push      cx
          push      dx
          mov       ax,0600h    ; 㭪樨 ⪨ ࠭  AX
          mov       bh,07h      ;ਡ 
          xor       cx,cx       ; CX - 孥  㣫
          mov       dx,184fh    ; DX -  ࠢ 㣫
          int       10h         ;ᮡ⢥ ⪠
          pop       dx
          pop       cx
          pop       bx
          pop       ax
          ret
clrs      endp

;   ணࠬ ᪨ ࠭


;         736 - ணࠬ ७ ᫥  
;                       ࠭  B7FFF.
;  楤 ஢ 墠뢠  ᫥   
;  B7FFFh, ᫨ ,  祣  ।ਭ,  ᫨ ,  
;    18000h ,  ⠪    0000:0413 -
;  ᫮ 020h ( 736 㯭  ). ⥬ ந
; ஢ઠ  稥  ᫥   䨪 ணࠬ ᥣ-
;  PSP  ᫨  㦨,    㢥稢  -
;  ᯮ㥬 ࠣ   1800h.

m736      proc      near
          push      ax
          push      dx
          call      zmcb      ; ணࠬ ᪠ ᫥ 
          mov       ax,es
          add       ax,word ptr es:[0003h]
          inc       ax
          cmp       ax,0b800h ;᫨ MCB 㦥 ७  B800,
          jz        lb71      ; 稢.
          add       word ptr es:[0003h],1800h  ;.   96
          push      es
          xor       dx,dx
          mov       es,dx                      ;㢥祭 祭 ꥬ
          mov       word ptr es:[0413h],02e0h  ;㯭   ६-
          pop       es                         ; BIOS ( 0000:0413h ).
          cmp       word ptr es:[0010h],20cdh
;᫨  ᫥  室 PSP (ࢠ  int 10h),
; 㢥稢 ᫥ ᯮ㥬 ࠣ  PSP  1800h.
          jne       lb71
          add       word ptr es:[0012h],1800h
lb71:     xor       dx,dx
          mov       es,dx     ;ES=0
          pop       dx
          pop       ax
          ret
m736      endp

;   ணࠬ m736


;  ZMCB - ணࠬ ᪠ ᫥  
;  楤 稭  ᫥     ਭ-
; 饣 ᠬ ணࠬ, ᫥    
; 'Z'  砫 .  ᫥  楤 頥 
; ॣ ES.

zmcb      proc      near
          mov       dx,cs
          dec       dx
          mov       es,dx       ;⥯ ES 㪠뢠   
                                ;ਭ騩  ணࠬ
lbzm1:    cmp       byte ptr es:[0000h],5ah     ;᫨   
          jne       lbzm2                       ; ࠢ 'Z',   
          ret                                   ;᫥   -
                                                ; 蠥.
lbzm2:    mov       ax,word ptr es:[0003h]      ;     -
                                                ;.
          mov       dx,es                       ;DX=ES
          add       ax,dx
          inc       ax                          ;AX=AX+DX+1
          mov       es,ax       ;⥯ ES 㪠뢠  ᫥騩
                                ; 
          jmp       lbzm1       ;室  ஢   ᫥
zmcb      endp

;   ணࠬ ZMCB


;         m640 - ணࠬ १ ᫥  
;                    ࠭  A0000
;  楤 砫 ஢  ॢ蠥   뤥
; ᫥   ࠭ A0000h,  ᫨  ⠪,   -
; ⢨  ।ਭ. ᫨ ᫥   ॢ蠥 ࠭
; A0000h,   १  18000h ,  ⠪    0000:0413h
; 뢠 ᫮ 0280h ( 640k 㯭  ). ⥬ ந-
;  ஢ઠ  稥  ᫥   䨪 ணࠬ-
;  ᥣ PSP,  ᫨  ⠬,  㬥蠥    ᫥-
;  ᯮ㥬 ࠣ   1800h.

m640      proc      near
          push      ax
          push      dx
          call      zmcb      ; ᫥  
          add       ax,word ptr es:[0003h]
          cmp       ax,9fffh  ;᫨ MCB 㦥  A0000,
          jbe       jlb71     ; 室.
          sub       word ptr es:[0003h],1800h     ;१  
          push      es
          push      cx
          push      di
          mov       dx,0a000h                     ;㫥 
          mov       es,dx                         ;⮩  ⨢
          xor       di,di
          mov       cx,8000h
          xor       ax,ax
          cld
rep       stosw
          mov       dx,0b000h
          mov       es,dx
          xor       di,di
          mov       cx,4000h
rep       stosw
          xor       dx,dx                         ;㬥襭 祭
          mov       es,dx                         ;ꥬ 㯭 -
          mov       word ptr es:[0413h],0280h     ;  ६
          pop       di                            ;BIOS ( 0000:0413h ).
          pop       cx
          pop       es
          cmp       word ptr es:[0010h],20cdh     ;᫨   ,
          jne       jlb71                         ; १ 뤥
          sub       word ptr es:[0012h],1800h     ; 
jlb71:    jmp       lb71
m640      endp

;   ணࠬ 640


;⢮   ᨢ nprg
nname   dw      (?)

;  ᨢ  ணࠬ   室 ⪫줮. .
;    稭  ࠭ 13 , ᮤন ᨬ
;  12 ᨬ,  稢 㫥 ⮬.

nprg    db      3328 dup(0)

;   ᨢ  ணࠬ.


;  砫  १⭮  ணࠬ

begin:
;   ࠬ஢    ப
        mov     cl,nprm ;nprm - - ⮢  ࠬ
        cmp     cl,01h  ;᫨ ࠬ஢  (nprm<=1),
        ja      lbl03   ; nprm=0.
        mov     nprm,00h
        jmp     lbl09
exit1:  call    printscreen
        int     20h
;     ࠬ
;  /help - nprm=01, /off - nprm=02, /on - nprm=03.
lbl03:  xor     ch,ch
        mov     si,0081h        ; ᨬ '/'
lbl04:  lodsb
        cmp     al,2fh
        loopne  lbl04
        cmp     cx,0000h         ;᫨ ᨬ '/'  ,
        jne     lbl06            ; 뢮 ᮮ饭 errprm 
lbl05:  mov     dx,offset errprm ;訡  ࠬ.
        jmp     exit1
lbl06:  lodsb
        cmp     al,3fh          ;ᨬ = '?',
        je      lbl06a
        or      al,20h          ;ॢ ᨬ   ॣ
        cmp     al,68h          ;ᨬ = 'h',
        jne     lbl07           ;᫨ ,   lbl07,
lbl06a: mov     dx,offset help  ;᫨ ,  뢮 ࠢ  室
        jmp     exit1
lbl07:  cmp     al,6fh  ;᫨ ᨬ  'o',  뢮 ᮮ饭
        jne     lbl05   ; 訡  ࠬ.
        lodsb           ;㧨 ᫥騩 ᨬ
        or      al,20h  ;ॢ    ॣ
        cmp     al,66h  ;᫨ ᨬ 'f',  nprm=02,
        jne     lbl08   ; த  lbl08
        mov     nprm,02h
        jmp     lbl09
lbl08:  cmp     al,6eh  ;᫨ ᨬ  'n',  뢮 ᮮ饭
        jne     lbl05   ; 訡  ࠬ.
        mov     nprm,03h        ;nprm=03,   ࠬ=/on
;    ࠬ஢
lbl09:  cmp     word ptr ds:[0002h],0a00h
        jae     lbl01           ;᫨   ⥬  640,
        mov     dx,offset izv2  ; 뢮   室.
exit2:  mov     ax,0900h
        int     21h
        int     20h
lbl01:  xor     ax,ax
        push    es
        mov     es,ax     ;ES 㪠뢠  砫 
        mov     al,byte ptr es:[0487h]   ;஢ઠ  EGA-256k
        pop     es
        and     ax,0060h  ;᫨ EGA_256k,  த  lbl01a
        cmp     ax,0060h  ; 室  ﬨ
        jz      lbl02
        mov     dx,offset izv1      ;㧪 ᬥ饭 
        jmp     short exit2
lbl02:  mov     ax,0ef00h       ;஢ઠ  稥 १⭮ 
        int     2fh             ;ணࠬ  ⥬.
        cmp     ax,0aa55h       ;᫨  १,   lbl12,
        jne     lbl10           ; த
        jmp     lbl12
lbl10:  cmp     nprm,02h         ;᫨ ࠬ /OFF   १,
        jne     lbl11            ; 吝 㣠  室,
        mov     dx,offset rugat1 ; 室  cp1
        jmp     exit1

hand    dw      0       ;奭 䠩 Mem736.com
longm   dw      0       ; 䠩 Mem736.com

;  ⠭ ணࠬ १⭮  ⨢஢ ,
;  祭 ⥫ 96  .
lbl11:  mov     ax,3510h        ;祭  ES:BX  .10
        int     21h
        mov     word ptr ds:[00c0h],bx  ;࠭  .10 
        mov     bx,es                   ;祩 old10 (DS:00C0)
        mov     word ptr ds:[00c2h],bx
        mov     ax,352fh        ;祭  ࠭  (DS:00C4)
        int     21h             ; 뢠 2F
        mov     word ptr ds:[00c4h],bx
        mov     bx,es
        mov     word ptr ds:[00c6h],bx
        mov     ax,3508h        ;祭  ࠭  (DS:00D0)
        int     21h             ; 뢠 08
        mov     word ptr ds:[00d0h],bx
        mov     bx,es
        mov     word ptr ds:[00d2h],bx
        mov     ax,3520h        ;祭  ࠭  (DS:00D4)
        int     21h             ; 뢠 20
        mov     word ptr ds:[00d4h],bx
        mov     bx,es
        mov     word ptr ds:[00d6h],bx
        mov     ax,3521h        ;祭  ࠭  (DS:00D8)
        int     21h             ; 뢠 21
        mov     word ptr ds:[00d8h],bx
        mov     bx,es
        mov     word ptr ds:[00dah],bx
        mov     dx,offset new2f ;⠭   .2F
        mov     ax,252fh
        int     21h
        mov     prz1,0000h      ;㫥 ਧ ⨢ ࠡ
        mov     prz2,0000h      ;ணࠬ Mem736.
        mov     dx,offset new10 ;⠭   .10
        mov     ax,2510h
        int     21h
        mov     dx,offset new08 ;⠭   .08
        mov     ax,2508h
        int     21h
        mov     dx,offset new12 ;⠭   .12
        mov     ax,2512h
        int     21h
        mov     dx,offset new20 ;⠭   .20
        mov     ax,2520h
        int     21h
        mov     dx,offset new21 ;⠭   .21
        mov     ax,2521h
        int     21h
        mov     ax,0efaah       ;⨢ ணࠬ
        int     2fh
        mov     dx,offset salut ;뢮 ਢ⢨
        call    printscreen
        mov     ax,ds           ;⠭ ॣ ES
        mov     es,ax


;  ணࠬ ᥭ  ᨢ NPRG  ணࠬ  䠩 Mem736.lpr.
;    稭  ࠭ 13 ,    
;  ॣ. ᥣ  256 .  mem736.lpr  ⥪-
;  ⮢,  ணࠬ    ப, ஡, ᨬ
;  ⠡樨  ⮬  ᨬ  砫 ப .
;  ᫨ ।  ணࠬ ⮨ ᨬ '+',   砥,  
;  । १  । ᪮ ⮩ ணࠬ 室
;   ⠭ ⠭ ० . ⨬ -
;   楤 new21h,  ᭮ ᫥ ࠭稢饣
;     ணࠬ  ᨢ nprg. ᫨   ࠢ 00h,
;     १  640, ।  -
;    . ᫨   ࠢ 01h,  ⠭ ०
;   ⠭ .  mem736.lpr  
;  ⮬  ⠫  ᯮ ணࠬ mem736.com, ⠫ -
;    ⠭⭮  envirovment,   ண ।-
;  ⢥ ।   ணࠬ mem736.com.

        cld
        mov     cx,1000h
        mov     di,8000h
        xor     ax,ax
rep     stosw           ;㫥   ᬥ饭 8000 (ᥣ 8 ).
        mov     ax,word ptr ds:[002ch]
        push    ds
        mov     ds,ax   ;ᥣ  ६묨 ।  DS
        xor     si,si
lprg1:  lodsb
        cmp     al,00h
        jne     lprg1
        lodsb
        cmp     al,00h  ;  㫥 ⮢.
        jne     lprg1
        lodsw
        mov     di,offset listprg
        mov     cx,0080h
rep     movsb           ;७  ணࠬ  ६ LISTPRG
        pop     ds
        mov     si,offset listprg
lprg2:  lodsb
        cmp     al,2eh  ; 窨   䠩.
        jne     lprg2
        mov     byte ptr ds:[si],4ch    ;ନ஢ ७ LPR 
        mov     byte ptr ds:[si+1],50h  ; 㫥   .
        mov     byte ptr ds:[si+2],52h
        mov     byte ptr ds:[si+3],00h
        mov     ax,3d00h
        mov     dx,offset listprg
        int     21h                     ;⪠  䠩 Mem736.lpr.
        jnc     lprg4           ;᫨ 㤠筮, 
lprg3:  mov     dx,offset nrlpr ;뢮 ᮮ饭  㤠  ନ஢
                                ;ᨢ   ணࠬ  ࠡ
        call    printscreen     ; ࠢ Mem736.
        mov     cx,0100h
        jmp     lblrez
lprg4:  mov     hand,ax         ;࠭ 奭 䠩.
        mov     bx,ax           ;  BX.
        mov     ax,3f00h        ;㭪 ⥭ 䠩.
        mov     dx,8000h        ;饭   DX.
        mov     cx,1800h        ;।쭠  䠩 (6144).
        int     21h
        jnc     lprg5
        mov     ax,3e00h        ;㭪  䠩.
        mov     bx,hand         ;  BX.
        int     21h
        jmp     lprg3
lprg5:  mov     ax,3e00h        ;㭪  䠩.
        mov     bx,hand         ;  BX.
        int     21h
        mov     bp,offset nprg  ;ᬥ饭 ᨢ   BP
        mov     si,8000h        ;ᬥ饭   SI
        xor     di,di           ;ᬥ饭 ࢮ ᨬ  ᨢ   DI
        mov     cx,0100h        ;稪 = 256 .
lprg55: mov     byte ptr ds:[00f8h],00h ;㫥  DS:[00F8h]
lprg56: lodsb
        cmp     al,00h  ;᫨ । ᨬ 00h,    ᯨ᪠
        je      lblrez  ;ணࠬ,   室  襭.
        cmp     al,21h  ; ᨬ 訥  ࠢ ஡ 
        jb      lprg56  ;.
        cmp     al,2bh  ;᫨ ᨬ '+',  뢠  DS:[00F8h]  01h
        jne     lprg57
        mov     byte ptr ds:[00f8h],01h
        jmp     short lprg56
lprg57: dec     si
lprg6:  lodsb                   ; ᨬ  .
        cmp     al,00h          ;᫨ ᨬ = 0,    䠩,
        jne     lprg7           ; ᫥⥫쭮 室   ணࠬ,
        jmp     lblrez          ; த  LPRG7.
lprg7:  cmp     al,21h          ;᫨  ᨬ (>='஡'),  室
        jae     lprg9
        cmp     al,0dh          ;᫨ ᨬ  ॢ ப, 
        jne     lprg6           ;室  쭥訬 ஢ઠ  LPRG9,
lprg75: dec     cx              ; 㬥蠥 稪 ,
        cmp     cx,0000h        ; ᫨  ࠢ ,  砥
        jne     lprg8           ; ⨬,  LPRG8  ᫥饬
        jmp     lblrez          ; ᨢ .
lprg8:  mov     dl,byte ptr ds:[00f8h]
        mov     byte ptr ds:[bp+di],dl  ;    DS:[00F8h]
        add     bp,000dh        ;ᬥ饭 ᫥饣   BP.
        xor     di,di           ;ᬥ饭 ࢮ ᨬ    DI.
        inc     si              ;SI 㪠뢠  ᫥饥   .
        jmp     lprg55          ; 쭥 ࠡ.
lprg9:  cmp     al,41h          ;஢ઠ  孨 ॣ,
        jb      lprga           ; ᫨  ⠪,  ॢ 
        cmp     al,5bh          ; ॣ.
        jae     lprga
        or      al,20h
lprga:  mov     byte ptr ds:[bp+di],al  ;࠭ ᨬ  ᨢ.
        inc     di              ;㪠뢠  ᫥騩 ᨬ  ᨢ.
        cmp     di,000ch        ;᫨  12 ᨬ  ,
        jne     lprg6           ;  ᫥饬  ᨢ,
lprgb:  lodsb                   ;  LPRG6 த ନ஢
        cmp     al,0dh          ;ᨢ.
        jne     lprgb
        jmp     lprg8

;   ணࠬ ᥭ   ᨢ NPRG.


;   DX  ᫥ ᯮ㥬   १⭮  + 1
lblrez: mov     ax,0101h        ;ᨬ쭮 ⢮   nprg 0101h
        sub     ax,cx           ;  ⢮   nprg
        mov     nname,ax        ;࠭ ⢠   nname
        mov     cx,000dh
        mul     cl
        add     ax,4            ;⥯    ᨢ nprg 
                                ;訬 ᮬ
        mov     dx,offset nprg
        add     dx,ax           ; DX  १⭮ 
        int     27h             ;   १⭮
;   ⠭ ணࠬ १⭮

;      ᫨ ணࠬ 㦥 ᨤ  
lbl12:  cmp     nprm,00h        ;᫨  ࠬ஢,  த,
        jne     lbl14           ; 室  lbl14
        mov     ax,0ef00h
        int     2fh             ;᫨ Mem736 ⨢,
        cmp     bx,0ffffh       ; ,
        jne     lbl13           ; 室  lbl13
        mov     dx,offset mon   ;뤠 ᮮ饭 Mem736 is ON
        jmp     exit1
lbl13:  mov     dx,offset moff  ;뤠 ᮮ饭 Mem736 is OFF
        jmp     exit1
lbl14:  cmp     nprm,02h  ;᫨ ࠬ /OFF,
        jne     lbl15     ; 몫砥 Mem736,
        mov     ax,0ef55h ; 砥 ( lbl15).
        int     2fh
        mov     word ptr ds:[0002h],0a000h
        mov     dx,offset moff
        jmp     exit1
lbl15:  mov     ax,0efaah
        int     2fh
        mov     dx,offset mon
        jmp     exit1

;   ணࠬ

listprg db      128 dup(?)      ;ப   䠩 Mem736.lpr.

include prnscr.asm

;  饭

errprm  db      13,10,7,255,94h
        db      '         訡  ࠬ ணࠬ.          ',13,10,255,7
        db      ' 祭 ࠢ ᯮ 樥 /Help.'
        db      13,10,0
help    db      13,10,13,10,255,0ch
        db      '      emory 736 Kbytes ( MEM736.COM ) ணࠬ ७ ⨢',13,10
        db      '        DOS      EGA  VGA ᯫ.',13,10,255,3
        db      ' version 1.0, Copyright (C) Alexander Andreev, Russia, Magadan, October 1993.',13,10
        db      '  "쨭", ., ⥫. 2-48-11, RELCOM: root@gpsi.magadan.su',13,10,13,10,255,7
        db      '      ꥬ    ।⠢塞   DOS 㢥稢   640  736 .',13,10
        db      ' ணࠬ ࠡ⠥  稨    640    ⨢    ',13,10
        db      '   EGA  VGA  ꥬ     256 .    ',13,10
        db      ' ᪨ ०  EGA  VGA ᯮ ᢮  , ',13,10
        db      '  ᯮ騥 䨪  ᯮ  ꥬ  (640).',13,10
        db      '  ,ࠡ騥 ⮫쪮  ⥪⮢ ०,  ᢮ ᯮ殮-',13,10
        db      '  ⥫쭮 96  .   ணࠬ    ଠ쭮',13,10
        db      ' ࠡ  ⨢ Mem736   ⮣,  ⮡ ⠪ ணࠬ ᪠',13,10
        db      '  ஡, , ⨢஢ Mem736, , ࠧ , ',13,10
        db      '  ⮩ ணࠬ  䠩 Mem736.lpr,   室   -',13,10
        db      ' ⠫    ணࠬ Mem736.com.  ஡  䠩 Mem736.doc.',13,10,13,10,255,12
        db      ' P.S.',255,5,'        ࠦ ⨢ ᢮ ࠭ ',13,10
        db      '          ணࠬ  䨪樨  .',255,7,13,10,13,10
        db      '     樨 ணࠬ:   /HELP,/H,/? - 祭  ࠢ',13,10
        db      '                        /OFF        - ⨢஢ १⭮ ணࠬ',13,10
        db      '                        /ON         - ⨢஢ १⭮ ணࠬ',13,0
mon     db      13,10,255,4,' Mem736  ⨢ ﭨ.',13,10,0
moff    db      13,10,255,4,' Mem736 ⨢஢.',13,10,0
salut   db      27,25,7,255,15
        db      '        Mem736  -  ணࠬ  ७    DOS   ',255,8fh,'736',255,15,' .',13,10,255,11
        db      '                (version 1.0), Copyright (C) Alexander Andreev.',13,10
        db      '                     Russia,  Magadan,  October  1993.',13,10,13,10,255,7
        db      '        樨:   /HELP,/H,/? - 祭 ࠢ',13,10
        db      '                 /OFF        - ⨢஢ १⭮ ணࠬ',13,10
        db      '                 /ON         - ⨢஢ १⭮ ணࠬ',13,25,23,0
rugat1  db      13,10,7,255,12
        db      '          襬,     ⪠'
        db      ' ⨢樨 ணࠬ',13,10
        db      ' ன    ? ᫨   ஢'
        db      '  ,    ',13,10
        db      ' ⢥⢥  .',13,10,0
nrlpr   db      7,27,13,10,13,10,255,9ch
        db      '                   䠩 Mem736.'
        db      'lpr.                       ',13,10,13,10,255,3
        db      '  ⮬ 䠩  室  ணࠬ'
        db      '  ࠡ  ⨢',13,10
        db      ' ﭨ Mem736.  䠩  室'
        db      '  ⮩  ४ਨ  ',13,10
        db      ' ணࠬ Mem736.com.',13,10,13,10,7,255,12
        db      '       :    ᪠ ணࠬ  '
        db      ' ᫥,',13,10
        db      '                    ᠭ  ४⭠'
        db      ' ࠡ ⤥',13,10
        db      '                   ணࠬ.',13,10,0
izv1    db      13,10,7
        db      '  饭,    '
        db      ' EGA .',13,10
        db      '          '
        db      ' 室 ࠧ. ( 256k )',13,10
        db      ' 祭 ᮦ,  ࠡ  ⠪'
        db      ' ᫮   ᨫ.',13,10,36
izv2    db      13,10,7
        db      '  饭,  襬    ꥬ'
        db      '  640 .',13,10
        db      ' 祭 ᮦ,  ࠡ  ⠪'
        db      ' ᫮   ᨫ.',13,10,36

;   ᮮ饭

cseg   ends             ;   ⥪ ணࠬ !!!
       end      start
