
   NNAAMMEE
      diff - display line-by-line differences between pairs of text files

   SSYYNNOOPPSSIISS
      ddiiffff [--##] [--aabbBBccddeeffhhHHiillnnNNpprrssttTTuuvvww] [--CC_l_i_n_e_s] [--FF_r_e_g_e_x_p] [--II_r_e_g_e_x_p]
           [--LL_l_a_b_e_l [--LL_l_a_b_e_l]] [--SS_f_i_l_e] [--DD_s_y_m_b_o_l] _p_a_t_h_1_ _p_a_t_h_2

   DDEESSCCRRIIPPTTIIOONN
      The ddiiffff installed on this system is the GNU diff. This version of
      ddiiffff provides all the features of BSD's ddiiffff in addition to
      numerous additional features.

      ddiiffff is a _d_i_f_f_e_r_e_n_t_i_a_l file comparator.  When run on regular files,
      and when comparing text files that differ during directory
      comparison (see the notes below on comparing directories), ddiiffff
      tells what lines must be changed in the files to bring them into
      agreement.  Except in rare circumstances, ddiiffff finds a smallest
      sufficient set of differences.  If neither _p_a_t_h_1 nor _p_a_t_h_2 is a
      directory, either may be given as "-", in which case the standard
      input is used.  If _p_a_t_h_1 is a directory, a file in that directory
      whose filename is the same as the filename of _p_a_t_h_2 is used (and
      vice versa).

      There are several options for output format; the default output
      format contains lines of these forms:

         _n_1
         aa
         _n_3, _n_4

         _n_1, _n_2
         dd
         _n_3

         _n_1, _n_2
         cc
         _n_3, _n_4

         These lines resemble eedd(1) commands to convert _p_a_t_h_1 into _p_a_t_h_2.
         The numbers after the letters pertain to _p_a_t_h_2.  In fact, by
         exchanging aa for dd and reading backward one may ascertain
         equally how to convert _p_a_t_h_2 into _p_a_t_h_1.  As in eedd(1), identical
         pairs, where _n_1 = _n_2 or _n_3 = _n_4, are abbreviated as a single
         number.

         Following each of these lines come all the lines that are
         affected in the first file flagged by "<", then all the lines
         that are affected in the second file flagged by ">".

         If both arguments are directories, ddiiffff sorts the contents of
         the directories by name, and then runs the regular file ddiiffff
         program as described above on text files which are different.
         Binary files which differ, common subdirectories, and files
         which appear in only one directory are listed.

   OOPPTTIIOONNSS
      This diff has these additional (non-BSD) features:

      --aa       Always treat files as text and compare them line-by-line,
               even if they do not appear to be ASCII.

      --BB       Ignore changes that just insert or delete blank lines.

      --CC_#      Request -c format and specify number of context lines.

      --FF_r_e_g_e_x_p In context format, for each unit of differences, show some
               of the last preceding line that matches the specified
               regexp.

      --HH       Use heuristics to speed handling of large files that have
               numerous scattered small changes.  The algorithm becomes
               asymptotically linear for such files!

      --II_r_e_g_e_x_p Ignore changes that just insert or delete lines that match
               the specified regexp.

      --LL_l_a_b_e_l  Use the specified label in file header lines output by the
               --cc option.  This option may be given zero, one, or two
               times, to affect neither label, just the first file's
               label, or both labels.  A file's default label is its
               name, a tab, and its modification date.

      --NN       In directory comparison, if a file is found in only one
               directory, treat it as present but empty in the other
               directory.

      --pp       Equivalent to -c -F'^[_a-zA-Z]'.  This is useful for C
               code because it shows which function each change is in.

      --TT       Print a tab rather than a space before the text of a line
               in normal or context format.  This causes the alignment of
               tabs in the line to look normal.

      --uu[_#]    Produce unified style output with _# context lines
               (default 3).   This style is like --cc, but it is more
               compact because context lines are printed only once.
               Lines from just the first file are marked "-"; lines from
               just the second file are marked "+".

      --vv       Print the version string before any other output.

      The following features are BSD standard:

      --bb       Ignore trailing blanks (SPACE and TAB characters) and
               treat all other strings of blanks as equivalent.

      --ii       Ignore the case of letters; for example, 'A' will compare
               equal to 'a'.

      --tt       Expand TAB characters in output lines.  Normal or --cc
               output adds character(s) to the front of each line which
               may alter the indentation of the original source lines and
               make the output listing difficult to interpret.  This
               option will preserve the original source's indentation.

      --ww       Ignore all blanks (SPACE and TAB characters); for example,
               "if ( a == b )" will compare equal to "if(a==b)".

      The following four options are mutually exclusive:

      --cc[_#]    Produce a listing of differences with lines of context.
               The default is to present 3 lines of context and may be
               changed, (to 10, for example), by --cc1100.  With --cc the
               output format is modified slightly:  output begins with
               identification of the files involved and their creation
               dates, then each change is separated by a line with a
               dozen **s.  The lines removed from _p_a_t_h_1 are marked with
               "-"; those added to _p_a_t_h_2 are marked "+".  Lines which are
               changed from one file to the other are marked in both
               files with "!".

               Changes which lie within <context> lines of each other are
               grouped together on output.  This is a change from the
               previous ddiiffff  --cc but the resulting output is usually much
               easier to interpret.

      --DD_s_y_m_b_o_l Output a file containing ##iiffddeeff directives based on _s_y_m_b_o_l
               which will allow creating either a version identical to
               _p_a_t_h_1 (_s_y_m_b_o_l not defined) or _p_a_t_h_2 (_s_y_m_b_o_l defined).

      --ee       Produce a script of aa, cc and dd commands for the editor eedd,
               which will recreate _p_a_t_h_2 from _p_a_t_h_1.

               In connection with --ee, the following shell program may
               help maintain multiple versions of a file.  Only an
               ancestral file ($1) and a chain of version-to-version eedd
               scripts ($2, $3, ...) made by ddiiffff need be on hand.  A
               "latest version" appears on the standard output.

                  (shift; cat $*; echo '1,$p') | ed - $1

               Extra commands are added to the output when comparing
               directories with --ee, so that the result is a sshh script for
               converting text files which are common to the two
               directories from their state in _d_i_r_e_c_t_o_r_y_1 to their state
               in _d_i_r_e_c_t_o_r_y_2.

      --ff       Produce a script similar to that of --ee, not useful with
               eedd, which is in the opposite order.

      --nn       Produce a script similar to that of --ee, but in the
               opposite order and with a count of changed lines on each
               insert or delete command.

      --hh       Do a fast, half-hearted job.  It works only when changed
               stretches are short and well separated, but does work on
               files of unlimited length.

      Options when comparing directories are:

      --ll       Long output format; each text file ddiiffff is piped through
               pprr(1V) to paginate it, other differences are remembered
               and summarized after all text file differences are
               reported.

      --rr       Apply ddiiffff recursively to common subdirectories
               encountered.

      --ss       Report files which are the same, which are otherwise not
               mentioned.

      --SS_n_a_m_e   Start a directory ddiiffff in the middle, beginning with file
               _n_a_m_e.

   SSEEEE  AALLSSOO
      cccc(1V), ccmmpp(1), ccoommmm(1), ccpppp(1), ddiiffff33(1V), eedd(1), pprr(1V)

   DDIIAAGGNNOOSSTTIICCSS
      Exit status is 0 for no differences, 1 for some differences, 2 for
      trouble.

      _M_i_s_s_i_n_g_ _n_e_w_l_i_n_e_ _a_t_ _e_n_d_ _o_f_ _f_i_l_e_ _X Indicates that the last line of
      file _X did not have a NEWLINE.  If the lines are different, they
      will be flagged and output, although the output will seem to
      indicate they are the same.

   BBUUGGSS
      Editing scripts produced under the --ee or --ff option are naive about
      creating lines consisting of a single '.'.

      When comparing directories with the --bb, --ww or --ii options specified,
      ddiiffff first compares the files (as in ccmmpp(1), and then runs the
      regular ddiiffff algorithm if they are not equal.  This may cause a
      small amount of spurious output if the files then turn out to be
      identical because the only differences are insignificant blank
      string or case differences.

      The --DD option ignores existing preprocessor controls in the source
      files, and can generate ##iiffddeeffss's with overlapping scope.  The
      output should be checked by hand, or run through cccc  --EE (see cccc(1V))
      and then ddiiffffed with the original source files.  Discrepancies
      revealed should be corrected before compilation.

      The MS-DOS and OS/2 versions sometimes get confused by files that
      exceed 64KB.
