//------------------------------------------------------------------
//   HANDLER.C
//
//   (C)1992-93 ᠭ ન
//   ⥫. (056-72)37-110, (056-72)37-702 (ࠡ稥)
//
//    ᮤন 㭪樨,  뢠  ࠡ⪨
//   ᮮ饭, 㯠  Controls
//
//   : BC++ 3.1
//------------------------------------------------------------------

#define STRICT

#include <windows.h>
#include <windowsx.h>
#pragma  hdrstop

#include <stdio.h>
#include "assocsrv.h"
#include "cntrls.h"
#include "handler.h"
#include "callback.h"

// 㭪 뢠  p⪨ 䨪樮 ᮮ饭 
// ᯨ᪠ pp
void HandleExtList (HWND hWnd, LPARAM lParam) {
     extern        int   nActiveList;
                   int   nIndex,
                         nCount;
                   BOOL  bEnable;

     switch (HIWORD (lParam)){            //  ᨬ  ᮮ饭
            case LBN_SETFOCUS:            // 䮪 p⨫  ᯨ᮪
                 nActiveList = EXT_LIST;  // ⠭ ᮮ⢥騩 p
                 if (SendDlgItemMessage (hWnd, EXT_LIST, LB_GETCOUNT, 0, 0L) <= 0)
                    bEnable = FALSE;
                 else
                     bEnable = TRUE;
                 EnableWindow (GetDlgItem (hWnd, EDIT_BUT), bEnable);
                 EnableWindow (GetDlgItem (hWnd, DELETE_BUT), bEnable);
                 break;

            case LBN_SELCHANGE:
                 nIndex = (int)SendDlgItemMessage (hWnd, EXT_LIST, LB_GETCURSEL, 0, 0L);
                 if (nIndex != LB_ERR)
                    ShowCommands (hWnd, nIndex);
                 break;

            case LBN_DBLCLK:            // Double click - pp
                 HandleEdit (hWnd);}
}

// 㭪 뢠  p⪨ 䨪樮 ᮮ饭 
// ᯨ᪠ 㯭 㭪⮢ 
void HandleMenuList (HWND hWnd, LPARAM lParam) {
     extern         int   nActiveList;
                    BOOL  bEnable;

     switch (HIWORD (lParam)) {
            case LBN_SETFOCUS:                  // ᯨ᮪ 稫 䮪
                 nActiveList = MENU_LIST;
                 if (SendDlgItemMessage (hWnd, MENU_LIST, LB_GETCOUNT, 0, 0L) <= 0)
                    bEnable = FALSE;
                 else
                     bEnable = TRUE;

                 EnableWindow (GetDlgItem (hWnd, EDIT_BUT), bEnable);
                 EnableWindow (GetDlgItem (hWnd, DELETE_BUT), bEnable);
                 break;

            case LBN_DBLCLK:                    // Double click - pp
                 HandleEdit (hWnd);}
}


// 㭪 p訢, p   p p⨨ 
BOOL HandleClose (HWND hWnd) {
     extern BOOL bChanged;
     BOOL        bRetVal = FALSE;
     int         nResult;

     if (!bChanged)      return TRUE;

     nResult = MessageBox (hWnd,
                           "Do you want to save changes ?",
                           "Settings has been changed",
                           MB_ICONQUESTION | MB_YESNOCANCEL);
     switch (nResult) {
            case IDYES:
                 HandleSave ();
            case IDNO:
                 bRetVal = TRUE;}

     return bRetVal;
}


// 㭪 p ⥪騥 ⠭  INI 䠩
void HandleSave (void) {
     extern     char            szIniFile [MAXLINE];
     extern     LPEXTCONTROL    lpContArray;
     extern     int             nContArrSize;
     extern     BOOL            bChanged;

                char            szDummy [1];
                int             nIter;
                LPMENUCH        lpCurrent;
                char            cBuffer [MAXLINE + 3];
                char            cStyle [3] = ";0";
                HCURSOR         hOldCursor;

                hOldCursor = SetCursor (LoadCursor (NULL, IDC_WAIT));
                remove (szIniFile);
                szDummy[0] = '\x0';

                // 砫 뢠 ᥪ [Extensions]
                for (nIter = 0 ; nIter < nContArrSize ; nIter++)
                    WritePrivateProfileString ("Extensions",
                                               lpContArray[nIter].szExtension,
                                               (LPSTR)szDummy,
                                               (LPSTR)szIniFile);

                //   pp ...
                for (nIter = 0 ; nIter < nContArrSize ; nIter++)
                    // ...      ...
                    for (lpCurrent = lpContArray[nIter].lpChain ; lpCurrent ; lpCurrent = lpCurrent->lpNext){
                        // ... ⠢塞 p ...
                        lstrcpy ((LPSTR)cBuffer, lpCurrent->lpCommand);
                        cStyle[1] = (char)('0' + lpCurrent->nStyle);
                        lstrcat ((LPSTR)cBuffer, (LPCSTR)cStyle);
                        // ...  襬  ᮮ⢥ ᥪ
                        WritePrivateProfileString (lpContArray[nIter].szExtension,
                                                   lpCurrent->lpMenuItem,
                                                   (LPCSTR)cBuffer,
                                                   (LPCSTR)szIniFile);}
                bChanged = FALSE;
                SetCursor (hOldCursor);
}

// 㭪 p뢠 p  pp pp  㭪 
BOOL HandleEdit (HWND hWnd) {
     extern int             nActiveList;
     extern int             nContArrSize;
     extern LPEXTCONTROL    lpContArray;
     extern HINSTANCE       hInst;

            LPMENUCH        lpCurrent;
            int             nSelection;
            DLGPROC         fpDlgProc;
            LPCSTR          lpcTemplate;
            BOOL            bRetVal = FALSE;

            switch (nActiveList) {
                   case EXT_LIST:
                        fpDlgProc = (DLGPROC)MakeProcInstance ((FARPROC)EditExtension, hInst);
                        lpcTemplate = MAKEINTRESOURCE (EXT_INPUT);
                        break;
                   case MENU_LIST:
                        fpDlgProc = (DLGPROC)MakeProcInstance ((FARPROC)EditMenu, hInst);
                        lpcTemplate = MAKEINTRESOURCE (INP_DLG);
                        break;
                   default:
                           return bRetVal;}

            bRetVal = (BOOL)DialogBox (hInst, lpcTemplate, hWnd, fpDlgProc);
            FreeProcInstance ((FARPROC)fpDlgProc);
            SetFocus (GetDlgItem (hWnd, nActiveList));
            return bRetVal;
}


// 㭪 p뢠 p    ᯨ᮪  pp
//   p⨢ 
BOOL HandleAppend (HWND hWnd) {
     extern int             nActiveList;
     extern int             nContArrSize;
     extern LPEXTCONTROL    lpContArray;
     extern HINSTANCE       hInst;

            BOOL            bRetVal = FALSE;
            LPMENUCH        lpCurrent;
            int             nSelection;
            DLGPROC         fpDlgProc;
            LPCSTR          lpcTemplate;

     switch (nActiveList) {
                   case EXT_LIST:
                        fpDlgProc = (DLGPROC)MakeProcInstance ((FARPROC)AppendExtension, hInst);
                        lpcTemplate = MAKEINTRESOURCE (EXT_INPUT);
                        break;

                   case MENU_LIST:
                        fpDlgProc = (DLGPROC)MakeProcInstance ((FARPROC)AppendMenuItem, hInst);
                        lpcTemplate = MAKEINTRESOURCE (INP_DLG);
                        break;
                   default:
                           return bRetVal;}

            bRetVal = (BOOL)DialogBox (hInst, lpcTemplate, hWnd, fpDlgProc);
            FreeProcInstance ((FARPROC)fpDlgProc);
            SetFocus (GetDlgItem (hWnd, nActiveList));
            return bRetVal;
}



// 㭪 p뢠 㤠  ᯨ᪠ pp 
// ᯨ᪠ p⨢ 
void HandleDelete (HWND hWnd) {
     extern int             nActiveList;
     extern int             nContArrSize;
     extern LPEXTCONTROL    lpContArray;
     extern BOOL            bChanged;

     char         cText [MAXLINE + 50];
     char*        szCaption         = "Delete confirmation";
     char*        szQuestion        = "Are you really want to delete %s %s ?";
     char*        szExtension       = "extension";
     char*        szMenuItem        = "menu item";
     LPMENUCH     lpCurrent,
                  lpPrev = (LPMENUCH)NULL;
     int          nIndex,
                  nMenuIndex,
                  i;
     LPEXTCONTROL lpNewArray;
     BOOL         bDummy;

     switch (nActiveList) {
            case EXT_LIST:
                 // p塞  ⥪饣 
                 nIndex = (int)SendDlgItemMessage (hWnd, EXT_LIST, LB_GETCURSEL, 0, 0L);
                 // p p ᮮ饭
                 wsprintf ((LPSTR)cText, (LPSTR)szQuestion, (LPSTR)szExtension, (LPSTR)(lpContArray [nIndex].szExtension));
                 break;

            case MENU_LIST:
                 // 砥  뤥   ᯨ᪠ pp
                 nIndex = (int)SendDlgItemMessage (hWnd, EXT_LIST, LB_GETCURSEL, 0, 0L);
                 // 砥   ᯨ᪠ ⮢ 
                 nMenuIndex = (int)SendDlgItemMessage (hWnd, MENU_LIST, LB_GETCURSEL, 0, 0L);
                 // 室 㦭   ᯨ᪥ ( p騩)
                 for (i = 0, lpCurrent = lpContArray[nIndex].lpChain ; (i < nMenuIndex) && lpCurrent ; i++, lpPrev = lpCurrent, lpCurrent = lpCurrent->lpNext);
                 wsprintf ((LPSTR)cText, (LPSTR)szQuestion, (LPSTR)szMenuItem, (LPSTR)(lpCurrent->lpMenuItem));}

     if (MessageBox (hWnd, cText, szCaption, MB_ICONQUESTION | MB_OKCANCEL) == IDOK)
        switch (nActiveList) {
               case EXT_LIST:
                    if (nContArrSize > 1) {
                       // pp塞    ᨢ
                       lpNewArray = GlobalAllocPtr (GHND, (nContArrSize - 1) * sizeof (EXTCONTROL));
                       if (lpNewArray) {
                          // p뢠 㪠⥫
                          for (i = 0 ; i < nIndex ; i++) {
                              lpNewArray[i].lpChain = lpContArray[i].lpChain;
                              lstrcpy (lpNewArray[i].szExtension, lpContArray[i].szExtension);}
                          // 㤠塞 ᯨ᮪
                          DestroyMenuCh (lpContArray[nIndex].lpChain);
                          for (i = nIndex + 1 ; i < nContArrSize ; i++) {
                              lpNewArray[i - 1].lpChain = lpContArray[i].lpChain;
                              lstrcpy (lpNewArray[i - 1].szExtension, lpContArray[i].szExtension);}
                          --nContArrSize;
                          // 㤠塞 p ᨢ
                          bDummy = GlobalFreePtr (lpContArray);
                          // pᢠ  祭 쭮 㪠⥫
                          lpContArray = lpNewArray;}
                       else{
                           DestroyArray ();
                           lpContArray = (LPEXTCONTROL)NULL;}

                       // 㬥蠥 祭 nContArrSize
                       // ⠢塞 p 
                       bChanged = TRUE;
                       // 塞 List Box
                       FillControls (hWnd);}
                    break;

               case MENU_LIST:
                    if (lpPrev)
                       // ᫨ lpCurrent -  p  ᯨ᪠
                       lpPrev->lpNext = lpCurrent->lpNext;
                    else
                         //  ᫨  - p
                         lpContArray[nIndex].lpChain = lpCurrent->lpNext;

                    // 㤠塞 , 饥   ᯨ᪠
                    bDummy = GlobalFreePtr (lpCurrent->lpCommand);
                    bDummy = GlobalFreePtr (lpCurrent->lpMenuItem);
                    bDummy = GlobalFreePtr (lpCurrent);
                    bChanged = TRUE;
                    // 塞 ᮤp List Box
                    ShowCommands (hWnd, nIndex);}
}




// 㭪  Combo Box  ⨫  롨p ⥪騩
void  SetStyles (HWND hWnd, int nStyleIndex) {
      extern    RUNSTYLES   rsStyles [STYLE_NUM];

                int         i;

                // 塞 Combo Box
                for (i = 0 ; i < STYLE_NUM ; i++)
                    SendDlgItemMessage (hWnd, RUN_STYLE, CB_ADDSTRING, 0, (LPARAM)(LPCSTR)&(rsStyles[i].cStyleName));

                // ⠭ ⥪騩 ⨫
                SendDlgItemMessage (hWnd, RUN_STYLE, CB_SETCURSEL, nStyleIndex, 0L);
}

