//--------------------------------------------------------------------
//             ASSOC.C
//
//   (C)1992-93 ᠭ ન
//   ⥫. (056-72)37-110, (056-72)37-702 (ࠡ稥)
//   
//   室 ⥪  DDE. 뢠   ப,
//   饩   䠩  ࠡ⪨. ⠥ ⠭
//   DDE  ࢥ஬  ।   䠩   ப
//   ᫨ 㤠 -  蠥,  ⨢ 砥 - 
//   뢮 ᮮ饭  㤠   ࠢ 蠥
//
//   : BC++ 3.1
//------------------------------------------------------------------


#define STRICT

#include <windows.h>
#include <dde.h>

#define PATH_SIZE   128

static char         szClientClass [] = "AssClientWnd";      // Windows class  
static UINT         wLastDDEClientMsg;
static int          nAckFlag;
static char         szApp [] = "AssocSrv";
static LPSTR        lpFile;
static char         szTopic [] = "File";
static char         szName  [] = "Filename";

// p⨯ 㭪権
BOOL                DDEClientSet (HINSTANCE hInst, HINSTANCE hPrev);
LRESULT CALLBACK    DDEClientWndProc (HWND hWnd, UINT msg, WPARAM wPar, LPARAM lPar);
void                TryStart (char* ExeName, HINSTANCE hInst);

#pragma argsused
int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow){
 MSG      msg;

 //  䠩
 lpFile = lpCmdLine;
 // 樠p㥬 p
 if (!(DDEClientSet (hInstance, hPrevInstance)))
    return (1);

 while (GetMessage (&msg, NULL, NULL, NULL)){
       TranslateMessage (&msg);
       DispatchMessage (&msg);}

 return (msg.wParam);
}


// 㭪 ppp   ᮧ 
BOOL DDEClientSet (HINSTANCE hInst, HINSTANCE hPrev){

     HWND          hChannel,
                   hServer;
     ATOM          aApp;
     ATOM          aTopic;
     WNDCLASS      wclass;
     BOOL          bRet = TRUE;

     // pp㥬 
     if (!hPrev) {
        wclass.style              = (UINT)NULL;
        wclass.lpfnWndProc        = (WNDPROC)DDEClientWndProc;
        wclass.cbClsExtra         = 0;
        wclass.cbWndExtra         = 0;
        wclass.hInstance          = hInst;
        wclass.hIcon              = 0;
        wclass.hCursor            = 0;
        wclass.hbrBackground      = 0;
        wclass.lpszMenuName       = 0;
        wclass.lpszClassName      = szClientClass;

        if (!RegisterClass (&wclass))  return (FALSE);}

     // ᮧ   饭  pp
     hChannel = CreateWindow (szClientClass,
                              NULL,
                              WS_OVERLAPPED,
                              0,
                              0,
                              0,
                              0,
                              NULL,
                              NULL,
                              hInst,
                              NULL);

     // ᫨  ᬮ - p頥
     if (!hChannel)  return (FALSE);
     bRet = TRUE;

     // 饬 pp
     if (!(hServer = FindWindow ("AssocSrvWin",NULL)))
        // ᫨  諨 - p㥬 
        TryStart (szApp, hInst);
     // ᭮ 饬
     if (!(hServer = FindWindow ("AssocSrvWin", NULL))){
        // ᫨   諨 - 뢥 ᮮ饭  p㫨
        MessageBox (hChannel, "Can't find the server",
                    "DDE Init Error", MB_ICONSTOP | MB_OK);
        return (FALSE);}


     //  ⮬  DDE
     if (!(aApp = GlobalAddAtom ((LPSTR)szApp)))    return (FALSE);
     if (!(aTopic = GlobalAddAtom ((LPSTR)szTopic))) {
        GlobalDeleteAtom (aApp);
        return (FALSE);}

     wLastDDEClientMsg = WM_DDE_INITIATE;
     // 뫠 p  DDE
     SendMessage (hServer, wLastDDEClientMsg, (WPARAM)hChannel, MAKELPARAM ((WORD)aApp, (WORD)aTopic));

     // 塞 ⮬
     GlobalDeleteAtom (aApp);
     GlobalDeleteAtom (aTopic);

     // ᫨  ⢥p - 뢮 ᮮ饭  㤠塞 
     if (!nAckFlag) {
        MessageBox (hChannel, "Can't talk to server", "DDE Error",
                    MB_ICONSTOP | MB_OK );
        DestroyWindow (hChannel);
        bRet = FALSE;}

     return (bRet);
}

// 㭪  ,  DDE 
LRESULT CALLBACK DDEClientWndProc (HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam){
     HANDLE       hPokeData;
     DDEPOKE FAR *lpPokeData;
     ATOM         aItem;
     switch (message) {
            case WM_DDE_ACK:
                 // p諮 ⢥p  pp
                 switch (wLastDDEClientMsg){
                        // ⢨   ᫥ ᮮ魨, p-
                        //  ⮬
                        case WM_DDE_INITIATE:
                             // p諮 ⢥p  ⢥  p  -
                             // 砫 DDE
                             GlobalDeleteAtom (LOWORD (lParam));
                             GlobalDeleteAtom (HIWORD (lParam));
                             //  ⮬  p pp  䠩
                             // p WM_DDE_POKE
                             if (!(aItem = GlobalAddAtom ((LPSTR) szName)))
                                return (0L);
                             // 뤥塞   pp DDEPOKE
                             if (!(hPokeData = GlobalAlloc (GMEM_MOVEABLE | GMEM_DDESHARE,
                                               (LONG)sizeof (DDEPOKE) + lstrlen (lpFile) + 2)))
                                 return (0L);
                             if (!(lpPokeData = (DDEPOKE FAR*)GlobalLock (hPokeData))) {
                                GlobalFree (hPokeData);
                                return (0L);}

                             //   ᢮ pp ( 砥 㤠)
                             lpPokeData->fRelease = TRUE;
                             // p 
                             lpPokeData->cfFormat = CF_TEXT;
                             // 뢠   pp
                             lstrcpy ((LPSTR)lpPokeData->Value, (LPSTR)lpFile);
                             lstrcat ((LPSTR)lpPokeData->Value, (LPSTR)"\r\n");
                             GlobalUnlock (hPokeData);
                             // ᫨  稫 p -  㤠塞
                             if (!PostMessage ((HWND)wParam, WM_DDE_POKE, (WPARAM)hWnd,
                                               MAKELPARAM ((WORD)hPokeData, (WORD)aItem))){
                                 GlobalDeleteAtom (aItem);
                                 GlobalFree (hPokeData);}
                             else {
                                  //  ᫨ 㤠 -  ᫥ p-
                                  //  ᮮ饭  ⠢塞 䫠 -
                                  // ⢥p
                                  wLastDDEClientMsg = WM_DDE_POKE;
                                  nAckFlag = 1;}
                             break;

                        case WM_DDE_POKE:
                             // p諮 ⢥p  WM_DDE_POKE
                             if (!(LOWORD (lParam))){
                                // ᫨ pp  㤠 ⮬, 㤠塞
                                GlobalDeleteAtom (aItem);
                                GlobalFree (hPokeData);}
                             // 㤠塞 
                             DestroyWindow (hWnd);}
                 break;

            case WM_DESTROY:
                 PostQuitMessage (0);
                 break;

            default:
                    return (DefWindowProc (hWnd, message, wParam, lParam));}
     return (0L);
}



// 㭪 ⠥  pp
void TryStart (char* szExeName, HINSTANCE hIns) {
     char  szMyPath [PATH_SIZE];
     int   nIter;

     if (!GetModuleFileName (hIns, szMyPath, PATH_SIZE))    return;
     for (nIter = lstrlen ((LPSTR) szMyPath) ; nIter ; nIter--)
         if ((szMyPath [nIter] == ':') || (szMyPath [nIter] == '\\') || (szMyPath [nIter] == '/')){
            szMyPath [++nIter] = (char)'\0';
            break;}

     WinExec (lstrcat ((LPSTR) szMyPath, (LPSTR) szExeName), SW_SHOWMINIMIZED);
}




