{*******************************************************}
{                                                       }
{       Turbo Pascal Version 7.0                        }
{       Extended Strings Unit                           }
{       Version 1.1                                     }
{                                                       }
{       Copyright (c) 1993 by RDA Software              }
{                                                       }
{*******************************************************}

Unit  Strings_;

{$I-,S-,R-}

     INTERFACE


Procedure StrToLower(Var Str: String);
{ 楤 ८ࠧ ப Str   ॣ. }

Procedure StrToUpper(Var Str: String);
{ 楤 ८ࠧ ப Str  孥 ॣ. }

Function  StrChr(Str: String; Sim: Char): Boolean;
{ 㭪 ஢ 宦 ᨬ Chr  ப Str. }

Function  StrIChr(Str: String; Sim: Char): Boolean;
{ 㭪 ஢ 宦 ᨬ Chr  ப Str,
    ⮬ 㪢 孥   ॣ஢
  묨. }

Function  StrCmp(Str1, Str2: String): Integer;
{ 㭪 頥 १ ࠢ  ப:
    -1, ᫨ Str1 < Str2;
     0, ᫨ Str1 = Str2;
     1, ᫨ Str1 > Str2. }

Function  StrICmp(Str1, Str2: String): Integer;
{ 㭪 頥 १ ࠢ  ப,
   㪢 孥   ॣ஢ 묨:
    -1, ᫨ Str1 < Str2;
     0, ᫨ Str1 = Str2;
     1, ᫨ Str1 > Str2. }

Function  StrNCmp(Str1, Str2: String; N: Byte): Integer;
{ 㭪 頥 १ ࠢ  ப,
  ࠢ  , 祬  N ᨬ:
    -1, ᫨ Str1 < Str2;
     0, ᫨ Str1 = Str2;
     1, ᫨ Str1 > Str2. }

Procedure  StrSet(Var Str: String; Sim: Char);
{ 楤 ⠭  ᨬ ப  祭,
   ࠬ஬ Sim.}

Procedure StrNSet(Var Str: String; Sim: Char; N: Byte);
{ 楤 ⠭ N ᨬ ப  祭,
   ࠬ஬ Sim.  ப ⠭  N. }

Function  StrLen(Str: String): Byte;
Inline($5F/$07/$26/$8A/$05);
{ 頥  ப Str. }

Function  Contains(Str1, Str2: String): Byte;
{ 㭪 頥  樨 ࢮ ᨬ  ப Str1,
   ᮤন  ப Str2  0, ᫨   ᨬ  Str1
     Str2. }

Procedure DelRightSpace(Var Str: String);
{ 楤 㤠 騥 ஡  ப Str. }

Procedure DelLeftSpace(Var Str: String);
{ 楤 㤠 騥 ஡  ப Str. }


     IMPLEMENTATION

{$L Strings}

Procedure StrToLower; External;

Procedure StrToUpper; External;

Function  StrChr; External;

Function  StrIChr; External;

Function  StrCmp; External;

Function  StrICmp; External;

Function  StrNCmp; External;

Procedure StrSet; External;

Procedure StrNSet; External;

Function  Contains; External;

Procedure DelRightSpace; External;

Procedure DelLeftSpace; External;

end.
