          {-------------------------------------------------}
          {         Convert  V 1.0 for Windows              }
          {-------------------------------------------------}
          {   : Borland Pascal V 7.0    }
          {   : 12.11.1993                      }
          {    : 12.11.1993           }
          {-------------------------------------------------}
          {           }
          {              }
          {   MS-DOS 866 code page   Windows  }
          {-------------------------------------------------}
          { (c) 1993,                           }
          {-------------------------------------------------}

Program Convert;
{$R Conv.Res }
{$R CDlg.Res }
Uses Objects, WinDos, WinTypes, WinProcs, Strings, OWindows,
  ODialogs, OstdDlgs;
Type
  TConvertApplication = Object ( TApplication )
    {      }
    Procedure InitMainWindow; Virtual;
      {     }
    Procedure InitInstance; Virtual;
      {    }
  End; { Object TConvertApplication }
{----------------------------------------------------------}
Const
  id_DosWin = 102;
    {   Dos - Windows }
  id_WinDos = 103;
    {   Windows - Dos }
  id_Return = 104;
    {      }
Type
  POptDialog = ^TOptDialog;
    {       }
  TOptDialog = Object ( TDialog )
    {     }
    Coder : Integer;
      {   }
    Procedure DosToWindows ( Var Msg : TMessage );
      Virtual id_First + id_DosWin;
        {    Dos - Windows }
    Procedure WindowsToDos ( Var Msg : TMessage );
      Virtual id_First + id_WinDos;
        {    Windows - Dos }
    Procedure Return ( Var Msg : TMessage );
      Virtual id_First + id_Return;
        {     }
  End; { Object TOptDialog }
{----------------------------------------------------------}
Const
  cm_File = 201;
    {   "" }
  cm_Options = 202;
    {   "" }
  cm_Path = 203;
    {   "" }
  cm_Help = 204;
    {   "" }
  cm_Exit = 205;
    {   "" }
Type
  TCoder = ( NoCoder, Dos_Windows, Windows_Dos );
    {    }
  PMainWin = ^TMainWin;
    {        }
  TMainWin = Object ( TWindow )
    {      }
    DestinationPath : Array [ 0..40 ] Of Char;
      {   }
    Coder : TCoder;
      {    }
    Constructor Init ( AParent : PWindowsObject; ATitle : PChar );
      {   }
    Procedure GetWindowClass ( Var AWndClass : TWndClass ); Virtual;
      {     }
    Procedure Files ( Var Msg : TMessage ); Virtual cm_First + cm_File;
      {    "" }
    Procedure Options ( Var Msg : TMessage ); Virtual cm_First + cm_Options;
      {   "" }
    Procedure Path ( Var Msg : TMessage ); Virtual cm_First + cm_Path;
      {   "" }
    Procedure Help ( Var Msg : TMessage ); Virtual cm_First + cm_Help;
      {   ""  }
    Procedure Quit ( Var Msg : TMessage ); Virtual cm_First + cm_Exit;
      {   ""  }
  End; { Object TMainWin}
{----------------------------------------------------------}
Const
  wm_Proc = 101;
    {     }
Type
  PMsgWindow = ^TMsgWindow;
    {        }
  TMsgWindow = Object ( TWindow )
    {       }
    StartParam : LongInt;
      {      }
    Constructor Init ( AParent : PWindowsObject; ATitle : PChar;
      Start : LongInt; sx, sy : Word );
      {   }
    Procedure ProcMsg ( Var Msg : TMessage ); Virtual wm_First + wm_Proc;
     {    }
  End; { Object TMsgWindow }
{==========================================================}
Function t866ToParaGraph ( Line : String ) : String;
  {     866 code page 
    ParaGraph }
Var
  Index : Byte;
Begin
  For Index := 1 To Length ( Line ) Do Begin
    Case Line [ Index ] Of
      #$80..#$AF : Line [ Index ] := Chr ( Ord ( Line [ Index ] ) + $40 );
      #$E0..#$EF : Line [ Index ] := Chr ( Ord ( Line [ Index ] ) + $10 );
    End; { Case }
  End;
  t866ToParaGraph := Line;
End; { Function t866ToParaGraph }
{----------------------------------------------------------}
Function ParaGraphTot866 ( Line : String ) : String;
  {     ParaGraph  
   866 code page }
Var
  Index : Byte;
Begin
  For Index := 1 To Length ( Line ) Do Begin
    Case Line [ Index ] Of
      #$C0..#$EF : Line [ Index ] := Chr ( Ord ( Line [ Index ] ) - $40 );
      #$F0..#$FF : Line [ Index ] := Chr ( Ord ( Line [ Index ] ) - $10 );
    End; { Case }
  End;
  ParaGraphTot866 := Line;
End; { Function ParaGraphTot866 }
{==========================================================}
Constructor TMsgWindow.Init ( AParent : PWindowsObject; ATitle : PChar;
  Start : LongInt; sx, sy : Word );
  {   }
Begin
  TWindow.Init ( AParent, ATitle );
  With Attr Do Begin
    Style := ws_PopupWindow Or ws_Caption Or ws_Child Or ws_Visible;
    X := sx + 80;
    Y := sy + 80;
    W := 400;
    H := 100;
  End;
  StartParam := Start;
End; { Constructor TMsgWindow.Init }
{----------------------------------------------------------}
Procedure TMsgWindow.ProcMsg ( Var Msg : TMessage );
  {    }
Var
  Proc : Real;
  Line : Array [ 0..60 ] of Char;
  DC : HDC;
  KeyOut : Boolean;
Begin
  Proc := ( Msg.LParam / StartParam ) * 100.0;
  Str ( Proc : 5 : 2, Line );
  DC := GetDC ( HWindow );
  StrCat ( Line, ' %     ' );
  SetTextColor ( DC, RGB ( 255, 0, 0 ) );
  KeyOut := TextOut ( DC, 100, 20, Line, StrLen ( Line ) );
  ReleaseDC ( HWindow, DC );
End; { Procedure TMsgWindow.ProcMsg }
{==========================================================}
Procedure TOptDialog.DosToWindows ( Var Msg : TMessage );
 {    Dos - Windows }
Begin
  SendDlgItemMsg ( id_DosWin, bm_SetCheck, 1, LongInt ( 0 ) );
  SendDlgItemMsg ( id_WinDos, bm_SetCheck, 0, LongInt ( 0 ) );
  PMainWin ( Application^.MainWindow )^.Coder := Dos_Windows;
End; { Procedure TOptDialog.DosToWindows }
{----------------------------------------------------------}
Procedure TOptDialog.Return ( Var Msg : TMessage );
  {     }
Begin
  SendMessage ( HWindow, wm_Close, 0, LongInt ( 0 ) );
End; { Procedure TOptDialog.Return }
{----------------------------------------------------------}
Procedure TOptDialog.WindowsToDos ( Var Msg : TMessage );
 {    Windows - Dos }
Begin
  SendDlgItemMsg ( id_WinDos, bm_SetCheck, 1, LongInt ( 0 ) );
  SendDlgItemMsg ( id_DosWin, bm_SetCheck, 0, LongInt ( 0 ) );
  PMainWin ( Application^.MainWindow )^.Coder := Windows_Dos;
End; { Procedure TOptDialog.WindowsToDos }
{==========================================================}
Constructor TMainWin.Init ( AParent : PWindowsObject; ATitle : PChar );
  {   }
Begin
  TWindow.Init ( AParent, ATitle );
  Attr.Menu := LoadMenu ( hInstance, 'CMENU' );
  Attr.X := 80;
  Attr.Y := 100;
  Attr.W := 500;
  Attr.H := 300;
  FillChar ( DestinationPath, SizeOf ( DestinationPath ), #0 );
  StrCat ( DestinationPath, 'D:\WORK.WIN\LIB' );
  Coder := Dos_Windows;
End; { Constructor TMainWin.Init }
{----------------------------------------------------------}
Procedure TMainWin.GetWindowClass ( Var AWndClass : TWndClass );
  {     }
Begin
  TWindow.GetWindowClass ( AWndClass );
  AWndClass.hIcon := LoadIcon ( hInstance, 'CICON' );
End; { Procedure TMainWin.GetWindowClass }
{----------------------------------------------------------}
Procedure TMainWin.Files ( Var Msg : TMessage );
  {    "" }
Var
  CurrDir : Array [ 0..fsPathName ] Of Char;
  FileName : Array [ 0..fsPathName ] Of Char;
  FileOut : Array [ 0..fsPathName ] Of Char;
  Fl_In, Fl_Out : Text;
  FlSz : File;
  InSize : LongInt;
  Counter : LongInt;
  S1, S2 : Array [ 0..fsPathName ] Of Char;
  Line : String;
  Dir : Array [ 0..fsPathName ] Of Char;
  Name : Array [ 0..fsFileName ] Of Char;
  Ext : Array [ 0..fsExtension ] Of Char;
  MsgWnd : PWindow;
Begin
  if StrPas ( DestinationPath ) = '' then Begin
    MessageBox ( HWindow, '   ', '',
      mb_OK + mb_IconExclamation );
    Exit;
  End;
  GetCurDir ( CurrDir, 0 );
  if IOResult <> 0 then Begin
    MessageBox ( HWindow, '    ','',
      mb_OK + mb_IconExclamation );
    Exit;
  End;
  ChDir ( StrPas ( DestinationPath ) );
  if IOResult <> 0 then Begin
    MessageBox ( HWindow, '    ','',
      mb_OK + mb_IconExclamation );
    Exit;
  End;
  ChDir ( StrPas ( CurrDir ) );
  if IOResult <> 0 then Begin
    MessageBox ( HWindow, '    ','',
      mb_OK + mb_IconExclamation );
    Exit;
  End;
  FillChar ( FileName, SizeOf ( FileName ), #0 );
  StrCat ( FileName, '*.*' );
  While Application^.ExecDialog ( New ( PFileDialog,
    Init ( @Self, PChar ( sd_FileOpen ), FileName ) ) ) = id_OK Do Begin
    FillChar ( FileOut, SizeOf ( FileOut ), #0 );
    StrCat ( FileOut, DestinationPath );
    StrCat ( FileOut, '\' );
    FileSplit ( FileName, Dir, Name, Ext );
    StrCat ( FileOut, Name );
    StrCat ( FileOut, Ext );
    if FileExpand ( S1, FileName ) = FileExpand ( S2, FileOut ) then Begin
      MessageBox ( HWindow, '    ',
        '', mb_OK + mb_IconExclamation );
      Exit;
    End;
    Assign ( FlSz, StrPas ( S1 ) );
    ReSet ( FlSz, 1 );
    if IOResult <> 0 then Begin
      MessageBox ( HWindow, '  ',
        '', mb_OK + mb_IconExclamation );
      Continue;
    End;
    InSize := FileSize ( FlSz );
    Close ( FlSz );
    if IOResult <> 0 then;
    Assign ( Fl_In, StrPas ( S1 ) );
    Assign ( Fl_Out, StrPas ( S2 ) );
    ReSet ( Fl_In );
    if IOResult <> 0 then Begin
      MessageBox ( HWindow, '  ',
        '', mb_OK + mb_IconExclamation );
      Continue;
    End;
    ReWrite ( Fl_Out );
    if IOResult <> 0 then Begin
      MessageBox ( HWindow, '    ',
        '', mb_OK + mb_IconExclamation );
      Close ( Fl_In );
      if IOResult <> 0 then;
      Continue;
    End;
    Counter := 0;
    MsgWnd := New ( PMsgWindow,
      Init ( @Self, '', InSize, Attr.X, Attr.Y ) );
    Application^.MakeWindow ( MsgWnd );
    While Not Eof ( Fl_In ) Do Begin
      ReadLn ( Fl_In, Line );
      if IOResult <> 0 then Begin
        MessageBox ( HWindow, '   ',
          '', mb_OK + mb_IconExclamation );
        Break;
      End;
      Case Coder Of
        Dos_Windows : Line := t866ToParaGraph ( Line );
        Windows_Dos : Line := ParaGraphTot866 ( Line );
      End; { Case }
      WriteLn ( Fl_Out, Line );
      if IOResult <> 0 then Begin
        MessageBox ( HWindow, '   ',
          '', mb_OK + mb_IconExclamation );
        Break;
      End;
      Counter := Counter + Length ( Line ) + 2;
      SendMessage ( MsgWnd^.HWindow, wm_Proc, 0, Counter );
    End;
    SendMessage ( MsgWnd^.HWindow, wm_Close, 0, LongInt ( 0 ) );
    Close ( Fl_In );
    if IOResult <> 0 then;
    Close ( Fl_Out );
    if IOResult <> 0 then;
  End;
End; { Procedure TMainWin.Files }
{----------------------------------------------------------}
Procedure TMainWin.Options ( Var Msg : TMessage );
  {   "" }
Begin
  Coder := Dos_Windows;
  Application^.ExecDialog ( New ( POptDialog, Init ( @Self, 'CDIALOG' ) ) );
End; { Procedure TMainWin.Options }
{----------------------------------------------------------}
Procedure TMainWin.Path ( Var Msg : TMessage );
  {   "" }
Var
  CurrDir : Array [ 0..fsPathName ] Of Char;
  KeyDir : Boolean;
Begin
  Repeat
    KeyDir := True;
    if Application^.ExecDialog ( New ( PInputDialog,
      Init ( @Self, '','   :',
        DestinationPath, SizeOf ( DestinationPath ) ) ) ) <> id_OK then
          Break;
    GetCurDir ( CurrDir, 0 );
    if IOResult <> 0 then Begin
      MessageBox ( HWindow, '    ','',
        mb_OK + mb_IconExclamation );
      Exit;
    End;
    ChDir ( StrPas ( DestinationPath ) );
    if IOResult <> 0 then Begin
      MessageBox ( HWindow, '    ','',
        mb_OK + mb_IconExclamation );
      KeyDir := False;
    End;
    ChDir ( StrPas ( CurrDir ) );
    if IOResult <> 0 then Begin
      MessageBox ( HWindow, '    ','',
        mb_OK + mb_IconExclamation );
      Exit;
    End;
  Until KeyDir;
End; { Procedure TMainWin.Path }
{----------------------------------------------------------}
Procedure TMainWin.Help ( Var Msg : TMessage );
  {   ""  }
Begin
  Application^.ExecDialog ( New ( POptDialog, Init ( @Self, 'HDIALOG' ) ) );
End; { Procedure TMainWin.Help }
{----------------------------------------------------------}
Procedure TMainWin.Quit ( Var Msg : TMessage );
  {   ""  }
Begin
  SendMessage ( HWindow, wm_Close, 0, LongInt ( 0 ) );
End; { Procedure TMainWin.Quit }
{==========================================================}
Procedure TConvertApplication.InitMainWindow;
  {     }
Begin
  MainWindow := New ( PMainWin, Init ( Nil,
    ' ' ) );
End; {  Procedure TConvertApplication.InitMainWindow }
{----------------------------------------------------------}
Procedure TConvertApplication.InitInstance;
  {    }
Begin
  TApplication.InitInstance;
  HAccTable := LoadAccelerators ( hInstance, 'CACCELERATORS' );
End; { Procedure TConvertApplication.InitInstance; }
{==========================================================}
Var
  Conv : TConvertApplication;
  Lib : THandle;
  Dir : Array [ 0..fsPathName ] Of Char;
Begin
  FileSearch ( Dir, 'BWCC.DLL', GetEnvVar ( 'PATH' ) );
  if StrPas ( Dir ) <> '' then Begin;
    Lib := LoadLibrary ( 'BWCC.DLL' );
    Conv.Init ( '' );
    Conv.Run;
    Conv.Done;
    FreeLibrary ( Lib );
  End
  else Begin
    MessageBox ( 0, '  BWCC.DLL',' ',
      mb_Ok + mb_IconStop + mb_SystemModal );
  End;
End. { Program Convert }
