
{************************************************}
{                                                }
{        L e c a r                               }
{   Turbo Pascal 5.X, 6.X                        }
{   ,  稭  Copyright-  1991     }
{     1.0  11.11.1991 14.00.45.55        }
{************************************************}


{$A+,B-,D-,E-,F-,I-,N-,O-,R-,S-,L-}
{$M $1000, 0, $800}

Unit ErrHand;

{  ᯮ  ࠡ⪨ ᪨ 訡,
     १ ᪮ 権 /뢮.
    ᥪ樨 樠樨   ⪫祭 
   ⢥ ᫥⢨  ᭮ ணࠬ.  ⮬
   砥 訡 㭪樨  १ Abort
}

Interface

Uses
    Crt,
    Dos;

Const
     ErrorFlag     : Boolean = False;    {   訡 }
     LastError     : String  = '';       { 饭  ᫥ 訡 }
     MonoHi        : Byte    = $0F;      { ਡ ⨢ 㭪  () }
     MonoLo        : Byte    = $70;      { ਡ ⨢ 㭪  () }
     ColorSelect   : Byte    = $1E;      { ਡ ⨢ 㭪  (梥) }
     ColorUnSelect : Byte    = $4F;      { ਡ ⨢ 㭪  (梥) }
     ErrHandlerPtr : Pointer = NIL;      { ⥫  짮⥫ 楤 ࠡ⪨ 訡 }
     RetryFlag     : Boolean = True;     { , 頥 짮. 楤ன  樨 Retry }

Function GetErrorName : String;          { 頥  訡 }

Implementation

Var
   ErrorHandler : Procedure Absolute ErrHandlerPtr;
   { ᫨  㪠뢠  NIL 뢠   ᪮ 訡 }

Const
     ErrMsg : Array [0..$58] of String[35] = { ᨢ ᮮ饭  訡 }
           (
{00}         'Undefine',
{01}         'Invalid function number',
{02}         'File not found',
{03}         'Path not found',
{04}         'Too many open files',
{05}         'Access denied',
{06}         'Invalid handle',
{07}         'MCB destroyed',
{08}         'Insufficient memory',
{09}         'Invalid memory block addres',
{0A}         'Invalid environment',
{0B}         'Invalid format',
{0C}         'Invalid accses code',
{0D}         'Invalid data',
{0E}         '',
{0F}         'Invalid drive specified',
{10}         'Can''t remove current dir',
{11}         'Not same device',
{12}         'No more matching file',
{13}         'Write-protected',
{14}         'Unknown unit ID',
{15}         'Drive not ready',
{16}         'Unknown command',
{17}         'Disk data error (CRC error)',
{18}         'Bad request structure length',
{19}         'Disk seek error',
{1A}         'Unknown disk media type',
{1B}         'Sector not found',
{1C}         'Out of paper',
{1D}         'Write fault',
{1E}         'Read fault',
{1F}         'General failure',
{20}         'File sharing violation',
{21}         'File locking violation',
{22}         'Invalid disk change',
{23}         'Too many FCBs',
{24}         'Sharing buffer overflow',
{25}         '',
{26}         '',
{27}         '',
{28}         '',
{29}         '',
{2A}         '',
{2B}         '',
{2C}         '',
{2D}         '',
{2E}         '',
{2F}         '',
{30}         '',
{31}         '',
{32}         'Network request not supported',
{33}         'Remote computer not listening',
{34}         'Duplicate name on network',
{35}         'Network name not found',
{36}         'Network busy',
{37}         'Network device no longer exists',
{38}         'Net BIOS command limit exceeded',
{39}         'Network adapter hardware error',
{3A}         'Incorrect response from network',
{3B}         'Unexpected network error',
{3C}         'Incompatible remote adapter',
{3D}         'Print gueue full',
{3E}         'Not enough space for print file',
{3F}         'Print file was deleted',
{40}         'Network name was deleted',
{41}         'Access denided',
{42}         'Incorrect network device type',
{43}         'Network name not found',
{44}         'Network name limit exceeded',
{45}         'Net BIOS sessinon linit exceeded',
{46}         'Temporarily paused',
{47}         'Network request not accepted',
{48}         'Print or disk redirection is paused',
{49}         '',
{4A}         '',
{4B}         '',
{4C}         '',
{4D}         '',
{4E}         '',
{4F}         '',
{50}         'File already exist',
{51}         '',
{52}         'Cannot make directory entry',
{53}         'Fail error from int 24h',
{54}         'Too many redirections',
{55}         'Duplicate redirection',
{56}         'Invalid password',
{57}         'Invalid parameter',
{58}         'Network data fault'
           );

     { 饭  訡, 頥 INT 24H }
     Int24ErrMsg : Array [0..$11] of String[30] =
           (
{00}         'Write-protect error',
{01}         'Unknown unit',
{02}         'Drive not ready',
{03}         'Unknown command',
{04}         'Data error ( bad CRC )',
{05}         'Bad request structure lentgh',
{06}         'Seek error',
{07}         'Unknown media type',
{08}         'Sector not found',
{09}         'Printer out of paper',
{0A}         'Write fault',
{0B}         'Read fault',
{0C}         'General failure',
{0D}         'Sharing violation',
{0E}         'Lock violation',
{0F}         'Invalid disk change',
{10}         'FCB unavailable',
{11}         'Sharing buffer overflow'
           );

     TextModes : Set of Byte = [ 0, 1, 2, 3, 7 ] ;
     { ०, ন unit- ErrHand }

Type
    BuffType   = Array [0..3999] of Byte;
    {   }

Const
     Height  = 10; {   訡 }
     XL      = 25; { 孨  㣮 }
     YL      = 8;
     Abort   = ' Abort ';
     Retry   = ' Retry ';
     PrevWindow : Array [0..Height-2] of String[30] =
              (

               '                   ',
               ' Ŀ ',
               '                 ',
               '                 ',
               '                 ',
               '                 ',
               '                 ',
               '  ',
               '                   '
              );

     Window  : Array [0..Height] of String[40] =
              (

               '                                   ',
               '  Error Ŀ ',
               '                                 ',
               '                                 ',
               '                                 ',
               '                                 ',
               '                                 ',
               '                                 ',
               '                                 ',
               '  ',
               '                                   '
              );


Var
   ExtCode   : Word;
   I, J      : Byte;
   Sys24     : Procedure;  { ⥬ ࠡ稪 INT 24H }
   Buff      : BuffType;   {   }
   SaveExit,
   VideoPtr  : Pointer;
   VideoMem  : Word;
   F         : File;
   Regs      : Registers;
   VideoPage,
   Columns   : Byte;

Function GetVideoMode : Byte;   { 頥 ࠬ  ० INT 10H }
Begin
     Regs.AH := $0F;
     Intr ( $10, Regs );
     GetVideoMode := Regs.AL;
     VideoPage := Regs.BH;
     Columns := Regs.AH;
End;

{$F+}  { ਬ FAR ⨯ 맮 ணࠬ }

Function GetErrorName : String; { 頥 ७ ଠ  訡 INT 21H }
Begin
     Regs.AH := $59;
     Regs.BX := 0;
     MsDos ( Regs );
     GetErrorName := ErrMsg[Lo(Regs.AX)];
End;

Function GetKey : Word;  {  ७   }
Begin
     Regs.AH := 0;
     Intr ( $16, Regs );
     If Regs.AL = 0 then GetKey := Regs.AX
       else GetKey := Regs.AL;
End;

{  ⢥ ࠡ稪 ᪨ 訡 }
Procedure Int24 ( Flags,CS,IP,AX,BX,CX,DX,SI,DI,DS,ES,BP: Word); Interrupt;
   Var
      Mode     : Byte;
      Choice   : Byte;
      _X, _Y   : Byte;
      Msg      : String[20];
      SaveAttr : Byte;
      Select,
      Unselect : Byte;
Begin
     ErrorFlag := True;                   { ந諠 訡 }
     LastError := Int24ErrMsg[Lo(DI)];    {  訡 }
     If ErrHandlerPtr <> NIL then begin   { ᫨  짮⥫᪨ ࠡ稪, 맢  }
       ErrorHandler;
       If RetryFlag then AX := Hi(AX) Shl 8 + 1  { Retry }
         else AX := Hi(AX) Shl 8 + 3;     { ⠭  室 Abort }
       Exit;                              {  室 }
     end;
     SaveAttr := TextAttr;
     Mode := GetVideoMode;                {   ० }
     Choice := 0;
     If Mode In TextModes then begin      { ஢ઠ ন ० }
       DirectVideo := True;
       CheckSnow := False;
       _X := WhereX;
       _Y := WhereY;
       Select := ColorSelect;
       UnSelect := ColorUnSelect;
       If Mode  = 7 then begin           { ஬ ० }
         VideoMem := $B000;
         Select := MonoLo;
         UnSelect := MonoHi;
       end
       else VideoMem := $B800;          { ⭮ }
       VideoPtr := Ptr ( VideoMem, VideoPage*4000 ); { ᫥  ⥪饩 ࠭ }
       Move ( VideoPtr^, Buff, 4000 );   {  ࠭ ࠭   }
       TextAttr := UnSelect;
       For I:=0 to Height-2 do begin
          GoToXY ( XL+8, YL+I+1 );
          Write ( PrevWindow [I] );      { ᮢ   }
       end;
       Delay ( 50 );
       For I:=0 to Height do begin
          GoToXY ( XL, YL+I );
          Write ( Window [I] );          { ᮢ    }
       end;
       GoToXY ( XL+17-(Length(Int24ErrMsg[Lo(DI)]) Div 2), YL+3 );
       TextAttr := UnSelect;
       Write ( Int24ErrMsg[Lo(DI)] );    { 뢮 ᮮ饭  訡 }
       Msg := 'Drive: ';
       If (AX AND $8000) = 0
         then Msg := Msg + Char(Byte('A')+Lo(AX)) + ':'
         else For I := $0A to $12 do Msg := Msg + Char(Mem[BP:SI+I]);
       GoToXY ( XL+17-(Length(Msg) Div 2), YL+5 );
       Write ( Msg );                    { 뢮 訡筮 ன⢠ }
       Mem [ $0000:$41C ] := Mem [ $0000:$41A ]; { ⪠   }
       If (Hi(AX) AND $10) = 0 then begin
         AX := Hi(AX) Shl 8 + 3;         { 訡  }
         GoToXY ( XL+17-(Length(Abort) Div 2), YL+7 );
         TextAttr := $1E;
         Write  ( Abort );
         GoToXY ( _X, _Y );
         Repeat
               ExtCode := GetKey;
         Until (ExtCode = 13) Or (ExtCode = 27); { 室  Ener  ESC }
       end
       else begin
           GoToXY ( XL+9, YL+7 );
           TextAttr := Select;
           Write  ( Abort );
           GoToXY ( XL+19, YL+7 );
           TextAttr := UnSelect;
           Write  ( Retry );
           GoToXY ( _X, _Y );
           Repeat                      { 稭 롮  Abort  Retry }
                 ExtCode := GetKey;
                 Case ExtCode of
                      $4B00 : If Choice = 1 then Choice := 0
                                else Choice := 1;
                      $4D00 : If Choice = 0 then Choice := 1
                                else Choice := 0;
                 end;           { ५  롮 }
                 If Choice = 0 then begin
                   GoToXY ( XL+9, YL+7 );
                   TextAttr := Select;
                   Write  ( Abort );
                   GoToXY ( XL+19, YL+7 );
                   TextAttr := UnSelect;
                   Write  ( Retry );
                   AX := Hi(AX) Shl 8 + 3;      { Abort }
                 end
                 else begin
                   GoToXY ( XL+9, YL+7 );
                   TextAttr := UnSelect;
                   Write  ( Abort );
                   GoToXY ( XL+19, YL+7 );
                   TextAttr := Select;
                   Write  ( Retry );
                   AX := Hi(AX) Shl 8 + 1;      { Retry }
                 end;
                 GoToXY ( _X, _Y );
           Until (ExtCode = 13) Or (ExtCode = 27);
           If ExtCode = 27 then AX := Hi(AX) Shl 8 + 3;
       end;
       Move ( Buff, VideoPtr^, 4000 ); { ⠭ ࠭ }
       GoToXY ( _X, _Y );
       TextAttr := SaveAttr;
     end
     else begin
          AX := Hi(AX) Shl 8 + 3;
          Exit;
     end;
End;

Procedure ExitHandler;      { ࠡ稪 ७ 訡 ⮬ }
Begin
     ExitProc := SaveExit;  { ⠭ 室 ࠡ稪 }
     Halt( 0 );             { 0  -  誠 }
End;

{$F-}

Begin                                  {  樠樨 }
     SaveExit := ExitProc;             
     ExitProc := @ExitHandler;         { ⠭ ࠡ稪 ७ 訡 }
     GetIntVec ( $24, @Sys24);         
     SetIntVec ( $24, Addr(Int24) );   { ⠭ INT 24H }
End.