unit Mice;

interface

type

  {Format of BIN-file, generated by EDMICE, is the same as this record.}

  MouseShapeType = record
    HotSpotX, HotSpotY : word;
    AndMask, XorMask : array [0..15] of word
  end;

  MouseShapePtr = ^MouseShapeType;

  function MouseInstalled: boolean;

  procedure ShowMouse;

  procedure HideMouse;

  procedure SetMouseShape(M : MouseShapePtr);

  procedure SetGraphMode;

  procedure SetTextMode;

{=========================== implementation =========================}

implementation

  function MouseInstalled: boolean; assembler;
  asm
    mov   ax, 3533h
    int   21h
    mov   ax, es
    or    ax, bx
    je    @Exit
    xor   ax, ax
    int   33h
    cmp   ax, 0FFFFh
    je    @Exit
    xor   ax, ax
  @Exit:
  end;

  procedure ShowMouse; assembler;
  asm
    mov   ax, 0001h
    int   33h
  end;

  procedure HideMouse; assembler;
  asm
    mov   ax, 0002h
    int   33h
  end;

  procedure SetMouseShape(M : MouseShapePtr); assembler;
  asm
    push  ds
    push  es
    lds   si, M
    lodsw
    mov   bx, ax
    lodsw
    mov   cx, ax
    push  ds
    pop   es
    push  si
    pop   dx
    mov   ax, 0009h
    int   33h
    pop   es
    pop   ds
  end;

  procedure SetGraphMode; assembler;
  asm
    mov  ax, 0013h
    int  10h
  end;

  procedure SetTextMode; assembler;
  asm
    mov  ax, 0003h
    int  10h
  end;

end.
{eof mice.pas}
