/**
*  , ᮤঠ騩 ᭮  "" 㭪樨:
*	 ᯥ稢 室  樨  樨.
*
* 	1.5	(C)Copyright InfoScope Inc. 1992
*
**/

#include <stdio.h>

#include <display.h>
#include <xm.h>

#include "life.h"
#include "lifetxt.h"
#include "lifescr.h"
#include "life_io.h"

CELL *mainList;

LOCAL int vicinity [5] [5];
big	stepNo;

LOCAL void makeVicinity (CELL *center);
	/*  窨  業஬  center ந ⭮ ࠤ 3.	*/
	/* ᬠਢ 窨  ᯨ᪠    mainList. 	*/

LOCAL int checkCreation (int x, int y);
	/* ᬠਢ ⭮ 窨 (x,y)  Vicinity,        	*/
	/* 蠥, 㦭  ᮧ  ᪮            	*/
	/*  ᮮ⢥騬 न⠬.                        	*/
	/* 頥 1, ᫨ 㦭, 0  ⨢ 砥.         	*/
LOCAL void glueList(CELL *list);
	/* ᮥ  ᯨ, 稭饬  list,           	*/
	/* ᯨ᮪, 稭騩  mainList.                        	*/
	/* NB      ᮪ "稭"  p,                        	*/
	/*         ᫨  p ࠭   ࢮ .   	*/

/**
*
*  findCell	--    न⠬ (x, y)  ᯨ᪥ mainList
*
* 饭	this = findCell (x, y);
*
*		CELL *this	  ᯨ᪠ mainList
*		long x		न ᪮   ਧ⠫
*		long y		 ⨪
*
* ᠭ	  ᯨ᪠ 稭饣  mainList
*		 न⠬ (x, y)  頥 㪠⥫
*		   NULL.
*
* 頥	this	⥫    
*			NULL ᫨   
*
**/
ENTRY CELL *findCell (long x, long y)
{
   CELL *c;

   for (c = mainList;
        (c) && ((c->loc.x != x) || (c->loc.y != y));
        c = c->next);

   return c;

}/*findCell*/


/**
*
* 	addCell     --    묨 न⠬  ᯨ
*
* 饭	result = addCell(x,y,phead);
*
*		int result	1, ᫨   浪,
*			       -1, ᫨ 窠 㦥   ᯨ᪥,
*				0, ᫨  墠⨫ .
*		int x,y		न 窨.
*		CELL **phead	 ६, ᮤঠ饩
*				 砫 ᯨ᪠.
*
* ᠭ	室  ⠬ ᯨ᪠ ஢塞,  
*		窠   ᯨ᪥.
*		᫨   浪, 訢   
*		  ᯨ᪥     ⮬.
*
* 頥	result	1, ᫨   浪,
*		       -1, ᫨ 窠 㦥   ᯨ᪥,
*			0, ᫨  墠⨫ .
*
**/
ENTRY int  addCell (long x, long y, CELL **head)
{
   CELL *current;

   for (current = *head; current != NULL; current = current->next)
      if(current->loc.x == x && current->loc.y == y)
         return -1;       		/* 窠 㦥   ᯨ᪥.	*/

   if ((current = x_calloc (sizeof (CELL), 1)) == NULL)
      return 0;				/* ,  墠⠥ .	*/

   current->next = *head;		/* 塞   ᯨ᪠.	*/
   *head = current;
   current->loc.x = x;
   current->loc.y = y;

#ifdef XM_USED
   x_checkMem();
#endif

   return 1;				/* !!!	*/

}/*addCell*/

/**
*
*  listLen	-- 頥  ᯨ᪠, 稭饣  mainList
*
* 饭	len = listLen (void);
*
*		big len		頥 
*
* ᠭ	頥  ᯨ᪠ 稭饣  mainList,
*		.. - ⮢  .
*
* 頥	len	- ⮢  ᯨ᪥
*
**/
ENTRY big listLen (void)
{
   CELL *cur;
   big n;

   for (n=0,cur = mainList; cur; cur = cur->next, n++);
   return n;
}/*listLen*/

/**
*
*  makeVicinity	--  ⭮  窨 ࠤᮬ 2
*
* 饭	makeVicinity (center);
*
*		CELL *center	業 ⭮
*
* ᠭ	ᨢ vicinity  ।⠢塞 ⭮ ࠤ 2
*		(..  5x5)  業஬    "" ⮪.
*		 ᨢ vicinity ⠢ 1   , 
*		 室 ᪮, ।⠢塞 ᯨ᪮
*		mainList, ᮮ⢥ "" 窠.
*		ᯮ짮 ⭮ - .  㭪樨 makeStep.
*
* 頥	void	.. 祣.
*
**/
LOCAL void makeVicinity (CELL *center)
{
   CELL *current;
   int i, j;

   for (i = 0; i < 5; i++)              /* 㫨 ᨢ vicinity      */
      for (j = 0; j < 5; j++)
         vicinity [i] [j] = 0;

                      /*  ⥯ ⠢ 1 ⠬,   窨       */
   for (current = mainList; current != NULL; current = current->next) {
      if ((labs (center->loc.x - current->loc.x) <= 2) &&
             (labs (center->loc.y - current->loc.y) <= 2))
         vicinity [(int) (current->loc.x + 2 - center->loc.x)]
                  [(int) (current->loc.y + 2 - center->loc.y)] = 1;
   }
}/*makeVicinity*/

/**
*
*  makeStep	--  蠣   "" 
*
* 饭	makeStep ();
*
*		ࠬ஢ 
*
* ᠭ	८ࠧ   ᪮   
*		"" :
*			1. ᫨  ⮩ ⪨ 3  ᥤ (ᥤ
*		⪮ 뢠 ⠪ ⪠  ᠥ 
*		   㣫)  ⥪饬 ,   ⮩ ⪥
*		த    ᫥饬 .
*			2. ᫨   ⪨    ᥤ
*		  ,  ᫥饬    ७ᥫ.
*			3. ᫨  ,     ⢠.
*		   ﭨ ⪨  .
*
* 頥	void	.. 祣.
*
**/
ENTRY void makeStep (void)
{
   CELL *current, *newHead=NULL;
   int k,x,y;

   OutStatistics(ThinkingMsg);
   for (current = mainList; current != NULL; current = current->next) {
      makeVicinity (current);
      k = 0;
      for (x = 1; x < 4; x++)		/* ⠥ ⢮	*/
         for (y = 1; y < 4; y++)	/* ᥤ 窨, 室饩	*/
            if (vicinity [x] [y])	/*  業  vicinity.	*/
               k++;
      if (k != 3 && k != 4)		/* . ࠢ 2  3.		*/
         current->mode = DELETE;     	/* ⨬   㤠    */

      for (x = 1; x < 4; x++)           /* 室  窠 vicinity,	*/
         for (y = 1; y < 4; y++) {	/* ਫ騬   業.	*/
            if (vicinity [x] [y] == 0){    /* ᫨  窨, ஢ਬ, */
               if (checkCreation (x, y)){  /*  㦭  த.   	*/
                  if(addCell (current->loc.x - 2 + x,
                             current->loc.y - 2 + y, &newHead) == 0)
                     finMessage(" 墠⨫   । 窨");
              }
           }
	 }
                  			/* ⨬,  業ࠫ쭠	*/
                                        /* ᥣ , ⮬  	*/
                                        /*  ஢.		*/
   }

   clearLand();			/* ᨬ  ᯨ᪠ 㬥訥 窨.	*/

   if(newHead)			/* ᫨ த  窨,		*/
      glueList(newHead);	/* ४   ᭮ ᯨ᮪.	*/

   stepNo++;
   OutStatistics("");		/* ⮡   祭	*/
   				/*  蠣  - 祪.		*/
}/*makeStep*/

/**
*
*  clearLand	--  窨 祭  㤠
*
* 饭	clearLand();
*
* ᠭ	  ᯨ᪠ mainList  窨,  
*		 mode ࠢ DELETE,  ⮬, 㡨   ࠭.
*
* 頥	void	.. 祣.
*
**/
ENTRY void clearLand(void)
{
   CELL *current=mainList,**Next=&mainList;

   while (current != NULL) {
      if((current)->mode == DELETE) {
         *Next = current->next;
         hideCell(current);
         x_free(current);
         current = *Next;
      }
      else {
         Next = &(current->next);
         current = current->next;
      }
   }
}/*clearLand*/

/**
*
*  wipeLand --   窨
*
* 饭	wipeLand();
*
* ᠭ	ன  窠, ⨬     㤠.
*		᫥ ⮣ 맮 clearLand.
*
* 頥	void	.. 祣.
*
**/
ENTRY void wipeLand(void)
{
   CELL *current;

   for (current=mainList;current != NULL;current=current->next)
      current->mode = DELETE;
   clearLand();
}/*wipeLand*/

/**
*
* 	glueList --  ᭮ ᯨ᮪ 
*
* 饭	glueList(list);
*
*		CELL *list	塞 ᯨ᮪ ⮪.
*
* ᠭ	 ᫥   ᯨ᪠ ⮪,
*		楯塞   ᭮ ᯨ᮪
*		(  -  ६ mainList).
*		 ᪥ ந室 ()뢮 樨.
*
*	NB	 ᪥ ᫥  ᭮뢠  ⮬,
*		 ᯨ᮪ list .
*
* 頥	祣 - 㭪 ⨯ void.
*
**/
LOCAL void glueList(CELL *list)
{
   CELL *l;

   for(l = list;l->next;l=l->next)	/*   ᯨ᪠ list 	*/
      showCell(l);
   l->next = mainList;		/* ...楯   ᯨ᮪ mainList	*/
   showCell(l);			/*   ᫥  ⮦.	*/

   mainList = list;			/*   ᯨ᮪ ࠡ稬	*/

}/*glueList*/

/**
*
* 	checkCreation -- ஢ઠ 窨 ⭮
*
* 饭	create = checkCreation (x, y);
*
*		int create	1 - 㦭 ᮧ  ,
*				0 -  㦭.
*		int x, y	न 窥  ⭮.
*
* ᠭ	ᬠਢ ⭮ ࠤ 1  業஬  (x,y)
*		 ᭮ ⭮. ⠥ ⢮
*		㫥 祪  ᬠਢ ⭮.
*		᫨  ࠢ 3, 頥 1,  - 0.
*
* 頥	create	1 - 㦭 ᮧ  ,
*			0 -  㦭.
*
**/
LOCAL int checkCreation (int x, int y)
{
   int k, i, j;

   k = 0;
   for (i = 1; i < 4; i++)
      for (j = 1; j < 4; j++)
         if (vicinity [x - 2 + i] [y - 2 + j])
            k++;

   return (k == 3);

}/*checkCreation*/
