/* 	key.h

	Definitions of key's codes

	Copyright (C) 1991, E.S.E. Extraware, Inc.
	All Rights Reserved.
*/

#define		ESC		0x1b
#define		ENTER		0x0d
#define		CTRL_SPASE	0x20
#define		CTRL_BackSpace	0x7f

#define		F1		0x3b
#define		F2		0x3c
#define		F3		0x3d
#define		F4		0x3e
#define		F5		0x3f
#define		F6		0x40
#define		F7		0x41
#define		F8		0x42
#define		F9		0x43
#define		F10		0x44

#define		ALT_F1		0x68
#define		ALT_F2		0x69
#define		ALT_F3		0x6a
#define		ALT_F4		0x6b
#define		ALT_F5		0x6c
#define		ALT_F6		0x6d
#define		ALT_F7		0x6e
#define		ALT_F8		0x6f
#define		ALT_F9		0x70
#define		ALT_F10		0x71

#define		SHIFT_F1	0x54
#define		SHIFT_F2	0x55
#define		SHIFT_F3	0x56
#define		SHIFT_F4	0x57
#define		SHIFT_F5	0x58
#define		SHIFT_F6	0x59
#define		SHIFT_F7	0x5a
#define		SHIFT_F8	0x5b
#define		SHIFT_F9	0x5c
#define		SHIFT_F10	0x5d

#define		CTRL_F1		0x5e
#define		CTRL_F2		0x5f
#define		CTRL_F3		0x60
#define		CTRL_F4		0x61
#define		CTRL_F5		0x62
#define		CTRL_F6		0x63
#define		CTRL_F7		0x64
#define		CTRL_F8		0x65
#define		CTRL_F9		0x66
#define		CTRL_F10	0x67

#define		HOME		0x47
#define         LEFT            0x4b
#define         END             0x4f
#define         K_UP            0x48
#define         K_5             0x4c
#define         K_DOWN          0x50
#define         PgUp            0x49
#define         RIGHT           0x4d
#define         PgDn            0x51

#define		CTRL_HOME	0x77
#define         CTRL_LEFT       0x73
#define         CTRL_END        0x75
#define         CTRL_PgUp       0x84
#define         CTRL_RIGH       0x74
#define         CTRL_PgDn       0x76

#define		ALT_A		0x1d
#define		ALT_B           0x30
#define		ALT_C           0x2d
#define		ALT_D           0x20
#define		ALT_E           0x12
#define		ALT_F           0x21
#define		ALT_G           0x22
#define		ALT_H           0x23
#define		ALT_I           0x17
#define		ALT_J           0x24
#define		ALT_K           0x25
#define		ALT_L           0x26
#define		ALT_M           0x32
#define		ALT_N           0x31
#define		ALT_O           0x18
#define		ALT_P           0x19
#define		ALT_Q           0x10
#define		ALT_R           0x13
#define		ALT_S           0x1f
#define		ALT_T           0x14
#define		ALT_U           0x16
#define		ALT_V           0x2f
#define		ALT_W           0x11
#define		ALT_X           0x2d
#define		ALT_Y           0x15
#define		ALT_Z           0x2c

#define		CTRL_A          0x01
#define		CTRL_B          0x02
#define		CTRL_C          0x03
#define		CTRL_D          0x04
#define		CTRL_E          0x05
#define		CTRL_F          0x06
#define		CTRL_G          0x07
#define		CTRL_H          0x08
#define		CTRL_I          0x09
#define		CTRL_J          0x0a
#define		CTRL_K          0x0b
#define		CTRL_L          0x0c
#define		CTRL_M          0x0d
#define		CTRL_N          0x0e
#define		CTRL_O          0x0f
#define		CTRL_P          0x10
#define		CTRL_Q          0x11
#define		CTRL_R          0x12
#define		CTRL_S          0x13
#define		CTRL_T          0x14
#define		CTRL_U          0x15
#define		CTRL_V          0x16
#define		CTRL_W          0x17
#define		CTRL_X          0x18
#define		CTRL_Y          0x19
#define		CTRL_Z          0x1a

#define		ALT_1		0x78
#define		ALT_2           0x79
#define		ALT_3           0x7a
#define		ALT_4           0x7b
#define		ALT_5           0x7c
#define		ALT_6           0x7d
#define		ALT_7           0x7e
#define		ALT_8           0x7f
#define		ALT_9           0x80
#define		ALT_0           0x81
#define		ALT_MN          0x82
#define		ALT_EQ          0x83

#define		INS		0x52
#define		DEL		0x53
#define		TAB		0x09

#define		SHIFT_TAB	0x0f
#define		CTRL_PrtSc      0x72
#define		BackSpace       0x08
