#include <\fido\fido.h>
#include <ascii.h>

/* 
	Re-LogIn the same caller. This does a bunch of error checks,
	then sets the caller record number that just logged off into
	the AutoLog field to make Fido log this user back in and
	place them at the Main Section menu, with the last-known
	baud rate and time limit. 

	For: Fido/Fidonet version 12a
	Copyright T. Jennings 
	16 Aug 87

*/
int _stack = 10000;		/* room for (auto) struct fido below */

main(argc,argv)
int argc;
char **argv;
{
int i;
struct _fido fido;		/* FIDO.SYS structure */


	printf("Fido/FidoNet version 12, 1 Mar 90\r\n");
	printf("ReLogIn the caller just logged off\r\n");

	allmem();
	fastfile(1);

	i= open("FIDO.SYS",2);
	if (i == -1) {
		printf(" ! Can't find FIDO.SYS!\07\r\n");
		exit(1);
	}
	if (read(i,&fido,sizeof(struct _fido)) != sizeof(struct _fido)) {
		printf(" ! FIDO.SYS is the wrong version?\07\r\n");
		exit(1);
	}
	if (fido.fido_version != FIDOVER) {
		printf(" ! This program is the wrong version for FIDO.SYS (or vice versa)\r\n");
		exit(1);
	}
	if (fido.caller < 0) {
		printf(" ! There was no caller previously on to Re-Login!\r\n\07");
		exit(1);
	}
	fido.autolog= fido.caller;		/* log this one in again */
	lseek(i,0L,0);				/* back to the start, */
	write(i,&fido,sizeof(struct _fido));	/* nah, I wont check */
	close(i);

	exit(0);				/* glad thats over */
}
