#include "fido.h"
#include "fidomem.h"
#include <ascii.h>
#include "proto.h"

/*
	One time Fido initialization.

It is ASSUMED that all globals are inited to all zeros at program
load time!

*/

extern char _spr_sepchar;			/* in printf(), in SPR, in LIB.LIB */

extern FLAG reptflg;				/* reptflg in FIDOMAIN */

void fidoini(argc,argv)
int argc;
char **argv;
{
char *p,buff[SS],swbuff[SS];
int i,f,n;
unsigned t;
char **cp;

	printf(0,"Fido/FidoNet version %d%c             Copyright Tom Jennings 1991..1984\377",FIDOVER,FILEVER+96);
	printf(0,"Release date: 23 Sep 91              Fido Software, Box 77731, San Francisco,\377");
	printf(0,"%-36s CA 94107 USA. All rights reserved. \"Fido\",\377",driver_id);

/*	printf(0,"                                     \"FidoNet\", and the dog-with-diskette are\377");
	printf(0,"                                     registered trademarks of Tom Jennings.\377\377");
*/
	printf(0," BETA VERSION ONLY --                \"FidoNet\", and the dog-with-diskette are\377");
	printf(0," -- DO NOT DISTRIBUTE                registered trademarks of Tom Jennings.\377\377");

	allmem();				/* get all available */
	if (! fastfile(8)) {			/* init the buffered file system */
		clprintf(0,"! NOT ENOUGH MEMORY\377");
		exit(1);
	}
	memsize= sizmem();			/* how much there is, */
	mem= getmem(memsize);			/* get it all */
	t= 0;					/* tally of space needed */

/* Load the language files first, set the language tables so we can 
issue error messages! Note that the loaded tables contains a table of offsets,
from the start of the table to the text strings; we have to convert the
built-in tables to that format. (The compiler generates them as the usual
array of string pointers.) */

	texttbl[0]= (char *) fmtable;		/* link to fixed messages */
	texttbl[2]= (char *) lmtable;		/* link to log messages */
	f= open("FIDO.SLN",0);			/* default sysop file */
	if (f == -1) {
		cprintf(0,"! NO FILE: \"FIDO.SLN\"\377");
		exit(1);
	}

/* Load the language file and link it in. Check the CRC of the file. */

	read(f,mem,sizeof(struct _lang_hdr));		/* read the header, */
	if (((struct _lang_hdr *)mem)-> version != LANGVER) {/* check version */
		clprintf(0,"! WRONG VERSION FILE: \"FIDO.SLN\"\377");
		exit(1);
	}
	clrcrc();
	for (n= 0; n < sizeof(struct _lang_hdr); n++) 	/* CRC the header portion, */
		updcrc(mem[n]);

	n= read(f,mem,15000);				/* hell if I know */
	close(f);

	for (i= 0; i < n; i++) updcrc(mem[i]);		/* CRC the data, */
	if (chkcrc()) {
		cprintf(0,"! DAMAGED FILE: FIDO.SLN\377"); /* "bad language file" */
		exit(1);
	}
	texttbl[1]= mem;				/* link it in, */
	for (cp= (char **) mem; (int)(*cp) != -1; ++cp) { /* convert offsets */
		*cp += (unsigned) mem;			/* to pointers */
	}
	n -= 4;						/* skip -1 marker, CRC bytes */
	mem += n; t += n;				/* tally memory used */

/* OK, so now we have the sysop language linked in, we can load FIDO.SYS
and figure out what other things we need. */

	if (getsys() == -1) {			/* load system stuff */
		cprintf(SM+11);			/* "missing FIDO.SYS" */
		cprintf(SM+12);
		exit(1);
	}
	if ((fido.fido_version != FIDOVER) || (fido.file_version != FILEVER)) {
		cprintf(SM+13);
		cprintf(SM+14);			/* "wrong version" */
		cprintf(SM+15,fido.fido_version,fido.file_version + 96);
		cprintf(SM+16,FIDOVER,FILEVER+96);
		cprintf(SM+17);
		exit(1);
	}

	iodev= -1;				/* no serial port selected */
	mdmtype= -1;				/* no modem type set */

/* Set certain globals from the FIDO.SYS file, now, and only once. */

	ioport= fido.iodev;			/* default I/O port to use */
	_spr_sepchar= fido.sep_char;		/* printf() 1000's seperator */

	zmttype= fido.zmttype;			/* Zmodem transmit behaviour */
	zmrtype= fido.zmrtype;			/* Zmodem receive behaviour */
	zmblkst= fido.zmtstart;			/* Zmodem starting block size */
	zmblkmax= fido.zmblkmax;		/* Zmodem maximum blocksize */

	id.zone= fido.zone;			/* node ID */
	id.net= fido.net;
	id.number= fido.number;
	id.point= fido.point;

	altid.zone= fido.altzone;		/* alternate ID */
	altid.net= fido.altnet;
	altid.number= fido.altnumber;
	altid.point= fido.altpoint;

	cprintf(SM+18,fido.name);		/* impress the sysop */
	cprintf(SM+8,string(SM+0),string(SM+163)); /* "sysop language: " */

/* We now know the number of message areas; make the table of message
number counters. */

	n= fido.marea_max * (sizeof(int) / sizeof(char));
	n += sizeof(int);			/* room for msg tables */
	highmsg= (int *)mem; mem += n; t += n; /* highest msg */
	totlmsg= (int *)mem; mem += n; t += n; /* number of msgs */
	for (n= 0; n < fido.marea_max; n++) {
		highmsg[n]= 0;			/* clear it out */
		totlmsg[n]= 0;
	}

/* ZMODEM buffer. */

	zmbuff= mem; mem += zmblkmax; t += zmblkmax; /* ZMODEM buffer */

/* Now check that the memory we took was actually available! What's left over
is the "mem buffer". */

	if (t > memsize) {
		cprintf(SM+19);			/* "not enough memory" */
		exit(1);
	}
	memsize -= t;				/* memory buffers' actual size */

/* Now memory is set, system is loaded, it's almost like a normal 
program start. */

	if (!loadlang(0)) exit(1);		/* missing language file! */
	cprintf(SM+132,string(CM+0),string(CM+172)); /* say what we just loaded */

	msgarea.number= filearea.number= -1;	/* init for area loading */
	localout= 1;
	newdelim(" \t;,\n\r");			/* arg delimiter list, */
	while (--argc) {
		cpyarg(buff,*++argv);		/* filename? */
		strip_switch(swbuff,*argv);	/* the switches, */
		p= swbuff;
		while (*p) {
			switch (*p) {
				case '1': 
				case '2': 
				case '3': 
				case '4': 
				case '5': 
				case '6': 
				case '7': 
				case '8': 
				case '9': 
					n= atoi(p) - 1;
					if (n >= 0) ioport= n;
					cprintf(SM+20,ioport + 1); 
					break;

/* Note: /C works by setting doscode to the Control-C result, which causes
the main loop in fidomain() to not run, and causes an end_fidonet() which
closes up any packets. */

				case 'C': cprintf(SM+21); doscode= 1; break;

				case 'I': taskid= atoi(buff); 
					localout= test; 
					cprintf(SM+22,taskid); 
					break;
				case 'O': online_baud= atoi(buff);
					cprintf(SM+23,online_baud); break;

				case 'Q': fido.autolog= 0; 
					/* FALL THROUGH TO /T ... */
				case 'L': case 'T': test= localin= localout= 1; break;
				case 'V': if (atoi(buff)) cd_bit= atoi(buff); 
					cprintf(SM+24,cd_bit); break;
				case '?': printf(SM+25,textsize); reptflg= 1; break;
				default: printf(SM+26,*p); break;
			}
			++p;
		}
	}
}
