/*--------------------------------------------------------------------------*/
/*               The Opus Computer-Based Conversation System                */
/*       (c) Copyright 1986, Wynn Wagner III, All Rights Reserved           */
/* This source code is proprietary and confidential.  Not for distribution. */
/*--------------------------------------------------------------------------*/

#define  FILE_SECTION
#define  WAZOO_SECTION
#include "opus.h"

/*--------------------------------------------------------------------------*/
/* Status and error words                                                   */
/*--------------------------------------------------------------------------*/
extern char  *EOT_msg;
extern char  *ACK_msg;
extern char  *NAK_msg;
extern char  *SOH_msg;
extern char  *CAN_msg;
extern char  *SYN_msg;
extern char  *DISK_msg;
extern char  *CRC_msg;
extern char  *CHK_msg;
extern char  *DUPE_msg;
extern char  *FUTURE_msg;
extern char  *C_msg;
extern char  *SHRT_msg;
extern char  *TIME_msg;
extern char  *SYN_msg;
extern char  *INIT_msg;
extern char  *FUBAR_msg;
extern char  *CARRIER_msg;
extern char  *NOTHING_msg;
extern char  *KBD_msg;
extern char  *IDUNNO_msg;
extern char  *CMPL_msg;
extern char  *SYNC_msg;
extern char  *OPEN_msg;
extern char  *WRITE_msg;

#ifdef BINKLEY
extern char  *IO_msg;
extern char  *CLOSE_msg;
extern char  *CREATE_msg;
extern char  *READ_msg;
extern char  *WRITE_msg;
extern char  *SEEK_msg;
extern char  *MEMOVFL_msg;

#define xfer_id "BinkleyTerm 1.00"
#define read_binary "rb"
#define write_binary "wb"

#define stcgfn strcpy
#define wherex() fossil_wherex()
#define wherey() fossil_wherey()
#define gotoxy(x,y) fossil_gotoxy(x,y)
#define crc_finish(x) x
#define CLEAR_IOERR() errno = 0
#define wait_for_clear() while (!OUT_EMPTY()) 
#define TIMED_READ(a) com_getc(a)
extern int locate_x, locate_y;
extern int cur_baud, errno;
extern char e_input[];
void pascal throughput();

struct FILEINFO {
	char rsvd[21];
	char attr;
	long time;
	long size;
	char name[13];
	char nill;
	};

#endif	/* BINKLEY */


/*--------------------------------------------------------------------------*/
/* Signals                                                                  */
/*--------------------------------------------------------------------------*/
extern char  *CAN_xfer;                   /* lots of CANs then BSs          */


/*--------------------------------------------------------------------------*/
/* Sealink and Telink header structure                                      */
/*--------------------------------------------------------------------------*/
#define HEADER_NAMESIZE  17
struct zero_block
   begin
      long size;                          /* file length                    */
      long time;                          /* file date/time stamp           */
      char name[HEADER_NAMESIZE];         /* original file name             */
      char moi[15];                       /* sending program name           */
   end;


/*--------------------------------------------------------------------------*/
/* Ascii character mnemonics                                                */
/*--------------------------------------------------------------------------*/
#define NUL 0x00
#define SOH 0x01
#define STX 0x02
#define ETX 0x03
#define EOT 0x04
#define ENQ 0x05
#define ACK 0x06
#define BEL 0x07
#define BS  0x08
#define HT  0x09
#define LV  0x0a
#define VT  0x0b
#define FF  0x0c
#define CR  0x0d
#define SO  0x0e
#define SI  0x0f
#define DLE 0x10
#define DC1 0x11
#define DC2 0x12
#define DC3 0x13
#define DC4 0x14
#define NAK 0x15
#define SYN 0x16
#define ETB 0x17
#define CAN 0x18
#define EM  0x19
#define SUB 0x1a
#define ESC 0x1b
#define FS  0x1c
#define GS  0x1d
#define RS  0x1e
#define US  0x1f

/*--------------------------------------------------------------------------*/
/* Parameters for calling ZMODEM routines                                   */
/*--------------------------------------------------------------------------*/
#define TRUE  1
#define FALSE 0
#define END_BATCH (-1)
#define DELETE_AFTER  '-'
#define TRUNC_AFTER   '#'
#define NOTHING_AFTER '@'
#define TRUNC_AFTER   '#'
#define NOTHING_AFTER '@'
#define DO_WAZOO   TRUE
#define D
