/*--------------------------------------------------------------------------*/
/*               The Opus Computer-Based Conversation System                */
/*       (c) Copyright 1986, Wynn Wagner III, All Rights Reserved           */
/*                                                                          */
/*                                                                          */
/*                   YOOHOO is a trademark of Wynn Wagner III               */
/*                                                                          */
/*                        YOOHOO-YOOHOO/2U2 & WaZOO are                     */
/*           Copyright 1987, Wynn Wagner III, All Rights Reserved           */
/*                                                                          */
/*--------------------------------------------------------------------------*/



/*--------------------------------------------------------------------------*/
/* LEGIBLE SECTION.  Definitions to make "C" look like a real language.     */
/*--------------------------------------------------------------------------*/
#define begin        {
#define end          }

#define true         (-1)
#define false        0
#define Procedure    void

#define shl          <<
#define shr          >>
#define xor          ^
#define and          &&
#define or           ||
#define not          !
#define mod          %

#ifndef max
#define max(a,b)     ((a)>(b)?(a):(b))
#endif

#ifndef min
#define min(a,b)     ((a)<=(b)?(a):(b))
#endif

typedef unsigned      bit;
typedef unsigned int  word;
typedef unsigned char byte;



/*--------------------------------------------------------------------------*/
/* TIME STAMP                                                               */
/*--------------------------------------------------------------------------*/
struct _stamp
   begin
   	unsigned int   date;
      unsigned int   time;
   end;




/*--------------------------------------------------------------------------*/
/* NodeList.Sys                                                             */
/*                                                                          */
/*    NET > 0 and NODE > 0    Normal node                                   */
/*                                                                          */
/*    NET > 0 and NODE <= 0   Host node                                     */
/*                               Net host........node== 0                   */
/*                               Regional host...node==-1                   */
/*                               Country host....node==-2                   */
/*                                                                          */
/*    NET == -1      Nodelist.Sys revision                                  */
/*                                                                          */
/*    NET == -2      Nodelist statement                                     */
/*                                                                          */
/*--------------------------------------------------------------------------*/


/*--------------------------------------------------------------------------*/
/* NODE                                                                     */
/* Please note the NewStyle structure (below).  Time is running out for the */
/* existing `_node' structure!                                              */
/*--------------------------------------------------------------------------*/
struct _node
   begin
      int   number;        /* node number                                   */
      int   net;           /* net number                                    */
      int   cost;          /* cost of a message to this node                */
      int   rate;          /* baud rate                                     */
      char  name[20];      /* node name                                     */
      char  phone[40];     /* phone number                                  */
      char  city[40];      /* city and state                                */
   end;


/*--------------------------------------------------------------------------*/
/* THE NEWSTYLE NODE LIST IS *NOT* USED RIGHT NOW                           */
/*--------------------------------------------------------------------------*/
#ifdef NEWSTYLE
  struct _node {
    int  number;           /* node number, */
    int  net;	            /* net number */
    int  cost;	            /* cost per minute to call */
    int  rate;	            /* baud rate */
    char name[35];         /* node name */
    char phone[40];        /* phone number */
    char city[30];         /* city and state, */

    char reserved[7];	   /* reserved for future use by IBM */
    int  realcost;	      /* phone company's charge */
    int  hubnode;          /* node # of this node's hub or 0 if none */
    int  modem; 	         /* modem type code ... I'll let the hardware
			                     guys come up with coding */
    unsigned int flags1;   /* set of flags (see below) */
   };


/*------------------------------------------------------------------------*/
/* Values for the `flags1' field                                          */
/*------------------------------------------------------------------------*/
#define B_hub      0x0001  /* node is a net hub       0000 0000 0000 0001 */
#define B_host     0x0002  /* node is a net host      0000 0000 0000 0010 */
#define B_region   0x0004  /* node is region coord    0000 0000 0000 0100 */
#define B_hold     0x0008  /* node is on hold         0000 0000 0000 1000 */
#define B_unlisted 0x0010  /* node is down            0000 0000 0001 0000 */
#define B_down     0x0020  /* number is unlisted      0000 0000 0010 0000 */
#define B_CM       0x0040  /* runs continuous mail    0000 0000 0100 0000 */
#define B_NA       0x0080  /* runs No.American NMH    0000 0000 1000 0000 */
#define B_Europe   0x0100  /* runs European NMH       0000 0001 0000 0000 */
#define B_Pacific  0x0200  /* runs Pacific NMH        0000 0010 0000 0000 */
#define B_res1     0x0400  /* reserved by Opus        0000 0100 0000 0000 */
#define B_res2     0x0800  /* reserved by Opus        0000 1000 0000 0000 */
#define B_res3     0x1000  /* reserved by Opus        0001 0000 0000 0000 */
#define B_res4     0x2000  /* reserved by Opus        0010 0000 0000 0000 */
#define B_res5     0x4000  /* reserved by Opus        0100 0000 0000 0000 */
#define B_res6     0x8000  /* reserved by Opus        1000 0000 0000 0000 */


#endif






/*--------------------------------------------------------------------------*/
/* Nodelist.Idx                                                             */
/* (File is terminated by EOF)                                              */
/*--------------------------------------------------------------------------*/
struct _ndi
   begin
      int   node;          /* node number  */
      int   net;           /* net number   */
   end;






#define MAXEXPAND 30          /* max download files (wildcard expansion)    */
#define CMDLEN    60          /* size of the command typeahead buffer       */
#define CARRYLEN  20          /* editor's carry buffer                      */
#define MAXLEN    85          /* size of primary line-input buffer          */



/*--------------------------------------------------------------------------*/
/* OPUS CONTROL FILE AND PARM FILE DECLARATIONS                             */
/*--------------------------------------------------------------------------*/

#define  THIS_CTL_VERSION  12       /* ASSEMBLER VERSION NUMBER             */


#ifdef   COMPILER
#           define CTLSIZE 0x7fff   /* Only used when compiling OPUS_CTL    */
#           define OFS     int
#else
#           define CTLSIZE 1
#           define OFS     char*
#endif


#define  MAX_EXTERN         8       /* max. number of external programs     */
#define  MAXCLASS          12       /* number of possible priv levels       */


               /*-----------------------------------------------------------*/
               /* Information about a class of users.  Warning: This is NOT */
               /* a stable structure.                                       */
               /*-----------------------------------------------------------*/
struct   class_rec
            {
               int          priv;
               int          max_time;      /* max cume time per day         */
               int          max_call;      /* max time for one call         */
               int          max_dl;        /* max dl bytes per day          */
               unsigned int ratio;         /* ul:dl ratio                   */
               unsigned int min_baud;      /* speed needed for logon        */
               unsigned int min_file_baud; /* speed needed for file xfer    */
            };




               /*-----------------------------------------------------------*/
               /* The structure of a PRM file created                       */
               /*                                                           */
               /* This is *NOT* a stable structure, check the assembler's   */
               /* version number.  If the version (above) doesn't match the */
               /* number in the file you are reading, you are GUARANTEED    */
               /* that the structure has changed because that's what the    */
               /* version means.  The location of the version number at     */
               /* offset zero is assured for all future versions.           */
               /*                                                           */
               /*-----------------------------------------------------------*/
struct pointers {

               /*-----------------------------------------------------------*/
               /* DATA                                                      */
               /*-----------------------------------------------------------*/
         byte  version;        /* for safety                                */
         byte  testmode;       /* input from keyboard, not modem            */
         long  total_callers;  /* total number of callers to system         */
         long  quote_position; /* last position used in last quote file     */
         byte  multitasker;    /* flag for DoubleDos (see below)            */
         byte  snooping;       /* Local monitor active                      */
         byte  edit_exit;      /* 1= use new user questionaire              */
         byte  verbose;        /* wordy sysop log                           */
         byte  terse;          /* brief sysop log                           */
         byte  trace;          /* log trace mode                            */
         byte  show_areapath;  /* use path not Dir.Bbs                      */
         byte  task_num;       /* for multi-tasking systems                 */
         byte  exit_val;       /* ERRORLEVEL to use after caller            */
         byte  val_outside;    /* ERRORLEVEL for O)utside                   */
         byte  val_zero;       /* ERRORLEVEL for sysop 0 command            */
         byte  no_crashmail;   /* 1 = don't accept crashmail                */
         byte  auto_kill;      /* RECD PVT msgs. 0=no 1=ask 2=yes           */
         byte  crashexit;      /* non-zero= ErrorLevel exit                 */
         byte  unpack_arc;     /* 1=unpack incomming arcmail                */
         byte  toss_echo;      /* 1=toss incomming echomail                 */
         byte  arc_exit;       /* ErrorLevel for after incomming ARCmail    */
         byte  use_dtr;        /* 1 drop dtr to look busy, 0 go off hook    */
         int   carrier_mask;
         int   handshake_mask;
         int   ctla_priv;      /* Priv to see CONTROL-A lines in messages   */
         int   max_baud;       /* fastest speed we can use                  */
         int   min_baud;       /* minimum baud to get on-line               */
         int   speed_graphics; /* min baud for graphics                     */
         int   com_port;       /* Com1=0, Com2=1                            */
         int   logon_priv;     /* Access level for new users                */
         int   date_style;     /* Used for FILES.BBS display                */
         int   seenby_priv;    /* Min priv to see SEEN_BY line              */

         int   msg_ask[16];    /* Array of privs. for message attr ask's    */
         int   msg_assume[16]; /* Array of privs. for message attr assume's */
         int   msg_fromfile;   /* Priv. for doing message from file         */

         byte  watchdog;       /* 1=Set Fossil to reboot during outside     */
         byte  video;          /* 0=Dos, 1=Fossil 2=IBM                     */

         byte  filler[11];

         byte  bfill;
         byte  Flags;          /* See "FLAGS" below                         */

         word  our_zone;
         word  matrix_mask;
         
         struct class_rec class[MAXCLASS];
         struct _ndi alias[15];


               /*-----------------------------------------------------------*/
               /* OFFSETS                                                   */
               /*-----------------------------------------------------------*/
         OFS   m_init;         /* modem initialization string               */
         OFS   predial;        /* modem dial command sent before number     */
         OFS   postdial;       /* modem command sent after dialed number    */
         OFS   timeformat;
         OFS   dateformat;
         OFS   fkey_path;      /* path to `F-key files'                     */
         OFS   parm_outside;   /* prog/parms for O)utside                   */
         OFS   parm_zero;      /* parm for sysop 0 command                  */
         OFS   sys_path;       /* path to SYSTEM?.BBS files                 */
         OFS   user_file;      /* path/filename of User.Bbs                 */
         OFS   net_info;       /* path to NODELIST files                    */
         OFS   sched_name;     /* name of file with _sched array            */
         OFS   logo;           /* first file shown to a caller              */
         OFS   welcome;        /* shown after logon                         */
         OFS   bulletin;       /* shown after the welcome file              */
         OFS   editorial;
         OFS   quote;
         OFS   question;       /* Questionnaire available on the main menu  */
         OFS   request_list;   /* list of files approved for file requests  */
         OFS   newuser1;
         OFS   newuser2;
         OFS   rookie;
         OFS   application;    /* new user questionnaire                    */
         OFS   avail_list;     /* file to send when FILES is file requested */
         OFS   hlp_editor;     /* Intro to msg editor for novices.          */
         OFS   hlp_replace;    /* Explain the Msg.Editor E)dit command      */
         OFS   msg_inquire;    /* Explain the Msg. I)nquire command         */
         OFS   hlp_locate;     /* Explain the Files L)ocate command         */
         OFS   hlp_contents;   /* Explain the Files C)ontents command       */
         OFS   out_leaving;    /* Bon Voyage                                */
         OFS   out_return;     /* Welcome back from O)utside                */
         OFS   daylimit;       /* Sorry, you've been on too long...         */
         OFS   timewarn;       /* warning about forced hangup               */
         OFS   sysop;          /* sysop's name                              */
         OFS   tooslow;        /* explains minimum logon baud rate          */
         OFS   xferbaud;       /* explains minimum file transfer baud rate  */
         OFS   msgarea_list;   /* dump file... used instead of Dir.Bbs      */
         OFS   file_area_list; /* dump file... used instead of Dir.Bbs      */
         OFS   maillist_file;  /* default "nodelist" file                   */
         OFS   byebye;         /* file displayed at logoff                  */
         OFS   protocols[MAX_EXTERN]; /* external file protocol programs    */
         OFS   local_editor;
         OFS   file_mgt;       /* external file section management          */
         OFS   hold_area;      /* path to pending outbound matrix traffic   */
         OFS   barricade;
         OFS   badaccess;
         OFS   msg_mgt;        /* external message section maintenance      */

         OFS   mailpath;       /* path to inbound bundles                   */
         OFS   filepath;       /* path for inbound matrix files             */
         OFS   oped_help;      /* help file for the full-screen editor      */
         OFS   temppath;       /* place to put temporary files              */
         OFS   ofs_3;
         OFS   ofs_4;
         OFS   ofs_5;

               /*-----------------------------------------------------------*/
               /* Log_Name must always be the last offset in this struct    */
               /* because Bbs_Init uses that symbol to flag the end of      */
               /* the offsets.                                              */
               /*-----------------------------------------------------------*/
         OFS   log_name;       /* name of the log file                      */


               /*-----------------------------------------------------------*/
               /* Big blob of stuff                                         */
               /* It's a sequence of null-terminated character arrays...    */
               /* pointed-to by the offsets (above).                        */
               /*-----------------------------------------------------------*/
         char  buf[CTLSIZE];
   };


/*--------------------------------------------------------------------------*/
/* Multitaskers (possible values for `ctl.multitasker'                      */
/*              NOTE: 0 means no multitasker in use                         */
/*--------------------------------------------------------------------------*/
#define DoubleDOS 1
#define DesqView  2
#define TopView   3
#define TaskView  4
#define MsWindows 5


/*--------------------------------------------------------------------------*/
/* Matrix mask                                                              */
/* Undefined bits are reserved by Opus                                      */
/*--------------------------------------------------------------------------*/
#define NO_TRAFFIC 0x0001  /* ok to send outbound local 0000 0000 0000 0001 */
#define LOCAL_ONLY 0x0002  /* ok to send outbound local 0000 0000 0000 0010 */
#define OPUS_ONLY  0x0004  /* only send to #CM systems  0000 0000 0000 0100 */

#define NO_EXITS   0x2000  /* crash/arc exits ignored   0010 0000 0000 0000 */
#define MAIL_ONLY  0x4000  /* no human callers allowed  0100 0000 0000 0000 */
#define TAKE_REQ   0x8000  /* file requests are ok      1000 0000 0000 0000 */

/*--------------------------------------------------------------------------*/
/* Flags                                                                    */
/*--------------------------------------------------------------------------*/
#define LOGECHO    0x0001  /* log echomail areas        0000 0000 0000 0001 */
#define STEADY     0x0002  /* never change baud rate    0000 0000 0000 0010 */














   
/*--------------------------------------------------------------------------*/
/* The rest of this file contains structure definitions similar to those    */
/* used by Fido<tm> version 11w.  No claim is made that Opus will maintain  */
/* compatibility with these structures beyond Opus version 0.               */
/*                                                                          */
/* The original version of the following items can be found in STRUCT.H, an */
/* include file writte (and probably copyrighted by) Tom Jennings.          */
/*--------------------------------------------------------------------------*/





/*--------------------------------------------------------------------------*/
/* THE USER FILE                                                            */
/* Please note that the user structure will be changed in the near future.  */
/*--------------------------------------------------------------------------*/
   
#define  MAXLREAD  0x0a    /* Number of msg area pointers to maintain       */

struct   _usr
   begin
      char name[36];       /* Caller's first and last names                 */
      char city[36];       /* Caller's location                             */

      struct {             /* Last message read for the prior 10 areas      */
        word area;
        word msg;
      } lastmsg[MAXLREAD];

      char pwd[16];        /* Password                                      */
      word times;          /* Number of previous calls to this system       */
      int  help;           /* Help level (see below)                        */
      word tabs;           /* 0=transmit <sp> instead of <tab>              */
      word nulls;          /* Number of Nulls (delays) after <cr>           */
      word msg;            /* Last message area visited                     */
      bit  filler   : 3;
      bit  use_lore : 1;   /* Use the line-oriented editor */
      bit  more     : 1;   /* Wants the "MORE?" prompt                      */
      bit  ansi     : 1;   /* OPUS: set=wants Ansi                          */
      bit  kludge   : 1;   /* OPUS: set=used Opus before                    */
      bit  formfeed : 1;   /* OPUS: set=transmit <ff>, clear=ignore <ff>    */
      int  priv;           /* Access level (see below)                      */
      char ldate[20];      /* Date of previous date (AsciiZ string)         */
      int  time;           /* Time on-line so-far today                     */
      word flag;           /* Used to hold baud rate on O)utside command    */
      int  upld;           /* K-bytes uploaded, all calls                   */
      int  dnld;           /* K-bytes downloaded, all calls                 */
      int  dnldl;          /* K-bytes downloaded, today                     */
      word files;          /* Last file area visited                        */
      byte width;          /* Width of the caller's monitor                 */
      byte len;            /* Height of the caller's */
      int  credit;
      int  debit;
   end;



/*--------------------------------------------------------------------------*/
/* Access levels                                                            */
/* For information on how these are used in Opus, read the TechRef pamphlet */
/* called REF_PRIV.DOC and the sample control file called OPUS.CTL          */
/*--------------------------------------------------------------------------*/
#define  TWIT        0xFFFE
#define  DISGRACE    0x0000
#define  NORMAL      0x0002
#define  PRIVEL      0x0004
#define  EXTRA       0x0006
#define  ASSTSYSOP   0x0008
#define  SYSOP       0x000A
#define  HIDDEN      0x000B




/*--------------------------------------------------------------------------*/
/* User help levels                                                         */
/*--------------------------------------------------------------------------*/
#define  EXPERT      0x02  /* grizzled veteran, no menus at all             */
#define  REGULAR     0x04  /* experienced user, brief menus                 */
#define  NOVICE      0x06  /* Full menus plus additional hand-holding       */










/*--------------------------------------------------------------------------*/
/*                                                                          */
/* MESSAGE AND FILE AREAS                                                   */
/*                                                                          */
/*--------------------------------------------------------------------------*/


/*--------------------------------------------------------------------------*/
/* System?.Bbs structure                                                    */
/* Please note that the `_sys' structure should NOT be considered stable.   */
/*--------------------------------------------------------------------------*/
struct _sys {
    word ls_caller;        /* Used in SYSTEM.BBS only: number of callers    */
    int  priv;             /* Minimum privs required to get to the area     */
    byte msgpath[40];      /* Path to messages                              */
    byte bbspath[40];      /* Path to BBS/GBS files *or* the barricade file */
    byte hlppath[40];      /* Path to the user-help system                  */
    byte uppath[40];       /* Path to the file upload sub-directory         */
    byte filepath[40];     /* Path to the file download sub-directory       */
    word attrib;           /* Area attribute (see below)                    */
    word ms_caller;        /* Unused by Opus v0.0                           */
    long quote_pos;        /* Position of next usable byte in Quote file    */
};

/*--------------------------------------------------------------------------*/
/* Area attributes (limit or describe the behavior of an area)              */
/*--------------------------------------------------------------------------*/
#define  SYSMAIL   0x01    /* is a mail area                                */
#define  SYSOVR    0x02    /* overwriting files OK                          */
#define  NOPUBLIC  0x04    /* OPUS: Disallow public messages                */
#define  NOPRIVATE 0x08    /* OPUS: Disallow private messages               */
#define  ANON_OK   0x10    /* OPUS: Enable anonymous messages               */
#define  ECHOMAIL  0x20    /* OPUS: Set=Echomail Clear=Not Echomail         */







/*--------------------------------------------------------------------------*/
/* THE MENU SYSTEM                                                          */
/* A "priv" file is a sequence of these structures.  Note that the "priv"   */
/* file system is fairly high on Wynn's DOOMED LIST.                        */
/*--------------------------------------------------------------------------*/

struct _cmd
   begin
      char  name[20];
      int   priv;
   end;






/*--------------------------------------------------------------------------*/
/*                                                                          */
/* MESSAGES                                                                 */
/*                                                                          */
/*--------------------------------------------------------------------------*/

/*--------------------------------------------------------------------------*/
/* Message header                                                           */
/*--------------------------------------------------------------------------*/
struct _msg
   begin
      byte from[36];
      byte to[36];
      byte subj[72];
      byte date[20];       /* Obsolete/unused ASCII date information        */
      word times;          /* FIDO<tm>: Number of times read                */
      word dest;           /* Destination node                              */
      word orig;           /* Origination node number                       */
      word cost;           /* Unit cost charged to send the message         */

      word orig_net;       /* Origination network number                    */
      word dest_net;       /* Destination network number                    */
                           
                           /* A TIMESTAMP is a 32-bit integer in the Unix   */
                           /* flavor (ie. the number of seconds since       */
                           /* January 1, 1970).  Timestamps in messages are */
                           /* always Greenwich Mean Time, never local time. */

      struct _stamp date_written;   /* When user wrote the msg              */
      struct _stamp date_arrived;   /* When msg arrived on-line             */

      word reply;          /* Current msg is a reply to this msg number     */
      word attr;           /* Attribute (behavior) of the message           */
      word up;             /* Next message in the thread                    */
   end;



/*--------------------------------------------------------------------------*/
/* Message attributes                                                       */
/*--------------------------------------------------------------------------*/
#define MSGPRIVATE 0x0001  /* private message         * 0000 0000 0000 0001 */
#define MSGCRASH   0x0002  /* crashmail               * 0000 0000 0000 0010 */
#define MSGREAD    0x0004  /* read by addressee       * 0000 0000 0000 0100 */
#define MSGSENT    0x0008  /* sent OK (remote)          0000 0000 0000 1000 */
#define MSGFILE    0x0010  /* file attached to msg    * 0000 0000 0001 0000 */
#define MSGFWD     0x0020  /* in transit                0000 0000 0010 0000 */
#define MSGORPHAN  0x0040  /* unknown dest node         0000 0000 0100 0000 */
#define MSGKILL    0x0080  /* kill after mailing      * 0000 0000 1000 0000 */
#define MSGLOCAL   0x0100  /* FidoNet vs. local         0000 0001 0000 0000 */
#define MSGHOLD    0x0200  /* Hold, don't send        * 0000 0010 0000 0000 */
#define MSGXX2     0x0400  /* <reserved>              ? 0000 0100 0000 0000 */
#define MSGFRQ     0x0800  /* file request            * 0000 1000 0000 0000 */
#define MSGRRQ     0x1000  /* receipt requested       * 0001 0000 0000 0000 */
#define MSGCPT     0x2000  /* is a return receipt     * 0010 0000 0000 0000 */
#define MSGARQ     0x4000  /* audit trail requested   * 0100 0000 0000 0000 */
#define MSGURQ     0x8000  /* update request          * 1000 0000 0000 0000 */
                                                   /*-----------------------*/
                                                   /* ^                     */
                                                   /* |                     */
                                                   /*  * = preserved by     */
                                                   /*      the network      */
                                                   /*  ? = stripped by the  */
                                                   /*      net (FTSC spec)  */
                                                   /*      but preserved    */
                                                   /*      by seadog<tm>    */
                                                   /*-----------------------*/




/*--------------------------------------------------------------------------*/
/*                                                                          */
/* EVENTS                                                                   */
/*                                                                          */
/*--------------------------------------------------------------------------*/
#define EXT_EVENT   'X'    /* External event (return to Dos)                */
#define YELL_EVENT  'Y'    /* Yell event (when Yell is on)                  */
#define SCHEDS      35     /* Maximum number of events                      */

struct _time
   begin
      word  year;          /* Usable but doesn't make much sense            */
      word  month;         /* For events only in 1 month                    */
      word  day;           /* Day of the month                              */
      word  daywk;         /* Day of the week (0=Sun,6=Sat,7=ALL)           */
      word  hour;          /* 0..23                                         */
      word  mins;          /* 0..59                                         */
      word  sec;           /* Unused                                        */
   end;


/*--------------------------------------------------------------------------*/
/* Schedule file record                                                     */
/*--------------------------------------------------------------------------*/
struct _sched
   begin
      struct _time time;   /* Starting time of the event                    */
      word  len;           /* Duration of event in minutes                  */
      int   enable;        /* 1==Enabled                                    */
      word  trigger;       /* Unknown/unused                                */
      word  result;        /* X errorlevel; OPUS: Yell bell duration        */
      byte  tag;           /* Event type ('A'..'Z')                         */
      byte  junk_1;        /* OPUS: ADDED TO MAKE THIS WORD-ALIGNED         */
      word  last_ran;      /* OPUS: Day of the month executed last          */
      word  b;             /* OPUS: Reserved                                */   
      word  c;             /* OPUS: Reserved                                */
      word  behavior;      /* (See below)                                   */
      byte  event_mask;    /* OPUS: Force this event                        */
      byte  GMT;           /* OPUS: Set=GMT, Clear=local time               */
   end;

/* MASKS */
#define  FORCE_EVENT 0x0001 /* Execute this always */

/* Z EVENTS BEHAVIOR...                                                     */
/*    If RESULT==1, the `behavior' field contains a "matrix mask".  Those   */
/*                  are described in #define's near the CTL declaration.    */
/*    If RESULT==2, it is an internal housekeeping event                    */

/* HOUSEKEEPING  */
#define CLEAN_HOLD 0x0001  /* del HoldArea "$" files    0000 0000 0000 0001 */








/*--------------------------------------------------------------------------*/
/* Message bundle header                                                    */
/*--------------------------------------------------------------------------*/
#define PKTVER       2

#define isFIDO       0        /* Fido<tm>'s product code                    */
#define isSPARK      1        /* FastScan, Rover, etc                       */
#define isSEA        2        /* Seadog<tm>'s product code                  */
#define isOPUS       5        /* Opus<no_tm>'s product code (a PRIME number)*/
#define isHENK       6        /* Dutchie product code                       */


struct _pkthdr
   begin
      int   orig_node;        /* originating node               */
      int   dest_node;        /* destination node               */
      int   year;             /* 0..99  when packet was created */
      int   month;            /* 1..12  when packet was created */
      int   day;              /* 1..31  when packet was created */
      int   hour;             /* 0..23  when packet was created */
      int   minute;           /* 0..59  when packet was created */
      int   second;           /* 0..59  when packet was created */
      int   rate;             /* destination's baud rate        */
      int   ver;              /* packet version                 */
      int   orig_net;         /* originating network number     */
      int   dest_net;         /* destination network number     */
      char  product;          /* product type                   */
      char  rev_level;        /* bundle revision level          */
      char  pickup[8];        /* pickup password                */
      char  junk[20];
      long  something_else;   /* Thom's secret data area        */
                              /*  int   extra[16]; */
   end;

   /* NOTE: Seadog<tm> seems to be using `pktjunk' for something. */




#ifdef WAZOO_SECTION

#ifndef ACK
#define ACK    0x06
#endif

#ifndef NAK
#define NAK    0x15
#endif

#ifndef ENQ
#define ENQ    0x05
#endif

#ifndef YOOHOO
#define YOOHOO 0xb0
#endif

#ifndef  TSYNC    
#define  TSYNC 0x00ae
#endif

struct   _Hello
   begin
      word     signal;           /* always 'o'     (0x6f)                   */
      word     hello_version;    /* currently 1    (0x01)                   */
      word     product;          /* product code                            */
      word     product_maj;      /* major revision of the product           */
      word     product_min;      /* minor revision of the product           */
      char     my_name[60];      /* Other end's name                        */
      char     reserved1[20];
      word     my_zone;          /* 0== not supported                       */
      word     my_net;           /* out primary net number                  */
      word     my_node;          /* our primary node number                 */
      word     my_point;         /* 0== not supported                       */
      word     my_password[8];   /* currently unused                        */
      word     capabilities;     /* see below */
      word     reserved2[20];
   end; /* size 128 bytes */


/*--------------------------------------------------------------------------*/
/* YOOHOO<tm> CAPABILITY VALUES                                             */
/*--------------------------------------------------------------------------*/
#define Y_DIETIFNA 0x0001  /* Can do LoTek            0000 0000 0000 0001 */
#define Bit_1      0x0002  /* reserved by Opus        0000 0000 0000 0010 */
#define Bit_2      0x0004  /* reserved by Opus        0000 0000 0000 0100 */
#define ZED_ZAPPER 0x0008  /* Can do ZModem/plain     0000 0000 0000 1000 */
#define Bit_4      0x0010  /* reserved by Opus        0000 0000 0001 0000 */
#define Bit_5      0x0020  /* reserved by Opus        0000 0000 0010 0000 */
#define Bit_6      0x0040  /* reserved by Opus        0000 0000 0100 0000 */
#define Bit_7      0x0080  /* reserved by Opus        0000 0000 1000 0000 */
#define Bit_8      0x0100  /* reserved by Opus        0000 0001 0000 0000 */
#define Bit_9      0x0200  /* reserved by Opus        0000 0010 0000 0000 */
#define Bit_a      0x0400  /* reserved by Opus        0000 0100 0000 0000 */
#define Bit_b      0x0800  /* reserved by Opus        0000 1000 0000 0000 */
#define Bit_c      0x1000  /* reserved by Opus        0001 0000 0000 0000 */
#define Bit_d      0x2000  /* reserved by Opus        0010 0000 0000 0000 */
#define Bit_e      0x4000  /* reserved by Opus        0100 0000 0000 0000 */
#define WZ_FREQ    0x8000  /* accepts file requests   1000 0000 0000 0000 */

#endif /* WaZOO_Section */

/* END OF FILE: opus.h */


