/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class ZipOutputStream
extends DeflaterOutputStream
implements ZipConstants {
    private ZipEntry entry;
    private Vector entries = new Vector();
    private Hashtable names = new Hashtable();
    private CRC32 crc = new CRC32();
    private long written;
    private long locoff;
    private String comment;
    private int method = 8;
    private boolean finished;
    public static final int STORED = 0;
    public static final int DEFLATED = 8;

    public ZipOutputStream(OutputStream outputStream) {
        super(outputStream, new Deflater(-1, true));
    }

    public void setComment(String string) {
        if (string.length() > 65535) {
            throw new IllegalArgumentException("invalid ZIP file comment");
        }
        this.comment = string;
    }

    public void setMethod(int n) {
        if (n != 8 && n != 0) {
            throw new IllegalArgumentException("invalid compression method");
        }
        this.method = n;
    }

    public void setLevel(int n) {
        this.def.setLevel(n);
    }

    public void putNextEntry(ZipEntry zipEntry) throws IOException {
        if (this.entry != null) {
            this.closeEntry();
        }
        if (zipEntry.time == -1L) {
            zipEntry.setTime(System.currentTimeMillis());
        }
        if (zipEntry.method == -1) {
            zipEntry.method = this.method;
        }
        switch (zipEntry.method) {
            case 8: {
                if (zipEntry.size == -1L || zipEntry.csize == -1L || zipEntry.crc == -1L) {
                    zipEntry.flag = 8;
                } else if (zipEntry.size != -1L && zipEntry.csize != -1L && zipEntry.crc != -1L) {
                    zipEntry.flag = 0;
                } else {
                    throw new ZipException("DEFLATED entry missing size, compressed size, or crc-32");
                }
                zipEntry.version = 20;
                break;
            }
            case 0: {
                if (zipEntry.size == -1L) {
                    zipEntry.size = zipEntry.csize;
                } else if (zipEntry.csize == -1L) {
                    zipEntry.csize = zipEntry.size;
                } else if (zipEntry.size != zipEntry.csize) {
                    throw new ZipException("STORED entry where compressed != uncompressed size");
                }
                if (zipEntry.size == -1L || zipEntry.crc == -1L) {
                    throw new ZipException("STORED entry missing size, compressed size, or crc-32");
                }
                zipEntry.version = 10;
                zipEntry.flag = 0;
                break;
            }
            default: {
                throw new ZipException("unsupported compression method");
            }
        }
        zipEntry.offset = this.written;
        this.writeLOC(zipEntry);
        if (this.names.put(zipEntry.name, zipEntry) != null) {
            throw new ZipException("duplicate entry: " + zipEntry.name);
        }
        this.entries.addElement(zipEntry);
        this.entry = zipEntry;
    }

    public void closeEntry() throws IOException {
        ZipEntry zipEntry = this.entry;
        if (zipEntry != null) {
            switch (zipEntry.method) {
                case 8: {
                    this.def.finish();
                    while (!this.def.finished()) {
                        this.deflate();
                    }
                    if ((zipEntry.flag & 8) == 0) {
                        if (zipEntry.size != (long)this.def.getTotalIn()) {
                            throw new ZipException("invalid entry size (expected " + zipEntry.size + " but got " + this.def.getTotalIn() + " bytes)");
                        }
                        if (zipEntry.csize != (long)this.def.getTotalOut()) {
                            throw new ZipException("invalid entry compressed size (expected " + zipEntry.csize + " but got " + this.def.getTotalOut() + " bytes)");
                        }
                        if (zipEntry.crc != this.crc.getValue()) {
                            throw new ZipException("invalid entry CRC-32 (expected 0x" + Long.toHexString(zipEntry.crc) + " but got 0x" + Long.toHexString(this.crc.getValue()) + ")");
                        }
                    } else {
                        zipEntry.size = this.def.getTotalIn();
                        zipEntry.csize = this.def.getTotalOut();
                        zipEntry.crc = this.crc.getValue();
                        this.writeEXT(zipEntry);
                    }
                    this.def.reset();
                    this.written += zipEntry.csize;
                    break;
                }
                case 0: {
                    if (zipEntry.size != this.written - this.locoff) {
                        throw new ZipException("invalid entry size (expected " + zipEntry.size + " but got " + (this.written - this.locoff) + " bytes)");
                    }
                    if (zipEntry.crc == this.crc.getValue()) break;
                    throw new ZipException("invalid entry crc-32 (expected 0x" + Long.toHexString(zipEntry.size) + " but got 0x" + Long.toHexString(this.crc.getValue()) + ")");
                }
                default: {
                    throw new InternalError("invalid compression method");
                }
            }
            this.crc.reset();
            this.entry = null;
        }
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.entry == null) {
            throw new ZipException("no current ZIP entry");
        }
        switch (this.entry.method) {
            case 8: {
                super.write(byArray, n, n2);
                break;
            }
            case 0: {
                this.written += (long)n2;
                if (this.written - this.locoff > this.entry.size) {
                    throw new ZipException("attempt to write past end of STORED entry");
                }
                this.out.write(byArray, n, n2);
                break;
            }
            default: {
                throw new InternalError("invalid compression method");
            }
        }
        this.crc.update(byArray, n, n2);
    }

    public void finish() throws IOException {
        if (this.finished) {
            return;
        }
        if (this.entry != null) {
            this.closeEntry();
        }
        if (this.entries.size() < 1) {
            throw new ZipException("ZIP file must have at least one entry");
        }
        long l = this.written;
        Enumeration enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            this.writeCEN((ZipEntry)enumeration.nextElement());
        }
        this.writeEND(l, this.written - l);
        this.finished = true;
    }

    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    private void writeLOC(ZipEntry zipEntry) throws IOException {
        this.writeInt(67324752L);
        this.writeShort(zipEntry.version);
        this.writeShort(zipEntry.flag);
        this.writeShort(zipEntry.method);
        this.writeInt(zipEntry.time);
        if ((zipEntry.flag & 8) == 8) {
            this.writeInt(0L);
            this.writeInt(0L);
            this.writeInt(0L);
        } else {
            this.writeInt(zipEntry.crc);
            this.writeInt(zipEntry.csize);
            this.writeInt(zipEntry.size);
        }
        this.writeShort(zipEntry.name.length());
        this.writeShort(zipEntry.extra != null ? zipEntry.extra.length : 0);
        this.writeAscii(zipEntry.name);
        if (zipEntry.extra != null) {
            this.writeBytes(zipEntry.extra, 0, zipEntry.extra.length);
        }
        this.locoff = this.written;
    }

    private void writeEXT(ZipEntry zipEntry) throws IOException {
        this.writeInt(134695760L);
        this.writeInt(zipEntry.crc);
        this.writeInt(zipEntry.csize);
        this.writeInt(zipEntry.size);
    }

    private void writeCEN(ZipEntry zipEntry) throws IOException {
        this.writeInt(33639248L);
        this.writeShort(zipEntry.version);
        this.writeShort(zipEntry.version);
        this.writeShort(zipEntry.flag);
        this.writeShort(zipEntry.method);
        this.writeInt(zipEntry.time);
        this.writeInt(zipEntry.crc);
        this.writeInt(zipEntry.csize);
        this.writeInt(zipEntry.size);
        this.writeShort(zipEntry.name.length());
        this.writeShort(zipEntry.extra != null ? zipEntry.extra.length : 0);
        this.writeShort(zipEntry.comment != null ? zipEntry.comment.length() : 0);
        this.writeShort(0);
        this.writeShort(0);
        this.writeInt(0L);
        this.writeInt(zipEntry.offset);
        this.writeAscii(zipEntry.name);
        if (zipEntry.extra != null) {
            this.writeBytes(zipEntry.extra, 0, zipEntry.extra.length);
        }
        if (zipEntry.comment != null) {
            this.writeAscii(zipEntry.comment);
        }
    }

    private void writeEND(long l, long l2) throws IOException {
        this.writeInt(101010256L);
        this.writeShort(0);
        this.writeShort(0);
        this.writeShort(this.entries.size());
        this.writeShort(this.entries.size());
        this.writeInt(l2);
        this.writeInt(l);
        this.writeShort(this.comment != null ? this.comment.length() : 0);
        if (this.comment != null) {
            this.writeAscii(this.comment);
        }
    }

    private void writeShort(int n) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write(n & 0xFF);
        outputStream.write(n >>> 8 & 0xFF);
        this.written += 2L;
    }

    private void writeInt(long l) throws IOException {
        OutputStream outputStream = this.out;
        outputStream.write((int)(l & 0xFFL));
        outputStream.write((int)(l >>> 8 & 0xFFL));
        outputStream.write((int)(l >>> 16 & 0xFFL));
        outputStream.write((int)(l >>> 24 & 0xFFL));
        this.written += 4L;
    }

    private void writeAscii(String string) throws IOException {
        byte[] byArray = new byte[string.length()];
        string.getBytes(0, byArray.length, byArray, 0);
        this.writeBytes(byArray, 0, byArray.length);
    }

    private void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        this.written += (long)n2;
    }
}

