/*
 *   This file is a part of uuhydra, a replacement for Waffle's uucico
 *
 *   Copyright (C) 1993  Erik Bos (erik@trashcan.hacktic.nl)
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <dir.h>
#include <dos.h>
#include <ctype.h>
#include <signal.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys\timeb.h>
#include <time.h>
#include "async.h"
#include "uuhydra.h"

FILE	*fp_logfile,
	*fp_static;

int 	DEBUG=FALSE,
	hydracom100=FALSE,
	CurrentDrive,
	position,
	serialport=0;

long 	baudrate=0;

char	UucpName[ValueLength];

char	HydraLog[PathLength],
	Compress[PathLength]="pkzip",
	DeCompress[PathLength]="pkunzip",
	HangUpString[PathLength]="\\p\\p\\p+++\\p\\p\\pATH",
	LogFilePath[PathLength],

	TEMPSTRING[256],	/* temp string    */
	TEMPPATH[PathLength],	/* temporary path */
	OwnPath[PathLength],	/* work path      */
	MailName[ValueLength],
	Extension[ValueLength],
	CurrentDir[PathLength],
	SpoolDir[PathLength],

/*********************** staticfile ********************/

	DefaultDevice[ValueLength],
	DefaultBaudRate[ValueLength],
	StaticFile[PathLength],
	WafflePath[PathLength],
	UucpPath[PathLength],

/***************** system / dialer vars ***************/

	S_Name[ValueLength],
	S_Time[ValueLength],
	S_Protocol[ValueLength],
	S_Dialer[ValueLength],
	S_Script[ValueLength],

	S_ScriptCmds[ValueLength],

	S_PhoneNumber[ValueLength],
	S_AccountName[ValueLength],
	S_Password[ValueLength],
	S_DialerName[ValueLength],
	S_Device[ValueLength],
	S_BaudRate[ValueLength],
	S_DialCmds[ValueLength];

long BaudRates[]={300L,1200L,2400L,4800L,9600L,19200L,38400L,0L};
int FossilBaudRate[]={B300,B1200,B2400,B4800,B9600,B19200,B38400,-1};

int main(int argc,char *argv[])
{
	int x;
	char TempPath[PathLength];

	/* ctrlbrk(control_break); */
	CurrentDrive=getdisk();
	getcwd(CurrentDir,sizeof(CurrentDir));

	atexit(EndProgram);

#ifdef __MSDOS__
	poke(0x40,0x1a,peek(0x40,0x1c)); /* set begin to latest char in keyboard's ringbuffer */
#endif

	strcpy(OwnPath,argv[0]);
	for(x=strlen(OwnPath);(OwnPath[x]!='\\') && x;x--)
		;
	OwnPath[++x]='\0';

        strcpy(LogFilePath,".\\");

	strcpy(TempPath,OwnPath);
	strcat(TempPath,CONFIGFILE);
        if (DEBUG)
		WriteLog(TempPath,0);

	if (ReadConfig(TempPath)) {
                OpenLog();
	   	WriteLog("Can't open "CONFIGFILE" !",1);
        }

	OpenLog();
	WriteLog(NAME" "VERSION" ("__TIME__" "__DATE__")",0);
	WriteLog("(c) 1992-1993 Erik Bos (erik@trashcan.hacktic.nl)",0);
	WriteLog("bugfixes: Mark Lewis (mlewis@wplace.cssnet.sanford.nc.us)",0);

	printf("%d %s",hydracom100,LogFilePath);

	if (!getenv("TZ"))
		putenv("TZ=GMT0");

	tzset();

	if (argc==1) {
		Help();
		exit(1);
	}

	x=0;
	MailName[0]='\0';
	while (++x<argc) {
		if (argv[x][0]=='-' || argv[x][0]=='/') {
			switch(toupper(argv[x][1])) {
			case 'B':
				if (argv[x][2])
					baudrate=atol(&argv[x][2]);
				else
					baudrate=atol(argv[++x]);
				break;
			case 'D':
				if (argv[x][2])
					serialport=atoi(&argv[x][2]);
				else
					serialport=atoi(argv[++x]);
				break;
			case 'N':
				if (argv[x][2])
					strcpy(MailName,&argv[x][2]);
				else
					strcpy(MailName,argv[++x]);
				MailName[3]='\0';
				break;
			}
		}
	}

	if (!baudrate)
		baudrate=atol(DefaultBaudRate);

	if (!serialport)
		serialport=atoi(DefaultDevice);

	serialport--;

	x=0;
	while (++x<argc) {
		if (argv[x][0]=='-' || argv[x][0]=='/') {
			switch(toupper(argv[x][1])) {
				case 'B': /* check if the next arg should*/
				case 'D': /* be skipped (a value)        */
				case 'N':
					 x++;
					 if (argv[x][0]=='-' || argv[x][0]=='/')
						 x--;
					 break;
				case '?':
				case 'H':
					Help();
					break;
				case 'M':
					if (argv[x][2])
						PackMail(&argv[x][2]);
					else
						PackMail(argv[++x]);
					break;
				case 'R':
					if (argv[x][2])
						Receive(&argv[x][2]);
					else
						Receive(argv[++x]);
					break;
				case 'S':
					if (argv[x][2])
						Poll(&argv[x][2]);
					else
						Poll(argv[++x]);
					break;
				default:
					printf(" Unknown commandline switch '%c'\n",argv[x][1]);
					exit(1);
			}
		} else {
			printf(" Unparseable commandline option '%s'\n",argv[x]);
			Help();
			exit(1);
		}
	}
	return(0);
}

void Help(void)
{
	puts("\nusage: uuhydra -<option>\n");
	puts("\th		this helptext\n");
	puts("\ts <uucpname>	poll host");
	puts("\tr <uucpname>	incoming uuhydra call");
	puts("\tm <uucpname>	create mailpacket\n");

	puts("\tb <baudrate>	set baudrate");
	puts("\td <port>	set serialport");
	puts("\tn <name>	set mailpacket name\n");
}

void Poll(char *system)
{
	FILE *fp;
	int x,y,known;

	char TempString[PathLength],TempString2[PathLength];

	if (system==NULL)
		WriteLog("Don't forget to specify the uucpname behind `-s'!",1);

	if (DEBUG)
		WriteLog("processing outgoing mail.",0);

	x=CheckProtocol(system);
	if (x==UnknownSystem) {
		sprintf(TempString,"system `%s' doesn't exits!",system);
		WriteLog(TempString,1);
	}
	if (x==UnknownProtocol) {
		sprintf(TempString,"system `%s' doesn't use the `h' protocol!",system);
		WriteLog(TempString,1);
	}
	CreateMailPacket(system,x);

/******************** scripts *********************************/

	strcpy(TempString,UucpPath);
	strcat(TempString,"Scripts");

	if ((fp=fopen(TempString,"rt"))==NULL)
		WriteLog("Can't read waffle's Scripts file!",1);

	known=FALSE;
	while (!feof(fp)) {
		fgets(TempString,sizeof(TempString),fp);
		String_Clean(TempString);
		if (TempString[0]!='#') {
			sscanf(TempString,"%s",TempString2);
			if (!strcmpi(TempString2,S_Script)) {
				known=TRUE;
				strcpy(S_ScriptCmds,strchr(TempString,' '));
				String_Clean(S_ScriptCmds);
				break;
				}
		}
	}
	fclose(fp);

        if (DEBUG) {
                sprintf(TempString,"script: %s\n",S_ScriptCmds);
                fputs(TempString,fp_logfile);
	}

	if (!known) {
		sprintf(TempString,"Unknown script `%s'!",S_Script);
		WriteLog(TempString,1);
	}

/********************* dialers **************************

ZyXEL Default 38400 "" ATZ0 OK ATS37=10NDT\T CONNECT \m\c

*/
	strcpy(TempString,UucpPath);
	strcat(TempString,"Dialers");

	if ((fp=fopen(TempString,"rt"))==NULL)
		WriteLog("Can't read waffle's Dialers file!",1);

	known=FALSE;
	while (!feof(fp)) {
		fgets(TempString,sizeof(TempString),fp);
		String_Clean(TempString);
		if (TempString[0]!='#') {
			sscanf(TempString,"%s %s %s %s",
			S_DialerName,
			S_Device,
			S_BaudRate,
			S_DialCmds);
			if (!strcmpi(S_DialerName,S_Dialer)) {
				known=TRUE;
				break;
				}
		}
	}
	fclose(fp);
	strcpy(S_DialCmds,strstr(TempString,S_DialCmds));

        if (DEBUG) {
                sprintf(TempString,"dialer: %s\n",S_DialCmds);
                fputs(TempString,fp_logfile);
        }

	if (!known) {
		sprintf(TempString,"Unknown dialer `%s' used by system `%s'!",S_Dialer,S_Name);
		WriteLog(TempString,1);
	}

	if (!serialport) {
		if (!strcmpi(S_Device,"default"))
			serialport=atoi(DefaultDevice);
		else
			serialport=atoi(S_Device);
		serialport--;
	}

	x=AsyncInitPort(serialport);
	if (!x) {
		sprintf(TEMPSTRING,"No fossil driver loaded or port %d doesn't exist!",++serialport);
		WriteLog(TEMPSTRING,1);
	}

	if (x<5)
		WriteLog("I can't use a Fossil driver which doesn't support revision 5 commands!",1);

	if (!baudrate) {
		if (!strcmpi(S_BaudRate,"default"))
			baudrate=atol(DefaultBaudRate);
		else
			baudrate=atol(S_BaudRate);
	}

	for (x=0;BaudRates[x];x++) {
		if (BaudRates[x]==baudrate)
			break;
	}

	if (BaudRates[x]==0) {
		sprintf(TEMPSTRING,"Unsupported baudrate %ld used!",baudrate);
		WriteLog(TEMPSTRING,1);
	}
	if (DEBUG) {
		serialport++;
		sprintf(TEMPSTRING,"Initializing serial port %d at %ld bps.",serialport,BaudRates[x]);
		WriteLog(TEMPSTRING,0);
		serialport--;
	}
	AsyncSetBaudRate(serialport,FossilBaudRate[x]|PNONE|S1|D8);
	AsyncSetDTR(serialport,DTR_READY);

	sprintf(TempString,"Calling system `%s' using dialer `%s'.",S_Name,S_Dialer);
	WriteLog(TempString,0);

	AsyncRxPurge(serialport);

	x=0;
	while (x<5) {
		AsyncPuts(serialport,"\r\rAT\r");
		y=AsyncWatch(serialport,TempString,"OK","OK",3,1);
		if (y==100) {
			AsyncPuts(serialport,"\r");
			WriteLog(NAME" aborted by operator!",1);
		}
		if (y==2)
			break;

		x++;
	}
	if (x==5) {
		puts("");
		WriteLog("modem doesn't respond !",1);
	}

	if (DEBUG) {
	  sprintf(TempString,"Parsing dialing script : %s",S_DialCmds);
	  WriteLog(TempString,0);
	}
	ParseScript(S_DialCmds,60);

	if (DEBUG) {
	  sprintf(TempString,"Parsing logon script : %s",S_ScriptCmds);
	  WriteLog(TempString,0);
	}
	ParseScript(S_ScriptCmds,15);

	StartProtocol(system);
	KillMail(HydraLog);		/* delete and decompress mail */
}

void Receive(char *system)
{
	int x;

	char TempString[PathLength],TempName[PathLength];

	if (system==NULL)
		WriteLog("Don't forget to specify the uucpname behind `-r'!",1);

	x=CheckProtocol(system);
	if (x==UnknownSystem) {
		sprintf(TempString,"system `%s' doesn't exits!",system);
		WriteLog(TempString,1);
	}
	if (x==UnknownProtocol) {
		sprintf(TempString,"system `%s' doesn't use the `h' protocol!",system);
		WriteLog(TempString,1);
	}

	strcpy(TempName,system);	/* truncate long uucpname */
	TempName[8]='\0';

	strcpy(TempString,SpoolDir);    /* append spooldir and uucpname */
	strcat(TempString,TempName);

	if (!ChangeDir(TempString)) {
		sprintf(TempName,"Can't access spooldirectory '%s'!",TempString);
		WriteLog(TempName,1);
	}

	StartProtocol(system);
	KillMail(HydraLog);
}

void PackMail(char *system)
{
	int x;
	char TempString[PathLength];
	FILE *fp;

	if (system==NULL) {
		WriteLog("Don't forget to specify the uucpname behind `-m'!",1);
	}

	if (strcmpi(system,"all") && strcmpi(system,"any")) {
		x=CheckProtocol(system);
		if (x==UnknownSystem) {
			sprintf(TempString,"system `%s' doesn't exits!",system);
			WriteLog(TempString,1);
		}
		if (x==UnknownProtocol) {
			sprintf(TempString,"system `%s' doesn't use the `h' protocol!",system);
			WriteLog(TempString,1);
		}
		CreateMailPacket(system,x);
		return;
	}

	if (DEBUG)
		WriteLog("compressing all spooldirectories",0);

	strcpy(TempString,UucpPath);
	strcat(TempString,"Systems");

	if ((fp=fopen(TempString,"rt"))==NULL)
		WriteLog("Can't read waffle's Systems file!",1);

	while (!feof(fp)) {
		fgets(TempString,sizeof(TempString),fp);
		String_Clean(TempString);
		if (TempString[0]!='#' && TempString[0]!='\0') {
			sscanf(TempString,"%s %s %s %s %s %s %s %s",
			S_Name,
			S_Time,
			S_Protocol,
			S_Dialer,
			S_Script,
			S_PhoneNumber,
			S_AccountName,
			S_Password);
			if (!strcmp(S_Protocol,"H"))
				CreateMailPacket(S_Name,OnePacket);
			if (!strcmp(S_Protocol,"h"))
				CreateMailPacket(S_Name,MultiplePackets);
		}
	}
	fclose(fp);
}

int GetString(char *string,char *des)
{
	static int c;

	while (1) {
		c=string[position];
		position++;
		if (c==0x0) {
			*des='\0';
			return(0);
		}
		if (isspace(c) || c=='-') {
			*des='\0';
			return(1);
		}
		*des++=c;
	}
}

void ParseScript(char *s,int timeout)
{
	int x,y,What2Do;
	char TempString[ValueLength],tstr[PathLength];

        What2Do=0;
	position=0;

	while (1) {
		What2Do^=1;
		x=GetString(s,TempString);

		if (!strcmp(TempString,"\42\42"))
			continue;

		if (What2Do){
                        if (DEBUG) {
                                sprintf(tstr,"--expecting %s --\n",TempString);
                                printf(tstr);
                                fputs(tstr,fp_logfile);
                        }
                       	y=AsyncWatch(serialport,TempString,"NO CARRIER","BUSY",timeout,1);
			--position;
			if (!y && s[position]!='-') {
				HangUpModem(serialport);
				WriteLog("Time out!",1);
			}
			++position;
			if (y==2 && !carrier(serialport)) {
				puts("");
				HangUpModem(serialport);
				WriteLog("Carrier lost!",1);
			}
			if (y==3 && !carrier(serialport)) {
				puts("");
				HangUpModem(serialport);
				WriteLog("host is busy!",2);
			}
			if (y==100) {
				HangUpModem(serialport);
				WriteLog(NAME" aborted by operator!",1);
			}
		} else {
			if (DEBUG) {
                                sprintf(tstr,"--sending %s --\n",TempString);
                                printf(tstr);
                                fputs(tstr,fp_logfile);
                        }
                        AsyncPuts(serialport,TempString);
			AsyncTxChar(serialport,0x0d);
		}
		if (!x)
			break;
	}
}

void StartProtocol(char *system)
{
	char TempString[PathLength],TempName[ValueLength];

	if (MailName[0])
		strcpy(TempName,MailName);
	else
		strcpy(TempName,system);
	TempName[3]='\0';

	sprintf(TempString,"hydracom send %s*.%s",TempName,Extension);
	Execute(TempString);
	HangUpModem(serialport);
}

int CheckProtocol(char *system)
{
	FILE *fp;
	char TempString[PathLength];

	strcpy(TempString,UucpPath);
	strcat(TempString,"Systems");

	if ((fp=fopen(TempString,"rt"))==NULL)
		WriteLog("Can't read waffle's Systems file!",1);

	while (!feof(fp)) {
		fgets(TempString,sizeof(TempString),fp);
		String_Clean(TempString);
		if (TempString[0]!='#' && TempString[0]!='\0') {
			sscanf(TempString,"%s %s %s %s %s %s %s %s",
			S_Name,
			S_Time,
			S_Protocol,
			S_Dialer,
			S_Script,
			S_PhoneNumber,
			S_AccountName,
			S_Password);
			if (!strcmpi(S_Name,system)) {
				if (!strcmp(S_Protocol,"H"))
					return(OnePacket);
				if (!strcmp(S_Protocol,"h"))
					return(MultiplePackets);
				return(UnknownProtocol);
			}
		}
	}
	fclose(fp);
	return(UnknownSystem);
}

void DeleteFiles(char *search)
{
	struct ffblk FCBLK;
	int done;

	done=findfirst(search,&FCBLK,0);
	while (!done) {
		if (DEBUG) {
			sprintf(TEMPSTRING,"deleting %s",FCBLK.ff_name);
			WriteLog(TEMPSTRING,0);
		}
		if (unlink(FCBLK.ff_name)) {
			sprintf(TEMPSTRING,"DOS ERROR: %s.",sys_errlist[errno]);
			WriteLog(TEMPSTRING,0);
		}
		done=findnext(&FCBLK);
	}
}

void Move(char *s1,char *s2)
{
	char TempString[PathLength];

	sprintf(TempString,"move %s %s",s1,s2);
	if (!DEBUG)
		strcat(TempString," > nul");
	Execute(TempString);
}

char *CreateUniqueName(char *Name)
{
	char TempString[PathLength],TempString2[ValueLength];

	if (MailName[0])
		strcpy(TempString,MailName);
	else
		strcpy(TempString,Name);

	TempString[3]='\0';
	strcat(TempString,ultoa((unsigned long)time(NULL)%60000000L,TempString2,36));
	strcat(TempString,".");
	strcat(TempString,Extension);
	return(TempString);
}

char *CreateMailName(char *Name,int update)
{
	char TempString[PathLength];
	struct ffblk ffblk;

	if (update==MultiplePackets)
		return(CreateUniqueName(Name));

	strcpy(TempString,Name);
	TempString[3]='\0';
	strcat(TempString,"*.");
	strcat(TempString,Extension);

	if (DEBUG)
		printf("searching %s\n",TempString);

	if (findfirst(TempString,&ffblk,0))
		return(CreateUniqueName(Name));
	else {
		Move(ffblk.ff_name,TempDirectory);
		return(ffblk.ff_name);
	}
}

void CreateMailPacket(char *Name,int update)
{
	char FileName[ValueLength],TempString[PathLength],TempString2[PathLength];
	struct ffblk test;
	long FileSize;

	strcpy(FileName,Name);		/* truncate long uucpname */
	FileName[8]='\0';

	strcpy(TempString,SpoolDir);    /* append spooldir and uucpname */
	strcat(TempString,FileName);

	if (!ChangeDir(TempString)) {
		sprintf(TempString2,"Can't access spooldirectory '%s'!",TempString);
		WriteLog(TempString2,1);
	}

	if (findfirst("*.xqt",&test,0) || findfirst("*.dat",&test,0))
		return;

	mkdir(TempDirectory);
	Move("*.xqt",TempDirectory);
	Move("*.dat",TempDirectory);
	DeleteFiles("*.cmd");

	strcpy(FileName,CreateMailName(Name,update));

	ChangeDir(TempDirectory);
	RenameFiles();

	if (DEBUG) {
		sprintf(TempString,"creating mailpacket '%s'.",FileName);
		WriteLog(TempString,0);
	}

	if ((update==OnePacket) && (!findfirst(FileName,&test,0)))
		FileSize=test.ff_fsize;
	else
		FileSize=0L;

	if (DEBUG)
		printf("old file size %ld\n",FileSize);

	sprintf(TEMPSTRING,"%s %s *.x *.d",Compress,FileName);

	if (!DEBUG)
		strcat(TEMPSTRING," > nul");

	Execute(TEMPSTRING);

	if (!findfirst(FileName,&test,0)) {
		if (DEBUG)
			printf("new file size %ld\n",test.ff_fsize);
		if (FileSize<test.ff_fsize){
			DeleteFiles("*.x");
			DeleteFiles("*.d");
		}
	}

	strcpy(FileName,"*.");
	strcat(FileName,Extension);
	Move(FileName,"..");
	ChangeDir("..");
}

void KillMail(char *logfile)
{
	FILE *fp;
	unsigned int x,r_count=0,t_count=0,r_mail=0,t_mail=0;
	unsigned long r_cps=0,t_cps=0;
	char FileName[ValueLength],LineBuffer[256],Status[3],Cps[6];

	if ((fp=fopen(logfile,"r+"))==NULL) {
		WriteLog("Unable to open/find hydracom's logfile!",1);
	}

/* work around stupid bug in Turbo C's feof() */

#ifdef __TURBOC__
	fseek(fp,0,SEEK_END);
	fputs("\n",fp); /* add <CR><LF> */
	rewind(fp);
#endif

	while (!feof(fp)) {
		fgets(LineBuffer,sizeof(LineBuffer),fp);
		if (LineBuffer[0]==10)
			break;
		sscanf(LineBuffer,"%s %s %s %s %s %s %s %s %s %s %s",Status,S_Name,
		S_Name,S_Name,Cps,S_Name,S_Name,S_Name,S_Name,S_Name,FileName);

		String_Clean(Status);
		String_Clean(Cps);
		String_Clean(FileName);

		if (DEBUG)
			printf("* %s * %s * %s *\n",Status,Cps,FileName);
		if ((!strcmp(Status,"H") && hydracom100==TRUE) ||
		    (!strcmp(Status,"h") && hydracom100==FALSE)) {
			t_mail++;
			x=atoi(Cps);
			if (x!=9999) {
				t_count++;
				t_cps+=x;
			}
		if (DEBUG) {
			sprintf(TEMPSTRING,"deleting succesfull transmitted file %s.",FileName);
			WriteLog(TEMPSTRING,0);
		}
		if (unlink(FileName)) {
			sprintf(TEMPSTRING,"DOS ERROR: %s.",sys_errlist[errno]);
			WriteLog(TEMPSTRING,0);
		}
		continue;
		}
		if ((!strcmp(Status,"R") && hydracom100==TRUE) ||
		    (!strcmp(Status,"H") && hydracom100==FALSE)) {
			r_mail++;
			x=atoi(Cps);
			if (x!=9999) {
				r_count++;
				r_cps+=x;
			}
			strcpy(TEMPSTRING,DeCompress);
			strcat(TEMPSTRING," ");
			strcat(TEMPSTRING,FileName);
			Execute(TEMPSTRING);
			if (unlink(FileName)) {
				sprintf(TEMPSTRING,"DOS ERROR: %s.",sys_errlist[errno]);
				WriteLog(TEMPSTRING,0);
			}
		}
	}
	fclose(fp);

	if (unlink(logfile)) {
		sprintf(TEMPSTRING,"DOS ERROR: %s while deleting %s",sys_errlist[errno],logfile);
		WriteLog(TEMPSTRING,0);
	}

	if (r_mail) {
		if (r_count){
			sprintf(TEMPSTRING,"%d file(s) received (%ld cps)",r_mail,r_cps/=r_count);
			WriteLog(TEMPSTRING,0);
		} else {
			sprintf(TEMPSTRING,"%d file(s) received",r_mail);
			WriteLog(TEMPSTRING,0);
		}
	}
	if (t_mail) {
		if (t_count){
			sprintf(TEMPSTRING,"%d file(s) sent (%ld cps)",t_mail,t_cps/=t_count);
			WriteLog(TEMPSTRING,0);
		} else {
			sprintf(TEMPSTRING,"%d file(s) sent",t_mail);
			WriteLog(TEMPSTRING,0);
		}
	}

}

int ChangeDir(char *dir)
{
	char TempString[PathLength];

	String_Clean(dir);
	if (DEBUG) {
		sprintf(TempString,"cd %s",dir);
		WriteLog(TempString,0);
	}
	if (chdir(dir))
		return(0);

	if (dir[1]==':')
		setdisk(toupper(dir[0])-'A');
	return(1);
}

char *NukeName(char *FileName)
{
	int x;
	char Afzender[100],NewName[100],TempString[100];
	FILE *fp;

	if ((fp=fopen(FileName,"r"))==NULL)
		WriteLog("Unable to open *.xqt file in tempdirectory!",1);

	do {
		fgets(Afzender,sizeof(Afzender),fp);
	} while (Afzender[0]!='U' && !feof(fp));

	rewind(fp);

	do {
		fgets(NewName,sizeof(NewName),fp);
	} while (NewName[0]!='F' && !feof(fp));

	fclose(fp);

	String_Clean(Afzender);
	String_Clean(NewName);

	strcpy(NewName,&NewName[4]);

	sscanf(Afzender,"%s %s %s",TempString,TempString,Afzender);
	if (strchr(Afzender,'.')!=NULL)
		*strchr(Afzender,'.')='\0';

	for (x=0;x!=strlen(Afzender);x++) {
		if (Afzender[x]==NewName[0]) {
			memmove(NewName,&NewName[1],strlen(NewName));
		} else
			break;
	}

	memmove(&NewName[1],NewName,strlen(NewName));
	NewName[0]='0';
	for (x=0;x!=strlen(NewName);x++) {
		if (NewName[x]=='.')
			NewName[x]='_';
	}
	return(NewName);
}

void RenameFiles(void)
{
	/* rename files : 0123.dat -> 00123.d */

	int done;
	struct ffblk FCBLK;
	char Name[100],OldName[100],NewName[100];

	done=findfirst("*.xqt",&FCBLK,0);
	while (!done) {
		strcpy(Name,NukeName(FCBLK.ff_name));

		strcpy(OldName,FCBLK.ff_name);
		if (strchr(OldName,'.')!=NULL)
			*strchr(OldName,'.')='\0';
		strcat(OldName,".dat");

		strcpy(NewName,Name);
		strcat(NewName,".d");
		if (DEBUG) {
			sprintf(TEMPSTRING,"renaming %s to %s",OldName,NewName);
			WriteLog(TEMPSTRING,0);
		}
		rename(OldName,NewName);

		strcpy(OldName,FCBLK.ff_name);
		if (strchr(OldName,'.')!=NULL)
			*strchr(OldName,'.')='\0';
		strcat(OldName,".xqt");

		strcpy(NewName,Name);
		strcat(NewName,".x");
		if (DEBUG) {
			sprintf(TEMPSTRING,"renaming %s to %s",OldName,NewName);
			WriteLog(TEMPSTRING,0);
		}
		rename(OldName,NewName);

		done = findnext(&FCBLK);
	}
}

void EndProgram(void)
{
	WriteLog("End "NAME".",0);

	if (fp_logfile)
		CloseLog();

	setdisk(CurrentDrive);
	ChangeDir(CurrentDir);
}

int control_break(void)
{
	return(1);
}

int GetStaticVar(FILE *fp,char *s1,char *s2)
{
	static char LineBuffer[100],
	var1[PathLength],var2[PathLength],var3[PathLength];

	rewind(fp);
	while (!feof(fp)){
		fgets(LineBuffer,sizeof(LineBuffer),fp);
		String_Clean(LineBuffer);
		if (LineBuffer[0]!=';' && LineBuffer[0]!='\0') {
			var3[0]='\0';
			sscanf(LineBuffer,"%s %s %s",&var1,&var2,&var3);
			String_Clean(var2);

			if (!strcmp(var2,":"))
				strcpy(var2,var3);

			if (!strncmpi(var1,s1,strlen(s1))) {
				strcpy(s2,var2);
				return(1);
			}
		}
	}
	return(0);
}

void AsyncRxFlush(int port)
{
	while (AsyncGetPortStatus(port)&S_RXCHARS)
		putchar(AsyncRxChar(port));
}

int AsyncGets(int p,char *s,long timeout,int cancel)
{
	unsigned char c;
	int x=0;
	struct timeb time_1,time_2;

	ftime(&time_1);

	while(1) {
		if ((AsyncKbPeek()!=-1) && cancel)
			return(100);

		ftime(&time_2);

		if (((time_2.time-time_1.time)>=timeout) && (timeout!=-1))
			return(0);

		if (AsyncGetPortStatus(p)&S_RXCHARS) {
			c=AsyncRxChar(p);
			if (c==0x0d) {
				s[x]='\0';
				return(1);
			}
			s[x]=c;
			x++;
	      }
	}
}

int AsyncPuts(int p,char *s)
{
	int i,x;

	for (i=0;s[i];i++) {
		x=s[i];
		switch (x) {
		case '^':
			i++;
			if (s[i]=='\0')
				AsyncTxChar(p,'^');
			else
			switch (s[i]) {
				case '[':
					AsyncTxChar(p,0x1b);
					break;
				default:
					AsyncTxChar(p,s[i]-'@');
			}
			break;
		case '\\':
			i++;
			if (s[i]=='\0')
				AsyncTxChar(p,'\\');
			else
			switch (s[i]) {
				case 'b':
					AsyncPuts(p,"^H");
					break;
				case 'd':
					delay(2000);
					break;
				case 'n':
					AsyncPuts(p,"^J");
					break;
				case 'p':
					delay(500);
					break;
				case 'r':
					AsyncPuts(p,"^M");
					break;
				case 's':
					AsyncTxChar(p,' ');
					break;
				case 't':
					AsyncPuts(p,"^I");
					break;
				case '\\':
					AsyncTxChar(p,127);
					break;
				case 'D':
					AsyncSetDTR(p,DTR_NOT_READY);
					break;
				case 'T':
					AsyncPuts(p,S_PhoneNumber);
					break;
				case 'L':
					AsyncPuts(p,S_AccountName);
					break;
				case 'P':
					AsyncPuts(p,S_Password);
					break;
				case 'S':
					AsyncPuts(p,S_Name);
					break;
				default:
					break;
			}
			break;
		default:
			AsyncTxChar(p,x);
			break;
		}
	}
	return(0);
}

int AsyncWatch(int port,char *s1,char *s2,char *s3,long timeout,int cancel)
{
	unsigned char c,x1=0,x2=0,x3=0;
	struct timeb time_1,time_2;

	String_UpperCase(s1);
	String_UpperCase(s2);
	String_UpperCase(s2);
	ftime(&time_1);

	while(1) {
		if ((AsyncKbPeek()!=-1) && (cancel))
			return(100);

		ftime(&time_2);

		if (((time_2.time-time_1.time)>=timeout) && (timeout!=-1))
			return(0);

		if (AsyncGetPortStatus(port)&S_RXCHARS) {
			c=AsyncRxChar(port);
			putchar(c);
			c=toupper(c);

			if (c!=s1[x1])
				x1=0;

			if (c!=s2[x2])
				x2=0;

			if (c!=s3[x3])
				x3=0;

			if (c==s1[x1]) {
				x1++;
				if (!s1[x1])
					return(1);
			}

			if (c==s2[x2]) {
				x2++;
				if (!s2[x2])
					return(2);
			}
			if (c==s3[x3]) {
				x3++;
				if (!s3[x3])
					return(3);
			}
		}
	}
}

void HangUpModem(int port)
{
	AsyncRxPurge(port);

	AsyncInitPort(port);
	AsyncSetDTR(port,DTR_NOT_READY);

	AsyncPuts(port,HangUpString);
	AsyncTxChar(port,0x0d);

	AsyncWatch(port,"NO CARRIER","OK","BUSY",8,1);
	AsyncRxPurge(port);
	AsyncDeInitPort(port);
}

void String_GetValues(char *s1,char *s2,char *s3)
{
	int x;
	x=strcspn(s1,"=");
	strncpy(s2,s1,x);
	s2[x]='\0';
	strcpy(s3,strchr(s1,'=')+1);
	String_Clean(s2);
	String_Clean(s3);
}

void String_Clean(char *s)
{
    static unsigned char x,y;
    for(x=0;!isgraph(s[x]) && s[x]!=0;x++)
	;
    for(y=strlen(s);!isgraph(s[y]) && y!=x;y--)
	;
    s[++y]='\0';
    strcpy(s,&s[x]);
}

void String_UpperCase(char *s)
{
	while (*s)
		*s++=toupper(*s);
}

int ReadConfig(char *s)
{
	FILE *fp_temp;
	char LineBuffer[PathLength],LineSymbol[ValueLength],LineValue[PathLength];


	if ((fp_temp=fopen(s,"r"))==NULL)
		return(1);

	while (!feof(fp_temp)) {
		fgets(LineBuffer,sizeof(LineBuffer),fp_temp);

		if (LineBuffer[0]==';')
			continue;	      /* skip a commented line   */

		if (!strchr(LineBuffer,'='))  /* skip a NON-comment line */
			continue;

		String_GetValues(LineBuffer,LineSymbol,LineValue);

		if (!strcmpi(LineSymbol,"debug")) {
			if (!strcmpi(LineValue,"on"))
				DEBUG=TRUE;
			continue;
		}
		if (!strcmpi(LineSymbol,"extension")) {
			strncpy(Extension,LineValue,sizeof(Extension));
			continue;
		}
		if (!strcmpi(LineSymbol,"compress")) {
			strncpy(Compress,LineValue,sizeof(Compress));
			continue;
		}
		if (!strcmpi(LineSymbol,"decompress")) {
			strncpy(DeCompress,LineValue,sizeof(DeCompress));
			continue;
		}
		if (!strcmpi(LineSymbol,"hangup")) {
			strncpy(HangUpString,LineValue,sizeof(HangUpString));
			continue;
		}
		if (!strcmpi(LineSymbol,"logfile")) {
			strncpy(LogFilePath,LineValue,sizeof(LogFilePath));
			continue;
		}
		if (!strcmpi(LineSymbol,"hydracom1.00")) {
			if (!strcmpi(LineValue,"on"))
				hydracom100=TRUE;
			if (!strcmpi(LineValue,"true"))
				hydracom100=TRUE;
			if (!strcmpi(LineValue,"yes"))
				hydracom100=TRUE;
			continue;
		}
		sprintf(TEMPSTRING,"Unknown variable '%s' in "CONFIGFILE"!",LineSymbol);
		WriteLog(TEMPSTRING,0);

	}
	fclose(fp_temp);

	if ((fp_temp=fopen(getenv("WAFFLE"),"rt"))==NULL)
		WriteLog("Can't read waffle's STATIC file, please define WAFFLE environment variable!",1);

	if (!GetStaticVar(fp_temp,"uucpname",UucpName))
		WriteLog("please define `uucpname' in your static file!",1);

	if (!GetStaticVar(fp_temp,"waffle",WafflePath))
		WriteLog("please define `waffle' in your static file!",1);

	if (!GetStaticVar(fp_temp,"device",DefaultDevice))
		WriteLog("please define `device' in your static file!",1);

	if (!GetStaticVar(fp_temp,"speed",DefaultBaudRate))
		WriteLog("please define `speed' in your static file!",1);

	if (!GetStaticVar(fp_temp,"spool",SpoolDir))
		WriteLog("please define `spool' in your static file!",1);

	fclose(fp_temp);

	strcpy(LineBuffer,OwnPath);
	strcat(LineBuffer,"hydracom.cfg");

	if ((fp_static=fopen(LineBuffer,"rt"))==NULL)
		WriteLog("Can't read hydracom's configfile!",1);

	HydraLog[0]='\0';
	while (!feof(fp_temp)) {
		fgets(LineBuffer,sizeof(LineBuffer),fp_static);
		sscanf(LineBuffer,"%s %s",LineSymbol,LineValue);
		if (!strcmpi(LineSymbol,"receive")) {
			if (strcmp(LineValue,".")) {
				sprintf(LineBuffer,"Please set the `receive' keyword in hydracom.cfg to '.' instead of `%s'!\n",LineValue);
				WriteLog(LineBuffer,1);
			}
		}
	}
	rewind(fp_temp);
	while (!feof(fp_temp)) {
		fgets(LineBuffer,sizeof(LineBuffer),fp_static);
		sscanf(LineBuffer,"%s %s",LineSymbol,LineValue);
		if (!strcmpi(LineSymbol,"result")) {
			strcpy(HydraLog,LineValue);
			break;
		}
	}
	fclose(fp_temp);

	if (!HydraLog[0])
		WriteLog("please define `result' in hydracom.cfg",1);

	if (WafflePath[strlen(WafflePath)-1]!='\\')
		strcat(WafflePath,"\\");

	if (SpoolDir[strlen(SpoolDir)-1]!='\\')
		strcat(SpoolDir,"\\");

	if (LogFilePath[strlen(LogFilePath)-1]!='\\')
		strcat(LogFilePath,"\\");

	strcpy(UucpPath,WafflePath);
	strcat(UucpPath,"uucp\\");
	return(0);
}

void Execute(char *s)
{
	int x,y;
	char CommandLine[PathLength];

	for(x=0,y=0;s[x];x++,y++) {
		if (s[x]!='%')
			CommandLine[y]=s[x];
		else {
			x++;
			if (s[x]=='%') {
				y++;
				CommandLine[y]=s[x];
				continue;
			}
			CommandLine[y]='\0';
			switch (toupper(s[x])) {
/*				case 'B':
					strcat(CommandLine,itoa(BaudRates[C_BAUDRATE]);
					y+=(strlen(BaudRateStrings[C_BAUDRATE])-1);
					break;*/
				case 'P':
					CommandLine[y]='1'+serialport;
					break;
				default:
					break;
			}
		}
	}
	CommandLine[y]='\0';

	if (DEBUG) {
		sprintf(TEMPSTRING,"Executing [%s]",CommandLine);
		WriteLog(TEMPSTRING,0);
	}

	if (system(CommandLine)) {
		sprintf(TEMPSTRING,"DOS ERROR: %s.",sys_errlist[errno]);
		WriteLog(TEMPSTRING,0);
	}
}

void OpenLog(void)
{
	char TempString[PathLength];

	strcpy(TempString,LogFilePath);
	strcat(TempString,LOGFILE);
	fp_logfile=fopen(TempString,"a+");
}

void CloseLog(void)
{
	fputs("\n",fp_logfile);
	fclose(fp_logfile);
}

void WriteLog(char *s,int errorlevel)
{
	time_t t;
	static char buffer[256],TempString[26];

	printf("# %s\n",s);
	time(&t);
	strcpy(TempString,ctime(&t));
	TempString[19]='\0';
	sprintf(buffer,"%s # %s\n",TempString,s);

	fputs(buffer,fp_logfile);

	if (errorlevel)
		exit(errorlevel);
}
