/*===========================================================================
SOLARGO
Original Author: Kevin Sartorelli <kevin@nui-wgtn.gen.nz>
Much code stolen from the source for Solar by Kevin Houle

Used to maintain users where Solar is being run in a non Waffle environment

Exists with an error code of 1 if an error occured, 0 if not.

This source code has been placed into the public domain.
===========================================================================*/

/* Header Files */
#include <ctype.h>
#include <dir.h>
#include <string.h>
#include <stdio.h>
#include <time.h>
#include <values.h>
#include <limits.h>
#include <stdlib.h>
#include "codedate.h"
#include "solargo.h"
#include "..\common\fossil.h"

int main(int argc, char *argv[])
{
	extern    char		*optarg;
	unsigned  char		x;
	const     char		*optionS = "c:C:vVFf";
	char					orig_path[MAXPATH];
   char              usernamev[64];
   FILE              *fp;

	/* Store original directory */

	getcwd(orig_path, MAXPATH);

	/* Set default values for globals */

   strcpy(config_path,  "NONE");
   strcpy(batch_path,   "NONE");
   strcpy(user_path,    "NONE");
   strcpy(temp_path,    "NONE");
   strcpy(drop_path,    "NONE");
	strcpy(username,		"NONE");
   strcpy(fullname,     "NONE");
   strcpy(usernamev,    "USER");
	strcpy(speed, 			"LOCAL");

	use_fossil				= NO;
	port						= 99;
	verbose 					= NO;


   /* Parse the command line and load file settings */

	while ((x = getopt(argc, argv, optionS)) != '\xFF')
	{
		switch (toupper(x)) {
			case '?'  : usage();
                     exit(0);
			case 'C'  : strcpy(config_path,optarg);
							break;
         case 'U'  : if ((strcmp(usernamev,"USER")) == 0)
                     {
                        strcpy(usernamev,optarg);
                        break;
                     }
                     else
                     {
                        usage();
                        exit(0);
                     }
			case 'V'  : verbose = YES;
								break;
			case 'F'  : use_fossil = YES;
								break;
		}
	}

   if (verbose == YES)
	{
      RPrintf("\nSOLARGO v%s (%s)\n",VERSION,CODE_DATE);
	}

   /* Load configuration files. */

	if (load_config(config_path) != 0) {
      RPrintf("%s\n",_slrerr);
		exit(1);
   }

	if (load_static() != 0) {
      RPrintf("%s\n",_slrerr);
		exit(1);
   }

   /* Get users full name from drop file */

   if ((fp = fopen(drop_path,"r")) == NULL) {
      RPrintf("Error opening file %s\n",strupr(drop_path));
      exit(1);
   }
   Get_File_String(fullname,sizeof(fullname)-2,fp);
   fclose(fp);
   if (verbose)
      RPrintf("User full name: %s\n",strupr(fullname));

   /* See if user is known and get name if not */

   GetName();

   /* Write information out to BATch file */

   if ((fp = fopen(batch_path,"wt")) == NULL) {
      RPrintf("Error opening file %s\n",strupr(batch_path));
      exit(1);
   }
   fprintf(fp,"@echo off\n");
   fprintf(fp,"set %s=%s\n",usernamev,username);
   fclose(fp);

   return(0);
}

/*
Function: usage()
Purpose : Display SolarGo command line usage.
Return	: N/A
*/

void usage(void)
{
   RPrintf("SOLARGO v%s (%s) - Set Up Username for SOLAR.\n\n",VERSION,CODE_DATE);
	RPrintf("Usage: solargo [options]\n");
   RPrintf("\t-c configfile  Name of configuration file.\n");
   RPrintf("\t-u variable    DOS Environment variable to set.\n");
   RPrintf("\t-v             Verbose messages.\n");
   RPrintf("\t-f             Use FOSSIL output.\n");
	return;
}

void GetName(void)
{
   int errcode;
   FILE *fp;

   if (GetZipFullName(fullname,username) != 0) {
      RPrintf("I couldn't find your name (%s)\n",strupr(fullname));
      RPrintf("Please enter an Internet alias 1-8 characters long.\n");
      RPrintf("[Enter] or QUIT to abort.\n\n");
      RPrintf("=> ");
      Rgets(username);
      while ((errcode = GetZipName(username)) != 0) {
         if (errcode == 2)
            exit(1);
         RPrintf("\nThe name you entered (%s) is already used.\n",strupr(username));
         RPrintf("Please enter another 1-8 character alias.\n");
         RPrintf("[Enter] or QUIT to abort.\n\n");
         RPrintf("=> ");
         Rgets(username);
      }

      if ((fp = fopen(name_path,"at")) == NULL) {
         RPrintf("Error opening file %s\n",strupr(name_path));
         exit(1);
      }
      fprintf(fp,"%s %s\n",strupr(fullname),strlwr(username));
      fclose(fp);

      strcat(user_path,username);
      if (mkdir(user_path) != 0) {
         if (errno != 5) {
            RPrintf("Error #%d creating directory %s\n",errno,strupr(user_path));
            exit(1);
         }
      }
      if (newsgroup[0] != '\0') {
         strcat(user_path,"\\JOIN");
         if ((fp = fopen(user_path,"at")) == NULL) {
            RPrintf("Error opening file %s\n",strupr(user_path));
            exit(1);
         }
         fprintf(fp,"%s: 0\n",newsgroup);
         fclose(fp);
      }
   }
   if (verbose)
      RPrintf("Waffle Name: %s\n",strlwr(username));
}

int GetZipFullName(char *realname,char *name)
{
   int i;
   char buffer[200],buff[200];
   FILE *fp;

   if ((fp = fopen(name_path,"r")) == NULL) {
      RPrintf("Error opening file %s\n",strupr(name_path));
      exit(1);
   }
   do {
      Get_File_String(buffer,sizeof(buffer)-2,fp);
      if (!feof(fp)) {
         for (i = strlen(buffer) - 1; i < 0, buffer[i] != ' '; i--)
            buff[strlen(buffer)-i-1] = buffer[i];
         buff[strlen(buffer)-i-1] = '\0';
         buffer[i] = '\0';
      }
   } while (!feof(fp) && strcmp(realname,buffer));
   fclose(fp);
   if (!strcmp(realname,buffer)) {
      for (i = 0; i < strlen(buff); i++)
         name[strlen(buff)-i-1] = buff[i];
      name[strlen(buff)] = '\0';
      return(0);
   }
   return(1);
}

int GetZipName(char *name)
{
   int i;
   char buffer[100],buff[100],ubuff[100];
   FILE *fp;

   if (name[0] == '\0' || !stricmp(name,"QUIT"))
      return(2);
   if ((fp = fopen(name_path,"r")) == NULL) {
      RPrintf("Error opening file %s\n",strupr(name_path));
      exit(1);
   }
   do {
      Get_File_String(buffer,sizeof(buffer)-2,fp);
      if (!feof(fp)) {
         for (i = strlen(buffer) - 1; i < 0, buffer[i] != ' '; i--)
            buff[strlen(buffer)-i-1] = buffer[i];
         buff[strlen(buffer)-i-1] = '\0';
         buffer[i] = '\0';
         for (i = 0; i < strlen(buff); i++)
            ubuff[strlen(buff)-i-1] = buff[i];
         ubuff[strlen(buff)] = '\0';
      }
   } while (!feof(fp) && strcmp(name,ubuff));
   fclose(fp);
   if (!strcmp(name,ubuff))
      return(1);
   return(0);
}

/****************************************************************************/
/*                                                                          */
/*          My function to get a string from a file without the CR          */
/*                                                                          */
/****************************************************************************/

int Get_File_String(char *str,int len,FILE *f);
int Get_File_String(str,len,f)
char *str;                                         /* Name of string to get */
int len;                                 /* Maximum number of bytes to read */
FILE *f;                                          /* Pointer to file stream */
{
	fgets(str,len,f);                                /* Get line from stream */
   if (str == NULL)
		return(1);                                      /* Error reading file */
	if ((str[strlen(str)-1] == 0x0d) || (str[strlen(str)-1] == 0x0a))
		str[strlen(str)-1] = '\0';                   /* Delete CR from string */
	else
		str[strlen(str)] = '\0';        /* Make sure the string is terminated */
	return(0);                                      /* No error reading file */
}
