/*===========================================================================
SOLAR v0.95.3 solar :: Module ..\solar\register.c
Original Author: Kevin Houle <kjhoule@iowegia.dsm.ia.us>

This software module has been placed in the public domain.
30/10/95  KJS  Added check for carrier drop to get_option()
===========================================================================*/

#include <stdio.h>
#include <dir.h>
#include <values.h>
#include <stdlib.h>
#include "register.h"

/*
 * Function: int build_newsrc()
 * Purpose : Build or modify NEWSRC.HPG subscription file.
 * Return  : number of groups subscribed, -1 on error and set _slrerr.
*/

int build_newsrc()
{
	FILE *forum_file = NULL;
	int  get_option(char *groupname, long high_msg, int defval);

  FILE *newsrc_file = NULL;
  int  option;
	long high_msgno  = 0L;
	long low_msgno   = 0L;
	int  sub_count   = 0;
	int  subscribed  = 0;
	int  x           = 0;
	FORUM *current   = NULL;
	char forumbuf[128];

  /* Make sure there is no exising NEWSRC_TMP file */

  kill_newsrc(NEWSRC_TMP);

  /* Load linked list with path to forum files. */

  if (load_forums() != 0) goto ErrorExit;

  /* Open newsrc file to begin processing existing
     subscription list. */

  if ((newsrc_file = open_newsrc(NEWSRC,"rt")) != NULL)
  {
    RPrintf("\nProcessing current subscription list:\n\n");

    /* Process all records in newsrc */

    while (read_newsrc(newsrc_file) == 0)
    {
			switch (set_default_path()) {

        /* Access to group is denied, do not rewrite. */

        case  2 : RPrintf("Group: %s - Access denied... unsubscribing.\n",area_name);
                  break;

        /* Group not found in forum file(s). Do not rewrite. */

        case -1 : RPrintf("Group: %s - Not valid... unsubscribing.\n",area_name);
                  break;

        /* Critical unexpected error. Get outta here. */

        case -2 : goto ErrorExit;

        /* Normal result, group is found. Directory may or may not
           exist, though. Either is OK. Evaluate group. */

        default : high_msgno = high_fileno();
                  low_msgno = low_fileno();
                  if (low_msgno > msg_high)
                  {
                    msg_high = low_msgno;
                    index_high = low_msgno;
                  }
									if (high_msgno < msg_high)
                  {
                    msg_high = high_msgno;
                    index_high = high_msgno;
                  }

                  /* Find out what the user wishes to do */

                  option = get_option(area_name,high_msgno,YES);

                  /* Subscribe and batch all articles */

                  if ((option == 'A') || (option == 'a'))
                  {
                    keyword = 'a';
                    write_newsrc(NEWSRC_TMP,"at");
                    sub_count++;
                  }

                  /* Subscribe but batch only summaries */

                  if ((option == 'S') || (option == 's'))
									{
                    keyword = 's';
                    write_newsrc(NEWSRC_TMP,"at");
                    sub_count++;
                  }

                  /* Quit without updating newsrc */

                  if ((option == 'q') || (option == 'Q'))
                  {
                    goto NoUpdateExit;
                  }

                  /* End subscription process and update */

                  if ((option == 'e') || (option == 'E'))
                  {
                    goto UpdateExit;
                  }

                  /* Catch up on all articles */

                  if ((option == 'c') || (option == 'C'))
                  {
                    msg_high = high_msgno;
                    index_high = high_msgno;
                    write_newsrc(NEWSRC_TMP,"at");
                    sub_count++;
                  }
                  break;
			}
		}
		fclose(newsrc_file);
    if (sub_count == 0) kill_newsrc(NEWSRC_TMP);
	}

  /* Now process all entries in each forum file. Do not inquire again */
  /* on groups in NEWSRC.OLD, if it exists, just copy them over into  */
  /* NEWSRC.NEW. No need to be reduntant.                             */

  RPrintf("\nProcessing all unsubscribed groups:\n\n");

  current = forum;
	while (current)
	{
    if ((forum_file = open_forum_file(current->forum_path)) == NULL)
    {
      goto ErrorExit;
    }
    while (fgets(forumbuf,128,forum_file) != NULL)
    {
			if ((strnicmp(forumbuf,"DEFAULT",6) != 0) &&
          (strnicmp(forumbuf,"FORUM",5) != 0)   &&
          (forumbuf[0] != '\n') && (forumbuf[0] != '#') &&
          (forumbuf[0] != ' ')  &&
          (strstr(forumbuf,"/nosolar") == NULL))
			{
				x = 0;
        while ((forumbuf[x] != ' ') && (forumbuf[x] != '\n')) x++;
        forumbuf[x] = '\0';
        subscribed = NO;

        if (list_vs_newsrc(forumbuf) == 0) subscribed = YES;

GetOption:
				if (subscribed == NO)
				{
					option = get_option(forumbuf,0L,NO);
          if ((option == 'S') || (option == 's'))
					{
						strcpy(area_name,forumbuf);
            msg_high = 0L;
            index_high = 0L;
            keyword = 's';
            write_newsrc(NEWSRC_TMP,"at");
						sub_count++;
          }
          if ((option == 'A') || (option == 'a'))
          {
            strcpy(area_name,forumbuf);
            msg_high = 0L;
            index_high = 0L;
            keyword = 'a';
						write_newsrc(NEWSRC_TMP,"at");
						sub_count++;
          }
          if ((option == 'q') || (option == 'Q'))
					{
						goto NoUpdateExit;
          }
					if ((option == 'e') || (option == 'E'))
          {
            goto UpdateExit;
          }
				}
      }
		}
    fclose(forum_file);
    current = current->next;
  }
UpdateExit:
  current = NULL;
  if (forum_file) fclose(forum_file);
  if (forum) remove_list();
  fclose(newsrc_file);
  if (sub_count > 0)
  {
    RPrintf("\n");
    update_newsrc();
    RPrintf("Subscription file updated\n\n");
	}
  else
  {
    kill_newsrc(NEWSRC_TMP);
    RPrintf("\nNo changes made to subscription file\n\n");
	}
  return sub_count;

NoUpdateExit:
  current = NULL;
  if (forum_file) fclose(forum_file);
  if (forum) remove_list();
  fclose(newsrc_file);
	kill_newsrc(NEWSRC_TMP);
  RPrintf("\nNo changes made to subscription file\n\n");
  return 0;

ErrorExit:
  current = NULL;
  if (forum_file) fclose(forum_file);
  if (forum) remove_list();
  if (newsrc_file) fclose(newsrc_file);
  return -1;
}

int get_option(char *groupname, long high_msg, int defval)
{
  static int choice;
  int valid_choice = NO;

  valid_choice = NO;
  while (valid_choice == NO)
  {
    RPrintf("Group: %s : ",groupname);
		if (defval == YES)
			RPrintf("<%lu new> (A,s,n,c,e,q,?) : ",high_msg - msg_high);
    else
      RPrintf("(a,s,N,e,q,?) : ");
    choice = Rgetc();
    if (choice == -1) {
      sprintf(_slrerr,"get_option(): Carrier dropped in Rgetc().");
      goto ErrorExit;
    }
		RPrintf("\n");
    if ((choice == 'q') || (choice == 'Q') ||
        (choice == 'n') || (choice == 'N') ||
        (choice == 's') || (choice == 'S') ||
        (choice == 'a') || (choice == 'A') ||
        (choice == 'e') || (choice == 'E'))
    {
			valid_choice = YES;
    }
    else
    {
      if (choice == '\x0D')
      {
				if (defval == YES)
        {
          choice = 'A';
          valid_choice = YES;
        }
				if (defval == NO)
        {
          choice = 'N';
          valid_choice = YES;
        }
      }
      else
      {
				if (defval == YES)
        {
          if ((choice == 'c') || (choice == 'C'))
            valid_choice = YES;
        }
      }
    }
    if (valid_choice == NO)
    {
      RPrintf("\nA = Keep subscription, batches include full articles.\n");
      RPrintf("S = Keep subscription, batches include summaries only.\n");
			if (defval == YES)
      {
				RPrintf("N = No, don't resubscribe to group.\n");
        RPrintf("C = Catch up on all messages in group.\n");
      }
      else
      {
        RPrintf("N = No, don't subscribe to group.\n");
      }
      RPrintf("E = End, save groups subscribed so far.\n");
      RPrintf("Q = Quit, make no changes to subscription.\n\n");
    }
  }
GoodExit:
  return choice;
ErrorExit:
  return 'Q';
}

/*
 * Function: int list_vs_newsrc(char *groupname);
 * Purpose : Compare group name against entries in subscription file.
 * Return  : zero if group is subscribed, non-zero if not.
*/

int list_vs_newsrc(char *groupname)
{
  FILE *newsrc_file = NULL;
  char compbuf[128];

  if ((newsrc_file = open_newsrc(NEWSRC_TMP,"rt")) == NULL)
		goto NotFoundExit;

  while (fgets(compbuf,128,newsrc_file) != NULL)
  {
    if (stricmp(strtok(compbuf,":"),groupname) == 0)
      goto FoundExit;
  }

NotFoundExit:
  if (newsrc_file) fclose(newsrc_file);
  return 1;
FoundExit:
	if (newsrc_file) fclose(newsrc_file);
  return 0;
}

/*
 * Function: high_fileno()
 * Purpose : Scan directory of numeric filenames and return the highest number.
 * Return  : Highest numbered filename, or 0 if no files found.
*/

long high_fileno()
{
  long msg_number = 0L;
	long high_msg   = 0L;
  int  done;
  struct ffblk ffblk;

  done = findfirst("*",&ffblk,0);
  while (!done)
  {
    msg_number = atol(ffblk.ff_name);
    if (msg_number > high_msg)
    {
      high_msg = msg_number;
    }
    done = findnext(&ffblk);
	}
  return high_msg;
}

/*
 * Function: low_fileno()
 * Purpose : Scan directory of numeric filenames and return the lowest number.
 * Return  : Lowest numbered filename, or 0 if no files found.
*/

long low_fileno()
{
  long msg_number = 0L;
  long low_msg   = MAXLONG;
  int  done;
  struct ffblk ffblk;

  done = findfirst("*",&ffblk,0);
  while (!done)
  {
    msg_number = atol(ffblk.ff_name);
    if (msg_number < low_msg)
    {
      low_msg = msg_number;
    }
    done = findnext(&ffblk);
  }
  return low_msg;
}

