/*===========================================================================
SOLAR v0.95.2 slrnews :: Module ..\slrnews\packet.c
Original Author: Kevin Houle <kjhoule@iowegia.dsm.ia.us>

This software module has been placed in the public domain.
===========================================================================*/

/* Include files */
#include <stdio.h>
#include <string.h>
#include <dir.h>
#include <limits.h>
#include <stdlib.h>
#include "..\common\yesno.h"
#include "packet.h"

long pack_group()
{
  FILE *batch_file;
  FILE *index_file;
  FILE *message_file;
  FILE *areas_file;

  long message_size   = 0L;
  long byte_count     = 0L;
  long offset         = 0L;
  long area_msg_count = 0L;
  long msg_index      = 0L;
  int  x;
  int  killcount      = 0;
  char temp[10];
  char file_name[MAXFILE];

  struct ffblk ffblk;

  /* Check for messages to be batched */

  area_msg_count = eval_area();
  if (area_msg_count == 0L)
  {
    goto GoodExit;
  }
  if (area_msg_count == -1L)
  {
    /* The message area keyword was unknown. */

    RPrintf("\nwarning: %s\n",_slrerr);
    area_msg_count = 0L;
    goto GoodExit;
  }

  /* Decide how many messages to batch and set index */

  if (area_msg_count > news_area_messages)
  {
    switch (keyword) {
      case 's'  : RPrintf(" - found %lu, summarizing last %lu :  ",area_msg_count,news_area_messages);
                  break;
      case 'a'  : RPrintf(" - found %lu, batching last %lu :  ",area_msg_count,news_area_messages);
                  break;
    }
    msg_index = (high_msg - news_area_messages) + 1L;
    area_msg_count = news_area_messages;
  }
  else
  {
    switch (keyword) {
      case 's'  : RPrintf(" - %lu new messages, summarizing :  ",area_msg_count);
                  msg_index = index_high + 1L;
                  break;
      case 'a'  : RPrintf(" - %lu new messages, batching :  ",area_msg_count);
                  msg_index = msg_high + 1L;
                  break;
    }
  }

  /* Open MSG batch file and IDX index file, as needed */

  if (get_batch_prefix() != 0) goto ErrorExit;
  switch (keyword) {
    case 'a'  : if ((batch_file = open_batch_file()) == NULL) goto ErrorExit;
                break;
    case 's'  : break;
  }
  if ((keyword == 's') || ((news_index == C) || (news_index == c)))
    if ((index_file = open_index_file()) == NULL) goto ErrorExit;

  /* Set some initial stuff before looping */

  killcount = 0;
  area_msg_count = 0L;
  ltoa(area_msg_count,temp,10);

  /* Batch all needed messages and/or indexes */

  while (!(msg_index > high_msg))
  {
    /* Open the message file */

    ltoa(msg_index,file_name,10);
    if ((message_file = fopen(file_name, "rt")) == NULL)
    {
      msg_index++;    /* Expected message isn't there anymore! */
    }
    else
    {
      /* Check against user kill file. This check can be bypassed
         for summary messages from Solar's config file */

      if (((keyword == 's') && (kill_summary == NO)) || \
           (kill_msg(message_file) != 0))
      {
        /* Unless we're doing summaries for this group, make sure adding
           this message won't put the user over the max. # of bytes */

        switch (keyword) {
          case 'a'  : message_size = filesize(message_file);
                      byte_count += message_size;
                      if (byte_count > news_area_bytes)
                      {
                        RPrintf("\nExceed area maximum of %lu bytes.",news_area_bytes);
                        fclose(message_file);
                        break;
                      }
                      if (news_type == u)
                      {
                        fprintf(batch_file, "#! rnews %lu\n", message_size);
                      }
                      offset = ftell(batch_file);
                      break;
          case 's'  : offset = 0L;
                      message_size = 0L;
                      break;
        }

        /* Now we are ready to write the index file record */

        switch (news_index) {
          case C  : partial_cnews(message_file, index_file, message_size, offset, file_name);
                    break;
          case c  : full_cnews(message_file, index_file, message_size, offset, file_name);
                    break;
          case n  : if (keyword == 's')
                      partial_cnews(message_file, index_file, message_size, offset, file_name);
                    break;
        }

        /* And finally, write the message to the batch file unless
           we are doing summaries for this area */

        fseek(message_file,0L,SEEK_SET);    /* Reset message file */
        switch (news_type) {
          case u  : if (keyword == 'a')
                      usenet_message(message_file, batch_file);
                    break;
          case B  : if (keyword == 'a')
                      binary_message(message_file, batch_file, message_size);
                    break;
          case i  : break;
        }

        /* Update the stuff. Don't count summaries in the byte total */

        area_msg_count++;
        if (keyword != 's')
          totbyte_count += message_size;
        for (x = 0; x < strlen(temp); x++)
        {
          printf("\b");
        }
        ltoa(area_msg_count,temp,10);
        printf("%s",temp);
      }
      else
      {
        /* We have killed and we must repent */
        killcount++;
      }
      fclose(message_file);
      msg_index++;
    }
  }
  if (killcount > 0) RPrintf(" killed %u",killcount);
  RPrintf("\n");
  if (batch_file) fclose(batch_file);
  if (index_file) fclose(index_file);

  /* If we smoked through some messages, there is more work to do */

  if (area_msg_count > 0L)
  {
    /* First, write to the areas file */

    if ((areas_file = open_areas_file()) == NULL) goto ErrorExit;
    fprintf(areas_file,"%s\t%s\t",batch_prefix,area_name);
    switch (news_type) {
      case u  : switch (keyword) {
                  case 's'  : fprintf(areas_file, "i"); break;
                  case 'a'  : fprintf(areas_file, "u"); break;
                }
      case B  : switch (keyword) {
                  case 's'  : fprintf(areas_file, "i"); break;
                  case 'a'  : fprintf(areas_file, "B"); break;
                }
    }
    switch (news_index) {
      case c  : fprintf(areas_file,"c"); break;
      case C  : fprintf(areas_file,"C"); break;
      case n  : switch (keyword) {
                  case 's'  : fprintf(areas_file,"C"); break;
                  case 'a'  : fprintf(areas_file,"n"); break;
                }
    }
    fprintf(areas_file,"n");
    if (strcmp(newsgroups_path,"NONE") != 0)
    {
      if (write_description(areas_file) == 0)
        if (keyword == 'a') fprintf(areas_file,"\t%lu",area_msg_count);
    }
    fprintf(areas_file,"\n");
    fclose(areas_file);
  }
  else
  {
    clean_zero_byte_file();
  }

  /* Update newsrc values, the write is done from slrnews.c */

  switch (keyword) {
    case 'a'  : msg_high = msg_index - 1L;
                if ((msg_index - 1L) > index_high)
                  index_high = msg_index - 1L;
                break;
    case 's'  : index_high = msg_index - 1L;
                break;
  }

GoodExit:
  return area_msg_count;
ErrorExit:
  if (batch_file) fclose(batch_file);
  if (index_file) fclose(index_file);
  if (message_file) fclose(message_file);
  if (areas_file) fclose(areas_file);
  return -1L;
}

/*
 * Function: int eval_area()
 * Purpose : Evaluate message area
 * Return  : Number of messages in area to process, -1L on error.
 *
*/

long eval_area()
{
  long temp_number = 0L;

  low_msg  = low_fileno();
  high_msg = high_fileno();

  switch (keyword) {
    case 's'  : if (index_high >= high_msg)
                {
                  if (high_msg == 0L)
                    RPrintf(" - No messages... skipping.\n");
                  else
                    RPrintf("- No new messages... skipping.\n");
                }
                else
                {
                  if (low_msg > index_high) index_high = low_msg - 1L;
                  temp_number = high_msg - index_high;
                }
                break;
    case 'a'  : if (msg_high >= high_msg)
                {
                  if (high_msg == 0L)
                    RPrintf(" - No messages... skipping.\n");
                  else
                    RPrintf("- No new messages... skipping.\n");
                }
                else
                {
                  if (low_msg > msg_high) msg_high = low_msg - 1L;
                  temp_number = high_msg - msg_high;
                }
                break;
    default : sprintf(_slrerr,"eval_area(): unknown message area keyword");
              temp_number = -1L;
              break;
  }
  return temp_number;
}

/*
 * Function: open_areas_file()
 * Purpose : Open SOUP packet index file for append in binary mode.
 * Return  : A pointer to the index file, NULL on error and set _slrerr.
*/

FILE *open_areas_file()
{
  FILE *areas_file;

  char path[MAXPATH];

  strcpy(path,temp_path);
  strcat(path,"\\");
  strcat(path,AREAS_NAME);

  if ((areas_file = fopen(path,"ab")) == NULL)
  {
    sprintf(_slrerr,"open_areas_file(): error opening %s file %s", AREAS_NAME,path);
  }
  return areas_file;
}

/*
 * Function: open_batch_file()
 * Purpose : Open a batch file in binary mode in temp directory. Use unique
 *           filename prefix on a per user basis.
 * Return  : Pointer to batch file, exit on error.
*/

FILE *open_batch_file()
{
  FILE  *batch_file   = NULL;

  char  batch_path[MAXPATH];

  strcpy(batch_path, temp_path);
  strcat(batch_path, "\\");
  strcat(batch_path, batch_prefix);
  strcat(batch_path, ".");
  strcat(batch_path, BATCH_EXT);
  if ((batch_file = fopen(batch_path, "wb")) == NULL)
    sprintf(_slrerr,"open_batch_file(): error opening batch file %s", batch_path);

  return batch_file;
}

/*
 * Function: open_index_file()
 * Purpose : Open an index file in binary mode in temp directory. Use unique
 *           filename prefix on a per user basis.
 * Return  : Pointer to index file, NULL on error and set _slrerr.
*/

FILE *open_index_file()
{
  FILE  *index_file   = NULL;

  char  index_path[MAXPATH];

  strcpy(index_path, temp_path);
  strcat(index_path, "\\");
  strcat(index_path, batch_prefix);
  strcat(index_path, ".");
  strcat(index_path, INDEX_EXT);
  if ((index_file = fopen(index_path, "wb")) == NULL)
  {
    sprintf(_slrerr,"open_index_file(): error opening index file %s",index_path);
  }
  return index_file;
}

/*
 * Function: int usenet_message(FILE *message_file, FILE *batch_file);
 * Purpose : Write message file to batch file
 * Return  : Zero on success
*/

int usenet_message(FILE *message_file, FILE *batch_file)
{
  char buffer[1024];

  while (fgets(buffer,1024,message_file) != NULL)
    fprintf(batch_file,"%s",buffer);

  return 0;
}

/*
 * Function: int binary_message(FILE *message_file, FILE *batch_file, long message_size);
 * Purpose : Write message file to batch file as type 'B'.
 * Return  : Zero on success.
*/

int binary_message(FILE *message_file, FILE *batch_file, long message_size)
{
  extern char *long_to_endian(long long_value);

  size_t count;
  char buf[1];

  fwrite(long_to_endian(message_size),4,1,batch_file);
  fseek(message_file, SEEK_SET, 0);

  count = fread(buf, 1, 1, message_file);
  while (count != 0)
  {
    fwrite(buf, 1, 1, batch_file);
    count = fread(buf, 1, 1, message_file);
  }

  return 0;
}

/*
 * Function: clean_zero_byte_file()
 * Purpose : Remove zero byte *.MSG and *.IDX files.
 * Return  : N/A
*/

void clean_zero_byte_file()
{
  char fname[MAXPATH];

  strcpy(fname,temp_path);
  strcat(fname,"\\");
  strcat(fname,batch_prefix);
  strcat(fname,".");
  strcat(fname,BATCH_EXT);
  unlink(fname);
  strcpy(fname,temp_path);
  strcat(fname,"\\");
  strcat(fname,batch_prefix);
  strcat(fname,".");
  strcat(fname,INDEX_EXT);
  unlink(fname);

  return;
}

/*
Function: high_fileno()
Purpose : Scan directory of numeric filenames and return the highest number.
Return  : Highest numbered filename, or 0 if no files found.
*/

long high_fileno()
{
  long msg_number = 0L;
  long temp_high_msg   = 0L;
  int  done;
  struct ffblk ffblk;

  done = findfirst("*",&ffblk,0);
  while (!done)
  {
    msg_number = atol(ffblk.ff_name);
    if (msg_number > temp_high_msg)
    {
      temp_high_msg = msg_number;
    }
    done = findnext(&ffblk);
  }
  return temp_high_msg;
}

/*
 * Function: low_fileno()
 * Purpose : Scan directory of numeric filenames and return the lowest number.
 * Return  : Lowest numbered filename, or 0 if no files found.
*/

long low_fileno()
{
  long msg_number = 0L;
  long temp_low_msg   = LONG_MAX;
  int  done;
  struct ffblk ffblk;

  done = findfirst("*",&ffblk,0);
  while (!done)
  {
    msg_number = atol(ffblk.ff_name);
    if (msg_number < temp_low_msg)
    {
      temp_low_msg = msg_number;
    }
    done = findnext(&ffblk);
  }
  return temp_low_msg;
}

