/*===========================================================================
SOLAR :: ..\common\forums.c

Original Author: Kevin Houle <kjhoule@iowegia.des-moines.ia.us>
This software module has been placed into the public domain.
===========================================================================*/

#include <dir.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "..\common\yesno.h"
#include "..\common\forums.h"

/*
 * Function: int set_default_path()
 * Purpose : Sets current directory based on area name.
 * Return  : 0 on success
 *           1 if group does not have a directory on spool
 *           2 if group is marked /nosolar in forum file (access denied)
 *          -1 if group is not in forum files
 *          -2 on error and set _slrerr.
*/

int set_default_path()
{
  FILE  *forum_file   = NULL;

  FORUM *current = forum;

  char  buf[128];
  char  default_path[MAXPATH];
  char  area_path[MAXPATH];

  strcpy(area_path,"NONE");
  strcpy(default_path,"NONE");

  while ((current) && (strcmp(area_path,"NONE") == 0))
  {
    if (!(forum_file = open_forum_file(current->forum_path)))
      goto ErrorExit;

    strcpy(default_path,"NONE");

    while ((fgets(buf,128,forum_file)) && (strcmp(area_path,"NONE") == 0))
    {
      /* Force to upper case */

      strupr(buf);

      /* Look for /READ, /GROUP, or /DIR in forum line */

      if (strnicmp(buf,area_name,strlen(area_name)) == 0)
      {
        /* Any /DIR must be a full path. */

        if (strstr(buf,"/DIR") != NULL)
        {
          strcpy(area_path,get_forum_value(buf,"/DIR"));
          default_path[0] = '\0';
        }
        else
        {
          strcpy(area_path,name_to_path());
        }
      }

      /* Process a DEFAULT or FORUM line in trample mode */

      if ((strnicmp(buf,"DEFAULT",7) == 0) || (strnicmp(buf,"FORUM",5) == 0))
      {
        if (strstr(buf,"/DIR") != NULL)
          strcpy(default_path,get_forum_value(buf,"/DIR"));
      }
    }
    fclose(forum_file);
    current = current->next;
  }
  current = NULL;

  if (strcmp(default_path,"NONE") == 0)
  {
    strcpy(_slrerr,"set_default_path(): forum file has no /DIR= parameter");
    goto ErrorExit;
  }

  if (strcmp(area_path,"NONE") == 0)
    goto InvalidExit;
  else
    strcat(default_path,area_path);

GoodExit:
  if (verbose == YES)
    RPrintf("Trying to change to: %s\n",default_path);

  /* Return 0 on success, 1 on failure to change directory */

  return(set_directory(default_path));

DenyExit:
  if (forum_file) fclose(forum_file);
  return 2;
InvalidExit:
  return -1;
ErrorExit:
  if (forum_file) fclose(forum_file);
  return -2;
}

/*
Function: FILE *open_forum_file(char path[MAXPATH])
Purpose : Open file. Not sure why this is a function.
Return  : Pointer to file, NULL and set _slrerr on fail.
*/

FILE *open_forum_file(char path[MAXPATH])
{
  static FILE *filep    = NULL;

  if (!(filep = fopen(path, "rt")))
    sprintf(_slrerr,"open_forum_file(): error opening forum file %s",path);
  return filep;
}

/*
Function: char *name_to_path()
Purpose : Convert Usenet-format newsgroup name to a disk path.
Return  : Disk path, or NONE on error.
*/

char *name_to_path()
{
  static char path[MAXPATH];
  char        *token;
  char        temp[80];

  strcpy(path,"NONE");
  strcpy(temp,area_name);

  if ((token = strtok(temp,".")) != NULL)
    strcpy(path,"\\");
  else
    goto GoodExit;

  while (token != NULL)
  {
    strncat(path,token,8);
    if ((token = strtok(NULL,".")) != NULL)
    {
      strcat(path,"\\");
    }
  }
GoodExit:
  if (verbose == YES)
    RPrintf("%s converted to %s\n",area_name,path);
  return path;
}

/*
Function: *get_forum_value(char *forum_line, const char item[MAX_ITEM])
Purpose : Get value for /ITEM= from forum line. Handles with or
          without quotes.
Return  : Value, or NONE if not found.
*/

char *get_forum_value(char *forum_line, const char item[MAX_ITEM])
{
  static char  value[MAXPATH];
  int   idx    = 0;
  int   idx2   = 0;
  char  *token;

  strcpy(value,"NONE");

  /* Force forum line to upper case */

  strupr(forum_line);

  /* Search forum line for item */

  if ((token = strstr(forum_line,item)) != NULL)
  {
    /* Advance in string past first '=' */

    while (token[idx++] != '=');

    /* Load each remaining character from value
       string into path, skipping quotes. */

    while ((token[idx] != ' ') && (token[idx] != '\0') && \
          (token[idx] != '\n') && (token[idx] != '\t'))
    {
      if (token[idx] != '\"') value[idx2++] = token[idx];
      idx++;
    }
    value[idx2] = '\0';
  }
  if (verbose == YES)
    RPrintf("Item %s set to %s\n",item,value);
  return value;
}

/*
 * Function: load_forums()
 * Purpose : Load the parameters from Waffle's static forums: line into
 *           a linked list on the heap. Store full paths to the forum files.
 * Return  : 0 on success, non-zero on error and set _slrerr.
*/

int load_forums()
{
  extern char static_path[MAXPATH];
  extern char system_path[MAXPATH];
  FILE *static_file = fopen(static_path,"rt");
  FORUM *current = NULL;

  int idx  = 0;
  int idx2 = 0;

  char buf[128];
  char buf2[MAXPATH];
  char *p = NULL;

  forum = NULL;

  if (!static_file)
  {
    sprintf(_slrerr,"load_forums(): error opening static file %s",static_path);
    goto ErrorExit;
  }

  buf2[0] = '\0';

  while (fgets(buf,128,static_file) != NULL)
  {
    if (strnicmp(buf,"forums",6) == 0)
    {
      while ((buf[idx] != ':') && (buf[idx] != '\n') && (buf[idx] != '\0')) idx++;
      idx++;
      while ((buf[idx] == ' ') && (buf[idx] != '\0') && \
            (buf[idx] != '\n') && (buf[idx] == '\t')) idx++;

      while ((buf[idx] != '\0') && (buf[idx] != '\n'))
      {
        if (((buf[idx] == ' ') && (buf2[idx] != ' ')) || (buf[idx] != ' '))
          buf2[idx2++] = buf[idx];
        idx++;
      }
      buf2[idx2] = '\0';

      if (strlen(buf2) > 0)
      {
        p = strtok(buf2," ");
        while (p != NULL)
        {
          if (forum == NULL)
          {
            forum = current = malloc(sizeof(FORUM));
            if (!forum)
            {
              sprintf(_slrerr,"load_forums(): insuffient memory to load forums");
              goto ErrorExit;
            }
            forum->next = NULL;
          }
          else
          {
            current->next = malloc(sizeof(FORUM));
            if (!current->next)
            {
              sprintf(_slrerr,"load_forums(): insuffient memory to load forums");
              goto ErrorExit;
            }
            current = current->next;
            current->next = NULL;
          }
          strcpy(current->forum_path,system_path);
          strcat(current->forum_path,"\\");
          strcat(current->forum_path,p);
          if (verbose == YES)
            RPrintf("Found forum file %s\n",current->forum_path);
          p = strtok(NULL," ");
        }
      }
    }
  }
  current = NULL;
GoodExit:
  return 0;
ErrorExit:
  if (static_file) fclose(static_file);
  return 1;
}

/*
 * Function: remove_list()
 * Purpose : Remove forums linked list from memory.
 * Return  : N/A
*/

void remove_list()
{
  FORUM *current = forum;

  while (current != NULL)
  {
    forum = current;
    current = current->next;
    free(forum);
  }
  forum = NULL;
  return;
}

