/*
	ndir.c for MS-DOS by Samuel Lam <skl@van-bc.UUCP>, June/87
*/

/*
   Berkeley-style directory reading routine on MS-DOS
*/

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <alloc.h>
#include <dos.h>
#include <stdlib.h>
#include <assert.h>

#include "ndir.h"

/*
   Open a directory
*/

DIR *opendir(dirname)
char *dirname;
{
	union REGS inregs, outregs;
	struct SREGS segregs;
	char pathname[128];
	DTA far *dtaptr;
	char far *pathptr;
	DIR *dirp;

	/* build pathname to be scanned */
	strcpy(pathname, dirname);
	strcat(pathname, "/*.*");

	/* allocate control block */
	dirp = malloc(sizeof(DIR));

	/* set DTA address to our buffer */
	inregs.h.ah = 0x1a;
	dtaptr = (DTA far *)&(dirp->dirdta);
	segregs.ds = FP_SEG(dtaptr);
	inregs.x.dx = FP_OFF(dtaptr);
	intdosx(&inregs, &outregs, &segregs);

	/* look for the first file */
	inregs.h.ah = 0x4e;
	pathptr = (char far *)pathname;
	segregs.ds = FP_SEG(pathptr);
	inregs.x.dx = FP_OFF(pathptr);
	inregs.x.cx = 0;   /* attribute */
	intdosx(&inregs, &outregs, &segregs);

	/* bad directory name? */
	if (outregs.x.cflag && (outregs.x.ax == 2 || outregs.x.ax == 3)) {
		free(dirp);
		return NULL;
	}

	dirp->dirfirst = outregs.x.cflag ? outregs.x.ax : 0;

	strcpy(dirp->dirid, "DIR");

	return dirp;

} /*opendir*/


/*
   Get next entry in a directory
*/

struct direct *readdir(dirp)
DIR *dirp;
{
	int errcode;

	assert(strcmp(dirp->dirid, "DIR") == 0);

	if (dirp->dirfirst == -1) {
		union REGS inregs, outregs;
		struct SREGS segregs;
		DTA far *dtaptr;

		inregs.h.ah = 0x4f;
		dtaptr = (DTA far *)&(dirp->dirdta);
		segregs.ds = FP_SEG(dtaptr);
		inregs.x.dx = FP_OFF(dtaptr);
		intdosx(&inregs, &outregs, &segregs);
		errcode = outregs.x.cflag ? outregs.x.ax : 0;

	} else {

		errcode = dirp->dirfirst;
		dirp->dirfirst = -1;

	};

	/* no more files in directory? */
	if (errcode == 18)
		return NULL;
	assert(errcode == 0);

	dirp->dirent.d_ino = -1;   /* no inode information */
	strlwr(strcpy(dirp->dirent.d_name, dirp->dirdta.filename));
	dirp->dirent.d_namlen = strlen(dirp->dirent.d_name);
	dirp->dirent.d_reclen = sizeof(struct direct) - (MAXNAMLEN + 1) +
		((((dirp->dirent.d_namlen + 1) + 3) / 4) * 4);

	return &(dirp->dirent);

} /*readdir*/


/*
   Close a directory
*/

void closedir(dirp)
DIR *dirp;
{

	strcpy(dirp->dirid, "XXX");
	free(dirp);

} /*closedir*/

